/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.security.provider;

import com.ibm.oti.security.provider.PKCS1;
import com.ibm.oti.security.provider.RSAPrivateCrtKey;
import com.ibm.oti.security.provider.RSAPrivateKey;
import com.ibm.oti.security.provider.RSAPublicKey;
import com.ibm.oti.util.Msg;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;

public abstract class SignatureRSA
extends Signature {
    protected static final int STATE_UNINITIALIZED = 0;
    protected static final int STATE_SIGN = 1;
    protected static final int STATE_VERIFY = 2;
    protected static final String[] STATE_DESCRIPTION = new String[]{"UNINITIALIZED", "SIGN", "VERIFY"};
    protected RSAPrivateKey privateKey;
    protected RSAPublicKey publicKey;
    protected int state = 0;
    protected String digestAlgorithmName;
    protected PKCS1 rsaEngine = null;

    public SignatureRSA(String digestAlgorithmName) {
        super(String.valueOf(digestAlgorithmName) + "with" + "RSA");
        this.digestAlgorithmName = digestAlgorithmName;
        this.rsaEngine = new PKCS1(digestAlgorithmName);
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (privateKey instanceof java.security.interfaces.RSAPrivateCrtKey) {
            this.privateKey = new RSAPrivateCrtKey((java.security.interfaces.RSAPrivateCrtKey)privateKey);
        } else if (privateKey instanceof java.security.interfaces.RSAPrivateKey) {
            this.privateKey = new RSAPrivateKey((RSAPrivateKey)privateKey);
        } else {
            throw new InvalidKeyException(Msg.getString("K00a5", privateKey));
        }
        this.state = 1;
        this.resetHash();
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        boolean valid = true;
        if (publicKey != null) {
            try {
                this.publicKey = new RSAPublicKey((java.security.interfaces.RSAPublicKey)publicKey);
            }
            catch (ClassCastException classCastException) {
                valid = false;
            }
        } else {
            valid = false;
        }
        if (!valid) {
            throw new InvalidKeyException(Msg.getString("K00a5", publicKey));
        }
        this.state = 2;
        this.resetHash();
    }

    protected byte[] engineSign() throws SignatureException {
        try {
            byte[] result = this.rsaEngine.signSSA_PKCS1_v15Impl(this.privateKey, this.getHash());
            this.resetHash();
            return result;
        }
        catch (IOException e) {
            throw new SignatureException(e.getMessage());
        }
    }

    protected void engineUpdate(byte b) throws SignatureException {
        this.updateHash(b);
    }

    protected void engineUpdate(byte[] buffer, int offset, int length) throws SignatureException {
        this.updateHash(buffer, offset, length);
    }

    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        int modBits = this.publicKey.getModulus().bitLength();
        int keyLength = (int)Math.ceil((double)modBits / 8.0);
        keyLength = Math.min(sigBytes.length, keyLength);
        byte[] trimedSigBytes = new byte[keyLength];
        System.arraycopy((Object)sigBytes, 0, (Object)trimedSigBytes, 0, keyLength);
        boolean result = this.rsaEngine.verifySSA_PKCS1_v15Impl(this.publicKey, this.getHash(), trimedSigBytes);
        this.resetHash();
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(128);
        result.append(" RSA Signature (");
        result.append(STATE_DESCRIPTION[this.state]);
        result.append(')');
        return result.toString();
    }

    protected abstract void resetHash();

    protected abstract void updateHash(byte[] var1, int var2, int var3);

    protected abstract void updateHash(byte var1);

    protected abstract byte[] getHash();
}

