/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.security.provider;

import com.ibm.oti.security.provider.ASN1OID;
import com.ibm.oti.security.provider.X500Principal;
import com.ibm.oti.security.provider.X509CRLEntry;
import com.ibm.oti.security.provider.X509Certificate;
import com.ibm.oti.security.provider.X509Extension;
import com.ibm.oti.util.ASN1Decoder;
import com.ibm.oti.util.ASN1Encoder;
import com.ibm.oti.util.ASN1Exception;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;

public class X509CRL
extends java.security.cert.X509CRL {
    private byte[] encoded;
    private int originalOffsetIntoRawBytes;
    private ASN1Decoder.Node tbsNode;
    private int version;
    private String sigAlgOID;
    private byte[] sigAlgParams;
    private byte[] rawSignature;
    private String signatureName;
    private String signatureProviderName;
    private X500Principal issuer;
    private Date thisUpdate;
    private Date nextUpdate;
    private Hashtable revokedCertificates;
    private Hashtable extensions;
    private static final String[] SUPPORTED_CRITICAL_EXTENSIONS = new String[0];

    protected X509CRL() {
    }

    public byte[] getEncoded() throws CRLException {
        return this.encoded;
    }

    public Principal getIssuerDN() {
        return this.issuer;
    }

    public Date getNextUpdate() {
        return this.nextUpdate;
    }

    public java.security.cert.X509CRLEntry getRevokedCertificate(BigInteger serialNumber) {
        if (this.revokedCertificates == null) {
            return null;
        }
        return (java.security.cert.X509CRLEntry)this.revokedCertificates.get(serialNumber);
    }

    public Set getRevokedCertificates() {
        if (this.revokedCertificates == null) {
            return null;
        }
        HashSet result = new HashSet();
        Enumeration elements = this.revokedCertificates.elements();
        while (elements.hasMoreElements()) {
            result.add(elements.nextElement());
        }
        return result;
    }

    public String getSigAlgName() {
        return this.signatureName;
    }

    public String getSigAlgOID() {
        return this.sigAlgOID;
    }

    public byte[] getSigAlgParams() {
        return this.sigAlgParams;
    }

    public byte[] getSignature() {
        return this.rawSignature;
    }

    public byte[] getTBSCertList() throws CRLException {
        byte[] result = new byte[this.tbsNode.endPosition - this.tbsNode.startPosition + 1];
        System.arraycopy((Object)this.encoded, this.tbsNode.startPosition - this.originalOffsetIntoRawBytes, (Object)result, 0, result.length);
        return result;
    }

    public Date getThisUpdate() {
        return this.thisUpdate;
    }

    public int getVersion() {
        return this.version;
    }

    public void verify(PublicKey key) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        if (this.signatureProviderName != null) {
            this.verify(key, this.signatureProviderName);
        } else {
            if (this.signatureName == null) {
                throw new NoSuchAlgorithmException(this.sigAlgOID);
            }
            Signature signature = Signature.getInstance(this.signatureName);
            this.verify(key, signature);
        }
    }

    public void verify(PublicKey key, String sigProvider) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        if (this.signatureName == null) {
            throw new NoSuchAlgorithmException(this.sigAlgOID);
        }
        Signature signature = Signature.getInstance(this.signatureName, sigProvider);
        this.verify(key, signature);
    }

    private void verify(PublicKey key, Signature signature) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        signature.initVerify(key);
        signature.update(this.getTBSCertList());
        boolean ok = signature.verify(this.getSignature());
        if (!ok) {
            throw new SignatureException();
        }
    }

    public boolean isRevoked(Certificate cert) {
        try {
            java.security.cert.X509Certificate toVerify = (java.security.cert.X509Certificate)cert;
            java.security.cert.X509CRLEntry revoked = this.getRevokedCertificate(toVerify.getSerialNumber());
            return revoked != null;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public boolean hasUnsupportedCriticalExtension() {
        Set critical = this.getCriticalExtensionOIDs();
        if (critical == null) {
            return false;
        }
        if (critical.size() > SUPPORTED_CRITICAL_EXTENSIONS.length) {
            return true;
        }
        int i = 0;
        while (i < SUPPORTED_CRITICAL_EXTENSIONS.length) {
            critical.remove(SUPPORTED_CRITICAL_EXTENSIONS[i]);
            ++i;
        }
        return critical.size() != 0;
    }

    private Set getExtensionOIDs(boolean isCritical) {
        if (this.extensions == null) {
            return null;
        }
        HashSet result = new HashSet();
        Enumeration elements = this.extensions.elements();
        while (elements.hasMoreElements()) {
            X509Extension extension = (X509Extension)elements.nextElement();
            if (extension.isCritical() != isCritical) continue;
            result.add(extension.name());
        }
        return result;
    }

    public Set getCriticalExtensionOIDs() {
        return this.getExtensionOIDs(true);
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.getExtensionOIDs(false);
    }

    public byte[] getExtensionValue(String oid) {
        if (this.extensions == null) {
            return null;
        }
        X509Extension extn = (X509Extension)this.extensions.get(oid);
        if (extn == null) {
            return null;
        }
        byte[] extnValue = extn.value();
        if (extnValue == null) {
            extnValue = new byte[]{};
        }
        ASN1Decoder.Node node = new ASN1Decoder.Node();
        node.type = 4;
        node.data = extn.value();
        return ASN1Encoder.encodeNode(node);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("X.509 CRL v");
        result.append(this.getVersion());
        result.append("\n\tThis update: ");
        result.append(this.getThisUpdate());
        result.append("\n\tNext update: ");
        result.append(this.getNextUpdate());
        result.append("\n\tExtensions: ");
        result.append(this.extensions == null ? 0 : this.extensions.size());
        result.append("\n");
        return result.toString();
    }

    public static ASN1Decoder CRLDecoder(InputStream inStream) {
        ASN1Decoder decoder = new ASN1Decoder(inStream);
        ASN1Decoder.TypeMapper mapper = new ASN1Decoder.TypeMapper(){

            public int map(int originalType, int nesting, int sequenceItem) {
                if (originalType == 0) {
                    return 16;
                }
                return originalType;
            }
        };
        decoder.configureTypeRedirection(2, mapper);
        return decoder;
    }

    private void configureRevokedCertificates(ASN1Decoder.Node revokedCertificatesNode, byte[] rawBytes) throws CRLException {
        ASN1Decoder.Node[] allRevokedNodes = (ASN1Decoder.Node[])revokedCertificatesNode.data;
        this.revokedCertificates = new Hashtable();
        int i = 0;
        while (i < allRevokedNodes.length) {
            ASN1Decoder.Node revokedCertificateNode = allRevokedNodes[i];
            X509CRLEntry entry = X509CRLEntry.X509CRLEntryFromASN1Object(revokedCertificateNode, rawBytes);
            this.revokedCertificates.put(entry.getSerialNumber(), entry);
            ++i;
        }
    }

    private void configureExtensions(ASN1Decoder.Node extensions) {
        ASN1Decoder.Node[] allExtensions = (ASN1Decoder.Node[])extensions.data;
        ASN1Decoder.Node[] actualExtensions = (ASN1Decoder.Node[])allExtensions[0].data;
        this.extensions = new Hashtable();
        int i = 0;
        while (i < actualExtensions.length) {
            ASN1Decoder.Node extension = actualExtensions[i];
            ASN1Decoder.Node[] extensionParts = (ASN1Decoder.Node[])extension.data;
            boolean isCritical = false;
            if (extensionParts.length > 2) {
                isCritical = (Boolean)extensionParts[1].data;
            }
            ASN1OID extnID = new ASN1OID((int[])extensionParts[0].data);
            byte[] extnValue = (byte[])extensionParts[extensionParts.length - 1].data;
            X509Extension extn = new X509Extension(extnID, extnValue, isCritical);
            this.extensions.put(extn.name(), extn);
            ++i;
        }
    }

    private void configureSignature(ASN1Decoder.Node[] asn1CRL) {
        ASN1Decoder.Node[] signatureAlgorithm = (ASN1Decoder.Node[])asn1CRL[1].data;
        ASN1Decoder.BitString signature = (ASN1Decoder.BitString)asn1CRL[2].data;
        this.rawSignature = signature.data;
        this.sigAlgOID = ASN1OID.OIDToString((int[])signatureAlgorithm[0].data);
        String[] found = new String[1];
        this.signatureName = X509Certificate.getAlias("Alg.Alias.Signature.", this.sigAlgOID, found);
        this.signatureProviderName = found[0];
        if (signatureAlgorithm.length > 1) {
            ASN1Decoder.Node algParams = signatureAlgorithm[1];
            if (algParams.type != 5) {
                this.sigAlgParams = new byte[algParams.endPosition - algParams.startPosition + 1];
                System.arraycopy((Object)this.encoded, algParams.startPosition - this.originalOffsetIntoRawBytes, (Object)this.sigAlgParams, 0, this.sigAlgParams.length);
            }
        }
    }

    static CRL CRLFromASN1Object(ASN1Decoder.Node node, byte[] rawBytes) throws CRLException {
        try {
            X500Principal issuer;
            int tbsFieldOffset;
            X509CRL result = new X509CRL();
            ASN1Decoder.Node[] asn1CRL = (ASN1Decoder.Node[])node.data;
            int start = node.startPosition;
            int end = node.endPosition;
            if (start == 0 && end == rawBytes.length - 1) {
                result.encoded = rawBytes;
            } else {
                result.encoded = new byte[end - start + 1];
                System.arraycopy((Object)rawBytes, start, (Object)result.encoded, 0, result.encoded.length);
            }
            result.originalOffsetIntoRawBytes = start;
            result.configureSignature(asn1CRL);
            ASN1Decoder.Node tbsNode = asn1CRL[0];
            ASN1Decoder.Node[] tbsCertList = (ASN1Decoder.Node[])tbsNode.data;
            result.tbsNode = tbsNode;
            if (tbsCertList[0].type == 2) {
                BigInteger version = (BigInteger)tbsCertList[0].data;
                result.version = version.intValue() + 1;
                tbsFieldOffset = 0;
            } else {
                result.version = 2;
                tbsFieldOffset = -1;
            }
            result.issuer = issuer = new X500Principal(tbsCertList[tbsFieldOffset + 2]);
            ASN1Decoder.Node updateNode = tbsCertList[tbsFieldOffset + 3];
            result.thisUpdate = (Date)updateNode.data;
            if (tbsCertList.length <= tbsFieldOffset + 4) {
                return result;
            }
            updateNode = tbsCertList[tbsFieldOffset + 4];
            if (updateNode.type == 23 || updateNode.type == 24) {
                result.nextUpdate = (Date)updateNode.data;
            } else {
                --tbsFieldOffset;
            }
            if (tbsCertList.length <= tbsFieldOffset + 5) {
                return result;
            }
            ASN1Decoder.Node revokedCertificatesNode = tbsCertList[tbsFieldOffset + 5];
            if (revokedCertificatesNode.originalType == 16) {
                result.configureRevokedCertificates(revokedCertificatesNode, rawBytes);
            } else {
                --tbsFieldOffset;
            }
            if (tbsCertList.length <= tbsFieldOffset + 6) {
                return result;
            }
            ASN1Decoder.Node crlExtensions = tbsCertList[tbsFieldOffset + 6];
            if (crlExtensions.originalType == 0) {
                result.configureExtensions(crlExtensions);
            }
            return result;
        }
        catch (ClassCastException classCastException) {
            throw new CRLException();
        }
    }

    static CRL CRLFromASN1Object(InputStream inStream) throws CRLException {
        try {
            ASN1Decoder decoder = X509CRL.CRLDecoder(inStream);
            decoder.collectBytes(true);
            ASN1Decoder.Node node = decoder.readContents();
            X509CRL crl = (X509CRL)X509CRL.CRLFromASN1Object(node, decoder.collectedBytes());
            return crl;
        }
        catch (ASN1Exception aSN1Exception) {
            throw new CRLException();
        }
        catch (ClassCastException classCastException) {
            throw new CRLException();
        }
    }

    public javax.security.auth.x500.X500Principal getIssuerX500Principal() {
        return new javax.security.auth.x500.X500Principal(this.issuer.getName());
    }
}

