/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.util;

import com.ibm.oti.util.Msg;
import com.ibm.oti.vm.VM;
import java.io.ByteArrayOutputStream;
import java.io.UTFDataFormatException;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.TimeZone;

public final class Util {
    private static String[] WEEKDAYS = new String[]{"", "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    private static String[] MONTHS = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private static final boolean useNative = VM.useNatives();
    private static final String defaultEncoding;

    static {
        String encoding = System.getProperty("os.encoding");
        if (encoding != null) {
            try {
                "".getBytes(encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                encoding = null;
            }
        }
        defaultEncoding = encoding;
    }

    public static byte[] getBytes(String name) {
        if (defaultEncoding != null) {
            try {
                return name.getBytes(defaultEncoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        return name.getBytes();
    }

    public static String toString(byte[] bytes) {
        if (defaultEncoding != null) {
            try {
                return new String(bytes, 0, bytes.length, defaultEncoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        return new String(bytes, 0, bytes.length);
    }

    public static String toString(byte[] bytes, int offset, int length) {
        if (defaultEncoding != null) {
            try {
                return new String(bytes, offset, length, defaultEncoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        return new String(bytes, offset, length);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long parseDate(String string) {
        int offset = 0;
        int length = string.length();
        int state = 0;
        int year = -1;
        int month = -1;
        int date = -1;
        int hour = -1;
        int minute = -1;
        int second = -1;
        StringBuffer buffer = new StringBuffer();
        while (offset <= length) {
            int nextState;
            char next = offset < length ? (char)string.charAt(offset) : (char)'\r';
            ++offset;
            if (next >= 'a' && next <= 'z' || next >= 'A' && next <= 'Z') {
                nextState = 1;
            } else if (next >= '0' && next <= '9') {
                nextState = 2;
            } else {
                if (" ,-:\r\t".indexOf(next) == -1) {
                    throw new IllegalArgumentException();
                }
                nextState = 0;
            }
            if (state == 2 && nextState != 2) {
                int digit = Integer.parseInt(buffer.toString());
                buffer.setLength(0);
                if (digit >= 70) {
                    if (year != -1 || next != ' ' && next != ',' && next != '\r') {
                        throw new IllegalArgumentException();
                    }
                    year = digit;
                } else if (next == ':') {
                    if (hour == -1) {
                        hour = digit;
                    } else {
                        if (minute != -1) throw new IllegalArgumentException();
                        minute = digit;
                    }
                } else if (next == ' ' || next == ',' || next == '-' || next == '\r') {
                    if (hour != -1 && minute == -1) {
                        minute = digit;
                    } else if (minute != -1 && second == -1) {
                        second = digit;
                    } else if (date == -1) {
                        date = digit;
                    } else {
                        if (year != -1) throw new IllegalArgumentException();
                        year = digit;
                    }
                } else {
                    if (year != -1 || month == -1 || date == -1) throw new IllegalArgumentException();
                    year = digit;
                }
            } else if (state == 1 && nextState != 1) {
                String text = buffer.toString().toUpperCase();
                buffer.setLength(0);
                if (text.length() < 3) {
                    throw new IllegalArgumentException();
                }
                if (!(Util.parse(text, WEEKDAYS) != -1 || month == -1 && (month = Util.parse(text, MONTHS)) != -1 || text.equals("GMT"))) {
                    throw new IllegalArgumentException();
                }
            }
            if (nextState == 1 || nextState == 2) {
                buffer.append(next);
            }
            state = nextState;
        }
        if (year == -1 || month == -1 || date == -1) throw new IllegalArgumentException();
        if (hour == -1) {
            hour = 0;
        }
        if (minute == -1) {
            minute = 0;
        }
        if (second == -1) {
            second = 0;
        }
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        int current = cal.get(1) - 80;
        if (year < 100 && (year += current / 100 * 100) < current) {
            year += 100;
        }
        cal.set(1, year);
        cal.set(2, month);
        cal.set(5, date);
        cal.set(11, hour);
        cal.set(12, minute);
        cal.set(13, second);
        cal.set(14, 0);
        return cal.getTime().getTime();
    }

    private static int parse(String string, String[] array) {
        int length = string.length();
        int i = 0;
        while (i < array.length) {
            if (string.regionMatches(true, 0, array[i], 0, length)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static native String convertUTF8(byte[] var0, int var1, int var2);

    public static String convertFromUTF8(byte[] buf, int offset, int utfSize) throws UTFDataFormatException {
        if (useNative) {
            String result = Util.convertUTF8(buf, offset, utfSize);
            if (result != null) {
                return result;
            }
            throw new UTFDataFormatException();
        }
        return Util.convertUTF8WithBuf(buf, new char[utfSize], offset, utfSize);
    }

    public static String convertUTF8WithBuf(byte[] buf, char[] out, int offset, int utfSize) throws UTFDataFormatException {
        int count = 0;
        int s = 0;
        while (count < utfSize) {
            byte b;
            if ((out[s] = (char)buf[offset + count++]) < '\u0080') {
                ++s;
                continue;
            }
            char a = out[s];
            if ((a & 0xE0) == 192) {
                if (count >= utfSize) {
                    throw new UTFDataFormatException(Msg.getString("K0062", count));
                }
                if (((b = buf[count++]) & 0xC0) != 128) {
                    throw new UTFDataFormatException(Msg.getString("K0062", count - 1));
                }
                out[s++] = (char)((a & 0x1F) << 6 | b & 0x3F);
                continue;
            }
            if ((a & 0xF0) == 224) {
                if (count + 1 >= utfSize) {
                    throw new UTFDataFormatException(Msg.getString("K0063", count + 1));
                }
                b = buf[count++];
                byte c = buf[count++];
                if ((b & 0xC0) != 128 || (c & 0xC0) != 128) {
                    throw new UTFDataFormatException(Msg.getString("K0064", count - 2));
                }
                out[s++] = (char)((a & 0xF) << 12 | (b & 0x3F) << 6 | c & 0x3F);
                continue;
            }
            throw new UTFDataFormatException(Msg.getString("K0065", count - 1));
        }
        return new String(out, 0, s);
    }

    public static boolean matchesPattern(String testString, String pattern) {
        if (testString.indexOf(42) != -1) {
            return false;
        }
        if (testString.equals(pattern)) {
            return true;
        }
        int idxWildcard = pattern.indexOf(42);
        if (idxWildcard == -1) {
            return false;
        }
        if (idxWildcard > 0 && !testString.regionMatches(false, 0, pattern, 0, idxWildcard)) {
            return false;
        }
        if (idxWildcard < pattern.length() - 1) {
            int testlen = pattern.length() - idxWildcard - 1;
            if (!testString.regionMatches(false, testString.length() - testlen, pattern, idxWildcard + 1, testlen)) {
                return false;
            }
        }
        return true;
    }

    public static String decode(String s, boolean convertPlus) {
        return Util.decode(s, convertPlus, null);
    }

    public static String decode(String s, boolean convertPlus, String encoding) {
        if (!convertPlus && s.indexOf(37) == -1) {
            return s;
        }
        StringBuffer result = new StringBuffer(s.length());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (convertPlus && c == '+') {
                result.append(' ');
            } else {
                if (c == '%') {
                    out.reset();
                    do {
                        if (i + 2 >= s.length()) {
                            throw new IllegalArgumentException(Msg.getString("K01fe", i));
                        }
                        int d1 = Character.digit(s.charAt(i + 1), 16);
                        int d2 = Character.digit(s.charAt(i + 2), 16);
                        if (d1 == -1 || d2 == -1) {
                            throw new IllegalArgumentException(Msg.getString("K01ff", s.substring(i, i + 3), String.valueOf(i)));
                        }
                        out.write((byte)((d1 << 4) + d2));
                    } while ((i += 3) < s.length() && s.charAt(i) == '%');
                    if (encoding != null) {
                        try {
                            result.append(out.toString(encoding));
                            continue;
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new IllegalArgumentException(e.getMessage());
                        }
                    }
                    result.append(out.toString());
                    continue;
                }
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }
}

