/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.vm;

import com.ibm.oti.vm.AbstractClassLoader;
import com.ibm.oti.vm.VM;
import java.util.Hashtable;

public class AppClassLoader
extends AbstractClassLoader {
    private boolean checkingPackageAccess = false;
    private static Hashtable protectionDomainCache = new Hashtable(10);

    public AppClassLoader() {
        this(null);
    }

    public AppClassLoader(ClassLoader parent) {
        super(parent);
        String classPath = System.getProperty("java.class.path", ".");
        classPath = this.parsePath(classPath);
        VM.setClassPathImpl((ClassLoader)this, classPath);
    }

    AppClassLoader(boolean ignore) {
        super(null);
    }

    protected Class findClass(String className) throws ClassNotFoundException {
        Class newClass = VM.findClassOrNull(className, this);
        if (newClass == null) {
            throw new ClassNotFoundException(className);
        }
        int index = VM.getCPIndexImpl(newClass);
        String packageName = this.getPackageName(newClass);
        if (packageName != null) {
            this.definePackage(packageName, index);
        }
        VM.setPDImpl(newClass, this.getFilePD(index));
        return newClass;
    }

    Hashtable getProtectionDomainCache() {
        return protectionDomainCache;
    }

    protected synchronized Class loadClass(String className, boolean resolveClass) throws ClassNotFoundException {
        int index;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && !this.checkingPackageAccess && (index = className.lastIndexOf(46)) > 0) {
            try {
                this.checkingPackageAccess = true;
                sm.checkPackageAccess(className.substring(0, index));
            }
            finally {
                this.checkingPackageAccess = false;
            }
        }
        return super.loadClass(className, resolveClass);
    }
}

