/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.vm;

import com.ibm.oti.util.Msg;
import com.ibm.oti.util.Util;
import com.ibm.oti.vm.Jxe;
import com.ibm.oti.vm.JxeException;
import com.ibm.oti.vm.JxeOutputStream;
import java.io.InputStream;

public final class JxeUtil {
    static {
        try {
            System.loadLibrary("iverel" + System.getProperty("com.ibm.oti.vm.library.version", "23"));
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            try {
                System.loadLibrary("j9vmall" + System.getProperty("com.ibm.oti.vm.library.version", "23"));
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError2) {}
        }
    }

    private static native long nativeGetRomImagePointerFromJxePointer(long var0);

    private static native String nativeGetRelocationMessage(int var0);

    static String getRelocationMessage(int relocationMessageNumber) {
        return JxeUtil.nativeGetRelocationMessage(relocationMessageNumber);
    }

    public static byte[] getRomClass(Jxe jxe, String className) {
        byte[] romClassCookie = new byte[40];
        if (jxe.romSegmentPointer == 0L) {
            return null;
        }
        if (!JxeUtil.nativeGetRomClassCookie(jxe.romSegmentPointer, jxe.getJxePointer(), className, romClassCookie)) {
            return null;
        }
        return romClassCookie;
    }

    private static native boolean nativeGetRomClassCookie(long var0, long var2, String var4, byte[] var5);

    private static native long nativeRomImageLoad(long var0, ClassLoader var2, long var3, long var5);

    public static void romImageLoad(Jxe jxe, ClassLoader classLoader) throws JxeException {
        if (jxe.romSegmentPointer != 0L) {
            throw new JxeException(Msg.getString("K0228"));
        }
        long romImagePointer = JxeUtil.nativeGetRomImagePointerFromJxePointer(jxe.getJxePointer());
        if (0L == romImagePointer) {
            throw new JxeException(Msg.getString("K01a1"));
        }
        long romSegmentPointer = JxeUtil.nativeRomImageLoad(romImagePointer, classLoader, jxe.getJxePointer(), jxe.getJxeAlloc());
        if (0L == romSegmentPointer) {
            throw new JxeException(Msg.getString("K01a2"));
        }
        jxe.romSegmentPointer = romSegmentPointer;
    }

    private static native int nativeRelocateJxeInPlace(long var0);

    static void relocateJxeInPlace(long jxePointer) throws JxeException {
        int rc = JxeUtil.nativeRelocateJxeInPlace(jxePointer);
        if (rc != 0) {
            throw JxeException.jxeExceptionFromRelocationReturnCode(rc);
        }
    }

    private static native int nativeRelocateJxeStreaming(InputStream var0, JxeOutputStream var1, int var2, int var3, long var4);

    public static void relocateJxeStreaming(InputStream iStream, JxeOutputStream oStream, int length, int bufferSize, long romImageAddress) throws JxeException {
        int rc = JxeUtil.nativeRelocateJxeStreaming(iStream, oStream, length, bufferSize, romImageAddress);
        if (rc != 0) {
            throw JxeException.jxeExceptionFromRelocationReturnCode(rc);
        }
    }

    private static native String nativeGetEnvironmentVariable(String var0);

    public static String getEnvironmentVariable(String key) {
        return JxeUtil.nativeGetEnvironmentVariable(key);
    }

    private static native int nativeVerifyJxe(long var0);

    public static void verifyJxe(long romImageAddress) throws JxeException {
        int rc = JxeUtil.nativeVerifyJxe(romImageAddress);
        if (rc != 0) {
            throw JxeException.jxeExceptionFromRelocationReturnCode(rc);
        }
    }

    private static native int nativeGetCurrentRomImageVersion();

    public static long getCurrentRomImageVersion() {
        return JxeUtil.nativeGetCurrentRomImageVersion();
    }

    private static native int nativeGetLowestRomImageVersion();

    public static long getLowestRomImageVersion() {
        return JxeUtil.nativeGetLowestRomImageVersion();
    }

    public static native String[] nativeGetClassList(byte[] var0);

    public static String[] getClassList(String jxe) {
        byte[] bytes = Util.getBytes(jxe);
        return JxeUtil.nativeGetClassList(bytes);
    }

    static boolean registerJxe(Jxe jxe) {
        long romImagePointer = JxeUtil.nativeGetRomImagePointerFromJxePointer(jxe.getJxePointer());
        if (0L == romImagePointer) {
            return false;
        }
        JxeUtil.nativeRegisterJxe(romImagePointer, jxe.getJxePointer(), jxe.getJxeAlloc());
        return true;
    }

    static native void nativeRegisterJxe(long var0, long var2, long var4);

    static boolean unregisterJxe(Jxe jxe) {
        long romImagePointer = JxeUtil.nativeGetRomImagePointerFromJxePointer(jxe.getJxePointer());
        if (0L == romImagePointer) {
            return false;
        }
        JxeUtil.nativeUnregisterJxe(romImagePointer);
        return true;
    }

    static native void nativeUnregisterJxe(long var0);
}

