/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.EmulatedFields;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;

class EmulatedFieldsForDumping
extends ObjectOutputStream.PutField {
    private EmulatedFields emulatedFields;

    EmulatedFieldsForDumping(ObjectStreamClass streamClass) {
        this.emulatedFields = new EmulatedFields(streamClass.fields(), null);
    }

    EmulatedFields emulatedFields() {
        return this.emulatedFields;
    }

    public void put(String name, byte value) {
        this.emulatedFields.put(name, value);
    }

    public void put(String name, char value) {
        this.emulatedFields.put(name, value);
    }

    public void put(String name, double value) {
        this.emulatedFields.put(name, value);
    }

    public void put(String name, float value) {
        this.emulatedFields.put(name, value);
    }

    public void put(String name, int value) {
        this.emulatedFields.put(name, value);
    }

    public void put(String name, long value) {
        this.emulatedFields.put(name, value);
    }

    public void put(String name, Object value) {
        this.emulatedFields.put(name, value);
    }

    public void put(String name, short value) {
        this.emulatedFields.put(name, value);
    }

    public void put(String name, boolean value) {
        this.emulatedFields.put(name, value);
    }

    public void write(ObjectOutput output) throws IOException {
        EmulatedFields.ObjectSlot[] slots = this.emulatedFields.slots();
        int i = 0;
        while (i < slots.length) {
            EmulatedFields.ObjectSlot slot = slots[i];
            Object fieldValue = slot.getFieldValue();
            Class type = slot.getField().getType();
            if (type == Integer.TYPE) {
                output.writeInt(fieldValue != null ? (Integer)fieldValue : 0);
            } else if (type == Byte.TYPE) {
                output.writeByte(fieldValue != null ? (int)((Byte)fieldValue).byteValue() : 0);
            } else if (type == Character.TYPE) {
                output.writeChar(fieldValue != null ? (int)((Character)fieldValue).charValue() : 0);
            } else if (type == Short.TYPE) {
                output.writeShort(fieldValue != null ? (int)((Short)fieldValue).shortValue() : 0);
            } else if (type == Boolean.TYPE) {
                output.writeBoolean(fieldValue != null ? (Boolean)fieldValue : false);
            } else if (type == Long.TYPE) {
                output.writeLong(fieldValue != null ? (Long)fieldValue : 0L);
            } else if (type == Float.TYPE) {
                output.writeFloat(fieldValue != null ? ((Float)fieldValue).floatValue() : 0.0f);
            } else if (type == Double.TYPE) {
                output.writeDouble(fieldValue != null ? (Double)fieldValue : 0.0);
            } else {
                output.writeObject(fieldValue);
            }
            ++i;
        }
    }
}

