/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.ibm.oti.util.Sorter;
import java.lang.ref.WeakReference;

public class ObjectStreamField
implements Comparable {
    private String name;
    private Object type;
    int offset;
    private String typeString;
    private boolean unshared = false;

    public ObjectStreamField(String name, Class cl) {
        if (name == null || cl == null) {
            throw new NullPointerException();
        }
        this.name = name;
        this.type = new WeakReference(cl);
    }

    public ObjectStreamField(String name, Class cl, boolean unshared) {
        if (name == null || cl == null) {
            throw new NullPointerException();
        }
        this.name = name;
        this.type = cl.getClassLoader() == null ? cl : new WeakReference(cl);
        this.unshared = unshared;
    }

    ObjectStreamField(String signature, String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.name = name;
        this.typeString = signature.replace('.', '/');
    }

    public int compareTo(Object o) {
        boolean fPrimitive;
        ObjectStreamField f = (ObjectStreamField)o;
        boolean thisPrimitive = this.isPrimitive();
        if (thisPrimitive != (fPrimitive = f.isPrimitive())) {
            return thisPrimitive ? -1 : 1;
        }
        return this.getName().compareTo(f.getName());
    }

    public String getName() {
        return this.name;
    }

    public int getOffset() {
        return this.offset;
    }

    public Class getType() {
        if (this.type instanceof WeakReference) {
            return (Class)((WeakReference)this.type).get();
        }
        return (Class)this.type;
    }

    public char getTypeCode() {
        Class type = this.getType();
        if (type == Integer.TYPE) {
            return 'I';
        }
        if (type == Byte.TYPE) {
            return 'B';
        }
        if (type == Character.TYPE) {
            return 'C';
        }
        if (type == Short.TYPE) {
            return 'S';
        }
        if (type == Boolean.TYPE) {
            return 'Z';
        }
        if (type == Long.TYPE) {
            return 'J';
        }
        if (type == Float.TYPE) {
            return 'F';
        }
        if (type == Double.TYPE) {
            return 'D';
        }
        if (type.isArray()) {
            return '[';
        }
        return 'L';
    }

    public String getTypeString() {
        if (this.typeString == null) {
            this.typeString = this.computeTypeString().intern();
        }
        return this.typeString;
    }

    private String computeTypeString() {
        Class type = this.getType();
        if (type.isArray()) {
            return type.getName().replace('.', '/');
        }
        if (this.isPrimitive()) {
            if (type == Integer.TYPE) {
                return "I";
            }
            if (type == Byte.TYPE) {
                return "B";
            }
            if (type == Character.TYPE) {
                return "C";
            }
            if (type == Short.TYPE) {
                return "S";
            }
            if (type == Boolean.TYPE) {
                return "Z";
            }
            if (type == Long.TYPE) {
                return "J";
            }
            if (type == Float.TYPE) {
                return "F";
            }
            if (type == Double.TYPE) {
                return "D";
            }
            throw new RuntimeException();
        }
        return ("L" + type.getName() + ';').replace('.', '/');
    }

    public boolean isPrimitive() {
        Class type = this.getType();
        return type != null && type.isPrimitive();
    }

    protected void setOffset(int newValue) {
        this.offset = newValue;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + '(' + this.getName() + ':' + this.getType() + ')';
    }

    static void sortFields(ObjectStreamField[] fields) {
        if (fields.length > 1) {
            Sorter.Comparator fieldDescComparator = new Sorter.Comparator(){

                public int compare(Object o1, Object o2) {
                    ObjectStreamField f1 = (ObjectStreamField)o1;
                    ObjectStreamField f2 = (ObjectStreamField)o2;
                    return f1.compareTo(f2);
                }
            };
            Sorter.sort(fields, fieldDescComparator);
        }
    }

    void resolve(ClassLoader loader) {
        String className;
        if (this.typeString.length() == 1) {
            switch (this.typeString.charAt(0)) {
                case 'I': {
                    this.type = Integer.TYPE;
                    return;
                }
                case 'B': {
                    this.type = Byte.TYPE;
                    return;
                }
                case 'C': {
                    this.type = Character.TYPE;
                    return;
                }
                case 'S': {
                    this.type = Short.TYPE;
                    return;
                }
                case 'Z': {
                    this.type = Boolean.TYPE;
                    return;
                }
                case 'J': {
                    this.type = Long.TYPE;
                    return;
                }
                case 'F': {
                    this.type = Float.TYPE;
                    return;
                }
                case 'D': {
                    this.type = Double.TYPE;
                    return;
                }
            }
        }
        if ((className = this.typeString.replace('/', '.')).charAt(0) == 'L') {
            className = className.substring(1, className.length() - 1);
        }
        try {
            Class cl = Class.forName(className, false, loader);
            this.type = cl.getClassLoader() == null ? cl : new WeakReference(cl);
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    boolean getUnshared() {
        return this.unshared;
    }
}

