/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.ibm.oti.util.Msg;
import com.ibm.oti.util.Util;
import com.ibm.oti.vm.AbstractClassLoader;
import com.ibm.oti.vm.BootstrapClassLoader;
import com.ibm.oti.vm.URLAppClassLoader;
import com.ibm.oti.vm.URLExtensionClassLoader;
import com.ibm.oti.vm.VM;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;

public abstract class ClassLoader {
    static ClassLoader systemClassLoader;
    private static ClassLoader applicationClassLoader;
    private static boolean initSystemClassLoader;
    private long vmRef;
    ClassLoader parent;
    private Object assertionLock = new AssertionLock();
    private boolean defaultAssertionStatus;
    private Map packageAssertionStatus;
    private Map classAssertionStatus;
    private Hashtable packages = new Hashtable();
    private Object lazyInitLock = new LazyInitLock();
    private Hashtable classSigners = null;
    private Hashtable packageSigners = new Hashtable();
    private static Certificate[] emptyCertificates;
    private ProtectionDomain defaultProtectionDomain;
    private Hashtable bundleCache;
    static /* synthetic */ Class class$0;

    static {
        initSystemClassLoader = false;
        emptyCertificates = new Certificate[0];
    }

    static final void initializeClassLoaders() {
        if (systemClassLoader != null) {
            return;
        }
        ClassLoader sysTemp = null;
        String systemLoaderString = System.getProperty("systemClassLoader");
        if (systemLoaderString == null) {
            sysTemp = BootstrapClassLoader.singleton();
        } else {
            try {
                sysTemp = (ClassLoader)Class.forName(systemLoaderString, true, null).newInstance();
            }
            catch (Throwable x) {
                x.printStackTrace();
                System.exit(1);
            }
        }
        systemClassLoader = sysTemp;
        AbstractClassLoader.setBootstrapClassLoader(systemClassLoader);
        applicationClassLoader = systemClassLoader;
        ClassLoader extTemp = null;
        String extensionLoaderString = System.getProperty("extensionClassLoader");
        if (extensionLoaderString == null) {
            extTemp = new URLExtensionClassLoader();
        } else {
            try {
                extTemp = (ClassLoader)Class.forName(extensionLoaderString, true, systemClassLoader).newInstance();
            }
            catch (Throwable x) {
                x.printStackTrace();
                System.exit(1);
            }
        }
        applicationClassLoader = extTemp;
        ClassLoader appTemp = null;
        String applicationLoaderString = System.getProperty("applicationClassLoader");
        if (applicationLoaderString == null) {
            appTemp = new URLAppClassLoader(applicationClassLoader);
        } else {
            try {
                appTemp = (ClassLoader)Class.forName(applicationLoaderString, true, applicationClassLoader).newInstance();
                super.setParent(applicationClassLoader);
            }
            catch (Throwable x) {
                x.printStackTrace();
                System.exit(1);
            }
        }
        applicationClassLoader = appTemp;
    }

    protected ClassLoader() {
        this(applicationClassLoader);
    }

    protected ClassLoader(ClassLoader parentLoader) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkCreateClassLoader();
        }
        this.parent = parentLoader;
        if (systemClassLoader != null) {
            VM.initializeClassLoader(this, false);
        }
        this.initializeClassLoaderAssertStatus();
    }

    protected final Class defineClass(String className, byte[] classRep, int offset, int length) throws ClassFormatError {
        return this.defineClass(className, classRep, offset, length, null);
    }

    private String checkClassName(String className) {
        int index = className.lastIndexOf(46);
        if (index >= 0) {
            String packageName = className.substring(0, index);
            if (className.startsWith("java.")) {
                throw new SecurityException(Msg.getString("K01d2", packageName, className));
            }
            return packageName;
        }
        return "";
    }

    protected final Class defineClass(final String className, final byte[] classRep, final int offset, final int length, ProtectionDomain protectionDomain) throws ClassFormatError {
        CodeSource cs;
        Object[] certs = null;
        if (protectionDomain != null && (cs = protectionDomain.getCodeSource()) != null) {
            certs = cs.getCertificates();
        }
        if (className != null) {
            String packageName = this.checkClassName(className);
            this.checkPackageSigners(packageName, className, (Certificate[])certs);
        }
        if (offset < 0 || length < 0 || offset > classRep.length || length > classRep.length - offset) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (protectionDomain == null) {
            protectionDomain = this.getDefaultProtectionDomain();
        }
        final ProtectionDomain pd = protectionDomain;
        Class answer = System.getSecurityManager() == null ? this.defineClassImpl(className, classRep, offset, length, pd) : (Class)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ClassLoader.this.defineClassImpl(className, classRep, offset, length, pd);
            }
        }, new AccessControlContext(new ProtectionDomain[]{pd}));
        if (this.isVerboseImpl()) {
            URL url;
            CodeSource cs2;
            String location = "<unknown>";
            if (pd != null && (cs2 = pd.getCodeSource()) != null && (url = cs2.getLocation()) != null) {
                location = url.toString();
            }
            VM.dumpString("class load: " + answer.getName() + " from: " + location + "\n");
        }
        if (certs != null) {
            this.setSigners(answer, certs);
        }
        return answer;
    }

    private native boolean isVerboseImpl();

    private void checkPackageSigners(String packageName, String className, Certificate[] classCerts) {
        Certificate[] packageCerts = (Certificate[])this.packageSigners.get(packageName);
        if (packageCerts == null) {
            if (classCerts == null) {
                this.packageSigners.put(packageName, emptyCertificates);
            } else {
                this.packageSigners.put(packageName, classCerts);
            }
        } else {
            if (classCerts == null && packageCerts.length == 0 || classCerts == packageCerts) {
                return;
            }
            if (classCerts != null && classCerts.length == packageCerts.length) {
                boolean foundMatch = true;
                int i = 0;
                while (i < classCerts.length) {
                    block11: {
                        if (classCerts[i] != packageCerts[i] && !classCerts[i].equals(packageCerts[i])) {
                            int j = 0;
                            while (j < packageCerts.length) {
                                if (j == i || classCerts[i] != packageCerts[j] && !classCerts[i].equals(packageCerts[j])) {
                                    ++j;
                                    continue;
                                }
                                break block11;
                            }
                            foundMatch = false;
                            break;
                        }
                    }
                    ++i;
                }
                if (foundMatch) {
                    return;
                }
            }
            throw new SecurityException(Msg.getString("K01d1", className));
        }
    }

    private final ProtectionDomain getDefaultProtectionDomain() {
        if (this.defaultProtectionDomain == null) {
            CodeSource nullCodeSource = new CodeSource(null, null);
            this.defaultProtectionDomain = new ProtectionDomain(nullCodeSource, null, this, null);
        }
        return this.defaultProtectionDomain;
    }

    private final native Class defineClassImpl(String var1, byte[] var2, int var3, int var4, Object var5);

    protected Class findClass(String className) throws ClassNotFoundException {
        throw new ClassNotFoundException();
    }

    protected final Class findLoadedClass(String className) {
        if (className != null && className.length() > 0 && className.charAt(0) == '[') {
            return null;
        }
        return this.findLoadedClassImpl(className);
    }

    private native Class findLoadedClassImpl(String var1);

    protected final Class findSystemClass(String className) throws ClassNotFoundException {
        return applicationClassLoader.loadClass(className);
    }

    public final ClassLoader getParent() {
        ClassLoader callersClassLoader;
        SecurityManager security = System.getSecurityManager();
        if (security != null && (callersClassLoader = ClassLoader.callerClassLoader()) != null && callersClassLoader != this && !callersClassLoader.isAncestorOf(this)) {
            security.checkPermission(RuntimePermission.permissionToGetClassLoader);
        }
        return this.parent;
    }

    public URL getResource(String resName) {
        URL url;
        URL uRL = url = this.parent == null ? systemClassLoader.findResource(resName) : this.parent.getResource(resName);
        if (url != null) {
            return url;
        }
        return this.findResource(resName);
    }

    public final Enumeration getResources(String resName) throws IOException {
        ClassLoader up = this;
        final Vector resources = new Vector();
        while (true) {
            Enumeration e;
            if ((e = up.findResources(resName)) != null && e.hasMoreElements()) {
                resources.addElement(e);
            }
            if (up == systemClassLoader) break;
            up = up.parent;
            if (up != null) continue;
            up = systemClassLoader;
        }
        return new Enumeration(){
            int index;
            {
                this.index = vector.size() - 1;
            }

            public boolean hasMoreElements() {
                while (this.index >= 0) {
                    if (((Enumeration)resources.elementAt(this.index)).hasMoreElements()) {
                        return true;
                    }
                    --this.index;
                }
                return false;
            }

            public Object nextElement() {
                while (this.index >= 0) {
                    Enumeration e = (Enumeration)resources.elementAt(this.index);
                    if (e.hasMoreElements()) {
                        return (URL)e.nextElement();
                    }
                    --this.index;
                }
                throw new NoSuchElementException();
            }
        };
    }

    public InputStream getResourceAsStream(String resName) {
        URL url = this.getResource(resName);
        try {
            if (url != null) {
                return url.openStream();
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    static void completeInitialization() {
        initSystemClassLoader = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassLoader getSystemClassLoader() {
        ClassLoader callersClassLoader;
        SecurityManager security;
        if (initSystemClassLoader) {
            Class classLoaderClass;
            Class clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.ClassLoader");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class clazz2 = classLoaderClass = clazz;
            synchronized (clazz2) {
                if (initSystemClassLoader) {
                    initSystemClassLoader = false;
                    String userLoader = System.getProperty("java.system.class.loader");
                    if (userLoader != null) {
                        try {
                            Class loaderClass = Class.forName(userLoader, true, applicationClassLoader);
                            Constructor constructor = loaderClass.getConstructor(new Class[]{classLoaderClass});
                            applicationClassLoader = (ClassLoader)constructor.newInstance(new Object[]{applicationClassLoader});
                        }
                        catch (Throwable e) {
                            throw new Error(e);
                        }
                    }
                }
            }
        }
        if ((security = System.getSecurityManager()) != null && (callersClassLoader = ClassLoader.callerClassLoader()) != null && callersClassLoader != applicationClassLoader && !callersClassLoader.isAncestorOf(applicationClassLoader)) {
            security.checkPermission(RuntimePermission.permissionToGetClassLoader);
        }
        return applicationClassLoader;
    }

    public static URL getSystemResource(String resName) {
        return ClassLoader.getSystemClassLoader().getResource(resName);
    }

    public static Enumeration getSystemResources(String resName) throws IOException {
        return ClassLoader.getSystemClassLoader().getResources(resName);
    }

    public static InputStream getSystemResourceAsStream(String resName) {
        return ClassLoader.getSystemClassLoader().getResourceAsStream(resName);
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        return this.loadClass(className, false);
    }

    protected synchronized Class loadClass(String className, boolean resolveClass) throws ClassNotFoundException {
        Class loadedClass = this.findLoadedClass(className);
        if (loadedClass == null) {
            try {
                loadedClass = this.parent == null ? systemClassLoader.loadClass(className) : this.parent.loadClass(className, resolveClass);
            }
            catch (ClassNotFoundException classNotFoundException) {}
            if (loadedClass == null) {
                loadedClass = this.findClass(className);
            }
        }
        if (resolveClass) {
            this.resolveClass(loadedClass);
        }
        return loadedClass;
    }

    protected final void resolveClass(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        J9VMInternals.verify(clazz);
    }

    private void setParent(ClassLoader newParent) {
        this.parent = newParent;
    }

    final boolean isSystemClassLoader() {
        if (this == systemClassLoader) {
            return true;
        }
        ClassLoader cl = applicationClassLoader;
        while (cl != null) {
            if (this == cl) {
                return true;
            }
            cl = cl.parent;
        }
        return false;
    }

    final boolean isAncestorOf(ClassLoader child) {
        if (child == null) {
            return false;
        }
        if (this == systemClassLoader) {
            return true;
        }
        ClassLoader cl = child.parent;
        while (cl != null) {
            if (this == cl) {
                return true;
            }
            cl = cl.parent;
        }
        return false;
    }

    protected URL findResource(String resName) {
        return null;
    }

    protected Enumeration findResources(String resName) throws IOException {
        return new Vector().elements();
    }

    protected String findLibrary(String libName) {
        return null;
    }

    protected Package getPackage(String name) {
        if (this != systemClassLoader) {
            Package pkg;
            ClassLoader parent = this.parent;
            if (parent == null) {
                parent = systemClassLoader;
            }
            if ((pkg = parent.getPackage(name)) != null) {
                return pkg;
            }
        }
        return (Package)this.packages.get(name);
    }

    protected Package[] getPackages() {
        Package[] ancestorsPackages = null;
        if (this.parent == null) {
            if (this != systemClassLoader) {
                ancestorsPackages = systemClassLoader.getPackages();
            }
        } else {
            ancestorsPackages = this.parent.getPackages();
        }
        int resultSize = this.packages.size();
        if (ancestorsPackages != null) {
            resultSize += ancestorsPackages.length;
        }
        Package[] result = new Package[resultSize];
        Enumeration myPkgs = this.packages.elements();
        int i = 0;
        if (ancestorsPackages != null) {
            while (i < ancestorsPackages.length) {
                result[i] = ancestorsPackages[i];
                ++i;
            }
        }
        while (myPkgs.hasMoreElements()) {
            result[i++] = (Package)myPkgs.nextElement();
        }
        return result;
    }

    protected Package definePackage(String name, String specTitle, String specVersion, String specVendor, String implTitle, String implVersion, String implVendor, URL sealBase) throws IllegalArgumentException {
        Hashtable hashtable = this.packages;
        synchronized (hashtable) {
            if (this.getPackage(name) == null) {
                Package newPackage = new Package(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
                this.packages.put(name, newPackage);
                return newPackage;
            }
            throw new IllegalArgumentException(Msg.getString("K0053", name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Object[] getSigners(Class c) {
        Object object = this.lazyInitLock;
        synchronized (object) {
            if (this.classSigners == null) {
                return null;
            }
        }
        try {
            Object result = this.classSigners.get(c);
            if (result != null) {
                return (Object[])result.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setSigners(Class c, Object[] signers) {
        if (c.getClassLoaderImpl() == this) {
            if (signers == null) {
                Object object = this.lazyInitLock;
                synchronized (object) {
                    if (this.classSigners == null) {
                        return;
                    }
                }
                this.classSigners.remove(c);
            } else {
                Object object = this.lazyInitLock;
                synchronized (object) {
                    if (this.classSigners == null) {
                        this.classSigners = new Hashtable();
                    }
                }
                this.classSigners.put(c, signers);
            }
        } else {
            c.getClassLoaderImpl().setSigners(c, signers);
        }
    }

    static final native ClassLoader getStackClassLoader(int var0);

    static ClassLoader callerClassLoader() {
        ClassLoader loader = ClassLoader.getStackClassLoader(2);
        if (loader == systemClassLoader) {
            return null;
        }
        return loader;
    }

    static synchronized void loadLibraryWithClassLoader(String libName, ClassLoader loader) {
        String realLibName;
        SecurityManager smngr = System.getSecurityManager();
        if (smngr != null) {
            smngr.checkLink(libName);
        }
        if (loader != null && (realLibName = loader.findLibrary(libName)) != null) {
            ClassLoader.loadLibraryWithPath(realLibName, loader, null);
            return;
        }
        ClassLoader.loadLibraryWithPath(libName, loader, System.internalGetProperties().getProperty(loader == null ? "com.ibm.oti.vm.bootstrap.library.path" : "java.library.path"));
    }

    static void loadLibraryWithPath(String libName, ClassLoader loader, String libraryPath) {
        byte[] message = ClassLoader.loadLibraryWithPath(Util.getBytes(libName), loader, libraryPath == null ? null : Util.getBytes(libraryPath));
        if (message != null) {
            String error;
            try {
                error = Util.convertFromUTF8(message, 0, message.length);
            }
            catch (IOException iOException) {
                error = Util.toString(message);
            }
            throw new UnsatisfiedLinkError(String.valueOf(libName) + " (" + error + ")");
        }
    }

    private static native byte[] loadLibraryWithPath(byte[] var0, ClassLoader var1, byte[] var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClassAssertionStatus(String cname, boolean enable) {
        Object object = this.assertionLock;
        synchronized (object) {
            if (this.classAssertionStatus == null) {
                this.classAssertionStatus = new HashMap();
            }
            this.classAssertionStatus.put(cname, enable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPackageAssertionStatus(String pname, boolean enable) {
        Object object = this.assertionLock;
        synchronized (object) {
            if (this.packageAssertionStatus == null) {
                this.packageAssertionStatus = new HashMap();
            }
            this.packageAssertionStatus.put(pname, enable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultAssertionStatus(boolean enable) {
        Object object = this.assertionLock;
        synchronized (object) {
            this.defaultAssertionStatus = enable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAssertionStatus() {
        Object object = this.assertionLock;
        synchronized (object) {
            this.defaultAssertionStatus = false;
            this.classAssertionStatus = null;
            this.packageAssertionStatus = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getClassAssertionStatus(String cname) {
        Object object = this.assertionLock;
        synchronized (object) {
            int dlrIndex = -1;
            if (this.classAssertionStatus != null) {
                Boolean b = (Boolean)this.classAssertionStatus.get(cname);
                if (b != null) {
                    return b;
                }
                dlrIndex = cname.indexOf(36);
                if (dlrIndex > 0 && (b = (Boolean)this.classAssertionStatus.get(cname.substring(0, dlrIndex))) != null) {
                    return b;
                }
            }
            if ((dlrIndex = cname.lastIndexOf(46)) > 0) {
                return this.getPackageAssertionStatus(cname.substring(0, dlrIndex));
            }
            return this.getDefaultAssertionStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getPackageAssertionStatus(String pname) {
        Object object = this.assertionLock;
        synchronized (object) {
            int prdIndex = -1;
            if (this.packageAssertionStatus != null) {
                Boolean b = (Boolean)this.packageAssertionStatus.get(pname);
                if (b != null) {
                    return b;
                }
                prdIndex = pname.lastIndexOf(46);
                if (prdIndex > 0) {
                    return this.getPackageAssertionStatus(pname.substring(0, prdIndex));
                }
            }
            return this.getDefaultAssertionStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getDefaultAssertionStatus() {
        Object object = this.assertionLock;
        synchronized (object) {
            return this.defaultAssertionStatus;
        }
    }

    private void initializeClassLoaderAssertStatus() {
        boolean bootLoader = systemClassLoader == null;
        String[] vmargs = VM.getVMArgs();
        String[] vmargOptions = new String[vmargs.length];
        String[] vmargExtraInfo = new String[vmargs.length];
        int i = 0;
        while (i < vmargOptions.length) {
            boolean def;
            int indexColon = vmargs[i].indexOf(58);
            if (indexColon == -1) {
                vmargOptions[i] = vmargs[i];
            } else {
                vmargOptions[i] = vmargs[i].substring(0, indexColon);
                vmargExtraInfo[i] = vmargs[i].substring(indexColon + 1);
            }
            if (vmargOptions[i].compareTo("-ea") == 0 || vmargOptions[i].compareTo("-enableassertions") == 0 || vmargOptions[i].compareTo("-da") == 0 || vmargOptions[i].compareTo("-disableassertions") == 0) {
                def = vmargOptions[i].charAt(1) == 'e';
                if (vmargExtraInfo[i] == null) {
                    if (!bootLoader) {
                        this.setDefaultAssertionStatus(def);
                    }
                } else {
                    String str = vmargExtraInfo[i];
                    int len = str.length();
                    if (len > 3 && str.charAt(len - 1) == '.' && str.charAt(len - 2) == '.' && str.charAt(len - 3) == '.') {
                        str = str.substring(0, len - 3);
                        this.setPackageAssertionStatus(str, def);
                    } else {
                        this.setClassAssertionStatus(str, def);
                    }
                }
            } else if ((vmargOptions[i].compareTo("-esa") == 0 || vmargOptions[i].compareTo("-enablesystemassertions") == 0 || vmargOptions[i].compareTo("-dsa") == 0 || vmargOptions[i].compareTo("-disablesystemassertions") == 0) && bootLoader) {
                def = vmargOptions[i].charAt(1) == 'e';
                this.setDefaultAssertionStatus(def);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Hashtable getBundleCache() {
        Object object = this.lazyInitLock;
        synchronized (object) {
            if (this.bundleCache == null) {
                this.bundleCache = new Hashtable();
            }
        }
        return this.bundleCache;
    }

    private static class AssertionLock {
        AssertionLock() {
        }
    }

    private static class LazyInitLock {
        LazyInitLock() {
        }
    }
}

