/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.ibm.oti.util.Msg;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;

public final class StringBuffer
implements Serializable,
CharSequence {
    private static final long serialVersionUID = 3388685877147921107L;
    private static final int INITIAL_SIZE = 16;
    private int count;
    private char[] value;
    private boolean shared;

    public StringBuffer() {
        this(16);
    }

    public StringBuffer(int capacity) {
        this.count = 0;
        this.value = new char[capacity];
    }

    public StringBuffer(String string) {
        this.count = string.length();
        this.value = new char[this.count + 16];
        string.getChars(0, this.count, this.value, 0);
    }

    public synchronized StringBuffer append(char[] chars) {
        int newSize = this.count + chars.length;
        if (newSize > this.value.length) {
            this.ensureCapacityImpl(newSize);
        }
        System.arraycopy((Object)chars, 0, (Object)this.value, this.count, chars.length);
        this.count = newSize;
        return this;
    }

    public synchronized StringBuffer append(char[] chars, int start, int length) {
        if (start >= 0 && length >= 0 && length <= chars.length - start) {
            int newSize = this.count + length;
            if (newSize > this.value.length) {
                this.ensureCapacityImpl(newSize);
            }
            System.arraycopy((Object)chars, start, (Object)this.value, this.count, length);
            this.count = newSize;
            return this;
        }
        throw new StringIndexOutOfBoundsException();
    }

    public synchronized StringBuffer append(char ch) {
        if (this.count >= this.value.length) {
            this.ensureCapacityImpl(this.count + 1);
        }
        this.value[this.count] = ch;
        ++this.count;
        return this;
    }

    public StringBuffer append(double value) {
        return this.append(String.valueOf(value));
    }

    public StringBuffer append(float value) {
        return this.append(String.valueOf(value));
    }

    public StringBuffer append(int value) {
        return this.append(Integer.toString(value));
    }

    public StringBuffer append(long value) {
        return this.append(Long.toString(value));
    }

    public StringBuffer append(Object value) {
        return this.append(String.valueOf(value));
    }

    public synchronized StringBuffer append(String string) {
        int adding;
        int newSize;
        if (string == null) {
            string = String.valueOf(string);
        }
        if ((newSize = this.count + (adding = string.length())) > this.value.length) {
            this.ensureCapacityImpl(newSize);
        }
        string.getChars(0, adding, this.value, this.count);
        this.count = newSize;
        return this;
    }

    public StringBuffer append(boolean value) {
        return this.append(String.valueOf(value));
    }

    public int capacity() {
        return this.value.length;
    }

    public synchronized char charAt(int index) {
        try {
            if (index < this.count) {
                return this.value[index];
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        throw new StringIndexOutOfBoundsException(index);
    }

    public synchronized StringBuffer delete(int start, int end) {
        if (start >= 0) {
            if (end > this.count) {
                end = this.count;
            }
            if (end > start) {
                int length = this.count - end;
                try {
                    if (!this.shared) {
                        if (length > 0) {
                            System.arraycopy((Object)this.value, end, (Object)this.value, start, length);
                        }
                    } else {
                        char[] newData = new char[this.value.length];
                        if (start > 0) {
                            System.arraycopy((Object)this.value, 0, (Object)newData, 0, start);
                        }
                        if (length > 0) {
                            System.arraycopy((Object)this.value, end, (Object)newData, start, length);
                        }
                        this.value = newData;
                        this.shared = false;
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new StringIndexOutOfBoundsException();
                }
                this.count -= end - start;
                return this;
            }
            if (start == end) {
                return this;
            }
        }
        throw new StringIndexOutOfBoundsException();
    }

    public synchronized StringBuffer deleteCharAt(int location) {
        if (location >= 0 && location < this.count) {
            int length = this.count - location - 1;
            try {
                if (!this.shared) {
                    if (length > 0) {
                        System.arraycopy((Object)this.value, location + 1, (Object)this.value, location, length);
                    }
                } else {
                    char[] newData = new char[this.value.length];
                    if (location > 0) {
                        System.arraycopy((Object)this.value, 0, (Object)newData, 0, location);
                    }
                    if (length > 0) {
                        System.arraycopy((Object)this.value, location + 1, (Object)newData, location, length);
                    }
                    this.value = newData;
                    this.shared = false;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new StringIndexOutOfBoundsException(location);
            }
            --this.count;
            return this;
        }
        throw new StringIndexOutOfBoundsException(location);
    }

    public synchronized void ensureCapacity(int min) {
        if (min > this.value.length) {
            this.ensureCapacityImpl(min);
        }
    }

    private void ensureCapacityImpl(int min) {
        int twice = (this.value.length << 1) + 2;
        char[] newData = new char[min > twice ? min : twice];
        System.arraycopy((Object)this.value, 0, (Object)newData, 0, this.count);
        this.value = newData;
        this.shared = false;
    }

    public synchronized void getChars(int start, int end, char[] buffer, int index) {
        try {
            if (start <= this.count && end <= this.count) {
                System.arraycopy((Object)this.value, start, (Object)buffer, index, end - start);
                return;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        throw new StringIndexOutOfBoundsException();
    }

    public synchronized StringBuffer insert(int index, char[] chars) {
        if (index >= 0 && index <= this.count) {
            this.move(chars.length, index);
            System.arraycopy((Object)chars, 0, (Object)this.value, index, chars.length);
            this.count += chars.length;
            return this;
        }
        throw new StringIndexOutOfBoundsException(index);
    }

    public synchronized StringBuffer insert(int index, char[] chars, int start, int length) {
        if (index >= 0 && index <= this.count) {
            if (start >= 0 && length >= 0 && length <= chars.length - start) {
                this.move(length, index);
                System.arraycopy((Object)chars, start, (Object)this.value, index, length);
                this.count += length;
                return this;
            }
            throw new StringIndexOutOfBoundsException();
        }
        throw new StringIndexOutOfBoundsException(index);
    }

    public synchronized StringBuffer insert(int index, char ch) {
        if (index >= 0 && index <= this.count) {
            this.move(1, index);
            this.value[index] = ch;
            ++this.count;
            return this;
        }
        throw new StringIndexOutOfBoundsException(index);
    }

    public StringBuffer insert(int index, double value) {
        return this.insert(index, String.valueOf(value));
    }

    public StringBuffer insert(int index, float value) {
        return this.insert(index, String.valueOf(value));
    }

    public StringBuffer insert(int index, int value) {
        return this.insert(index, Integer.toString(value));
    }

    public StringBuffer insert(int index, long value) {
        return this.insert(index, Long.toString(value));
    }

    public StringBuffer insert(int index, Object value) {
        return this.insert(index, String.valueOf(value));
    }

    public synchronized StringBuffer insert(int index, String string) {
        if (index >= 0 && index <= this.count) {
            if (string == null) {
                string = String.valueOf(string);
            }
            int min = string.length();
            this.move(min, index);
            string.getChars(0, min, this.value, index);
            this.count += min;
            return this;
        }
        throw new StringIndexOutOfBoundsException(index);
    }

    public StringBuffer insert(int index, boolean value) {
        return this.insert(index, String.valueOf(value));
    }

    public int length() {
        return this.count;
    }

    private void move(int size, int index) {
        int newSize;
        if (this.value.length - this.count >= size) {
            if (!this.shared) {
                System.arraycopy((Object)this.value, index, (Object)this.value, index + size, this.count - index);
                return;
            }
            newSize = this.value.length;
        } else {
            int a = this.count + size;
            int b = (this.value.length << 1) + 2;
            newSize = a > b ? a : b;
        }
        char[] newData = new char[newSize];
        System.arraycopy((Object)this.value, 0, (Object)newData, 0, index);
        System.arraycopy((Object)this.value, index, (Object)newData, index + size, this.count - index);
        this.value = newData;
        this.shared = false;
    }

    public synchronized StringBuffer replace(int start, int end, String string) {
        if (start >= 0) {
            if (end > this.count) {
                end = this.count;
            }
            if (end > start) {
                int stringLength = string.length();
                int diff = end - start - stringLength;
                if (diff > 0) {
                    if (!this.shared) {
                        System.arraycopy((Object)this.value, end, (Object)this.value, start + stringLength, this.count - end);
                    } else {
                        char[] newData = new char[this.value.length];
                        System.arraycopy((Object)this.value, 0, (Object)newData, 0, start);
                        System.arraycopy((Object)this.value, end, (Object)newData, start + stringLength, this.count - end);
                        this.value = newData;
                        this.shared = false;
                    }
                } else if (diff < 0) {
                    this.move(-diff, end);
                } else if (this.shared) {
                    this.value = (char[])this.value.clone();
                    this.shared = false;
                }
                string.getChars(0, stringLength, this.value, start);
                this.count -= diff;
                return this;
            }
            if (start == end) {
                if (string == null) {
                    throw new NullPointerException();
                }
                return this.insert(start, string);
            }
        }
        throw new StringIndexOutOfBoundsException();
    }

    public synchronized StringBuffer reverse() {
        if (this.count < 2) {
            return this;
        }
        if (!this.shared) {
            int i = 0;
            int end = this.count;
            int mid = this.count / 2;
            while (i < mid) {
                char temp = this.value[--end];
                this.value[end] = this.value[i];
                this.value[i] = temp;
                ++i;
            }
        } else {
            char[] newData = new char[this.value.length];
            int i = 0;
            int end = this.count;
            while (i < this.count) {
                newData[--end] = this.value[i];
                ++i;
            }
            this.value = newData;
            this.shared = false;
        }
        return this;
    }

    public synchronized void setCharAt(int index, char ch) {
        if (this.shared) {
            this.value = (char[])this.value.clone();
            this.shared = false;
        }
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        this.value[index] = ch;
    }

    public synchronized void setLength(int length) {
        if (length > this.value.length) {
            this.ensureCapacityImpl(length);
        } else if (length > this.count) {
            Arrays.fill(this.value, this.count, length, '\u0000');
        } else if (this.shared) {
            if (length < 0) {
                throw new IndexOutOfBoundsException();
            }
            char[] newData = new char[this.value.length];
            if (length > 0) {
                System.arraycopy((Object)this.value, 0, (Object)newData, 0, length);
            }
            this.value = newData;
            this.shared = false;
        } else if (length < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.count = length;
    }

    public synchronized String substring(int start) {
        if (start >= 0 && start <= this.count) {
            return new String(this.value, start, this.count - start);
        }
        throw new StringIndexOutOfBoundsException(start);
    }

    public synchronized String substring(int start, int end) {
        if (start >= 0 && start <= end && end <= this.count) {
            return new String(this.value, start, end - start);
        }
        throw new StringIndexOutOfBoundsException();
    }

    public synchronized String toString() {
        if (this.count >= 256 && this.count <= this.value.length >> 1) {
            return new String(this.value, 0, this.count);
        }
        this.shared = true;
        return new String(0, this.count, this.value);
    }

    char[] shareValue() {
        this.shared = true;
        return this.value;
    }

    private synchronized void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.count > this.value.length) {
            throw new InvalidObjectException(Msg.getString("K0199"));
        }
        this.shared = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StringBuffer append(StringBuffer sbuffer) {
        if (sbuffer == null) {
            return this.append((String)null);
        }
        StringBuffer stringBuffer = sbuffer;
        synchronized (stringBuffer) {
            int adding = sbuffer.count;
            int newSize = this.count + adding;
            if (newSize > this.value.length) {
                this.ensureCapacityImpl(newSize);
            }
            System.arraycopy((Object)sbuffer.value, 0, (Object)this.value, this.count, adding);
            this.count = newSize;
        }
        return this;
    }

    public CharSequence subSequence(int start, int end) {
        return this.substring(start, end);
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public synchronized int indexOf(String subString, int start) {
        int subCount;
        if (start < 0) {
            start = 0;
        }
        if ((subCount = subString.length()) > 0) {
            if (subCount + start > this.count) {
                return -1;
            }
            char firstChar = subString.charAt(0);
            while (true) {
                int i = start;
                boolean found = false;
                while (i < this.count) {
                    if (this.value[i] == firstChar) {
                        found = true;
                        break;
                    }
                    ++i;
                }
                if (!found || subCount + i > this.count) {
                    return -1;
                }
                int o1 = i;
                int o2 = 0;
                while (++o2 < subCount && this.value[++o1] == subString.charAt(o2)) {
                }
                if (o2 == subCount) {
                    return i;
                }
                start = i + 1;
            }
        }
        return start < this.count || start == 0 ? start : this.count;
    }

    public synchronized int lastIndexOf(String string) {
        return this.lastIndexOf(string, this.count);
    }

    public synchronized int lastIndexOf(String subString, int start) {
        int subCount = subString.length();
        if (subCount <= this.count && start >= 0) {
            if (subCount > 0) {
                if (start > this.count - subCount) {
                    start = this.count - subCount;
                }
                char firstChar = subString.charAt(0);
                while (true) {
                    int i = start;
                    boolean found = false;
                    while (i >= 0) {
                        if (this.value[i] == firstChar) {
                            found = true;
                            break;
                        }
                        --i;
                    }
                    if (!found) {
                        return -1;
                    }
                    int o1 = i;
                    int o2 = 0;
                    while (++o2 < subCount && this.value[++o1] == subString.charAt(o2)) {
                    }
                    if (o2 == subCount) {
                        return i;
                    }
                    start = i - 1;
                }
            }
            return start < this.count ? start : this.count;
        }
        return -1;
    }

    char[] getValue() {
        return this.value;
    }
}

