/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.ibm.oti.util.IdentityHashtable;
import com.ibm.oti.util.Msg;
import java.security.AccessControlContext;
import java.security.AccessController;

public class Thread
implements Runnable {
    public static final int MAX_PRIORITY = 10;
    public static final int MIN_PRIORITY = 1;
    public static final int NORM_PRIORITY = 5;
    private static int createCount = -1;
    private static final int NANOS_MAX = 999999;
    private static final int INITIAL_LOCAL_STORAGE_CAPACITY = 5;
    static final long NO_REF = 0L;
    long threadRef;
    long stackSize = 0L;
    private volatile boolean started;
    private String name = null;
    private int priority = 5;
    private boolean isDaemon = false;
    ThreadGroup threadGroup = null;
    private Runnable runnable = null;
    private Throwable stopThrowable = null;
    private ClassLoader contextClassLoader = null;
    private IdentityHashtable localStorage;
    private AccessControlContext accessControlContext;
    Object lock = new ThreadLock();
    private Object slot1;
    private Object slot2;
    private Object slot3;
    private long longSlot1;
    private Object slot4;
    private static ThreadGroup systemThreadGroup;
    private static ThreadGroup mainGroup;

    public Thread() {
        this(null, null, Thread.newName());
    }

    private Thread(String vmName, Object vmThreadGroup, int vmPriority, boolean vmIsDaemon) {
        this.name = vmName == null ? Thread.newName() : vmName;
        this.isDaemon = vmIsDaemon;
        this.priority = vmPriority;
        ThreadGroup group = null;
        boolean booting = false;
        if (mainGroup == null) {
            booting = true;
            mainGroup = new ThreadGroup(systemThreadGroup);
        }
        group = vmThreadGroup == null ? mainGroup : (ThreadGroup)vmThreadGroup;
        this.initialize(booting, group, null);
        this.threadGroup.add(this);
        if (booting) {
            System.completeInitialization();
        }
    }

    void completeInitialization() {
        this.contextClassLoader = ClassLoader.getSystemClassLoader();
    }

    public Thread(Runnable runnable) {
        this(null, runnable, Thread.newName());
    }

    public Thread(Runnable runnable, String threadName) {
        this(null, runnable, threadName);
    }

    public Thread(String threadName) {
        this(null, null, threadName);
    }

    public Thread(ThreadGroup group, Runnable runnable) {
        this(group, runnable, Thread.newName());
    }

    public Thread(ThreadGroup group, Runnable runnable, String threadName, long stack) {
        this(group, runnable, threadName);
        this.stackSize = stack;
    }

    public Thread(ThreadGroup group, Runnable runnable, String threadName) {
        SecurityManager currentManager;
        if (threadName == null) {
            throw new NullPointerException();
        }
        this.name = threadName;
        this.runnable = runnable;
        Thread currentThread = Thread.currentThread();
        this.isDaemon = currentThread.isDaemon();
        if (group == null && (currentManager = System.getSecurityManager()) != null) {
            group = currentManager.getThreadGroup();
        }
        if (group == null) {
            group = currentThread.getThreadGroup();
        }
        this.initialize(false, group, currentThread);
        this.setPriority(currentThread.getPriority());
    }

    private void initialize(boolean booting, ThreadGroup group, Thread parentThread) {
        this.threadGroup = group;
        if (parentThread != null) {
            this.initializeLocalStorage(parentThread);
            this.contextClassLoader = parentThread.contextClassLoader;
        } else {
            if (booting) {
                ClassLoader.initializeClassLoaders();
            }
            this.contextClassLoader = ClassLoader.getSystemClassLoader();
        }
        group.checkAccess();
        group.checkNewThread(this);
        this.accessControlContext = AccessController.getContext();
    }

    public Thread(ThreadGroup group, String threadName) {
        this(group, null, threadName);
    }

    public static int activeCount() {
        return Thread.currentThread().getThreadGroup().activeCount();
    }

    public final void checkAccess() {
        SecurityManager currentManager = System.getSecurityManager();
        if (currentManager != null) {
            currentManager.checkAccess(this);
        }
    }

    public static native Thread currentThread();

    public void destroy() {
        throw new NoSuchMethodError();
    }

    public static void dumpStack() {
        new Throwable().printStackTrace();
    }

    public static int enumerate(Thread[] threads) {
        return Thread.currentThread().getThreadGroup().enumerate(threads, true);
    }

    public ClassLoader getContextClassLoader() {
        ClassLoader callerClassLoader;
        SecurityManager currentManager = System.getSecurityManager();
        if (currentManager != null && (callerClassLoader = ClassLoader.callerClassLoader()) != null && this.contextClassLoader != callerClassLoader && !callerClassLoader.isAncestorOf(this.contextClassLoader)) {
            currentManager.checkPermission(RuntimePermission.permissionToGetClassLoader);
        }
        return this.contextClassLoader;
    }

    public final String getName() {
        return String.valueOf(this.name);
    }

    public final int getPriority() {
        return this.priority;
    }

    public final ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    Object getThreadLocal(ThreadLocal local) {
        Object value;
        if (this.localStorage == null) {
            this.initializeLocalStorage(5);
            value = IdentityHashtable.ABSENT_FLAG;
        } else {
            value = this.localStorage.get(local, IdentityHashtable.ABSENT_FLAG);
        }
        if (value == IdentityHashtable.ABSENT_FLAG) {
            value = local.initialValue();
            this.setThreadLocal(local, value);
        }
        return value;
    }

    private void initializeLocalStorage(int size) {
        this.localStorage = new IdentityHashtable(size);
    }

    private void initializeLocalStorage(Thread parent) {
        if (parent.localStorage == null) {
            return;
        }
        int size = parent.localStorage.size() / 2;
        if (size < 5) {
            size = 5;
        }
        this.initializeLocalStorage(size);
        IdentityHashtable.Iterator iterator = new IdentityHashtable.Iterator(){

            public void iterate(Object parentKey, Object parentValue) {
                if (parentKey instanceof InheritableThreadLocal) {
                    Thread.this.localStorage.put(parentKey, ((InheritableThreadLocal)parentKey).childValue(parentValue));
                }
            }
        };
        parent.localStorage.iterate(iterator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt() {
        this.checkAccess();
        Object object = this.lock;
        synchronized (object) {
            this.interruptImpl();
        }
    }

    public static native boolean interrupted();

    private native void interruptImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isAlive() {
        Object object = this.lock;
        synchronized (object) {
            return this.threadRef != 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDead() {
        Object object = this.lock;
        synchronized (object) {
            return this.started && this.threadRef == 0L;
        }
    }

    public final boolean isDaemon() {
        return this.isDaemon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInterrupted() {
        Object object = this.lock;
        synchronized (object) {
            return this.isInterruptedImpl();
        }
    }

    private native boolean isInterruptedImpl();

    public final synchronized void join() throws InterruptedException {
        if (this.started) {
            while (!this.isDead()) {
                this.wait(0L);
            }
        }
    }

    public final void join(long timeoutInMilliseconds) throws InterruptedException {
        this.join(timeoutInMilliseconds, 0);
    }

    public final synchronized void join(long timeoutInMilliseconds, int nanos) throws InterruptedException {
        if (timeoutInMilliseconds < 0L || nanos < 0 || nanos > 999999) {
            throw new IllegalArgumentException();
        }
        if (!this.started || this.isDead()) {
            return;
        }
        long totalWaited = 0L;
        long toWait = timeoutInMilliseconds;
        boolean timedOut = false;
        if (timeoutInMilliseconds == 0L & nanos > 0) {
            if (nanos < 500000) {
                timedOut = true;
            } else {
                toWait = 1L;
            }
        }
        while (!timedOut && !this.isDead()) {
            long start = System.currentTimeMillis();
            this.wait(toWait);
            long waited = System.currentTimeMillis() - start;
            toWait -= waited;
            boolean bl = timedOut = (totalWaited += waited) >= timeoutInMilliseconds;
        }
    }

    private static synchronized String newName() {
        if (createCount == -1) {
            ++createCount;
            return "main";
        }
        return "Thread-" + createCount++;
    }

    public void run() {
        if (this.runnable != null) {
            this.runnable.run();
        }
    }

    public void setContextClassLoader(ClassLoader cl) {
        SecurityManager currentManager = System.getSecurityManager();
        if (currentManager != null) {
            currentManager.checkPermission(RuntimePermission.permissionToSetContextClassLoader);
        }
        this.contextClassLoader = cl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setDaemon(boolean isDaemon) {
        this.checkAccess();
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                this.isDaemon = isDaemon;
            } else if (this.isAlive()) {
                throw new IllegalThreadStateException();
            }
        }
    }

    public final void setName(String threadName) {
        this.checkAccess();
        if (threadName == null) {
            throw new NullPointerException();
        }
        this.name = threadName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setPriority(int priority) {
        this.checkAccess();
        if (1 <= priority && priority <= 10) {
            int finalPriority = priority;
            int threadGroupMaxPriority = this.getThreadGroup().getMaxPriority();
            if (threadGroupMaxPriority < priority) {
                finalPriority = threadGroupMaxPriority;
            }
            this.priority = finalPriority;
            Object object = this.lock;
            synchronized (object) {
                if (this.started && this.threadRef != 0L) {
                    this.setPriorityNoVMAccessImpl(this.threadRef, finalPriority);
                }
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    private native void setPriorityNoVMAccessImpl(long var1, int var3);

    void setThreadLocal(ThreadLocal local, Object value) {
        if (this.localStorage == null) {
            this.initializeLocalStorage(5);
        }
        this.localStorage.put(local, value);
    }

    public static void sleep(long time) throws InterruptedException {
        Thread.sleep(time, 0);
    }

    public static native void sleep(long var0, int var2) throws InterruptedException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                throw new IllegalThreadStateException(Msg.getString("K0341"));
            }
            boolean success = false;
            this.threadGroup.add(this);
            try {
                this.startImpl();
                success = true;
            }
            finally {
                if (!success) {
                    this.threadGroup.remove(this);
                }
            }
        }
    }

    private native void startImpl();

    public String toString() {
        return "Thread[" + this.getName() + "," + this.getPriority() + "," + (this.getThreadGroup() == null ? "" : this.getThreadGroup().getName()) + "]";
    }

    public static native void yield();

    public static native boolean holdsLock(Object var0);

    private void uncaughtException(Throwable e) {
        ThreadGroup group = this.getThreadGroup();
        if (group != null) {
            group.uncaughtException(this, e);
        }
    }

    private static class ThreadLock {
        ThreadLock() {
        }
    }
}

