/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import com.ibm.oti.util.Msg;
import java.math.BigInteger;

public class BigDecimal
extends Number
implements Comparable {
    private static final long serialVersionUID = 6108874887143696463L;
    public static final int ROUND_UP = 0;
    public static final int ROUND_DOWN = 1;
    public static final int ROUND_CEILING = 2;
    public static final int ROUND_FLOOR = 3;
    public static final int ROUND_HALF_UP = 4;
    public static final int ROUND_HALF_DOWN = 5;
    public static final int ROUND_HALF_EVEN = 6;
    public static final int ROUND_UNNECESSARY = 7;
    private static final BigInteger TEN = new BigInteger("10");
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private static final BigDecimal ONE = new BigDecimal(BigInteger.ONE, 0);
    private static final BigDecimal ZERO = new BigDecimal(BigInteger.ZERO, 0);
    private int scale;
    private BigInteger intVal;
    private transient int setCount = 0;
    private transient int getCount = 0;
    private transient int[] uArray = new int[64];
    private transient int firstK = 0;

    public BigDecimal(BigInteger bval) {
        this.intVal = bval;
        this.scale = 0;
    }

    public BigDecimal(BigInteger bval, int sc) {
        if (sc < 0) {
            throw new NumberFormatException(Msg.getString("K0051"));
        }
        this.intVal = bval;
        this.scale = sc;
    }

    public BigDecimal(double bval) {
        long inputNumberBits = Double.doubleToLongBits(bval);
        long sign = (inputNumberBits & Long.MIN_VALUE) >> 63;
        long e = (inputNumberBits & 0x7FF0000000000000L) >> 52;
        long f = inputNumberBits & 0xFFFFFFFFFFFFFL;
        int pow = 0;
        boolean zero = false;
        this.setCount = 0;
        this.getCount = 0;
        String signString = sign == 0L ? "" : "-";
        if (e == 2047L) {
            throw new NumberFormatException(Msg.getString("K040b"));
        }
        if (e == 0L) {
            if (f == 0L) {
                this.intVal = BigInteger.ZERO;
                this.scale = 0;
                zero = true;
            } else {
                pow = (int)(e - 1075L + 1L);
            }
        } else {
            f |= 0x10000000000000L;
            pow = (int)(e - 1075L);
        }
        if (!zero) {
            String finalVal = String.valueOf(signString) + this.freeFormat(pow, f);
            this.intVal = new BigInteger(finalVal.toString());
        }
    }

    public BigDecimal(String val) {
        int period;
        int expIndex;
        String bval = val;
        if (bval.length() > 0 && bval.charAt(0) == '+') {
            bval = bval.substring(1, bval.length());
        }
        if ((expIndex = bval.indexOf(101, 0)) == -1) {
            expIndex = bval.indexOf(69, 0);
        }
        String expString = null;
        if (expIndex >= 0) {
            expString = new String(bval).substring(expIndex + 1, bval.length());
            bval = bval.substring(0, expIndex);
        }
        if ((period = bval.indexOf(46, 0)) == -1) {
            this.intVal = new BigInteger(bval);
            this.scale = 0;
        } else {
            int max = bval.length();
            String sub1 = bval.substring(0, period);
            String sub2 = bval.substring(period + 1, max);
            this.intVal = new BigInteger(String.valueOf(sub1) + sub2);
            this.scale = max - period - 1;
        }
        if (expString != null) {
            if (expString.length() > 0 && expString.charAt(0) == '+' && (expString = expString.substring(1, expString.length())).indexOf(45) >= 0) {
                throw new NumberFormatException(val);
            }
            Integer expVal = new Integer(expString);
            this.scale -= expVal.intValue();
            while (this.scale < 0) {
                this.intVal = this.intVal.shiftLeft(1).add(this.intVal.shiftLeft(3));
                ++this.scale;
            }
        }
    }

    public BigDecimal abs() {
        return new BigDecimal(this.unscaledValue().abs(), this.scale());
    }

    public BigDecimal add(BigDecimal bval) {
        BigInteger decRes;
        int maxScale;
        int bvalScale = bval.scale();
        BigInteger bvalintValue = bval.unscaledValue();
        if (this.scale == bvalScale) {
            return new BigDecimal(this.intVal.add(bvalintValue), this.scale);
        }
        int n = maxScale = this.scale > bvalScale ? this.scale : bvalScale;
        if (maxScale == this.scale) {
            BigInteger scaleNum = TEN.pow(maxScale - bvalScale);
            decRes = this.intVal.add(bvalintValue.multiply(scaleNum));
        } else {
            BigInteger scaleNum = TEN.pow(maxScale - this.scale);
            decRes = bvalintValue.add(this.intVal.multiply(scaleNum));
        }
        return new BigDecimal(decRes, maxScale);
    }

    public int compareTo(Object o) {
        if (!(o instanceof BigDecimal)) {
            throw new ClassCastException();
        }
        return this.compareTo((BigDecimal)o);
    }

    public int compareTo(BigDecimal bval) {
        BigDecimal result = this.subtract(bval);
        return result.signum();
    }

    private String freeFormat(int pow, long f) {
        char[] formattedDecimal = new char[309];
        int charPos = 0;
        int oldScale = 0;
        this.digitGenerator(pow, f);
        boolean allFraction = false;
        int U = this.getCount < this.setCount ? this.uArray[this.getCount] : -1;
        int k = this.firstK - this.getCount;
        ++this.getCount;
        if (k < 0) {
            allFraction = true;
            oldScale = -k - 1;
        }
        while (true) {
            if (k >= 0) {
                if (U != -1) {
                    formattedDecimal[charPos] = Character.forDigit(U, 10);
                    ++charPos;
                } else if (k >= -1) {
                    formattedDecimal[charPos] = 48;
                    ++charPos;
                }
                U = this.getCount < this.setCount ? this.uArray[this.getCount] : -1;
                k = this.firstK - this.getCount;
                ++this.getCount;
                continue;
            }
            if (U != -1) {
                formattedDecimal[charPos] = Character.forDigit(U, 10);
                ++charPos;
                ++oldScale;
            }
            U = this.getCount < this.setCount ? this.uArray[this.getCount] : -1;
            k = this.firstK - this.getCount;
            ++this.getCount;
            if (U == -1 && k < -1) break;
        }
        if (oldScale != 0 && !allFraction) {
            oldScale = -k - 1;
        }
        this.scale = oldScale;
        return new String(formattedDecimal, 0, charPos);
    }

    private void digitGenerator(int pow, long f) {
        boolean high;
        boolean low;
        BigInteger cache2;
        int U;
        BigInteger cache;
        BigInteger R = BigInteger.valueOf(f).shiftLeft(Math.max(pow, 0));
        BigInteger S = BigInteger.ZERO.setBit(Math.max(0, -pow));
        BigInteger M_minus = BigInteger.ZERO.setBit(Math.max(pow, 0));
        BigInteger M_plus = M_minus.abs();
        int k = 0;
        while ((cache = R.multiplyByTen()).compareTo(S) < 0) {
            --k;
            R = cache;
            M_minus = M_minus.multiplyByTen();
            M_plus = M_plus.multiplyByTen();
        }
        cache = R.shiftLeft(1).add(M_plus);
        while (cache.compareTo(S.shiftLeft(1)) >= 0) {
            S = S.multiplyByTen();
            ++k;
        }
        this.firstK = k - 1;
        cache = S.shiftLeft(1);
        while (true) {
            --k;
            BigInteger a = R.multiplyByTen();
            int digit = 0;
            int i = 3;
            while (i >= 0) {
                BigInteger remainder = a.subtract(S.shiftLeft(i));
                if (remainder.compareTo(BigInteger.ZERO) >= 0) {
                    a = remainder;
                    digit += 1 << i;
                }
                --i;
            }
            U = digit;
            R = a;
            M_minus = M_minus.multiplyByTen();
            M_plus = M_plus.multiplyByTen();
            cache2 = R.shiftLeft(1);
            low = cache2.compareTo(M_minus) < 0;
            boolean bl = high = cache2.compareTo(cache.subtract(M_plus)) > 0;
            if (low || high) break;
            this.uArray[this.setCount] = U;
            ++this.setCount;
        }
        if (low && !high) {
            this.uArray[this.setCount] = U;
            ++this.setCount;
        } else if (high && !low) {
            this.uArray[this.setCount] = U + 1;
            ++this.setCount;
        } else if (cache2.compareTo(S) <= 0) {
            this.uArray[this.setCount] = U;
            ++this.setCount;
        } else {
            this.uArray[this.setCount] = U + 1;
            ++this.setCount;
        }
    }

    public BigDecimal divide(BigDecimal bval, int roundingMode) {
        return this.divide(bval, this.scale, roundingMode);
    }

    /*
     * Unable to fully structure code
     */
    public BigDecimal divide(BigDecimal bval, int bscale, int roundingMode) {
        if (bscale < 0) {
            throw new ArithmeticException(Msg.getString("K0051"));
        }
        if (roundingMode < 0 || roundingMode > 7) {
            throw new IllegalArgumentException(Msg.getString("K0050"));
        }
        bvalScale = bval.scale();
        sign = this.intVal.signum() * bval.intVal.signum();
        if (bvalScale < this.scale) {
            newVal = bval.movePointRight(this.scale);
            divider = newVal.abs().intVal;
            result = this.intVal.abs().divideAndRemainder(divider);
        } else {
            divider = bval.abs().intVal;
            if (bvalScale > this.scale) {
                newThis = this.movePointRight(bvalScale);
                result = newThis.abs().intVal.divideAndRemainder(divider);
            } else {
                result = this.intVal.abs().divideAndRemainder(divider);
            }
        }
        i = bscale;
        finalRem = result[1];
        finalVal = new StringBuffer();
        if (sign < 0) {
            finalVal.append('-');
        }
        finalVal.append(result[0].toString());
        while (i >= 0 && !result[1].equals(BigInteger.ZERO)) {
            divisor = result[1].multiplyByTen();
            result = divisor.divideAndRemainder(divider);
            if (i > 0) {
                finalVal.append(result[0].toString());
            }
            if (i == 1) {
                finalRem = result[1];
            }
            --i;
        }
        v0 = round = i < 0;
        if (!round || roundingMode != 7) ** GOTO lbl41
        throw new ArithmeticException(Msg.getString("K004f"));
lbl-1000:
        // 1 sources

        {
            finalVal.append('0');
lbl41:
            // 2 sources

            ** while (i-- > 0)
        }
lbl42:
        // 1 sources

        quotient = new BigInteger(finalVal.toString());
        if (round) {
            quotient = BigDecimal.roundValues(quotient, finalRem, result, sign, roundingMode);
        }
        return new BigDecimal(quotient, bscale);
    }

    public double doubleValue() {
        try {
            Double db = new Double(this.toString());
            return db;
        }
        catch (NumberFormatException numberFormatException) {
            if (this.signum() == -1) {
                return Double.NEGATIVE_INFINITY;
            }
            return Double.POSITIVE_INFINITY;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BigDecimal)) {
            return false;
        }
        return this.unscaledValue().compareTo(((BigDecimal)obj).unscaledValue()) == 0 && this.scale() == ((BigDecimal)obj).scale();
    }

    public float floatValue() {
        try {
            Float fl = new Float(this.toString());
            return fl.floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            if (this.signum() == -1) {
                return Float.NEGATIVE_INFINITY;
            }
            return Float.POSITIVE_INFINITY;
        }
    }

    public int hashCode() {
        return this.intVal.hashCode() ^ this.scale;
    }

    public int intValue() {
        BigInteger intVal = this.toBigInteger();
        return intVal.intValue();
    }

    public long longValue() {
        BigInteger longValue = this.toBigInteger();
        return longValue.longValue();
    }

    public BigDecimal max(BigDecimal bval) {
        return this.compareTo(bval) > 0 ? this : bval;
    }

    public BigDecimal min(BigDecimal bval) {
        return this.compareTo(bval) >= 0 ? bval : this;
    }

    public BigDecimal movePointLeft(int n) {
        if (n < 0) {
            return this.movePointRight(-n);
        }
        return new BigDecimal(this.unscaledValue(), this.scale + n);
    }

    public BigDecimal movePointRight(int n) {
        if (n < 0) {
            return this.movePointLeft(-n);
        }
        if (this.scale - n < 0) {
            StringBuffer stBuf = new StringBuffer().append(this.intVal);
            int i = 0;
            while (i < n - this.scale) {
                stBuf.append("0");
                ++i;
            }
            return new BigDecimal(new BigInteger(stBuf.toString()), 0);
        }
        return new BigDecimal(this.intVal, this.scale - n);
    }

    public BigDecimal multiply(BigDecimal bval) {
        BigInteger res = this.intVal.multiply(bval.unscaledValue());
        int resScale = this.scale() + bval.scale();
        return new BigDecimal(res, resScale);
    }

    public BigDecimal negate() {
        return new BigDecimal(this.intVal.negate(), this.scale);
    }

    public int scale() {
        return this.scale;
    }

    public BigDecimal setScale(int newScale) {
        return this.setScale(newScale, 7);
    }

    public BigDecimal setScale(int newScale, int roundingMode) {
        if (newScale < 0) {
            throw new ArithmeticException(Msg.getString("K0051"));
        }
        if (roundingMode < 0 || roundingMode > 7) {
            throw new IllegalArgumentException(Msg.getString("K0050"));
        }
        if (this.scale < newScale) {
            StringBuffer stBuf = new StringBuffer("1");
            int i = 0;
            while (i < newScale - this.scale) {
                stBuf.append('0');
                ++i;
            }
            BigInteger multiplier = new BigInteger(stBuf.toString());
            BigInteger newValue = this.intVal.multiply(multiplier);
            return new BigDecimal(newValue, newScale);
        }
        if (this.scale > newScale) {
            BigInteger divisor = TEN.pow(this.scale - newScale);
            BigInteger[] result = this.intVal.divideAndRemainder(divisor);
            if (!result[1].equals(BigInteger.ZERO)) {
                if (roundingMode == 7) {
                    throw new ArithmeticException(Msg.getString("K004f"));
                }
                BigInteger[] furRes = null;
                if (roundingMode >= 4) {
                    divisor = TEN.pow(this.scale - newScale - 1);
                    furRes = result[1].divideAndRemainder(divisor);
                    furRes[0] = furRes[0].abs();
                }
                result[0] = BigDecimal.roundValues(result[0], result[1], furRes, this.intVal.signum(), roundingMode);
            }
            return new BigDecimal(result[0], newScale);
        }
        return this;
    }

    private static BigInteger roundValues(BigInteger num, BigInteger rem, BigInteger[] first, int sign, int mode) {
        switch (mode) {
            case 2: {
                if (sign >= 0 && !rem.equals(BigInteger.ZERO)) {
                    return num.add(BigInteger.ONE);
                }
                return num;
            }
            case 1: {
                return num;
            }
            case 3: {
                if (sign < 0 && !rem.equals(BigInteger.ZERO)) {
                    return num.add(BigInteger.ONE.negate());
                }
                return num;
            }
            case 5: {
                int digit = first[0].intValue();
                if (digit > 5 || digit == 5 && !first[1].equals(BigInteger.ZERO)) {
                    if (sign >= 0) {
                        return num.add(BigInteger.ONE);
                    }
                    return num.add(BigInteger.ONE.negate());
                }
                return num;
            }
            case 6: {
                int digit = first[0].intValue();
                if (digit > 5 || digit == 5 && !first[1].equals(BigInteger.ZERO)) {
                    if (sign >= 0) {
                        return num.add(BigInteger.ONE);
                    }
                    return num.add(BigInteger.ONE.negate());
                }
                if (digit == 5) {
                    BigInteger remainder = num.mod(BigInteger.ONE.add(BigInteger.ONE));
                    if (remainder.equals(BigInteger.ZERO)) {
                        return num;
                    }
                    if (sign >= 0) {
                        return num.add(BigInteger.ONE);
                    }
                    return num.add(BigInteger.ONE.negate());
                }
                return num;
            }
            case 4: {
                if (first[0].intValue() >= 5) {
                    if (sign >= 0) {
                        return num.add(BigInteger.ONE);
                    }
                    return num.add(BigInteger.ONE.negate());
                }
                return num;
            }
            case 0: {
                if (!rem.equals(BigInteger.ZERO)) {
                    if (sign >= 0) {
                        return num.add(BigInteger.ONE);
                    }
                    return num.add(BigInteger.ONE.negate());
                }
                return num;
            }
        }
        throw new IllegalArgumentException(Msg.getString("K0050"));
    }

    public int signum() {
        return this.intVal.signum();
    }

    public BigDecimal subtract(BigDecimal bval) {
        BigInteger decRes;
        int maxScale;
        int bvalScale = bval.scale();
        BigInteger bvalintValue = bval.unscaledValue();
        if (this.scale == bvalScale) {
            BigInteger decRes2 = this.intVal.subtract(bvalintValue);
            if (decRes2.equals(BigInteger.ZERO)) {
                bvalScale = 0;
            }
            return new BigDecimal(decRes2, bvalScale);
        }
        int n = maxScale = this.scale > bvalScale ? this.scale : bvalScale;
        if (maxScale == this.scale) {
            BigInteger scaleNum = TEN.pow(maxScale - bvalScale);
            decRes = this.intVal.subtract(bvalintValue.multiply(scaleNum));
        } else {
            BigInteger scaleNum = TEN.pow(maxScale - this.scale);
            decRes = this.intVal.multiply(scaleNum).subtract(bvalintValue);
        }
        if (decRes.equals(BigInteger.ZERO)) {
            maxScale = 0;
        }
        return new BigDecimal(decRes, maxScale);
    }

    public BigInteger toBigInteger() {
        BigInteger divisor = TEN.pow(this.scale);
        return this.intVal.divide(divisor);
    }

    public String toString() {
        String unscaledChar = this.intVal.toString();
        int max = unscaledChar.length();
        boolean negative = unscaledChar.charAt(0) == '-';
        StringBuffer stBuf = new StringBuffer();
        if (this.scale >= (negative ? max - 1 : max)) {
            if (negative) {
                String temp;
                stBuf = new StringBuffer().append("-0.");
                unscaledChar = temp = new String(unscaledChar).substring(1, max);
                max = unscaledChar.length();
            } else {
                stBuf = new StringBuffer().append("0.");
            }
            int i = 0;
            while (i < this.scale - max) {
                stBuf = stBuf.append("0");
                ++i;
            }
            stBuf = stBuf.append(unscaledChar);
            return stBuf.toString();
        }
        String sub1 = new String(unscaledChar).substring(0, max - this.scale);
        if (this.scale == 0) {
            return sub1;
        }
        String sub2 = new String(unscaledChar).substring(max - this.scale(), max);
        return String.valueOf(sub1) + "." + sub2;
    }

    public BigInteger unscaledValue() {
        return this.intVal;
    }

    public static BigDecimal valueOf(long bval) {
        return new BigDecimal(BigInteger.valueOf(bval), 0);
    }

    public static BigDecimal valueOf(long bval, int scale) {
        if (scale < 0) {
            throw new NumberFormatException(Msg.getString("K0051"));
        }
        BigInteger bvalBigInteger = BigInteger.valueOf(bval);
        if (bvalBigInteger == BigInteger.ZERO) {
            return ZERO;
        }
        if (bvalBigInteger == BigInteger.ONE) {
            return ONE;
        }
        return new BigDecimal(bvalBigInteger, scale);
    }
}

