/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import com.ibm.oti.util.Msg;
import com.ibm.oti.util.PriviAction;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PlainSocketImpl2;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketInputStream;
import java.net.SocketOutputStream;
import java.net.SocketTimeoutException;
import java.net.Socks4Message;
import java.net.UnknownHostException;
import java.security.AccessController;

class PlainSocketImpl
extends SocketImpl {
    private static InetAddress lastConnectedAddress;
    private static int lastConnectedPort;
    private boolean tcpNoDelay = true;
    private Object connectLock = new Object();
    private int trafficClass = 0;

    PlainSocketImpl() {
    }

    protected void accept(SocketImpl newImpl) throws IOException {
        if (PlainSocketImpl.usingSocks()) {
            ((PlainSocketImpl)newImpl).socksBind();
            ((PlainSocketImpl)newImpl).socksAccept();
            return;
        }
        try {
            PlainSocketImpl.acceptStreamSocketImpl(this.fd, newImpl, newImpl.fd, this.receiveTimeout);
        }
        catch (InterruptedIOException e) {
            throw new SocketTimeoutException(e.getMessage());
        }
        newImpl.localport = this.getLocalPort();
    }

    protected synchronized int available() throws IOException {
        if (this.shutdownInput) {
            return 0;
        }
        return PlainSocketImpl.availableStreamImpl(this.fd);
    }

    protected void bind(InetAddress anAddr, int aPort) throws IOException {
        if (PlainSocketImpl.usingSocks()) {
            this.socksBind();
            return;
        }
        try {
            PlainSocketImpl2.socketBindImpl2(this.fd, aPort, anAddr);
        }
        catch (BindException e) {
            throw new BindException(anAddr + ":" + aPort + " - " + e.getMessage());
        }
        this.address = anAddr;
        this.localport = aPort != 0 ? aPort : Socket.getSocketLocalPortImpl(this.fd, InetAddress.preferIPv6Addresses());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() throws IOException {
        FileDescriptor fileDescriptor = this.fd;
        synchronized (fileDescriptor) {
            if (this.fd.valid()) {
                if ((Socket.getSocketFlags() & 8) != 0) {
                    try {
                        this.shutdownOutput();
                    }
                    catch (Exception exception) {}
                }
                Socket.socketCloseImpl(this.fd);
                this.initializeSocket();
            }
        }
    }

    protected void connect(String aHost, int aPort) throws IOException {
        InetAddress anAddr = InetAddress.getHostByNameImpl(aHost, InetAddress.preferIPv6Addresses());
        this.connect(anAddr, aPort);
    }

    protected void connect(InetAddress anAddr, int aPort) throws IOException {
        this.connect(anAddr, aPort, 0);
    }

    private void connect(InetAddress anAddr, int aPort, int timeout) throws IOException {
        InetAddress address = anAddr.equals(InetAddress.ANY) ? InetAddress.LOOPBACK : anAddr;
        try {
            if (PlainSocketImpl.usingSocks()) {
                this.socksConnect(anAddr, aPort, 0);
            } else if (timeout == 0) {
                PlainSocketImpl2.connectStreamSocketImpl2(this.fd, aPort, this.trafficClass, address);
            } else {
                PlainSocketImpl2.connectStreamWithTimeoutSocketImpl2(this.fd, aPort, timeout, this.trafficClass, address);
            }
        }
        catch (ConnectException e) {
            throw new ConnectException(anAddr + ":" + aPort + " - " + e.getMessage());
        }
        this.address = anAddr;
        this.port = aPort;
    }

    protected void create(boolean streaming) throws SocketException {
        PlainSocketImpl.createStreamSocketImpl(this.fd, Socket.preferIPv4Stack());
    }

    protected void finalize() throws IOException {
        this.close();
    }

    protected synchronized InputStream getInputStream() throws IOException {
        if (!this.fd.valid()) {
            throw new SocketException(Msg.getString("K003d"));
        }
        return new SocketInputStream(this);
    }

    public Object getOption(int optID) throws SocketException {
        if (optID == 4102) {
            return new Integer(this.receiveTimeout);
        }
        if (optID == 3) {
            return new Integer(this.trafficClass);
        }
        Object result = Socket.getSocketOptionImpl(this.fd, optID);
        if (optID == 1 && (Socket.getSocketFlags() & 4) != 0) {
            return new Boolean(this.tcpNoDelay);
        }
        return result;
    }

    protected synchronized OutputStream getOutputStream() throws IOException {
        if (!this.fd.valid()) {
            throw new SocketException(Msg.getString("K003d"));
        }
        return new SocketOutputStream(this);
    }

    protected void listen(int backlog) throws IOException {
        if (PlainSocketImpl.usingSocks()) {
            return;
        }
        PlainSocketImpl.listenStreamSocketImpl(this.fd, backlog);
    }

    public void setOption(int optID, Object val) throws SocketException {
        if (optID == 4102) {
            this.receiveTimeout = (Integer)val;
        } else {
            block6: {
                try {
                    Socket.setSocketOptionImpl(this.fd, optID, val);
                    if (optID == 1 && (Socket.getSocketFlags() & 4) != 0) {
                        this.tcpNoDelay = (Boolean)val;
                    }
                }
                catch (SocketException e) {
                    if (optID == 3) break block6;
                    throw e;
                }
            }
            if (optID == 3) {
                this.trafficClass = (Integer)val;
            }
        }
    }

    static boolean usingSocks() {
        String proxySet = (String)AccessController.doPrivileged(new PriviAction("socksProxySet"));
        if (proxySet != null) {
            return proxySet.toLowerCase().equals("true");
        }
        return AccessController.doPrivileged(new PriviAction("socksProxyHost")) != null;
    }

    private int socksGetServerPort() {
        int port = -1;
        String proxyPort = (String)AccessController.doPrivileged(new PriviAction("socksProxyPort"));
        if (proxyPort != null) {
            port = Integer.parseInt(proxyPort);
        }
        if (port < 0) {
            port = 1080;
        }
        return port;
    }

    private InetAddress socksGetServerAddress() throws UnknownHostException {
        String proxyName = (String)AccessController.doPrivileged(new PriviAction("socksProxyHost"));
        InetAddress anAddr = InetAddress.getHostByNameImpl(proxyName, InetAddress.preferIPv6Addresses());
        return anAddr;
    }

    private void socksConnect(InetAddress applicationServerAddress, int applicationServerPort, int timeout) throws IOException {
        try {
            if (timeout == 0) {
                PlainSocketImpl2.connectStreamSocketImpl2(this.fd, this.socksGetServerPort(), this.trafficClass, this.socksGetServerAddress());
            } else {
                PlainSocketImpl2.connectStreamWithTimeoutSocketImpl2(this.fd, this.socksGetServerPort(), timeout, this.trafficClass, this.socksGetServerAddress());
            }
        }
        catch (Exception e) {
            throw new SocketException(Msg.getString("K003e", e));
        }
        this.socksRequestConnection(applicationServerAddress, applicationServerPort);
        lastConnectedAddress = applicationServerAddress;
        lastConnectedPort = applicationServerPort;
    }

    private void socksRequestConnection(InetAddress applicationServerAddress, int applicationServerPort) throws IOException {
        this.socksSendRequest(1, applicationServerAddress, applicationServerPort);
        Socks4Message reply = this.socksReadReply();
        if (reply.getCommandOrResult() != 90) {
            throw new IOException(reply.getErrorString(reply.getCommandOrResult()));
        }
    }

    void socksAccept() throws IOException {
        Socks4Message reply = this.socksReadReply();
        if (reply.getCommandOrResult() != 90) {
            throw new IOException(reply.getErrorString(reply.getCommandOrResult()));
        }
    }

    private void socksBind() throws IOException {
        try {
            PlainSocketImpl2.connectStreamSocketImpl2(this.fd, this.socksGetServerPort(), this.trafficClass, this.socksGetServerAddress());
        }
        catch (Exception e) {
            throw new IOException(Msg.getString("K003f", e));
        }
        if (lastConnectedAddress == null) {
            throw new SocketException(Msg.getString("K0040"));
        }
        this.socksSendRequest(2, lastConnectedAddress, lastConnectedPort);
        Socks4Message reply = this.socksReadReply();
        if (reply.getCommandOrResult() != 90) {
            throw new IOException(reply.getErrorString(reply.getCommandOrResult()));
        }
        if (reply.getIP() == 0) {
            this.address = this.socksGetServerAddress();
        } else {
            byte[] replyBytes = new byte[4];
            InetAddress.intToBytes(reply.getIP(), replyBytes, 0);
            this.address = new InetAddress(replyBytes);
        }
        this.localport = reply.getPort();
    }

    private void socksSendRequest(int command, InetAddress address, int port) throws IOException {
        Socks4Message request = new Socks4Message();
        request.setCommandOrResult(command);
        request.setPort(port);
        request.setIP(address.getAddress());
        request.setUserId("default");
        this.getOutputStream().write(request.getBytes(), 0, request.getLength());
    }

    private Socks4Message socksReadReply() throws IOException {
        Socks4Message reply = new Socks4Message();
        int bytesRead = 0;
        while (bytesRead < 8) {
            bytesRead += this.getInputStream().read(reply.getBytes(), bytesRead, 8 - bytesRead);
        }
        return reply;
    }

    protected void connect(SocketAddress remoteAddr, int timeout) throws IOException {
        InetSocketAddress inetAddr = (InetSocketAddress)remoteAddr;
        this.connect(inetAddr.getAddress(), inetAddr.getPort(), timeout);
    }

    protected boolean supportsUrgentData() {
        return SocketImpl.supportsUrgentDataImpl(this.fd);
    }

    protected void sendUrgentData(int value) throws IOException {
        SocketImpl.sendUrgentDataImpl(this.fd, (byte)value);
    }
}

