/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import com.ibm.oti.util.Msg;
import com.ibm.oti.util.PriviAction;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.BindException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PlainSocketImpl;
import java.net.PlainSocketImpl2;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketImplFactory;
import java.net.UnknownHostException;
import java.security.AccessController;

public class Socket {
    SocketImpl impl;
    static SocketImplFactory factory;
    private volatile boolean isCreated = false;
    private boolean isBound = false;
    private boolean isConnected = false;
    private boolean isClosed = false;
    private boolean isInputShutdown = false;
    private boolean isOutputShutdown = false;
    private Object connectLock = new Object();
    static final int MULTICAST_IF = 1;
    static final int MULTICAST_TTL = 2;
    static final int TCP_NODELAY = 4;
    static final int FLAG_SHUTDOWN = 8;
    static final int FLAG_BIND = 16;

    static {
        Socket.oneTimeInitialization(true);
    }

    private static native void oneTimeInitialization(boolean var0);

    public Socket() {
        this.impl = factory != null ? factory.createSocketImpl() : new PlainSocketImpl2();
    }

    public Socket(String dstName, int dstPort) throws UnknownHostException, IOException {
        this();
        InetAddress dstAddress = InetAddress.getByName(dstName);
        this.checkDestination(dstAddress, dstPort);
        this.startupSocket(dstAddress, dstPort, null, 0, true);
    }

    public Socket(String dstName, int dstPort, InetAddress localAddress, int localPort) throws IOException {
        this();
        InetAddress dstAddress = InetAddress.getByName(dstName);
        this.checkDestination(dstAddress, dstPort);
        this.startupSocket(dstAddress, dstPort, localAddress, localPort, true);
    }

    public Socket(InetAddress dstAddress, int dstPort) throws IOException {
        this();
        this.checkDestination(dstAddress, dstPort);
        this.startupSocket(dstAddress, dstPort, null, 0, true);
    }

    public Socket(InetAddress dstAddress, int dstPort, InetAddress localAddress, int localPort) throws IOException {
        this();
        this.checkDestination(dstAddress, dstPort);
        this.startupSocket(dstAddress, dstPort, localAddress, localPort, true);
    }

    protected Socket(SocketImpl anImpl) throws SocketException {
        this.impl = anImpl;
    }

    void checkDestination(InetAddress destAddr, int dstPort) {
        if (dstPort < 0 || dstPort > 65535) {
            throw new IllegalArgumentException(Msg.getString("K0032"));
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            if (destAddr instanceof Inet6Address) {
                security.checkConnect("[" + destAddr.getHostAddress() + "]", dstPort);
            } else {
                security.checkConnect(destAddr.getHostAddress(), dstPort);
            }
        }
    }

    public synchronized void close() throws IOException {
        this.isClosed = true;
        this.impl.close();
    }

    public InetAddress getInetAddress() {
        if (!this.isConnected()) {
            return null;
        }
        return this.impl.getInetAddress();
    }

    public InputStream getInputStream() throws IOException {
        this.checkClosedAndCreate(false);
        if (this.isInputShutdown()) {
            throw new SocketException(Msg.getString("K0321"));
        }
        return this.impl.getInputStream();
    }

    public boolean getKeepAlive() throws SocketException {
        this.checkClosedAndCreate(true);
        return (Boolean)this.impl.getOption(8);
    }

    public InetAddress getLocalAddress() {
        if (!this.isBound()) {
            return InetAddress.ANY;
        }
        return Socket.getSocketLocalAddressImpl(this.impl.fd, InetAddress.preferIPv6Addresses());
    }

    public int getLocalPort() {
        if (!this.isBound()) {
            return -1;
        }
        return this.impl.getLocalPort();
    }

    public OutputStream getOutputStream() throws IOException {
        this.checkClosedAndCreate(false);
        return this.impl.getOutputStream();
    }

    public int getPort() {
        if (!this.isConnected()) {
            return 0;
        }
        return this.impl.getPort();
    }

    public int getSoLinger() throws SocketException {
        this.checkClosedAndCreate(true);
        return (Integer)this.impl.getOption(128);
    }

    public synchronized int getReceiveBufferSize() throws SocketException {
        this.checkClosedAndCreate(true);
        return (Integer)this.impl.getOption(4098);
    }

    public synchronized int getSendBufferSize() throws SocketException {
        this.checkClosedAndCreate(true);
        return (Integer)this.impl.getOption(4097);
    }

    public synchronized int getSoTimeout() throws SocketException {
        this.checkClosedAndCreate(true);
        return (Integer)this.impl.getOption(4102);
    }

    public boolean getTcpNoDelay() throws SocketException {
        this.checkClosedAndCreate(true);
        return (Boolean)this.impl.getOption(1);
    }

    static native InetAddress getSocketLocalAddressImpl(FileDescriptor var0, boolean var1);

    static native int getSocketLocalPortImpl(FileDescriptor var0, boolean var1);

    static native Object getSocketOptionImpl(FileDescriptor var0, int var1) throws SocketException;

    static native void setSocketOptionImpl(FileDescriptor var0, int var1, Object var2) throws SocketException;

    public void setKeepAlive(boolean value) throws SocketException {
        this.checkClosedAndCreate(true);
        this.impl.setOption(8, value ? Boolean.TRUE : Boolean.FALSE);
    }

    static native int getSocketFlags();

    static native void socketCloseImpl(FileDescriptor var0);

    public static synchronized void setSocketImplFactory(SocketImplFactory fac) throws IOException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkSetFactory();
        }
        if (factory != null) {
            throw new SocketException(Msg.getString("K0044"));
        }
        factory = fac;
    }

    public synchronized void setSendBufferSize(int size) throws SocketException {
        this.checkClosedAndCreate(true);
        if (size < 1) {
            throw new IllegalArgumentException(Msg.getString("K0035"));
        }
        this.impl.setOption(4097, new Integer(size));
    }

    public synchronized void setReceiveBufferSize(int size) throws SocketException {
        this.checkClosedAndCreate(true);
        if (size < 1) {
            throw new IllegalArgumentException(Msg.getString("K0035"));
        }
        this.impl.setOption(4098, new Integer(size));
    }

    public void setSoLinger(boolean on, int timeout) throws SocketException {
        this.checkClosedAndCreate(true);
        if (!on || timeout >= 0) {
        } else {
            throw new IllegalArgumentException(Msg.getString("K0045"));
        }
        int val = on ? (65535 < timeout ? 65535 : timeout) : -1;
        this.impl.setOption(128, new Integer(val));
    }

    public synchronized void setSoTimeout(int timeout) throws SocketException {
        this.checkClosedAndCreate(true);
        if (timeout < 0) {
            throw new IllegalArgumentException(Msg.getString("K0036"));
        }
        this.impl.setOption(4102, new Integer(timeout));
    }

    public void setTcpNoDelay(boolean on) throws SocketException {
        this.checkClosedAndCreate(true);
        this.impl.setOption(1, new Boolean(on));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startupSocket(InetAddress dstAddress, int dstPort, InetAddress localAddress, int localPort, boolean streaming) throws IOException {
        if (localPort < 0 || localPort > 65535) {
            throw new IllegalArgumentException(Msg.getString("K0046"));
        }
        InetAddress addr = localAddress == null ? InetAddress.ANY : localAddress;
        Socket socket = this;
        synchronized (socket) {
            this.impl.create(streaming);
            this.isCreated = true;
            try {
                if (!streaming || !PlainSocketImpl.usingSocks()) {
                    this.impl.bind(addr, localPort);
                }
                this.isBound = true;
                this.impl.connect(dstAddress, dstPort);
                this.isConnected = true;
            }
            catch (IOException e) {
                this.impl.close();
                throw e;
            }
        }
    }

    public String toString() {
        if (!this.isConnected()) {
            return "Socket[unconnected]";
        }
        return this.impl.toString();
    }

    public void shutdownInput() throws IOException {
        this.checkClosedAndCreate(false);
        this.impl.shutdownInput();
        this.isInputShutdown = true;
    }

    public void shutdownOutput() throws IOException {
        this.checkClosedAndCreate(false);
        this.impl.shutdownOutput();
        this.isOutputShutdown = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkClosedAndCreate(boolean create) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException(Msg.getString("K003d"));
        }
        if (!create && !this.isConnected()) {
            throw new SocketException(Msg.getString("K0074"));
        }
        if (this.isCreated) {
            return;
        }
        Socket socket = this;
        synchronized (socket) {
            if (this.isCreated) {
                return;
            }
            try {
                this.impl.create(true);
            }
            catch (SocketException e) {
                throw e;
            }
            catch (IOException e) {
                throw new SocketException(e.toString());
            }
            this.isCreated = true;
        }
    }

    public SocketAddress getLocalSocketAddress() {
        if (!this.isBound()) {
            return null;
        }
        return new InetSocketAddress(this.getLocalAddress(), this.getLocalPort());
    }

    public SocketAddress getRemoteSocketAddress() {
        if (!this.isConnected()) {
            return null;
        }
        return new InetSocketAddress(this.getInetAddress(), this.getPort());
    }

    public boolean isBound() {
        return this.isBound;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(SocketAddress localAddr) throws IOException {
        this.checkClosedAndCreate(true);
        if (this.isBound()) {
            throw new BindException(Msg.getString("K0315"));
        }
        int port = 0;
        InetAddress addr = InetAddress.ANY;
        if (localAddr != null) {
            if (!(localAddr instanceof InetSocketAddress)) {
                throw new IllegalArgumentException(Msg.getString("K0316", localAddr.getClass()));
            }
            InetSocketAddress inetAddr = (InetSocketAddress)localAddr;
            addr = inetAddr.getAddress();
            if (addr == null) {
                throw new SocketException(Msg.getString("K0317", inetAddr.getHostName()));
            }
            port = inetAddr.getPort();
        }
        Socket socket = this;
        synchronized (socket) {
            try {
                if (!PlainSocketImpl.usingSocks()) {
                    this.impl.bind(addr, port);
                }
                this.isBound = true;
            }
            catch (IOException e) {
                this.impl.close();
                throw e;
            }
        }
    }

    public void connect(SocketAddress remoteAddr) throws IOException {
        this.connect(remoteAddr, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(SocketAddress remoteAddr, int timeout) throws IOException {
        this.checkClosedAndCreate(true);
        if (timeout < 0) {
            throw new IllegalArgumentException(Msg.getString("K0036"));
        }
        if (this.isConnected()) {
            throw new SocketException(Msg.getString("K0079"));
        }
        if (remoteAddr == null) {
            throw new IllegalArgumentException(Msg.getString("K0318"));
        }
        if (!(remoteAddr instanceof InetSocketAddress)) {
            throw new IllegalArgumentException(Msg.getString("K0316", remoteAddr.getClass()));
        }
        InetSocketAddress inetAddr = (InetSocketAddress)remoteAddr;
        InetAddress addr = inetAddr.getAddress();
        if (addr == null) {
            throw new SocketException(Msg.getString("K0317", inetAddr.getHostName()));
        }
        int port = inetAddr.getPort();
        this.checkDestination(addr, port);
        Object object = this.connectLock;
        synchronized (object) {
            try {
                if (!this.isBound()) {
                    if (!PlainSocketImpl.usingSocks()) {
                        this.impl.bind(InetAddress.ANY, 0);
                    }
                    this.isBound = true;
                }
                this.impl.connect(remoteAddr, timeout);
                this.isConnected = true;
            }
            catch (IOException e) {
                this.impl.close();
                throw e;
            }
        }
    }

    public boolean isInputShutdown() {
        return this.isInputShutdown;
    }

    public boolean isOutputShutdown() {
        return this.isOutputShutdown;
    }

    public void setReuseAddress(boolean reuse) throws SocketException {
        this.checkClosedAndCreate(true);
        this.impl.setOption(4, reuse ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean getReuseAddress() throws SocketException {
        this.checkClosedAndCreate(true);
        return (Boolean)this.impl.getOption(4);
    }

    public void setOOBInline(boolean oobinline) throws SocketException {
        this.checkClosedAndCreate(true);
        this.impl.setOption(4099, oobinline ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean getOOBInline() throws SocketException {
        this.checkClosedAndCreate(true);
        return (Boolean)this.impl.getOption(4099);
    }

    public void setTrafficClass(int value) throws SocketException {
        this.checkClosedAndCreate(true);
        if (value < 0 || value > 255) {
            throw new IllegalArgumentException();
        }
        this.impl.setOption(3, new Integer(value));
    }

    public int getTrafficClass() throws SocketException {
        this.checkClosedAndCreate(true);
        return ((Number)this.impl.getOption(3)).intValue();
    }

    public void sendUrgentData(int value) throws IOException {
        if (!this.impl.supportsUrgentData()) {
            throw new SocketException(Msg.getString("K0333"));
        }
        this.impl.sendUrgentData(value);
    }

    void accepted() {
        this.isConnected = true;
        this.isBound = true;
        this.isCreated = true;
    }

    static boolean preferIPv4Stack() {
        String result = (String)AccessController.doPrivileged(new PriviAction("java.net.preferIPv4Stack"));
        return "true".equals(result);
    }
}

