/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import com.ibm.oti.util.Msg;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URIEncoderDecoder;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.StringTokenizer;

public final class URI
implements Comparable,
Serializable {
    private static final long serialVersionUID = -6052424284110960213L;
    static final String unreserved = "_-!.~'()*";
    static final String punct = ",;:$&+=";
    static final String reserved = ",;:$&+=?/[]@";
    static final String someLegal = "_-!.~'()*,;:$&+=";
    static final String allLegal = "_-!.~'()*,;:$&+=?/[]@";
    private String string = null;
    private transient String scheme = null;
    private transient String schemespecificpart = null;
    private transient String authority = null;
    private transient String userinfo = null;
    private transient String host = null;
    private transient int port = -1;
    private transient String path = null;
    private transient String query = null;
    private transient String fragment = null;
    private transient boolean opaque;
    private transient boolean absolute;
    private transient boolean serverAuthority = false;
    private transient int hash = -1;

    private URI() {
    }

    public URI(String uri) throws URISyntaxException {
        new Helper().parseURI(uri, false);
    }

    public URI(String scheme, String ssp, String frag) throws URISyntaxException {
        StringBuffer uri = new StringBuffer();
        if (scheme != null) {
            uri.append(scheme);
            uri.append(':');
        }
        if (ssp != null) {
            uri.append(this.quoteComponent(ssp, allLegal));
        }
        if (frag != null) {
            uri.append('#');
            uri.append(this.quoteComponent(frag, allLegal));
        }
        new Helper().parseURI(uri.toString(), false);
    }

    public URI(String scheme, String userinfo, String host, int port, String path, String query, String fragment) throws URISyntaxException {
        if (scheme != null && path != null && path.length() > 0 && path.charAt(0) != '/') {
            throw new URISyntaxException(path, Msg.getString("K0302"));
        }
        StringBuffer uri = new StringBuffer();
        if (scheme != null) {
            uri.append(scheme);
            uri.append(':');
        }
        if (userinfo != null || host != null || port != -1) {
            uri.append("//");
        }
        if (userinfo != null) {
            uri.append(this.quoteComponent(userinfo, someLegal));
            uri.append('@');
        }
        if (host != null) {
            if (host.indexOf(58) != -1 && host.indexOf(93) == -1 && host.indexOf(91) == -1) {
                host = "[" + host + "]";
            }
            uri.append(host);
        }
        if (port != -1) {
            uri.append(':');
            uri.append(port);
        }
        if (path != null) {
            uri.append(this.quoteComponent(path, "/@_-!.~'()*,;:$&+="));
        }
        if (query != null) {
            uri.append('?');
            uri.append(this.quoteComponent(query, allLegal));
        }
        if (fragment != null) {
            uri.append('#');
            uri.append(this.quoteComponent(fragment, allLegal));
        }
        new Helper().parseURI(uri.toString(), true);
    }

    public URI(String scheme, String host, String path, String fragment) throws URISyntaxException {
        this(scheme, null, host, -1, path, null, fragment);
    }

    public URI(String scheme, String authority, String path, String query, String fragment) throws URISyntaxException {
        if (scheme != null && path != null && path.length() > 0 && path.charAt(0) != '/') {
            throw new URISyntaxException(path, Msg.getString("K0302"));
        }
        StringBuffer uri = new StringBuffer();
        if (scheme != null) {
            uri.append(scheme);
            uri.append(':');
        }
        if (authority != null) {
            uri.append("//");
            uri.append(this.quoteComponent(authority, "@[]_-!.~'()*,;:$&+="));
        }
        if (path != null) {
            uri.append(this.quoteComponent(path, "/@_-!.~'()*,;:$&+="));
        }
        if (query != null) {
            uri.append('?');
            uri.append(this.quoteComponent(query, allLegal));
        }
        if (fragment != null) {
            uri.append('#');
            uri.append(this.quoteComponent(fragment, allLegal));
        }
        new Helper().parseURI(uri.toString(), false);
    }

    private String quoteComponent(String component, String legalset) {
        try {
            return URIEncoderDecoder.quoteIllegal(component, legalset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public int compareTo(Object o) {
        if (!(o instanceof URI)) {
            throw new ClassCastException();
        }
        URI uri = (URI)o;
        int ret = 0;
        if (this.scheme == null && uri.scheme != null) {
            return -1;
        }
        if (this.scheme != null && uri.scheme == null) {
            return 1;
        }
        if (this.scheme != null && uri.scheme != null && (ret = this.scheme.compareToIgnoreCase(uri.scheme)) != 0) {
            return ret;
        }
        if (!this.opaque && uri.opaque) {
            return -1;
        }
        if (this.opaque && !uri.opaque) {
            return 1;
        }
        if (this.opaque && uri.opaque) {
            ret = this.schemespecificpart.compareTo(uri.schemespecificpart);
            if (ret != 0) {
                return ret;
            }
        } else {
            if (this.authority != null && uri.authority == null) {
                return 1;
            }
            if (this.authority == null && uri.authority != null) {
                return -1;
            }
            if (this.authority != null && uri.authority != null) {
                if (this.host != null && uri.host != null) {
                    if (this.userinfo != null && uri.userinfo == null) {
                        return 1;
                    }
                    if (this.userinfo == null && uri.userinfo != null) {
                        return -1;
                    }
                    if (this.userinfo != null && uri.userinfo != null && (ret = this.userinfo.compareTo(uri.userinfo)) != 0) {
                        return ret;
                    }
                    ret = this.host.compareToIgnoreCase(uri.host);
                    if (ret != 0) {
                        return ret;
                    }
                    if (this.port != uri.port) {
                        return this.port - uri.port;
                    }
                } else {
                    ret = this.authority.compareTo(uri.authority);
                    if (ret != 0) {
                        return ret;
                    }
                }
            }
            if ((ret = this.path.compareTo(uri.path)) != 0) {
                return ret;
            }
            if (this.query != null && uri.query == null) {
                return 1;
            }
            if (this.query == null && uri.query != null) {
                return -1;
            }
            if (this.query != null && uri.query != null && (ret = this.query.compareTo(uri.query)) != 0) {
                return ret;
            }
        }
        if (this.fragment != null && uri.fragment == null) {
            return 1;
        }
        if (this.fragment == null && uri.fragment != null) {
            return -1;
        }
        if (this.fragment != null && uri.fragment != null && (ret = this.fragment.compareTo(uri.fragment)) != 0) {
            return ret;
        }
        return 0;
    }

    public static URI create(String uri) {
        URI result = null;
        try {
            result = new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        return result;
    }

    private URI duplicate() {
        URI clone = new URI();
        clone.absolute = this.absolute;
        clone.authority = this.authority;
        clone.fragment = this.fragment;
        clone.host = this.host;
        clone.opaque = this.opaque;
        clone.path = this.path;
        clone.port = this.port;
        clone.query = this.query;
        clone.scheme = this.scheme;
        clone.schemespecificpart = this.schemespecificpart;
        clone.userinfo = this.userinfo;
        clone.serverAuthority = this.serverAuthority;
        return clone;
    }

    private String convertHexToLowerCase(String s) {
        StringBuffer result = new StringBuffer("");
        if (s.indexOf(37) == -1) {
            return s;
        }
        int index = 0;
        int previndex = 0;
        while ((index = s.indexOf(37, previndex)) != -1) {
            result.append(s.substring(previndex, index + 1));
            result.append(s.substring(index + 1, index + 3).toLowerCase());
            previndex = index += 3;
        }
        return result.toString();
    }

    private boolean equalsHexCaseInsensitive(String first, String second) {
        if (first.indexOf(37) != second.indexOf(37)) {
            return first.equals(second);
        }
        int index = 0;
        int previndex = 0;
        while ((index = first.indexOf(37, previndex)) != -1 && second.indexOf(37, previndex) == index) {
            boolean match = first.substring(previndex, index).equals(second.substring(previndex, index));
            if (!match) {
                return false;
            }
            match = first.substring(index + 1, index + 3).equalsIgnoreCase(second.substring(index + 1, index + 3));
            if (!match) {
                return false;
            }
            previndex = index += 3;
        }
        return first.substring(previndex).equals(second.substring(previndex));
    }

    public boolean equals(Object o) {
        if (!(o instanceof URI)) {
            return false;
        }
        URI uri = (URI)o;
        if (uri.fragment == null && this.fragment != null || uri.fragment != null && this.fragment == null) {
            return false;
        }
        if (uri.fragment != null && this.fragment != null && !this.equalsHexCaseInsensitive(uri.fragment, this.fragment)) {
            return false;
        }
        if (uri.scheme == null && this.scheme != null || uri.scheme != null && this.scheme == null) {
            return false;
        }
        if (uri.scheme != null && this.scheme != null && !uri.scheme.equalsIgnoreCase(this.scheme)) {
            return false;
        }
        if (uri.opaque && this.opaque) {
            return this.equalsHexCaseInsensitive(uri.schemespecificpart, this.schemespecificpart);
        }
        if (!uri.opaque && !this.opaque) {
            if (!this.equalsHexCaseInsensitive(this.path, uri.path)) {
                return false;
            }
            if (uri.query != null && this.query == null || uri.query == null && this.query != null) {
                return false;
            }
            if (uri.query != null && this.query != null && !this.equalsHexCaseInsensitive(uri.query, this.query)) {
                return false;
            }
            if (uri.authority != null && this.authority == null || uri.authority == null && this.authority != null) {
                return false;
            }
            if (uri.authority != null && this.authority != null) {
                if (uri.host != null && this.host == null || uri.host == null && this.host != null) {
                    return false;
                }
                if (uri.host == null && this.host == null) {
                    return this.equalsHexCaseInsensitive(uri.authority, this.authority);
                }
                if (!this.host.equalsIgnoreCase(uri.host)) {
                    return false;
                }
                if (this.port != uri.port) {
                    return false;
                }
                if (uri.userinfo != null && this.userinfo == null || uri.userinfo == null && this.userinfo != null) {
                    return false;
                }
                if (uri.userinfo != null && this.userinfo != null) {
                    return this.equalsHexCaseInsensitive(this.userinfo, uri.userinfo);
                }
                return true;
            }
            return true;
        }
        return false;
    }

    public String getAuthority() {
        return this.decode(this.authority);
    }

    public String getFragment() {
        return this.decode(this.fragment);
    }

    public String getHost() {
        return this.host;
    }

    public String getPath() {
        return this.decode(this.path);
    }

    public int getPort() {
        return this.port;
    }

    public String getQuery() {
        return this.decode(this.query);
    }

    public String getRawAuthority() {
        return this.authority;
    }

    public String getRawFragment() {
        return this.fragment;
    }

    public String getRawPath() {
        return this.path;
    }

    public String getRawQuery() {
        return this.query;
    }

    public String getRawSchemeSpecificPart() {
        return this.schemespecificpart;
    }

    public String getRawUserInfo() {
        return this.userinfo;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getSchemeSpecificPart() {
        return this.decode(this.schemespecificpart);
    }

    public String getUserInfo() {
        return this.decode(this.userinfo);
    }

    public int hashCode() {
        if (this.hash == -1) {
            this.hash = this.getHashString().hashCode();
        }
        return this.hash;
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    public boolean isOpaque() {
        return this.opaque;
    }

    private String normalize(String path) {
        int index = path.indexOf(58);
        int index2 = path.indexOf(47);
        StringBuffer newpath = new StringBuffer();
        index = 0;
        index2 = 0;
        int pathlen = path.length();
        index = -1;
        int size = 0;
        if (pathlen > 0 && path.charAt(0) != '/') {
            ++size;
        }
        while ((index = path.indexOf(47, index + 1)) != -1) {
            if (index + 1 >= pathlen || path.charAt(index + 1) == '/') continue;
            ++size;
        }
        String[] seglist = new String[size];
        boolean[] include = new boolean[size];
        int current = 0;
        index = pathlen > 0 && path.charAt(0) == '/' ? 1 : 0;
        while ((index2 = path.indexOf(47, index + 1)) != -1) {
            seglist[current++] = path.substring(index, index2);
            index = index2 + 1;
        }
        if (current < size) {
            seglist[current] = path.substring(index);
        }
        int i = 0;
        while (i < size) {
            include[i] = true;
            if (seglist[i].equals("..")) {
                int remove = i - 1;
                while (remove > -1 && !include[remove]) {
                    --remove;
                }
                if (remove > -1 && !seglist[remove].equals("..")) {
                    include[remove] = false;
                    include[i] = false;
                }
            } else if (seglist[i].equals(".")) {
                include[i] = false;
            }
            ++i;
        }
        newpath = new StringBuffer();
        if (path.startsWith("/")) {
            newpath.append('/');
        }
        i = 0;
        while (i < seglist.length) {
            if (include[i]) {
                newpath.append(seglist[i]);
                newpath.append('/');
            }
            ++i;
        }
        if (!path.endsWith("/") && seglist.length > 0 && include[seglist.length - 1]) {
            newpath.deleteCharAt(newpath.length() - 1);
        }
        String result = newpath.toString();
        index = result.indexOf(58);
        index2 = result.indexOf(47);
        if (index != -1 && (index < index2 || index2 == -1)) {
            newpath.insert(0, "./");
            result = newpath.toString();
        }
        return result;
    }

    public URI normalize() {
        if (this.opaque) {
            return this;
        }
        String normalizedPath = this.normalize(this.path);
        if (this.path.equals(normalizedPath)) {
            return this;
        }
        URI result = this.duplicate();
        result.path = normalizedPath;
        result.setSchemeSpecificPart();
        return result;
    }

    public URI parseServerAuthority() throws URISyntaxException {
        if (!this.serverAuthority) {
            new Helper().parseAuthority(true);
        }
        return this;
    }

    public URI relativize(URI relative) {
        if (relative.opaque || this.opaque) {
            return relative;
        }
        if (this.scheme == null ? relative.scheme != null : !this.scheme.equals(relative.scheme)) {
            return relative;
        }
        if (this.authority == null ? relative.authority != null : !this.authority.equals(relative.authority)) {
            return relative;
        }
        String tempPath = null;
        tempPath = this.path.endsWith("/") ? this.path : String.valueOf(this.path) + "/";
        String normrel = this.normalize(relative.path);
        if (!normrel.startsWith(tempPath = this.normalize(tempPath))) {
            return relative;
        }
        URI result = new URI();
        result.fragment = relative.fragment;
        result.query = relative.query;
        result.path = normrel.substring(tempPath.length());
        return result;
    }

    public URI resolve(URI relative) {
        URI result;
        if (relative.absolute || this.opaque) {
            return relative;
        }
        if (relative.path.equals("") && relative.scheme == null && relative.authority == null && relative.query == null && relative.fragment != null) {
            URI result2 = this.duplicate();
            result2.fragment = relative.fragment;
            return result2;
        }
        if (relative.authority != null) {
            result = relative.duplicate();
            result.scheme = this.scheme;
            result.absolute = this.absolute;
        } else {
            result = this.duplicate();
            result.fragment = relative.fragment;
            result.query = relative.query;
            if (relative.path.startsWith("/")) {
                result.path = relative.path;
            } else {
                int endindex = this.path.lastIndexOf(47) + 1;
                result.path = this.normalize(String.valueOf(this.path.substring(0, endindex)) + relative.path);
            }
            result.setSchemeSpecificPart();
        }
        return result;
    }

    private void setSchemeSpecificPart() {
        StringBuffer ssp = new StringBuffer();
        if (this.authority != null) {
            ssp.append("//" + this.authority);
        }
        if (this.path != null) {
            ssp.append(this.path);
        }
        if (this.query != null) {
            ssp.append("?" + this.query);
        }
        this.schemespecificpart = ssp.toString();
        this.string = null;
    }

    public URI resolve(String relative) {
        return this.resolve(URI.create(relative));
    }

    private String encodeOthers(String s) {
        try {
            return URIEncoderDecoder.encodeOthers(s);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private String decode(String s) {
        if (s == null) {
            return s;
        }
        try {
            return URIEncoderDecoder.decode(s);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String toASCIIString() {
        return this.encodeOthers(this.toString());
    }

    public String toString() {
        if (this.string == null) {
            StringBuffer result = new StringBuffer();
            if (this.scheme != null) {
                result.append(this.scheme);
                result.append(':');
            }
            if (this.opaque) {
                result.append(this.schemespecificpart);
            } else {
                if (this.authority != null) {
                    result.append("//");
                    result.append(this.authority);
                }
                if (this.path != null) {
                    result.append(this.path);
                }
                if (this.query != null) {
                    result.append('?');
                    result.append(this.query);
                }
            }
            if (this.fragment != null) {
                result.append('#');
                result.append(this.fragment);
            }
            this.string = result.toString();
        }
        return this.string;
    }

    private String getHashString() {
        StringBuffer result = new StringBuffer();
        if (this.scheme != null) {
            result.append(this.scheme.toLowerCase());
            result.append(':');
        }
        if (this.opaque) {
            result.append(this.schemespecificpart);
        } else {
            if (this.authority != null) {
                result.append("//");
                if (this.host == null) {
                    result.append(this.authority);
                } else {
                    if (this.userinfo != null) {
                        result.append(String.valueOf(this.userinfo) + "@");
                    }
                    result.append(this.host.toLowerCase());
                    if (this.port != -1) {
                        result.append(":" + this.port);
                    }
                }
            }
            if (this.path != null) {
                result.append(this.path);
            }
            if (this.query != null) {
                result.append('?');
                result.append(this.query);
            }
        }
        if (this.fragment != null) {
            result.append('#');
            result.append(this.fragment);
        }
        return this.convertHexToLowerCase(result.toString());
    }

    public URL toURL() throws MalformedURLException {
        if (!this.absolute) {
            throw new IllegalArgumentException(String.valueOf(Msg.getString("K0312")) + ": " + this.toString());
        }
        return new URL(this.toString());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            new Helper().parseURI(this.string, false);
        }
        catch (URISyntaxException e) {
            throw new IOException(e.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException, ClassNotFoundException {
        this.toString();
        out.defaultWriteObject();
    }

    private class Helper {
        Helper() {
        }

        private void parseURI(String uri, boolean forceServer) throws URISyntaxException {
            int index1;
            String temp = uri;
            URI.this.string = uri;
            int index = temp.indexOf(35);
            if (index != -1) {
                URI.this.fragment = temp.substring(index + 1);
                this.validateFragment(uri, URI.this.fragment, index + 1);
                temp = temp.substring(0, index);
            }
            index = index1 = temp.indexOf(58);
            int index2 = temp.indexOf(47);
            int index3 = temp.indexOf(63);
            if (!(index == -1 || index2 < index && index2 != -1 || index3 < index && index3 != -1)) {
                URI.this.absolute = true;
                URI.this.scheme = temp.substring(0, index);
                if (URI.this.scheme.length() == 0) {
                    throw new URISyntaxException(uri, Msg.getString("K0342"), index);
                }
                this.validateScheme(uri, URI.this.scheme, 0);
                URI.this.schemespecificpart = temp.substring(index + 1);
                if (URI.this.schemespecificpart.length() == 0) {
                    throw new URISyntaxException(uri, Msg.getString("K0303"), index + 1);
                }
            } else {
                URI.this.absolute = false;
                URI.this.schemespecificpart = temp;
            }
            if (URI.this.scheme == null || URI.this.schemespecificpart.length() > 0 && URI.this.schemespecificpart.charAt(0) == '/') {
                URI.this.opaque = false;
                temp = URI.this.schemespecificpart;
                index = temp.indexOf(63);
                if (index != -1) {
                    URI.this.query = temp.substring(index + 1);
                    temp = temp.substring(0, index);
                    this.validateQuery(uri, URI.this.query, index2 + 1 + index);
                }
                if (temp.startsWith("//")) {
                    index = temp.indexOf(47, 2);
                    if (index != -1) {
                        URI.this.authority = temp.substring(2, index);
                        URI.this.path = temp.substring(index);
                    } else {
                        URI.this.authority = temp.substring(2);
                        if (URI.this.authority.length() == 0 && URI.this.query == null && URI.this.fragment == null) {
                            throw new URISyntaxException(uri, Msg.getString("K0304"), uri.length());
                        }
                        URI.this.path = "";
                    }
                    if (URI.this.authority.length() == 0) {
                        URI.this.authority = null;
                    } else {
                        this.validateAuthority(uri, URI.this.authority, index1 + 3);
                    }
                } else {
                    URI.this.path = temp;
                }
                int pathIndex = 0;
                if (index2 > -1) {
                    pathIndex += index2;
                }
                if (index > -1) {
                    pathIndex += index;
                }
                this.validatePath(uri, URI.this.path, pathIndex);
            } else {
                URI.this.opaque = true;
                this.validateSsp(uri, URI.this.schemespecificpart, index2 + 2 + index);
            }
            this.parseAuthority(forceServer);
        }

        private void validateScheme(String uri, String scheme, int index) throws URISyntaxException {
            char ch = scheme.charAt(0);
            if (!(ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z')) {
                throw new URISyntaxException(uri, Msg.getString("K0305"), 0);
            }
            try {
                URIEncoderDecoder.validateSimple(scheme, "+-.");
            }
            catch (URISyntaxException e) {
                throw new URISyntaxException(uri, Msg.getString("K0305"), index + e.getIndex());
            }
        }

        private void validateSsp(String uri, String ssp, int index) throws URISyntaxException {
            try {
                URIEncoderDecoder.validate(ssp, URI.allLegal);
            }
            catch (URISyntaxException e) {
                throw new URISyntaxException(uri, Msg.getString("K0306", e.getReason()), index + e.getIndex());
            }
        }

        private void validateAuthority(String uri, String authority, int index) throws URISyntaxException {
            try {
                URIEncoderDecoder.validate(authority, "@[]_-!.~'()*,;:$&+=");
            }
            catch (URISyntaxException e) {
                throw new URISyntaxException(uri, Msg.getString("K0307", e.getReason()), index + e.getIndex());
            }
        }

        private void validatePath(String uri, String path, int index) throws URISyntaxException {
            try {
                URIEncoderDecoder.validate(path, "/@_-!.~'()*,;:$&+=");
            }
            catch (URISyntaxException e) {
                throw new URISyntaxException(uri, Msg.getString("K0308", e.getReason()), index + e.getIndex());
            }
        }

        private void validateQuery(String uri, String query, int index) throws URISyntaxException {
            try {
                URIEncoderDecoder.validate(query, URI.allLegal);
            }
            catch (URISyntaxException e) {
                throw new URISyntaxException(uri, Msg.getString("K0309", e.getReason()), index + e.getIndex());
            }
        }

        private void validateFragment(String uri, String fragment, int index) throws URISyntaxException {
            try {
                URIEncoderDecoder.validate(fragment, URI.allLegal);
            }
            catch (URISyntaxException e) {
                throw new URISyntaxException(uri, Msg.getString("K030a", e.getReason()), index + e.getIndex());
            }
        }

        private void parseAuthority(boolean forceServer) throws URISyntaxException {
            int tempPort;
            int hostindex;
            String tempHost;
            String tempUserinfo;
            block11: {
                if (URI.this.authority == null) {
                    return;
                }
                tempUserinfo = null;
                tempHost = null;
                hostindex = 0;
                tempPort = -1;
                String temp = URI.this.authority;
                int index = temp.indexOf(64);
                if (index != -1) {
                    tempUserinfo = temp.substring(0, index);
                    this.validateUserinfo(URI.this.authority, tempUserinfo, 0);
                    temp = temp.substring(index + 1);
                    hostindex = index + 1;
                }
                index = temp.lastIndexOf(58);
                int endindex = temp.indexOf(93);
                if (index != -1 && endindex < index) {
                    tempHost = temp.substring(0, index);
                    try {
                        tempPort = Integer.parseInt(temp.substring(index + 1));
                        if (tempPort < 0) {
                            if (forceServer) {
                                throw new URISyntaxException(URI.this.authority, Msg.getString("K00b1"), hostindex + index + 1);
                            }
                            return;
                        }
                        break block11;
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (forceServer) {
                            throw new URISyntaxException(URI.this.authority, Msg.getString("K00b1"), hostindex + index + 1);
                        }
                        return;
                    }
                }
                tempHost = temp;
            }
            if (tempHost.equals("")) {
                if (forceServer) {
                    throw new URISyntaxException(URI.this.authority, Msg.getString("K030c"), hostindex);
                }
                return;
            }
            if (!this.isValidHost(forceServer, tempHost)) {
                return;
            }
            URI.this.userinfo = tempUserinfo;
            URI.this.host = tempHost;
            URI.this.port = tempPort;
            URI.this.serverAuthority = true;
        }

        private void validateUserinfo(String uri, String userinfo, int index) throws URISyntaxException {
            int i = 0;
            while (i < userinfo.length()) {
                char ch = userinfo.charAt(i);
                if (ch == ']' || ch == '[') {
                    throw new URISyntaxException(uri, Msg.getString("K030d"), index + i);
                }
                ++i;
            }
        }

        private boolean isValidHost(boolean forceServer, String host) throws URISyntaxException {
            if (host.charAt(0) == '[') {
                if (host.charAt(host.length() - 1) != ']') {
                    throw new URISyntaxException(host, Msg.getString("K030e"), 0);
                }
                if (!this.isValidIP6Address(host)) {
                    throw new URISyntaxException(host, Msg.getString("K030f"));
                }
                return true;
            }
            if (host.indexOf(91) != -1 || host.indexOf(93) != -1) {
                throw new URISyntaxException(host, Msg.getString("K0310"), 0);
            }
            int index = host.lastIndexOf(46);
            if (index < 0 || index == host.length() - 1 || !Character.isDigit(host.charAt(index + 1))) {
                if (this.isValidDomainName(host)) {
                    return true;
                }
                if (forceServer) {
                    throw new URISyntaxException(host, Msg.getString("K0310"), 0);
                }
                return false;
            }
            if (this.isValidIPv4Address(host)) {
                return true;
            }
            if (forceServer) {
                throw new URISyntaxException(host, Msg.getString("K0311"), 0);
            }
            return false;
        }

        private boolean isValidDomainName(String host) {
            char ch;
            try {
                URIEncoderDecoder.validateSimple(host, "-.");
            }
            catch (URISyntaxException uRISyntaxException) {
                return false;
            }
            String label = null;
            StringTokenizer st = new StringTokenizer(host, ".");
            while (st.hasMoreTokens()) {
                label = st.nextToken();
                if (!label.startsWith("-") && !label.endsWith("-")) continue;
                return false;
            }
            return label.equals(host) || (ch = label.charAt(0)) < '0' || ch > '9';
        }

        private boolean isValidIPv4Address(String host) {
            try {
                int index = host.indexOf(46);
                int num = Integer.parseInt(host.substring(0, index));
                if (num < 0 || num > 255) {
                    return false;
                }
                int index2 = host.indexOf(46, index + 1);
                num = Integer.parseInt(host.substring(index + 1, index2));
                if (num < 0 || num > 255) {
                    return false;
                }
                index = host.indexOf(46, index2 + 1);
                num = Integer.parseInt(host.substring(index2 + 1, index));
                if (num < 0 || num > 255) {
                    return false;
                }
                num = Integer.parseInt(host.substring(index + 1));
                if (num < 0 || num > 255) {
                    return false;
                }
            }
            catch (Exception exception) {
                return false;
            }
            return true;
        }

        private boolean isValidIP6Address(String ipAddress) {
            int length = ipAddress.length();
            boolean doubleColon = false;
            int numberOfColons = 0;
            int numberOfPeriods = 0;
            String word = "";
            char c = '\u0000';
            char prevChar = '\u0000';
            int offset = 0;
            if (length < 2) {
                return false;
            }
            int i = 0;
            while (i < length) {
                prevChar = c;
                c = ipAddress.charAt(i);
                switch (c) {
                    case '[': {
                        if (i != 0) {
                            return false;
                        }
                        if (ipAddress.charAt(length - 1) != ']') {
                            return false;
                        }
                        offset = 1;
                        if (length >= 4) break;
                        return false;
                    }
                    case ']': {
                        if (i != length - 1) {
                            return false;
                        }
                        if (ipAddress.charAt(0) == '[') break;
                        return false;
                    }
                    case '.': {
                        if (++numberOfPeriods > 3) {
                            return false;
                        }
                        if (!this.isValidIP4Word(word)) {
                            return false;
                        }
                        if (numberOfColons != 6 && !doubleColon) {
                            return false;
                        }
                        if (numberOfColons == 7 && ipAddress.charAt(0 + offset) != ':' && ipAddress.charAt(1 + offset) != ':') {
                            return false;
                        }
                        word = "";
                        break;
                    }
                    case ':': {
                        if (++numberOfColons > 7) {
                            return false;
                        }
                        if (numberOfPeriods > 0) {
                            return false;
                        }
                        if (prevChar == ':') {
                            if (doubleColon) {
                                return false;
                            }
                            doubleColon = true;
                        }
                        word = "";
                        break;
                    }
                    default: {
                        if (word.length() > 3) {
                            return false;
                        }
                        if (!this.isValidHexChar(c)) {
                            return false;
                        }
                        word = String.valueOf(word) + c;
                    }
                }
                ++i;
            }
            if (numberOfPeriods > 0) {
                if (numberOfPeriods != 3 || !this.isValidIP4Word(word)) {
                    return false;
                }
            } else {
                if (numberOfColons != 7 && !doubleColon) {
                    return false;
                }
                if (word == "" && ipAddress.charAt(length - 1 - offset) != ':' && ipAddress.charAt(length - 2 - offset) != ':') {
                    return false;
                }
            }
            return true;
        }

        private boolean isValidIP4Word(String word) {
            if (word.length() < 1 || word.length() > 3) {
                return false;
            }
            int i = 0;
            while (i < word.length()) {
                char c = word.charAt(i);
                if (c < '0' || c > '9') {
                    return false;
                }
                ++i;
            }
            return Integer.parseInt(word) <= 255;
        }

        private boolean isValidHexChar(char c) {
            return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
        }
    }
}

