/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import com.ibm.oti.net.www.MimeTable;
import com.ibm.oti.util.Msg;
import com.ibm.oti.util.PriviAction;
import com.ibm.oti.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ContentHandler;
import java.net.ContentHandlerFactory;
import java.net.FileNameMap;
import java.net.URL;
import java.net.UnknownServiceException;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;

public abstract class URLConnection {
    protected URL url;
    private String contentType;
    private static String defaultRequestProperty = "";
    private static boolean defaultAllowUserInteraction = false;
    private static boolean defaultUseCaches = true;
    ContentHandler defaultHandler = new DefaultContentHandler();
    private long lastModified = -1L;
    protected long ifModifiedSince;
    private String requestProperty = defaultRequestProperty;
    protected boolean useCaches = defaultUseCaches;
    protected boolean connected = false;
    protected boolean doOutput = false;
    protected boolean doInput = true;
    protected boolean allowUserInteraction = defaultAllowUserInteraction;
    private static ContentHandlerFactory contentHandlerFactory;
    static Hashtable contentHandlers;
    private static FileNameMap fileNameMap;

    static {
        contentHandlers = new Hashtable();
    }

    protected URLConnection(URL url) {
        this.url = url;
    }

    public abstract void connect() throws IOException;

    public boolean getAllowUserInteraction() {
        return this.allowUserInteraction;
    }

    public Object getContent() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if ((this.contentType = this.getContentType()) == null && (this.contentType = URLConnection.guessContentTypeFromName(this.url.getFile())) == null) {
            this.contentType = URLConnection.guessContentTypeFromStream(this.getInputStream());
        }
        if (this.contentType != null) {
            return this.getContentHandler(this.contentType).getContent(this);
        }
        return null;
    }

    public Object getContent(Class[] types) throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if ((this.contentType = this.getContentType()) == null && (this.contentType = URLConnection.guessContentTypeFromName(this.url.getFile())) == null) {
            this.contentType = URLConnection.guessContentTypeFromStream(this.getInputStream());
        }
        if (this.contentType != null) {
            return this.getContentHandler(this.contentType).getContent(this, types);
        }
        return null;
    }

    public String getContentEncoding() {
        return this.getHeaderField("Content-Encoding");
    }

    private ContentHandler getContentHandler(String contentType) throws IOException {
        final String typeString = this.parseTypeString(contentType.replace('/', '.'));
        Object cHandler = contentHandlers.get(contentType);
        if (cHandler != null) {
            return (ContentHandler)cHandler;
        }
        if (contentHandlerFactory != null) {
            cHandler = contentHandlerFactory.createContentHandler(contentType);
            if (!(cHandler instanceof ContentHandler)) {
                throw new UnknownServiceException();
            }
            contentHandlers.put(contentType, cHandler);
            return (ContentHandler)cHandler;
        }
        String packageList = (String)AccessController.doPrivileged(new PriviAction("java.content.handler.pkgs"));
        if (packageList != null) {
            StringTokenizer st = new StringTokenizer(packageList, "|");
            while (st.countTokens() > 0) {
                try {
                    Class cl = Class.forName(String.valueOf(st.nextToken()) + "." + typeString, true, ClassLoader.getSystemClassLoader());
                    cHandler = (ContentHandler)cl.newInstance();
                }
                catch (Exception exception) {}
            }
        }
        if (cHandler == null) {
            cHandler = AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        String className = "com.ibm.oti.www.content." + typeString;
                        return Class.forName(className).newInstance();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (InstantiationException instantiationException) {}
                    return null;
                }
            });
        }
        if (cHandler != null) {
            if (!(cHandler instanceof ContentHandler)) {
                throw new UnknownServiceException();
            }
            contentHandlers.put(contentType, cHandler);
            return (ContentHandler)cHandler;
        }
        return this.defaultHandler;
    }

    public int getContentLength() {
        return this.getHeaderFieldInt("Content-Length", -1);
    }

    public String getContentType() {
        return this.getHeaderField("Content-Type");
    }

    public long getDate() {
        return this.getHeaderFieldDate("Date", 0L);
    }

    public static boolean getDefaultAllowUserInteraction() {
        return defaultAllowUserInteraction;
    }

    public boolean getDefaultUseCaches() {
        return defaultUseCaches;
    }

    public boolean getDoInput() {
        return this.doInput;
    }

    public boolean getDoOutput() {
        return this.doOutput;
    }

    public long getExpiration() {
        return this.getHeaderFieldDate("Expires", 0L);
    }

    public static FileNameMap getFileNameMap() {
        if (fileNameMap == null) {
            fileNameMap = new MimeTable();
        }
        return fileNameMap;
    }

    public String getHeaderField(int pos) {
        return null;
    }

    public Map getHeaderFields() {
        return Collections.EMPTY_MAP;
    }

    public Map getRequestProperties() {
        return Collections.EMPTY_MAP;
    }

    public void addRequestProperty(String field, String newValue) {
    }

    public String getHeaderField(String key) {
        return null;
    }

    public long getHeaderFieldDate(String field, long defaultValue) {
        String date = this.getHeaderField(field);
        if (date == null) {
            return defaultValue;
        }
        return Util.parseDate(date);
    }

    public int getHeaderFieldInt(String field, int defaultValue) {
        try {
            return Integer.parseInt(this.getHeaderField(field));
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public String getHeaderFieldKey(int posn) {
        return null;
    }

    public long getIfModifiedSince() {
        return this.ifModifiedSince;
    }

    public InputStream getInputStream() throws IOException {
        throw new UnknownServiceException(Msg.getString("K004d"));
    }

    public long getLastModified() {
        if (this.lastModified != -1L) {
            return this.lastModified;
        }
        this.lastModified = this.getHeaderFieldDate("Last-Modified", 0L);
        return this.lastModified;
    }

    public OutputStream getOutputStream() throws IOException {
        throw new UnknownServiceException(Msg.getString("K005f"));
    }

    public Permission getPermission() throws IOException {
        return new AllPermission();
    }

    public String getRequestProperty(String field) {
        return null;
    }

    public URL getURL() {
        return this.url;
    }

    public boolean getUseCaches() {
        return this.useCaches;
    }

    public static String guessContentTypeFromName(String url) {
        return URLConnection.getFileNameMap().getContentTypeFor(url);
    }

    public static String guessContentTypeFromStream(InputStream is) throws IOException {
        if (!is.markSupported()) {
            return null;
        }
        is.mark(4);
        char[] chars = new char[4];
        int i = 0;
        while (i < chars.length) {
            chars[i] = (char)is.read();
            ++i;
        }
        is.reset();
        if (chars[0] == 'P' && chars[1] == 'K') {
            return "application/zip";
        }
        if (chars[0] == 'G' && chars[1] == 'I') {
            return "image/gif";
        }
        if (new String(chars).trim().startsWith("<")) {
            return "text/html";
        }
        return null;
    }

    private String parseTypeString(String typeString) {
        StringBuffer typeStringBuffer = new StringBuffer(typeString);
        int i = 0;
        while (i < typeStringBuffer.length()) {
            char c = typeStringBuffer.charAt(i);
            if (!Character.isLetter(c) && !Character.isDigit(c) && c != '.') {
                typeStringBuffer.setCharAt(i, '_');
            }
            ++i;
        }
        return typeStringBuffer.toString();
    }

    public void setAllowUserInteraction(boolean newValue) {
        if (this.connected) {
            throw new IllegalStateException(Msg.getString("K0037"));
        }
        this.allowUserInteraction = newValue;
    }

    public static synchronized void setContentHandlerFactory(ContentHandlerFactory contentFactory) {
        if (contentHandlerFactory != null) {
            throw new Error(Msg.getString("K004e"));
        }
        SecurityManager sManager = System.getSecurityManager();
        if (sManager != null) {
            sManager.checkSetFactory();
        }
        contentHandlerFactory = contentFactory;
    }

    public static void setDefaultAllowUserInteraction(boolean allows) {
        defaultAllowUserInteraction = allows;
    }

    public void setDefaultUseCaches(boolean newValue) {
        if (this.connected) {
            throw new IllegalAccessError(Msg.getString("K0037"));
        }
        defaultUseCaches = newValue;
    }

    public void setDoInput(boolean newValue) {
        if (this.connected) {
            throw new IllegalAccessError(Msg.getString("K0037"));
        }
        this.doInput = newValue;
    }

    public void setDoOutput(boolean newValue) {
        if (this.connected) {
            throw new IllegalAccessError(Msg.getString("K0037"));
        }
        this.doOutput = newValue;
    }

    public static void setFileNameMap(FileNameMap map) {
        SecurityManager manager = System.getSecurityManager();
        if (manager != null) {
            manager.checkSetFactory();
        }
        fileNameMap = map;
    }

    public void setIfModifiedSince(long newValue) {
        if (this.connected) {
            throw new IllegalAccessError(Msg.getString("K0037"));
        }
        this.ifModifiedSince = newValue;
    }

    public void setRequestProperty(String field, String newValue) {
    }

    public void setUseCaches(boolean newValue) {
        if (this.connected) {
            throw new IllegalStateException(Msg.getString("K0037"));
        }
        this.useCaches = newValue;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + ":" + this.url.toString();
    }

    class DefaultContentHandler
    extends ContentHandler {
        DefaultContentHandler() {
        }

        public Object getContent(URLConnection u) throws IOException {
            return u.getInputStream();
        }
    }
}

