/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import com.ibm.oti.util.Msg;
import com.ibm.oti.util.PriviAction;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.DomainCombiner;
import java.security.Permission;
import java.security.ProtectionDomain;
import java.security.SecurityPermission;

public final class AccessControlContext {
    static int debugSetting = -1;
    DomainCombiner domainCombiner;
    ProtectionDomain[] domainsArray;
    private static final SecurityPermission createAccessControlContext = new SecurityPermission("createAccessControlContext");
    private static final SecurityPermission getDomainCombiner = new SecurityPermission("getDomainCombiner");
    static final int DEBUG_ACCESS = 1;
    static final int DEBUG_ACCESS_STACK = 2;
    static final int DEBUG_ACCESS_DOMAIN = 4;
    static final int DEBUG_ACCESS_FAILURE = 8;
    static final int DEBUG_ACCESS_THREAD = 16;
    static final int DEBUG_ALL = 255;

    static int debugSetting() {
        if (debugSetting != -1) {
            return debugSetting;
        }
        debugSetting = 0;
        boolean access = false;
        String value = (String)AccessController.doPrivileged(new PriviAction("java.security.debug"));
        if (value == null) {
            return debugSetting;
        }
        int start = 0;
        int length = value.length();
        while (start < length) {
            String keyword;
            int index = value.indexOf(44, start);
            if (index == -1) {
                index = length;
            }
            if ((keyword = value.substring(start, index)).equals("all")) {
                debugSetting = 255;
                return debugSetting;
            }
            if (keyword.startsWith("access")) {
                debugSetting |= 1;
                if (start + 6 < length && value.charAt(start + 6) == ':') {
                    index = start + 6;
                    access = true;
                }
            } else if (access && keyword.equals("stack")) {
                debugSetting |= 2;
            } else if (access && keyword.equals("domain")) {
                debugSetting |= 4;
            } else if (access && keyword.equals("failure")) {
                debugSetting |= 8;
            } else if (access && keyword.equals("thread")) {
                debugSetting |= 0x10;
            } else {
                access = false;
            }
            start = index + 1;
        }
        return debugSetting;
    }

    static void debugPrintAccess() {
        System.err.print("access: ");
        if ((AccessControlContext.debugSetting() & 0x10) == 16) {
            System.err.print("(" + Thread.currentThread() + ")");
        }
    }

    public AccessControlContext(ProtectionDomain[] context) {
        int length = context.length;
        int domainIndex = 0;
        this.domainsArray = new ProtectionDomain[length];
        int i = 0;
        while (i < length) {
            block4: {
                ProtectionDomain current = context[i];
                int j = 0;
                while (j < i) {
                    if (current != this.domainsArray[j]) {
                        ++j;
                        continue;
                    }
                    break block4;
                }
                this.domainsArray[domainIndex++] = current;
            }
            ++i;
        }
        if (domainIndex != length) {
            ProtectionDomain[] copy = new ProtectionDomain[domainIndex];
            System.arraycopy((Object)this.domainsArray, 0, (Object)copy, 0, domainIndex);
            this.domainsArray = copy;
        }
    }

    AccessControlContext(ProtectionDomain[] context, boolean ignored) {
        this.domainsArray = context;
    }

    public AccessControlContext(AccessControlContext acc, DomainCombiner combiner) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(createAccessControlContext);
        }
        this.domainsArray = acc.domainsArray;
        this.domainCombiner = combiner;
    }

    public void checkPermission(Permission perm) throws AccessControlException {
        int i;
        if (perm == null) {
            throw new NullPointerException();
        }
        if ((AccessControlContext.debugSetting() & 4) != 0) {
            AccessControlContext.debugPrintAccess();
            if (this.domainsArray.length == 0) {
                System.err.println("domain (context is null)");
            } else {
                i = 0;
                while (i < this.domainsArray.length) {
                    System.err.println("domain " + i + " " + this.domainsArray[i]);
                    ++i;
                }
            }
        }
        i = this.domainsArray.length;
        while (--i >= 0 && this.domainsArray[i].implies(perm)) {
        }
        if (i >= 0) {
            if ((AccessControlContext.debugSetting() & 1) != 0) {
                AccessControlContext.debugPrintAccess();
                System.err.println("access denied " + perm);
            }
            if ((AccessControlContext.debugSetting() & 8) != 0) {
                new Exception("Stack trace").printStackTrace();
                System.err.println("domain that failed " + this.domainsArray[i]);
            }
            throw new AccessControlException(Msg.getString("K002c", perm), perm);
        }
        if ((AccessControlContext.debugSetting() & 1) != 0) {
            AccessControlContext.debugPrintAccess();
            System.err.println("access allowed " + perm);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccessControlContext otherContext = (AccessControlContext)o;
        int length = this.domainsArray.length;
        ProtectionDomain[] otherDomains = otherContext.domainsArray;
        if (length != otherDomains.length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            block6: {
                ProtectionDomain current = this.domainsArray[i];
                int j = 0;
                while (j < length) {
                    if (current != otherDomains[j]) {
                        ++j;
                        continue;
                    }
                    break block6;
                }
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        int i = this.domainsArray.length;
        while (--i >= 0) {
            result ^= this.domainsArray[i].hashCode();
        }
        return result;
    }

    public DomainCombiner getDomainCombiner() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(getDomainCombiner);
        }
        return this.domainCombiner;
    }
}

