/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.SocketPermission;
import java.net.URL;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Enumeration;
import java.util.Hashtable;

public class CodeSource
implements Serializable {
    private static final long serialVersionUID = 4977541819976013951L;
    private URL location;
    private transient Certificate[] certificates;
    private transient Hashtable certificatesSet;

    public CodeSource(URL url, Certificate[] certificates) {
        this.location = url;
        if (certificates != null) {
            this.certificates = (Certificate[])certificates.clone();
            this.certificatesSet = new Hashtable(certificates.length * 3 / 2);
            int i = 0;
            while (i < certificates.length) {
                if (certificates[i] != null) {
                    this.certificatesSet.put(certificates[i], "ignored");
                }
                ++i;
            }
            if (this.certificatesSet.size() == 0) {
                this.certificatesSet = null;
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        CodeSource other = (CodeSource)o;
        URL myLocation = this.getLocation();
        if (myLocation == null ? other.getLocation() != null : !myLocation.equals(other.getLocation())) {
            return false;
        }
        if (this.certificatesSet == null) {
            if (other.certificatesSet != null) {
                return false;
            }
        } else {
            if (other.certificatesSet == null) {
                return false;
            }
            if (this.certificatesSet.size() != other.certificatesSet.size()) {
                return false;
            }
            Enumeration keysEnum = this.certificatesSet.keys();
            while (keysEnum.hasMoreElements()) {
                if (other.certificatesSet.containsKey(keysEnum.nextElement())) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        URL myLocation = this.getLocation();
        if (myLocation == null) {
            return 1313;
        }
        return myLocation.hashCode();
    }

    public final Certificate[] getCertificates() {
        if (this.certificates == null) {
            return null;
        }
        return (Certificate[])this.certificates.clone();
    }

    public final URL getLocation() {
        return this.location;
    }

    public boolean implies(CodeSource other) {
        URL myURL;
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (this.certificatesSet != null) {
            if (other.certificatesSet == null) {
                return false;
            }
            Enumeration keysEnum = this.certificatesSet.keys();
            while (keysEnum.hasMoreElements()) {
                if (other.certificatesSet.containsKey(keysEnum.nextElement())) continue;
                return false;
            }
        }
        if ((myURL = this.getLocation()) != null) {
            URL hisURL = other.getLocation();
            if (hisURL == null) {
                return false;
            }
            if (myURL.equals(hisURL)) {
                return true;
            }
            if (!myURL.getProtocol().equals(hisURL.getProtocol())) {
                return false;
            }
            if (!(myURL.getHost() == null || hisURL.getHost() != null && new SocketPermission(myURL.getHost(), "resolve").implies(new SocketPermission(hisURL.getHost(), "resolve")))) {
                return false;
            }
            if (myURL.getPort() != -1 && myURL.getPort() != hisURL.getPort()) {
                return false;
            }
            String myFile = myURL.getFile();
            String hisFile = hisURL.getFile();
            if (myFile != null && !myFile.equals(hisFile)) {
                if (myFile.endsWith("/-")) {
                    if (!hisFile.startsWith(myFile.substring(0, myFile.length() - 1))) {
                        return false;
                    }
                } else if (myFile.endsWith("/*")) {
                    if (!hisFile.startsWith(myFile.substring(0, myFile.length() - 1)) || hisFile.indexOf(47, myFile.length()) > 0) {
                        return false;
                    }
                } else if (!myFile.endsWith("/")) {
                    if (!hisFile.equals(String.valueOf(myFile) + "/")) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            if (myURL.getRef() != null && !myURL.getRef().equals(hisURL.getRef())) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        if (this.certificates == null || this.certificates.length == 0) {
            return "(" + this.location + " <no certificates>)";
        }
        return "(" + this.location + " " + this.certificates + ")";
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        if (this.certificates == null) {
            stream.writeInt(0);
        } else {
            stream.writeInt(this.certificates.length);
            int i = 0;
            while (i < this.certificates.length) {
                stream.writeUTF(this.certificates[i].getType());
                try {
                    byte[] encoded = this.certificates[i].getEncoded();
                    stream.writeInt(encoded.length);
                    stream.write(encoded);
                }
                catch (CertificateEncodingException certificateEncodingException) {
                    stream.writeInt(0);
                }
                ++i;
            }
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int count = stream.readInt();
        if (count > 0) {
            this.certificates = new Certificate[count];
            int i = 0;
            while (i < count) {
                String type = stream.readUTF();
                int length = stream.readInt();
                if (length > 0) {
                    byte[] encoded = new byte[length];
                    stream.readFully(encoded);
                    try {
                        CertificateFactory factory = CertificateFactory.getInstance(type);
                        this.certificates[i] = factory.generateCertificate(new ByteArrayInputStream(encoded));
                    }
                    catch (CertificateException certificateException) {}
                }
                ++i;
            }
            this.certificatesSet = new Hashtable(this.certificates.length * 3 / 2);
            i = 0;
            while (i < this.certificates.length) {
                if (this.certificates[i] != null) {
                    this.certificatesSet.put(this.certificates[i], "ignored");
                }
                ++i;
            }
            if (this.certificatesSet.size() == 0) {
                this.certificatesSet = null;
            }
        }
    }
}

