/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;

public abstract class KeyPairGenerator
extends KeyPairGeneratorSpi {
    private static final String KEY_PREFIX = "KeyPairGenerator.";
    private String algorithmName;
    private Provider provider;

    protected KeyPairGenerator(String algName) {
        this.setAlgorithm(algName);
    }

    public final KeyPair genKeyPair() {
        return this.generateKeyPair();
    }

    public String getAlgorithm() {
        return this.algorithmName;
    }

    public static KeyPairGenerator getInstance(String algorithmName) throws NoSuchAlgorithmException {
        if (algorithmName == null) {
            throw new IllegalArgumentException();
        }
        return KeyPairGenerator.toKeyPairGeneratorImplementation(algorithmName);
    }

    public static KeyPairGenerator getInstance(String algorithmName, String providerName) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (providerName == null) {
            throw new IllegalArgumentException();
        }
        if (algorithmName == null) {
            throw new IllegalArgumentException();
        }
        if (providerName.equals("")) {
            throw new IllegalArgumentException();
        }
        Provider provider = Security.getProvider(providerName);
        if (provider == null) {
            throw new NoSuchProviderException(providerName);
        }
        return KeyPairGenerator.toKeyPairGeneratorImplementation(algorithmName, provider);
    }

    public static KeyPairGenerator getInstance(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        if (algorithm == null || provider == null) {
            throw new IllegalArgumentException();
        }
        return KeyPairGenerator.toKeyPairGeneratorImplementation(algorithm, provider);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public void initialize(int keySize) {
        this.initialize(keySize, new SecureRandom());
    }

    public void initialize(int keySize, SecureRandom secureRandom) {
        throw new UnsupportedOperationException();
    }

    public void initialize(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        this.initialize(params, new SecureRandom());
    }

    public void initialize(AlgorithmParameterSpec params, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        super.initialize(params, secureRandom);
    }

    void setAlgorithm(String algorithmName) {
        this.algorithmName = algorithmName;
    }

    void setProvider(Provider provider) {
        this.provider = provider;
    }

    private static KeyPairGenerator toKeyPairGeneratorImplementation(String algorithmName) throws NoSuchAlgorithmException {
        Provider[] providers = Security.getProviders();
        int i = 0;
        while (i < providers.length) {
            Provider provider = providers[i];
            try {
                return KeyPairGenerator.toKeyPairGeneratorImplementation(algorithmName, provider);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                ++i;
            }
        }
        throw new NoSuchAlgorithmException(algorithmName);
    }

    private static KeyPairGenerator toKeyPairGeneratorImplementation(String algorithmName, Provider provider) throws NoSuchAlgorithmException {
        String keyPairGeneratorClassName;
        try {
            keyPairGeneratorClassName = provider.lookupProperty(KEY_PREFIX, algorithmName);
        }
        catch (ClassCastException classCastException) {
            throw new NoSuchAlgorithmException(algorithmName);
        }
        if (keyPairGeneratorClassName == null) {
            throw new NoSuchAlgorithmException(algorithmName);
        }
        try {
            Class keyPairGeneratorClass = Class.forName(keyPairGeneratorClassName, true, provider.getClass().getClassLoader());
            KeyPairGeneratorSpi providedKeyPairGenerator = (KeyPairGeneratorSpi)keyPairGeneratorClass.newInstance();
            KeyPairGenerator generator = providedKeyPairGenerator instanceof KeyPairGenerator ? (KeyPairGenerator)providedKeyPairGenerator : new Wrapper(providedKeyPairGenerator, algorithmName);
            generator.setProvider(provider);
            return generator;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (ClassCastException classCastException) {}
        throw new NoSuchAlgorithmException(algorithmName);
    }

    public KeyPair generateKeyPair() {
        return null;
    }

    private static class Wrapper
    extends KeyPairGenerator {
        KeyPairGeneratorSpi keyPairGeneratorProvider;

        Wrapper(KeyPairGeneratorSpi keyPairGeneratorProvider, String algorithmName) {
            super(algorithmName);
            this.keyPairGeneratorProvider = keyPairGeneratorProvider;
        }

        public KeyPair generateKeyPair() {
            return this.keyPairGeneratorProvider.generateKeyPair();
        }

        public void initialize(int keySize, SecureRandom secureRandom) {
            this.keyPairGeneratorProvider.initialize(keySize, secureRandom);
        }

        public void initialize(AlgorithmParameterSpec params, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            this.keyPairGeneratorProvider.initialize(params, secureRandom);
        }
    }
}

