/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import com.ibm.oti.util.DefaultPolicy;
import com.ibm.oti.util.PriviAction;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.ProtectionDomain;
import java.security.SecurityPermission;

public abstract class Policy {
    static Policy policy;

    public static Policy getPolicy() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(SecurityPermission.permissionToGetPolicy);
        }
        return Policy.getPolicyImpl();
    }

    static Policy getPolicyImpl() {
        if (policy == null) {
            String policyName = (String)AccessController.doPrivileged(PriviAction.getSecurityProperty("policy.provider"));
            try {
                if (policyName != null) {
                    policy = (Policy)Class.forName(policyName).newInstance();
                }
            }
            catch (Exception exception) {}
            if (policy == null) {
                policy = new DefaultPolicy();
            }
        }
        return policy;
    }

    public static void setPolicy(Policy p) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(SecurityPermission.permissionToSetPolicy);
        }
        policy = p;
    }

    public abstract PermissionCollection getPermissions(CodeSource var1);

    public abstract void refresh();

    public PermissionCollection getPermissions(ProtectionDomain domain) {
        return this.getPermissions(domain.getCodeSource());
    }

    public boolean implies(ProtectionDomain domain, Permission permission) {
        return this.getPermissions(domain).implies(permission);
    }
}

