/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import com.ibm.oti.util.Msg;
import com.ibm.oti.util.PriviAction;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.InvalidParameterException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.SecurityPermission;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;

public final class Security {
    private static final String[] defaultProperties = new String[]{"package.access", "com.ibm.oti.", "policy.provider", "com.ibm.oti.util.DefaultPolicy", "security.provider.1", "com.ibm.oti.security.provider.OTI"};
    private static final Properties securityProperties = Security.loadSecurityProperties();
    private static final Vector providersByPriority = new Vector();
    private static final Hashtable providersByName = new Hashtable(20);
    private static boolean providersLoaded = false;
    private static final int CRYPTO_SERVICE = 0;
    private static final int ALGORITHM_OR_TYPE = 1;
    private static final int ATTRIBUTE_NAME = 2;
    private static final int ATTRIBUTE_VALUE = 3;

    private Security() {
    }

    public static String getProperty(String key) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new SecurityPermission("getProperty." + key));
        }
        return securityProperties.getProperty(key);
    }

    public static void setProperty(String key, String datum) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new SecurityPermission("setProperty." + key));
        }
        securityProperties.put(key, datum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int addProvider(Provider provider) {
        if (!providersLoaded) {
            Security.loadSecurityProviders();
        }
        Vector vector = providersByPriority;
        synchronized (vector) {
            return Security.insertProviderAt(provider, providersByPriority.size() + 1);
        }
    }

    public static Provider getProvider(String providerName) {
        if (!providersLoaded) {
            Security.loadSecurityProviders();
        }
        return (Provider)providersByName.get(providerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Provider[] getProviders() {
        if (!providersLoaded) {
            Security.loadSecurityProviders();
        }
        Vector vector = providersByPriority;
        synchronized (vector) {
            Object[] result = new Provider[providersByPriority.size()];
            providersByPriority.copyInto(result);
            return result;
        }
    }

    private static boolean checkAttribute(String attrName, String attrValue, String sourceValue) {
        if (attrValue.length() == 0) {
            return true;
        }
        try {
            int v1 = Integer.parseInt(sourceValue);
            int v2 = Integer.parseInt(attrValue);
            return v1 >= v2;
        }
        catch (NumberFormatException numberFormatException) {
            return sourceValue.equals(attrValue);
        }
    }

    private static String[] parserOfFilter(String filter) {
        String[] filters = new String[4];
        char[] ch = new char[]{'.', ' ', ':'};
        int begin = 0;
        int end = 0;
        int length = filter.length();
        int i = 0;
        i = 0;
        while (i < ch.length && begin < length && end != -1) {
            end = filter.indexOf(ch[i], begin);
            if (end == -1) {
                filters[i] = new String(filter.substring(begin, length));
                break;
            }
            filters[i] = new String(filter.substring(begin, end));
            begin = end + 1;
            while (begin < length && filter.charAt(begin) == ' ') {
                ++begin;
            }
            ++i;
        }
        if (end != -1) {
            filters[i] = new String(filter.substring(begin, length));
        }
        return filters;
    }

    private static Provider[] getProvidersUsingFilters(Provider[] providers, String[] filters, int typeOfFilter) {
        int numberOfProviders = providers.length;
        if (numberOfProviders > 0) {
            String bufKey = String.valueOf(filters[0]) + "." + filters[1];
            String algAlias = "Alg.Alias." + bufKey;
            boolean isNotFound = true;
            int i = 0;
            while (i < providers.length) {
                String property;
                isNotFound = true;
                String key = bufKey;
                String alias = providers[i].getProperty(algAlias);
                if (alias != null) {
                    key = String.valueOf(filters[0]) + "." + alias;
                }
                if ((property = providers[i].getProperty(key)) != null) {
                    String value;
                    if (typeOfFilter == 1) {
                        isNotFound = false;
                    } else if (typeOfFilter == 2 && (value = providers[i].getProperty(key = String.valueOf(key) + ' ' + filters[2])) != null && Security.checkAttribute(filters[2], filters[3], value)) {
                        isNotFound = false;
                    }
                }
                if (isNotFound) {
                    providers[i] = null;
                    --numberOfProviders;
                }
                ++i;
            }
            if (numberOfProviders > 0) {
                Provider[] filterResult = new Provider[numberOfProviders];
                int j = 0;
                int i2 = 0;
                while (i2 < providers.length) {
                    if (providers[i2] != null) {
                        filterResult[j++] = providers[i2];
                    }
                    ++i2;
                }
                providers = filterResult;
            } else {
                providers = null;
            }
        } else {
            providers = null;
        }
        return providers;
    }

    public static Provider[] getProviders(String filter) {
        Provider[] providers = Security.getProviders();
        if (providers.length == 0) {
            return null;
        }
        String[] filters = Security.parserOfFilter(filter);
        int typeOfFilter = 0;
        if (filters[0] != null && filters[1] != null) {
            if (filters[2] != null || filters[3] != null) {
                if (filters[2] != null && filters[3] != null) {
                    if (filters[2].length() > 0) {
                        typeOfFilter = 2;
                    } else if (filters[3].length() == 0) {
                        typeOfFilter = 1;
                    }
                }
            } else if (filters[1].length() > 0) {
                typeOfFilter = 1;
            }
        }
        if (typeOfFilter == 0) {
            throw new InvalidParameterException(Msg.getString("K01a6"));
        }
        return Security.getProvidersUsingFilters(providers, filters, typeOfFilter);
    }

    public static Provider[] getProviders(Map filter) {
        Provider[] providers = Security.getProviders();
        if (providers.length == 0) {
            return null;
        }
        if (filter == null) {
            return providers;
        }
        Set keySet = filter.keySet();
        if (keySet == null) {
            return providers;
        }
        Iterator keys = keySet.iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String value = (String)filter.get(key);
            String[] filters = Security.parserOfFilter(key);
            int typeOfFilter = 0;
            if (filters[0] != null && filters[1] != null) {
                if (filters[2] != null) {
                    if (filters[3] != null) {
                        throw new InvalidParameterException(Msg.getString("K01a6"));
                    }
                    if (value.length() >= 0) {
                        typeOfFilter = 2;
                        filters[3] = value;
                    }
                } else if (value.length() == 0 && filters[1].length() > 0) {
                    typeOfFilter = 1;
                }
            }
            if (typeOfFilter == 0) {
                throw new InvalidParameterException(Msg.getString("K01a6"));
            }
            if ((providers = Security.getProvidersUsingFilters(providers, filters, typeOfFilter)) != null) continue;
            return null;
        }
        return providers;
    }

    public static int insertProviderAt(Provider provider, int position) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkSecurityAccess("insertProvider." + provider.getName());
        }
        if (!providersLoaded) {
            Security.loadSecurityProviders();
        }
        return Security.insertAt(provider, position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int insertAt(Provider provider, int position) {
        Vector vector = providersByPriority;
        synchronized (vector) {
            block5: {
                if (providersByName.get(provider.getName()) == null) break block5;
                return -1;
            }
            if (--position < 0 || position > providersByPriority.size()) {
                position = providersByPriority.size();
            }
            providersByPriority.insertElementAt(provider, position);
            providersByName.put(provider.getName(), provider);
        }
        return ++position;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeProvider(String name) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkSecurityAccess("removeProvider." + name);
        }
        if (!providersLoaded) {
            Security.loadSecurityProviders();
        }
        Vector vector = providersByPriority;
        synchronized (vector) {
            int foundIndex = -1;
            int i = 0;
            while (i < providersByPriority.size()) {
                Provider p = (Provider)providersByPriority.elementAt(i);
                if (name.equals(p.getName())) {
                    foundIndex = i;
                    break;
                }
                ++i;
            }
            if (foundIndex >= 0) {
                providersByPriority.removeElementAt(foundIndex);
                providersByName.remove(name);
            }
        }
    }

    public static Set getAlgorithms(String serviceName) {
        TreeSet result = new TreeSet();
        Provider[] providers = Security.getProviders();
        int i = 0;
        while (i < providers.length) {
            Provider p = providers[i];
            Set s = p.keySet();
            String searchName = serviceName.toLowerCase();
            Iterator iter = s.iterator();
            while (iter.hasNext()) {
                String element = (String)iter.next();
                String searchElement = element.toLowerCase();
                if (searchElement.indexOf(searchName) != 0) continue;
                int sepIndex = element.indexOf(46);
                String algorithm = element.substring(sepIndex + 1);
                result.add(algorithm);
            }
            ++i;
        }
        return result;
    }

    private static void loadDefaultProperties(Properties sp) {
        int i = 0;
        while (i < defaultProperties.length) {
            sp.put(defaultProperties[i], defaultProperties[i + 1]);
            i += 2;
        }
    }

    private static void loadSecurityProperties(String securityFile, Properties sp, boolean useDefaultIfNoFile) {
        File securityPropertiesFile = new File(securityFile);
        if (!securityPropertiesFile.exists()) {
            if (useDefaultIfNoFile) {
                Security.loadDefaultProperties(sp);
            }
        } else {
            InputStream in = null;
            try {
                try {
                    in = new BufferedInputStream(new FileInputStream(securityPropertiesFile));
                    sp.load(in);
                    Enumeration keyEnum = sp.keys();
                    while (keyEnum.hasMoreElements()) {
                        String key = (String)keyEnum.nextElement();
                        sp.put(key, ((String)sp.get(key)).trim());
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (IOException iOException) {}
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static Properties loadSecurityProperties() {
        File file;
        String javahome = (String)AccessController.doPrivileged(new PriviAction("java.home"));
        String additionalPropertiesName = (String)AccessController.doPrivileged(new PriviAction("java.security.properties"));
        String userDir = (String)AccessController.doPrivileged(new PriviAction("user.dir"));
        Properties sp = new Properties();
        Security.loadSecurityProperties(String.valueOf(javahome) + "/lib/security/java.security", sp, true);
        if (additionalPropertiesName == null || additionalPropertiesName.length() == 0) {
            return sp;
        }
        String override = sp.getProperty("security.overridePropertiesFile");
        if (override == null || !override.equalsIgnoreCase("true")) {
            return sp;
        }
        if (additionalPropertiesName.charAt(0) == '=') {
            sp = new Properties();
            additionalPropertiesName = additionalPropertiesName.substring(1);
        }
        if ((file = new File(additionalPropertiesName)).isAbsolute()) {
            Security.loadSecurityProperties(additionalPropertiesName, sp, false);
        } else {
            Security.loadSecurityProperties(String.valueOf(userDir) + File.separator + additionalPropertiesName, sp, false);
        }
        return sp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadSecurityProviders() {
        Vector vector = providersByPriority;
        synchronized (vector) {
            if (providersLoaded) {
                return;
            }
            providersLoaded = true;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    String providerName;
                    int providerNum = 1;
                    while ((providerName = Security.getProperty("security.provider." + providerNum++)) != null) {
                        try {
                            Class providerClass = Class.forName(providerName, true, ClassLoader.getSystemClassLoader());
                            Provider provider = (Provider)providerClass.newInstance();
                            Security.insertAt(provider, providersByPriority.size() + 1);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                        }
                        catch (IllegalAccessException illegalAccessException) {
                        }
                        catch (InstantiationException instantiationException) {}
                    }
                    return null;
                }
            });
        }
    }
}

