/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.UnresolvedPermissionCollection;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Hashtable;

public final class UnresolvedPermission
extends Permission
implements Serializable {
    private static final long serialVersionUID = -4821973115467008846L;
    private transient Certificate[] certificates;
    private String type;
    private String actions;
    private String name;
    static Class[] constructorArgs;
    static /* synthetic */ Class class$0;

    static {
        Class clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class string = clazz;
        constructorArgs = new Class[]{string, string};
    }

    public UnresolvedPermission(String type, String name, String actions, Certificate[] certs) {
        super(type);
        this.name = name;
        this.certificates = certs;
        this.type = type;
        this.actions = actions;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof UnresolvedPermission)) {
            return false;
        }
        UnresolvedPermission perm = (UnresolvedPermission)obj;
        if (!(this.type.equals(perm.type) && this.name.equals(perm.name) && this.actions.equals(perm.actions))) {
            return false;
        }
        if (this.certificates == null && perm.certificates == null) {
            return true;
        }
        if (this.certificates.length != perm.certificates.length) {
            return false;
        }
        Hashtable set = new Hashtable();
        int i = 0;
        while (i < this.certificates.length) {
            set.put(this.certificates[i], this.certificates[i]);
            ++i;
        }
        i = 0;
        while (i < perm.certificates.length) {
            if (set.get(perm.certificates[i]) == null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean implies(Permission p) {
        return false;
    }

    public PermissionCollection newPermissionCollection() {
        return new UnresolvedPermissionCollection();
    }

    public String getActions() {
        return "";
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return "(unresolved " + this.type + " " + this.name + " " + this.actions + ")";
    }

    Permission resolve(ClassLoader cl) {
        try {
            Class permClass = Class.forName(this.type, true, cl);
            boolean certified = true;
            Hashtable classCertificatesSet = null;
            if (permClass.getSigners() != null) {
                Certificate[] classCertificates = (Certificate[])permClass.getSigners();
                classCertificatesSet = new Hashtable(classCertificates.length * 3 / 2);
                int i = 0;
                while (i < classCertificates.length) {
                    if (classCertificates[i] != null) {
                        classCertificatesSet.put(classCertificates[i], classCertificates[i]);
                    }
                    ++i;
                }
                if (classCertificatesSet.size() == 0) {
                    classCertificatesSet = null;
                }
            }
            if (this.certificates != null) {
                if (classCertificatesSet == null) {
                    int i = 0;
                    while (i < this.certificates.length) {
                        if (this.certificates[i] != null) {
                            certified = false;
                            break;
                        }
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < this.certificates.length) {
                        if (this.certificates[i] != null && !classCertificatesSet.containsKey(this.certificates[i])) {
                            certified = false;
                            break;
                        }
                        ++i;
                    }
                }
            }
            if (certified) {
                Constructor constructor = permClass.getConstructor(constructorArgs);
                return (Permission)constructor.newInstance(new Object[]{this.name, this.actions});
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
        return null;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        int length = 0;
        if (this.certificates != null) {
            length = this.certificates.length;
        }
        stream.writeInt(length);
        int i = 0;
        while (i < length) {
            stream.writeUTF(this.certificates[i].getType());
            try {
                byte[] encoded = this.certificates[i].getEncoded();
                stream.writeInt(encoded.length);
                stream.write(encoded);
            }
            catch (CertificateEncodingException certificateEncodingException) {
                stream.writeInt(0);
            }
            ++i;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int count = stream.readInt();
        if (count > 0) {
            this.certificates = new Certificate[count];
            int i = 0;
            while (i < count) {
                String type = stream.readUTF();
                int length = stream.readInt();
                if (length > 0) {
                    byte[] encoded = new byte[length];
                    stream.readFully(encoded);
                    try {
                        CertificateFactory factory = CertificateFactory.getInstance(type);
                        this.certificates[i] = factory.generateCertificate(new ByteArrayInputStream(encoded));
                    }
                    catch (CertificateException certificateException) {}
                }
                ++i;
            }
        }
    }
}

