/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.MapEntry;
import java.util.NoSuchElementException;
import java.util.Set;

public class HashMap
extends AbstractMap
implements Map,
Cloneable,
Serializable {
    private static final long serialVersionUID = 362498820763181265L;
    transient int elementCount;
    transient Entry[] elementData;
    final float loadFactor;
    int threshold;
    transient int modCount = 0;
    private static final int DEFAULT_SIZE = 16;

    Entry[] newElementArray(int s) {
        return new Entry[s];
    }

    public HashMap() {
        this(16);
    }

    public HashMap(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        this.elementCount = 0;
        this.elementData = this.newElementArray(capacity == 0 ? 1 : capacity);
        this.loadFactor = 0.75f;
        this.computeMaxSize();
    }

    public HashMap(int capacity, float loadFactor) {
        if (capacity < 0 || !(loadFactor > 0.0f)) {
            throw new IllegalArgumentException();
        }
        this.elementCount = 0;
        this.elementData = this.newElementArray(capacity == 0 ? 1 : capacity);
        this.loadFactor = loadFactor;
        this.computeMaxSize();
    }

    public HashMap(Map map) {
        this(map.size() < 6 ? 11 : map.size() * 2);
        this.putAll(map);
    }

    public void clear() {
        if (this.elementCount > 0) {
            this.elementCount = 0;
            Arrays.fill(this.elementData, null);
            ++this.modCount;
        }
    }

    public Object clone() {
        try {
            HashMap map = (HashMap)super.clone();
            map.elementData = this.newElementArray(this.elementData.length);
            int i = 0;
            while (i < this.elementData.length) {
                Entry entry = this.elementData[i];
                if (entry != null) {
                    map.elementData[i] = (Entry)entry.clone();
                }
                ++i;
            }
            return map;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    private void computeMaxSize() {
        this.threshold = (int)((float)this.elementData.length * this.loadFactor);
    }

    public boolean containsKey(Object key) {
        return this.getEntry(key) != null;
    }

    public boolean containsValue(Object value) {
        if (value != null) {
            int i = this.elementData.length;
            while (--i >= 0) {
                Entry entry = this.elementData[i];
                while (entry != null) {
                    if (value.equals(entry.value)) {
                        return true;
                    }
                    entry = entry.next;
                }
            }
        } else {
            int i = this.elementData.length;
            while (--i >= 0) {
                Entry entry = this.elementData[i];
                while (entry != null) {
                    if (entry.value == null) {
                        return true;
                    }
                    entry = entry.next;
                }
            }
        }
        return false;
    }

    public Set entrySet() {
        return new HashMapEntrySet(this);
    }

    public Object get(Object key) {
        Entry m = this.getEntry(key);
        if (m != null) {
            return m.value;
        }
        return null;
    }

    Entry getEntry(Object key) {
        int index = this.getModuloHash(key);
        return this.findEntry(key, index);
    }

    int getModuloHash(Object key) {
        if (key == null) {
            return 0;
        }
        return (key.hashCode() & Integer.MAX_VALUE) % this.elementData.length;
    }

    /*
     * Unable to fully structure code
     */
    Entry findEntry(Object key, int index) {
        block2: {
            entry = this.elementData[index];
            if (key == null) ** GOTO lbl8
            while (entry != null && !entry.equalsKey(key, key.hashCode())) {
                entry = entry.next;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                entry = entry.next;
lbl8:
                // 2 sources

                ** while (entry != null && entry.key != null)
            }
        }
        return entry;
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet(){

                public boolean contains(Object object) {
                    return HashMap.this.containsKey(object);
                }

                public int size() {
                    return HashMap.this.size();
                }

                public void clear() {
                    HashMap.this.clear();
                }

                public boolean remove(Object key) {
                    if (HashMap.this.containsKey(key)) {
                        HashMap.this.remove(key);
                        return true;
                    }
                    return false;
                }

                public Iterator iterator() {
                    return new HashMapIterator(new MapEntry.Type(this){
                        final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public Object get(MapEntry entry) {
                            return entry.key;
                        }
                    }, HashMap.this);
                }
            };
        }
        return this.keySet;
    }

    public Object put(Object key, Object value) {
        int index = this.getModuloHash(key);
        Entry entry = this.findEntry(key, index);
        if (entry == null) {
            ++this.modCount;
            if (++this.elementCount > this.threshold) {
                this.rehash();
                index = key == null ? 0 : (key.hashCode() & Integer.MAX_VALUE) % this.elementData.length;
            }
            entry = this.createEntry(key, index, null);
        }
        Object result = entry.value;
        entry.value = value;
        return result;
    }

    Entry createEntry(Object key, int index, Object value) {
        Entry entry = new Entry(key, value);
        entry.next = this.elementData[index];
        this.elementData[index] = entry;
        return entry;
    }

    public void putAll(Map map) {
        super.putAll(map);
    }

    void rehash() {
        int length = this.elementData.length << 1;
        if (length == 0) {
            length = 1;
        }
        Entry[] newData = this.newElementArray(length);
        int i = 0;
        while (i < this.elementData.length) {
            Entry entry = this.elementData[i];
            while (entry != null) {
                Object key = entry.key;
                int index = key == null ? 0 : (key.hashCode() & Integer.MAX_VALUE) % length;
                Entry next = entry.next;
                entry.next = newData[index];
                newData[index] = entry;
                entry = next;
            }
            ++i;
        }
        this.elementData = newData;
        this.computeMaxSize();
    }

    public Object remove(Object key) {
        Entry entry = this.removeEntry(key);
        if (entry != null) {
            return entry.value;
        }
        return null;
    }

    Entry removeEntry(Object key) {
        Entry entry;
        int index = 0;
        Entry last = null;
        if (key != null) {
            index = (key.hashCode() & Integer.MAX_VALUE) % this.elementData.length;
            entry = this.elementData[index];
            while (entry != null && !entry.equalsKey(key, key.hashCode())) {
                last = entry;
                entry = entry.next;
            }
        } else {
            entry = this.elementData[0];
            while (entry != null && entry.key != null) {
                last = entry;
                entry = entry.next;
            }
        }
        if (entry == null) {
            return null;
        }
        if (last == null) {
            this.elementData[index] = entry.next;
        } else {
            last.next = entry.next;
        }
        ++this.modCount;
        --this.elementCount;
        return entry;
    }

    public int size() {
        return this.elementCount;
    }

    public Collection values() {
        if (this.valuesCollection == null) {
            this.valuesCollection = new AbstractCollection(){

                public boolean contains(Object object) {
                    return HashMap.this.containsValue(object);
                }

                public int size() {
                    return HashMap.this.size();
                }

                public void clear() {
                    HashMap.this.clear();
                }

                public Iterator iterator() {
                    return new HashMapIterator(new MapEntry.Type(this){
                        final /* synthetic */ 4 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public Object get(MapEntry entry) {
                            return entry.value;
                        }
                    }, HashMap.this);
                }
            };
        }
        return this.valuesCollection;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this.elementData.length);
        stream.writeInt(this.elementCount);
        Iterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            stream.writeObject(entry.key);
            stream.writeObject(entry.value);
            Entry entry2 = entry.next;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int length = stream.readInt();
        this.elementData = new Entry[length];
        int i = this.elementCount = stream.readInt();
        while (--i >= 0) {
            Object key = stream.readObject();
            int index = (key.hashCode() & Integer.MAX_VALUE) % length;
            this.createEntry(key, index, stream.readObject());
        }
    }

    static class Entry
    extends MapEntry {
        Entry next;

        Entry(Object theKey, Object theValue) {
            super(theKey, theValue);
        }

        public Object clone() {
            Entry entry = (Entry)super.clone();
            if (this.next != null) {
                entry.next = (Entry)this.next.clone();
            }
            return entry;
        }

        public boolean equalsKey(Object aKey, int hash) {
            if (this.key != null) {
                return this.key.equals(aKey);
            }
            return aKey == null;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    static class HashMapIterator
    implements Iterator {
        private int position = 0;
        int expectedModCount;
        final MapEntry.Type type;
        boolean canRemove = false;
        Entry entry;
        Entry lastEntry;
        final HashMap associatedMap;

        HashMapIterator(MapEntry.Type value, HashMap hm) {
            this.associatedMap = hm;
            this.type = value;
            this.expectedModCount = hm.modCount;
        }

        /*
         * Unable to fully structure code
         */
        public boolean hasNext() {
            if (this.entry == null) ** GOTO lbl7
            return true;
lbl-1000:
            // 1 sources

            {
                if (this.associatedMap.elementData[this.position] == null) {
                    ++this.position;
                    continue;
                }
                return true;
lbl7:
                // 2 sources

                ** while (this.position < this.associatedMap.elementData.length)
            }
lbl8:
            // 1 sources

            return false;
        }

        void checkConcurrentMod() throws ConcurrentModificationException {
            if (this.expectedModCount != this.associatedMap.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        public Object next() {
            Entry result;
            this.checkConcurrentMod();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.entry == null) {
                result = this.lastEntry = this.associatedMap.elementData[this.position++];
                this.entry = this.lastEntry.next;
            } else {
                if (this.lastEntry.next != this.entry) {
                    this.lastEntry = this.lastEntry.next;
                }
                result = this.entry;
                this.entry = this.entry.next;
            }
            this.canRemove = true;
            return this.type.get(result);
        }

        public void remove() {
            this.checkConcurrentMod();
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            this.canRemove = false;
            ++this.associatedMap.modCount;
            if (this.lastEntry.next == this.entry) {
                while (this.associatedMap.elementData[--this.position] == null) {
                }
                this.associatedMap.elementData[this.position] = this.associatedMap.elementData[this.position].next;
                this.entry = null;
            } else {
                this.lastEntry.next = this.entry;
            }
            --this.associatedMap.elementCount;
            ++this.expectedModCount;
        }
    }

    static class HashMapEntrySet
    extends AbstractSet {
        private final HashMap associatedMap;

        public HashMapEntrySet(HashMap hm) {
            this.associatedMap = hm;
        }

        HashMap hashMap() {
            return this.associatedMap;
        }

        public int size() {
            return this.associatedMap.elementCount;
        }

        public void clear() {
            this.associatedMap.clear();
        }

        public boolean remove(Object object) {
            if (this.contains(object)) {
                this.associatedMap.remove(((Map.Entry)object).getKey());
                return true;
            }
            return false;
        }

        public boolean contains(Object object) {
            if (object instanceof Map.Entry) {
                Entry entry = this.associatedMap.getEntry(((Map.Entry)object).getKey());
                return object.equals(entry);
            }
            return false;
        }

        public Iterator iterator() {
            return new HashMapIterator(new MapEntry.Type(this){
                final /* synthetic */ HashMapEntrySet this$1;
                {
                    this.this$1 = hashMapEntrySet;
                }

                public Object get(MapEntry entry) {
                    return entry;
                }
            }, this.associatedMap);
        }
    }
}

