/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class HashSet
extends AbstractSet
implements Set,
Cloneable,
Serializable {
    private static final long serialVersionUID = -5024744406713321676L;
    transient HashMap backingMap;

    public HashSet() {
        this(new HashMap());
    }

    public HashSet(int capacity) {
        this(new HashMap(capacity));
    }

    public HashSet(int capacity, float loadFactor) {
        this(new HashMap(capacity, loadFactor));
    }

    public HashSet(Collection collection) {
        this(new HashMap(collection.size() < 6 ? 11 : collection.size() * 2));
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            this.add(it.next());
        }
    }

    HashSet(HashMap backingMap) {
        this.backingMap = backingMap;
    }

    public boolean add(Object object) {
        return this.backingMap.put(object, this) == null;
    }

    public void clear() {
        this.backingMap.clear();
    }

    public Object clone() {
        try {
            HashSet clone = (HashSet)super.clone();
            clone.backingMap = (HashMap)this.backingMap.clone();
            return clone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean contains(Object object) {
        return this.backingMap.containsKey(object);
    }

    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    public Iterator iterator() {
        return this.backingMap.keySet().iterator();
    }

    public boolean remove(Object object) {
        return this.backingMap.remove(object) != null;
    }

    public int size() {
        return this.backingMap.size();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this.backingMap.elementData.length);
        stream.writeFloat(this.backingMap.loadFactor);
        stream.writeInt(this.backingMap.elementCount);
        int i = this.backingMap.elementData.length;
        while (--i >= 0) {
            HashMap.Entry entry = this.backingMap.elementData[i];
            while (entry != null) {
                stream.writeObject(entry.key);
                entry = entry.next;
            }
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int elementCount;
        stream.defaultReadObject();
        int length = stream.readInt();
        float loadFactor = stream.readFloat();
        this.backingMap = this.createBackingMap(length, loadFactor);
        int i = elementCount = stream.readInt();
        while (--i >= 0) {
            Object key = stream.readObject();
            this.backingMap.put(key, this);
        }
    }

    HashMap createBackingMap(int capacity, float loadFactor) {
        return new HashMap(capacity, loadFactor);
    }
}

