/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarVerifier;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class JarFile
extends ZipFile {
    public static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    static final String META_DIR = "META-INF/";
    private Manifest manifest;
    private ZipEntry manifestEntry;
    JarVerifier verifier;

    public JarFile(File file) throws IOException {
        this(file, true);
    }

    public JarFile(File file, boolean verify) throws IOException {
        super(file);
        if (verify) {
            this.verifier = new JarVerifier(file.getPath());
        }
        this.readMetaEntries();
    }

    public JarFile(File file, boolean verify, int mode) throws IOException {
        super(file, mode);
        if (verify) {
            this.verifier = new JarVerifier(file.getPath());
        }
        this.readMetaEntries();
    }

    public JarFile(String filename) throws IOException {
        this(filename, true);
    }

    public JarFile(String filename, boolean verify) throws IOException {
        super(filename);
        if (verify) {
            this.verifier = new JarVerifier(filename);
        }
        this.readMetaEntries();
    }

    public Enumeration entries() {
        class JarFileEnumerator
        implements Enumeration {
            Enumeration ze;
            JarFile jf;
            final /* synthetic */ JarFile this$0;

            JarFileEnumerator(JarFile jarFile, Enumeration zenum, JarFile jf) {
                this.this$0 = jarFile;
                this.ze = zenum;
                this.jf = jf;
            }

            public boolean hasMoreElements() {
                return this.ze.hasMoreElements();
            }

            public Object nextElement() {
                JarEntry je = new JarEntry((ZipEntry)this.ze.nextElement());
                je.parentJar = this.jf;
                if (this.this$0.verifier != null) {
                    je.certificates = this.this$0.verifier.getCertificates(je.getName());
                }
                return je;
            }
        }
        return new JarFileEnumerator(this, super.entries(), this);
    }

    public JarEntry getJarEntry(String name) {
        return (JarEntry)this.getEntry(name);
    }

    public Manifest getManifest() throws IOException {
        if (this.manifest != null) {
            return this.manifest;
        }
        if (this.manifestEntry != null) {
            InputStream is = super.getInputStream(this.manifestEntry);
            if (this.verifier != null) {
                byte[] buf = new byte[is.available()];
                is.mark(buf.length);
                is.read(buf, 0, buf.length);
                is.reset();
                this.verifier.addMetaEntry(this.manifestEntry.getName(), buf);
            }
            try {
                this.manifest = new Manifest(is, this.verifier != null);
            }
            finally {
                is.close();
            }
            this.manifestEntry = null;
        }
        return this.manifest;
    }

    private void readMetaEntries() throws IOException {
        ZipEntry[] metaEntries = this.getMetaEntriesImpl(null);
        int dirLength = META_DIR.length();
        boolean signed = false;
        if (metaEntries != null) {
            int i = 0;
            while (i < metaEntries.length) {
                ZipEntry entry = metaEntries[i];
                String entryName = entry.getName();
                if (this.manifestEntry == null && this.manifest == null && entryName.regionMatches(true, dirLength, MANIFEST_NAME, dirLength, MANIFEST_NAME.length() - dirLength)) {
                    this.manifestEntry = entry;
                    if (this.verifier == null) {
                        break;
                    }
                } else if (this.verifier != null && entryName.length() > dirLength && (entryName.regionMatches(true, entryName.length() - 3, ".SF", 0, 3) || entryName.regionMatches(true, entryName.length() - 4, ".DSA", 0, 4) || entryName.regionMatches(true, entryName.length() - 4, ".RSA", 0, 4))) {
                    signed = true;
                    InputStream is = super.getInputStream(entry);
                    byte[] buf = new byte[is.available()];
                    is.read(buf, 0, buf.length);
                    is.close();
                    this.verifier.addMetaEntry(entryName, buf);
                }
                ++i;
            }
        }
        if (!signed) {
            this.verifier = null;
        }
    }

    public InputStream getInputStream(ZipEntry ze) throws IOException {
        InputStream in;
        if (this.manifestEntry != null) {
            this.getManifest();
        }
        if (this.verifier != null) {
            this.verifier.setManifest(this.getManifest());
            if (this.verifier.readCertificates()) {
                this.verifier.removeMetaEntries();
                if (this.manifest != null) {
                    this.manifest.removeChunks();
                }
                if (!this.verifier.isSignedJar()) {
                    this.verifier = null;
                }
            }
        }
        if ((in = super.getInputStream(ze)) == null) {
            return null;
        }
        return new JarFileInputStream(in, ze, ze.getSize() >= 0L ? this.verifier : null);
    }

    public ZipEntry getEntry(String name) {
        ZipEntry ze = super.getEntry(name);
        if (ze == null) {
            return ze;
        }
        JarEntry je = new JarEntry(ze);
        je.parentJar = this;
        if (this.verifier != null) {
            je.certificates = this.verifier.getCertificates(je.getName());
        }
        return je;
    }

    private native ZipEntry[] getMetaEntriesImpl(byte[] var1);

    static final class JarFileInputStream
    extends FilterInputStream {
        private long count;
        private ZipEntry zipEntry;
        private JarVerifier verifier;
        private JarVerifier.VerifierEntry entry;
        private MessageDigest digest;

        JarFileInputStream(InputStream is, ZipEntry ze, JarVerifier ver) {
            super(is);
            if (ver != null) {
                this.zipEntry = ze;
                this.verifier = ver;
                this.count = this.zipEntry.getSize();
                this.entry = this.verifier.initEntry(ze.getName());
                if (this.entry != null) {
                    this.digest = this.entry.digest;
                }
            }
        }

        public int read() throws IOException {
            int r = super.read();
            if (this.entry != null) {
                if (r != -1) {
                    this.digest.update((byte)r);
                    --this.count;
                }
                if (r == -1 || this.count <= 0L) {
                    JarVerifier.VerifierEntry temp = this.entry;
                    this.entry = null;
                    this.verifier.verifySignatures(temp, this.zipEntry);
                }
            }
            return r;
        }

        public int read(byte[] buf, int off, int nbytes) throws IOException {
            int r = super.read(buf, off, nbytes);
            if (this.entry != null) {
                if (r != -1) {
                    int size = r;
                    if (this.count < (long)size) {
                        size = (int)this.count;
                    }
                    this.digest.update(buf, off, size);
                    this.count -= (long)r;
                }
                if (r == -1 || this.count <= 0L) {
                    JarVerifier.VerifierEntry temp = this.entry;
                    this.entry = null;
                    this.verifier.verifySignatures(temp, this.zipEntry);
                }
            }
            return r;
        }

        public long skip(long nbytes) throws IOException {
            long count = 0L;
            long rem = 0L;
            byte[] buf = new byte[4096];
            while (count < nbytes) {
                rem = nbytes - count;
                int x = this.read(buf, 0, rem > (long)buf.length ? buf.length : (int)rem);
                if (x == -1) {
                    return count;
                }
                count += (long)x;
            }
            return count;
        }
    }
}

