/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import com.ibm.oti.util.BASE64Decoder;
import com.ibm.oti.util.JarUtils;
import com.ibm.oti.util.Msg;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.InitManifest;
import java.util.jar.JarEntry;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

class JarVerifier {
    private String jarName;
    private Manifest man;
    private HashMap metaEntries = new HashMap(5);
    private Hashtable signatures = new Hashtable(5);
    private Hashtable certificates = new Hashtable(5);
    private Hashtable verifiedEntries = new Hashtable();

    JarVerifier(String name) {
        this.jarName = name;
    }

    VerifierEntry initEntry(String name) {
        if (this.man == null || this.signatures.size() == 0) {
            return null;
        }
        Attributes attributes = this.man.getAttributes(name);
        if (attributes == null) {
            return null;
        }
        Vector certs = new Vector();
        Iterator it = this.signatures.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            HashMap hm = (HashMap)entry.getValue();
            if (hm.get(name) == null) continue;
            String signatureFile = (String)entry.getKey();
            Vector newCerts = JarVerifier.getSignerCertificates(signatureFile, this.certificates);
            Iterator iter = newCerts.iterator();
            while (iter.hasNext()) {
                certs.add(iter.next());
            }
        }
        if (certs.size() == 0) {
            return null;
        }
        Object[] certificates = new Certificate[certs.size()];
        certs.toArray(certificates);
        String algorithms = attributes.getValue("Digest-Algorithms");
        if (algorithms == null) {
            algorithms = "SHA SHA1";
        }
        StringTokenizer tokens = new StringTokenizer(algorithms);
        while (tokens.hasMoreTokens()) {
            byte[] hashBytes;
            String algorithm = tokens.nextToken();
            String hash = attributes.getValue(String.valueOf(algorithm) + "-Digest");
            if (hash == null) continue;
            try {
                hashBytes = hash.getBytes("ISO8859_1");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e.toString());
            }
            try {
                return new VerifierEntry(MessageDigest.getInstance(algorithm), hashBytes, (Certificate[])certificates);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        }
        return null;
    }

    void addMetaEntry(String name, byte[] buf) {
        this.metaEntries.put(name.toUpperCase(), buf);
    }

    synchronized boolean readCertificates() {
        if (this.metaEntries == null) {
            return false;
        }
        Iterator it = this.metaEntries.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (!key.endsWith(".DSA") && !key.endsWith(".RSA")) continue;
            this.verifyCertificate(key);
            if (this.metaEntries == null) {
                return false;
            }
            it.remove();
        }
        return true;
    }

    private void verifyCertificate(String certFile) {
        String digestAttribute;
        byte[] manifest;
        String signatureFile = String.valueOf(certFile.substring(0, certFile.lastIndexOf(46))) + ".SF";
        byte[] sfBytes = (byte[])this.metaEntries.get(signatureFile);
        if (sfBytes == null) {
            return;
        }
        byte[] sBlockBytes = (byte[])this.metaEntries.get(certFile);
        try {
            Certificate[] signerCertChain = JarUtils.verifySignature(new ByteArrayInputStream(sfBytes), new ByteArrayInputStream(sBlockBytes));
            if (signerCertChain != null) {
                this.certificates.put(signatureFile, signerCertChain);
            }
        }
        catch (IOException iOException) {
            return;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SecurityException(Msg.getString("K00eb", this.jarName, signatureFile));
        }
        Attributes attributes = new Attributes();
        HashMap hm = new HashMap();
        try {
            new InitManifest(new ByteArrayInputStream(sfBytes), attributes, hm, null, "Signature-Version");
        }
        catch (IOException iOException) {
            return;
        }
        boolean createdBySigntool = false;
        String createdByValue = attributes.getValue("Created-By");
        if (createdByValue != null) {
            boolean bl = createdBySigntool = createdByValue.indexOf("signtool") != -1;
        }
        if ((manifest = (byte[])this.metaEntries.get("META-INF/MANIFEST.MF")) == null) {
            return;
        }
        String string = digestAttribute = createdBySigntool ? "-Digest" : "-Digest-Manifest";
        if (!this.verify(attributes, digestAttribute, manifest, false)) {
            Iterator it = hm.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                byte[] chunk = this.man.getChunk((String)entry.getKey());
                if (chunk == null) {
                    return;
                }
                if (this.verify((Attributes)entry.getValue(), "-Digest", chunk, createdBySigntool)) continue;
                throw new SecurityException(Msg.getString("K00ec", new Object[]{signatureFile, entry.getKey(), this.jarName}));
            }
        }
        this.metaEntries.put(signatureFile, null);
        this.signatures.put(signatureFile, hm);
    }

    void setManifest(Manifest mf) {
        this.man = mf;
    }

    void verifySignatures(VerifierEntry entry, ZipEntry zipEntry) {
        byte[] digest = entry.digest.digest();
        if (!MessageDigest.isEqual(digest, BASE64Decoder.decode(entry.hash))) {
            throw new SecurityException(Msg.getString("K00ec", new Object[]{"META-INF/MANIFEST.MF", zipEntry.getName(), this.jarName}));
        }
        this.verifiedEntries.put(zipEntry.getName(), entry.certificates);
        if (zipEntry instanceof JarEntry) {
            ((JarEntry)zipEntry).certificates = (Certificate[])entry.certificates.clone();
        }
    }

    boolean isSignedJar() {
        return this.certificates.size() > 0;
    }

    private boolean verify(Attributes attributes, String entry, byte[] data, boolean ignoreSecondEndline) {
        String algorithms = attributes.getValue("Digest-Algorithms");
        if (algorithms == null) {
            algorithms = "SHA SHA1";
        }
        StringTokenizer tokens = new StringTokenizer(algorithms);
        while (tokens.hasMoreTokens()) {
            byte[] hashBytes;
            MessageDigest md;
            String algorithm = tokens.nextToken();
            String hash = attributes.getValue(String.valueOf(algorithm) + entry);
            if (hash == null) continue;
            try {
                md = MessageDigest.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                continue;
            }
            if (ignoreSecondEndline && data[data.length - 1] == 10 && data[data.length - 2] == 10) {
                md.update(data, 0, data.length - 1);
            } else {
                md.update(data, 0, data.length);
            }
            byte[] b = md.digest();
            try {
                hashBytes = hash.getBytes("ISO8859_1");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e.toString());
            }
            return MessageDigest.isEqual(b, BASE64Decoder.decode(hashBytes));
        }
        return false;
    }

    Certificate[] getCertificates(String name) {
        Certificate[] certificates = (Certificate[])this.verifiedEntries.get(name);
        if (certificates == null) {
            return null;
        }
        return (Certificate[])certificates.clone();
    }

    void removeMetaEntries() {
        this.metaEntries = null;
    }

    public static Vector getSignerCertificates(String signatureFileName, Map certificates) {
        Vector result = new Vector();
        Certificate[] certChain = (Certificate[])certificates.get(signatureFileName);
        if (certChain != null) {
            int i = 0;
            while (i < certChain.length) {
                result.add(certChain[i]);
                ++i;
            }
        }
        return result;
    }

    static class VerifierEntry
    extends OutputStream {
        MessageDigest digest;
        byte[] hash;
        Certificate[] certificates;

        VerifierEntry(MessageDigest digest, byte[] hash, Certificate[] certificates) {
            this.digest = digest;
            this.hash = hash;
            this.certificates = certificates;
        }

        public void write(int value) {
            this.digest.update((byte)value);
        }

        public void write(byte[] buf, int off, int nbytes) {
            this.digest.update(buf, off, nbytes);
        }
    }
}

