/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import com.ibm.oti.util.Msg;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class InflaterInputStream
extends FilterInputStream {
    protected Inflater inf;
    protected byte[] buf;
    protected int len;
    boolean closed = false;
    boolean eof = false;
    static final int BUF_SIZE = 512;

    public InflaterInputStream(InputStream is) {
        this(is, new Inflater(), 512);
    }

    public InflaterInputStream(InputStream is, Inflater inf) {
        this(is, inf, 512);
    }

    public InflaterInputStream(InputStream is, Inflater inf, int bsize) {
        super(is);
        if (is == null || inf == null) {
            throw new NullPointerException();
        }
        if (bsize <= 0) {
            throw new IllegalArgumentException();
        }
        this.inf = inf;
        this.buf = new byte[bsize];
    }

    public int read() throws IOException {
        byte[] b = new byte[1];
        if (this.read(b, 0, 1) == -1) {
            return -1;
        }
        return b[0] & 0xFF;
    }

    public int read(byte[] buffer, int off, int nbytes) throws IOException {
        if (this.closed) {
            throw new IOException(Msg.getString("K0059"));
        }
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (off < 0 || nbytes < 0 || off + nbytes > buffer.length) {
            throw new IndexOutOfBoundsException();
        }
        if (nbytes == 0) {
            return 0;
        }
        if (this.inf.finished()) {
            this.eof = true;
            return -1;
        }
        if (off <= buffer.length && nbytes >= 0 && off >= 0 && buffer.length - off >= nbytes) {
            if (nbytes == 0) {
                return 0;
            }
            do {
                int result;
                if (this.inf.needsInput()) {
                    this.fill();
                }
                try {
                    result = this.inf.inflate(buffer, off, nbytes);
                }
                catch (DataFormatException e) {
                    if (this.len == -1) {
                        throw new EOFException();
                    }
                    throw new IOException(Msg.getString("K0413", e.getMessage()));
                }
                if (result > 0) {
                    return result;
                }
                if (this.inf.finished()) {
                    this.eof = true;
                    return -1;
                }
                if (!this.inf.needsDictionary()) continue;
                return -1;
            } while (this.len != -1);
            throw new EOFException();
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    protected void fill() throws IOException {
        if (this.closed) {
            throw new IOException(Msg.getString("K0059"));
        }
        this.len = this.in.read(this.buf);
        if (this.len > 0) {
            this.inf.setInput(this.buf, 0, this.len);
        }
    }

    public long skip(long nbytes) throws IOException {
        if (nbytes >= 0L) {
            long count = 0L;
            long rem = 0L;
            while (count < nbytes) {
                rem = nbytes - count;
                int x = this.read(this.buf, 0, rem > (long)this.buf.length ? this.buf.length : (int)rem);
                if (x == -1) {
                    this.eof = true;
                    return count;
                }
                count += (long)x;
            }
            return count;
        }
        throw new IllegalArgumentException();
    }

    public int available() throws IOException {
        if (this.closed) {
            throw new IOException(Msg.getString("K0059"));
        }
        if (this.eof) {
            return 0;
        }
        return 1;
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.inf.end();
            this.closed = true;
            this.eof = true;
            super.close();
        }
    }
}

