/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.zip.ZipConstants;

public class ZipEntry
implements ZipConstants,
Cloneable {
    String name;
    String comment;
    long compressedSize = -1L;
    long crc = -1L;
    long size = -1L;
    long dataOffset = -1L;
    int compressionMethod = -1;
    int time = -1;
    int modDate = -1;
    byte[] extra;
    public static final int DEFLATED = 8;
    public static final int STORED = 0;

    public ZipEntry(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (name.length() > 65535) {
            throw new IllegalArgumentException();
        }
        this.name = name;
    }

    public String getComment() {
        return this.comment;
    }

    public long getCompressedSize() {
        return this.compressedSize;
    }

    public long getCrc() {
        return this.crc;
    }

    public byte[] getExtra() {
        return this.extra;
    }

    public int getMethod() {
        return this.compressionMethod;
    }

    public String getName() {
        return this.name;
    }

    long getOffset() {
        return this.dataOffset;
    }

    public long getSize() {
        return this.size;
    }

    public long getTime() {
        if (this.time != -1) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.set(14, 0);
            cal.set(1980 + (this.modDate >> 9 & 0x7F), (this.modDate >> 5 & 0xF) - 1, this.modDate & 0x1F, this.time >> 11 & 0x1F, this.time >> 5 & 0x3F, (this.time & 0x1F) << 1);
            return cal.getTime().getTime();
        }
        return -1L;
    }

    public boolean isDirectory() {
        return this.name.charAt(this.name.length() - 1) == '/';
    }

    public void setComment(String string) {
        if (string != null && string.length() > 65535) {
            throw new IllegalArgumentException();
        }
        this.comment = string;
    }

    public void setCompressedSize(long value) {
        this.compressedSize = value;
    }

    public void setCrc(long value) {
        if (value < 0L || value > 0xFFFFFFFFL) {
            throw new IllegalArgumentException();
        }
        this.crc = value;
    }

    public void setExtra(byte[] data) {
        if (data != null && data.length > 65535) {
            throw new IllegalArgumentException();
        }
        this.extra = data;
    }

    public void setMethod(int value) {
        if (value != 0 && value != 8) {
            throw new IllegalArgumentException();
        }
        this.compressionMethod = value;
    }

    void setName(String entryName) {
        this.name = entryName;
    }

    void setOffset(long value) {
        this.dataOffset = value;
    }

    public void setSize(long value) {
        if (value < 0L || value > 0xFFFFFFFFL) {
            throw new IllegalArgumentException();
        }
        this.size = value;
    }

    public void setTime(long value) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(new Date(value));
        int year = cal.get(1);
        if (year < 1980) {
            this.modDate = 33;
            this.time = 0;
        } else {
            this.modDate = cal.get(5);
            this.modDate = cal.get(2) + 1 << 5 | this.modDate;
            this.modDate = cal.get(1) - 1980 << 9 | this.modDate;
            this.time = cal.get(13) >> 1;
            this.time = cal.get(12) << 5 | this.time;
            this.time = cal.get(11) << 11 | this.time;
        }
    }

    public String toString() {
        return this.name;
    }

    ZipEntry(String name, String comment, byte[] extra, long modTime, long size, long compressedSize, long crc, int compressionMethod, long modDate, long offset) {
        this.name = name;
        this.comment = comment;
        this.extra = extra;
        this.time = (int)modTime;
        this.size = size;
        this.compressedSize = compressedSize;
        this.crc = crc;
        this.compressionMethod = compressionMethod;
        this.modDate = (int)modDate;
        this.dataOffset = offset;
    }

    public ZipEntry(ZipEntry ze) {
        this.name = ze.name;
        this.comment = ze.comment;
        this.time = ze.time;
        this.size = ze.size;
        this.compressedSize = ze.compressedSize;
        this.crc = ze.crc;
        this.compressionMethod = ze.compressionMethod;
        this.modDate = ze.modDate;
        this.extra = ze.extra;
        this.dataOffset = ze.dataOffset;
    }

    public Object clone() {
        return new ZipEntry(this);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

