/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import com.ibm.oti.jce.support.Msg;
import com.ibm.oti.jce.support.Util;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;

public class SecretKeySpec
implements KeySpec,
SecretKey {
    public static final long serialVersionUID = 6577238317307289933L;
    byte[] key;
    String algorithm;

    public SecretKeySpec(byte[] key, String algorithm) {
        this(key, 0, key.length, algorithm);
    }

    public SecretKeySpec(byte[] key, int offset, int length, String algorithm) {
        if (key == null || algorithm == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || length < 0) {
            throw new IllegalArgumentException();
        }
        if (offset + length > key.length) {
            throw new IllegalArgumentException(Msg.getString("JCE011"));
        }
        this.algorithm = algorithm;
        this.key = new byte[length];
        System.arraycopy((Object)key, offset, (Object)this.key, 0, length);
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getFormat() {
        return "RAW";
    }

    public byte[] getEncoded() {
        return this.key;
    }

    public int hashCode() {
        return 1;
    }

    public boolean equals(Object compareTo) {
        if (compareTo instanceof SecretKeySpec) {
            return Util.equals(this.key, ((SecretKeySpec)compareTo).key);
        }
        if (compareTo instanceof SecretKey) {
            return Util.equals(this.key, ((SecretKey)compareTo).getEncoded());
        }
        return false;
    }
}

