/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.omf.aue.step1.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.LdnUtil;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractCreateInstanceAction;
import se.ericsson.crbs.omf.aue.step1.actions.CreateOneInstanceAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;

public class CreateMOEFuseAction
extends AbstractCreateInstanceAction {
    private static final Class THIS_CLASS = CreateMOEFuseAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String CREATE_MO_EFUSE_STEP2_ACTION = "efusesToCreate";
    protected static final String HWUNIT = "HwUnit";
    private static final String UNITTYPE = "unitType";
    private static final String LDN = "ldn";
    protected static final String EFUSE = "EFuse";
    private static final String EFUSE_FRO_TYPE = Integer.toString(117702667);

    public void createInstance(AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "convert()");
        TableData tableData = this.getTableData(this.tableHandler, HWUNIT);
        List list = this.findPDUs(tableData);
        List list2 = this.generateEFusesToCreateList(list);
        this.createEFuses(list2, aueContext);
        this.informStep2(list2);
        logger.traceReturn(THIS_CLASS, "convert()");
    }

    private void informStep2(List list) throws CrbsAueException {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            string2 = LdnUtil.getParentLdn((String)string);
            string3 = LdnUtil.getRdnValue((String)string2);
            string4 = LdnUtil.getRdnValue((String)string);
            string5 = string3 + "," + string4;
            stringBuffer.append((stringBuffer.length() > 0 ? " " : "") + string5);
        }
        try {
            logger.info(THIS_CLASS, "informStep2, storeing in Auepersistency: " + stringBuffer.toString());
            this.tableHandler.storeInAuePersistency("", CREATE_MO_EFUSE_STEP2_ACTION, stringBuffer.toString());
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException(tableDataException.getMessage(), (Throwable)tableDataException);
        }
    }

    private void createEFuses(List list, AueContext aueContext) throws CrbsAueException {
        CreateOneInstanceAction createOneInstanceAction = new CreateOneInstanceAction();
        Map map = this.createCreateOneInstanceActionArgsMap();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            map.put("parentldn", LdnUtil.getParentLdn((String)string));
            map.put("rdnValue", LdnUtil.getRdnValue((String)string));
            createOneInstanceAction.setMoActionArgs(map);
            createOneInstanceAction.convert(aueContext);
        }
    }

    private List generateEFusesToCreateList(List list) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "generateEFusesToCreateList()");
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!list.isEmpty()) {
            TableData tableData = this.getTableData(this.tableHandler, EFUSE);
            Object[] objectArray = new Object[]{};
            try {
                if (tableData.isNotEmpty()) {
                    objectArray = tableData.getAttributeValues(LDN);
                }
            }
            catch (TableDataException tableDataException) {
                throw new CrbsAueException(tableDataException.getMessage(), (Throwable)tableDataException);
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                for (int i = 1; i <= 16; ++i) {
                    boolean bl = false;
                    String string2 = string + ",EFuse=" + i;
                    for (int j = 0; j < objectArray.length; ++j) {
                        String string3 = objectArray[j].toString();
                        if (!string2.equalsIgnoreCase(string3)) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    arrayList.add(string2);
                }
            }
        }
        logger.info(THIS_CLASS, "generateEFusesToCreateList(): EFusesToCreate.size: " + arrayList.size());
        logger.traceReturn(THIS_CLASS, "generateEFusesToCreateList()");
        return arrayList;
    }

    private List findPDUs(TableData tableData) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "findPDUs()");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < tableData.getNumberOfRecords(); ++i) {
            Map map;
            try {
                map = tableData.getRecordMap(i);
            }
            catch (TableDataException tableDataException) {
                throw new CrbsAueException(tableDataException.getMessage(), (Throwable)tableDataException);
            }
            String string = (String)map.get(UNITTYPE);
            logger.info(THIS_CLASS, "findPDUs(): unittype: " + string);
            if (!"PDU".equals(string)) continue;
            String string2 = (String)map.get(LDN);
            arrayList.add(string2);
        }
        logger.info(THIS_CLASS, "findPDUs(): pduArrayList.size: " + arrayList.size());
        logger.traceReturn(THIS_CLASS, "findPDUs()");
        return arrayList;
    }

    private TableData getTableData(TableHandler tableHandler, String string) throws CrbsAueException {
        TableData tableData;
        try {
            tableData = tableHandler.getTableData(string);
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("It is not possible to get the table data: " + string, (Throwable)tableDataException);
        }
        return tableData;
    }

    private Map createCreateOneInstanceActionArgsMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("name", EFUSE);
        hashMap.put("frotype", EFUSE_FRO_TYPE);
        hashMap.put("parentRefExists", Boolean.FALSE.toString());
        return hashMap;
    }
}

