/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.omf.aue.step1.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractCreateInstanceAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;

public class FixClimateSystemAttrAction
extends AbstractCreateInstanceAction {
    private static final Class THIS_CLASS = FixClimateSystemAttrAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String AUE_PERSISTENCY_KEY = "FixClimateSystemAttrData";

    public void createInstance(AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "createInstance()");
        TableData tableData = this.getTableData(this.tableHandler, "Cabinet");
        List list = this.findCabinets(tableData);
        this.informStep2(list);
        logger.traceReturn(THIS_CLASS, "createInstance()");
    }

    private List findCabinets(TableData tableData) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "findCabinets()");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < tableData.getNumberOfRecords(); ++i) {
            Map map;
            try {
                map = tableData.getRecordMap(i);
            }
            catch (TableDataException tableDataException) {
                throw new CrbsAueException(tableDataException.getMessage(), (Throwable)tableDataException);
            }
            logger.info(THIS_CLASS, "findCabinets(): TRACE1: ");
            String string = ((Integer)map.get("climateSystem")).toString();
            logger.info(THIS_CLASS, "findCabinets(): TRACE2: ");
            String string2 = (String)map.get("ldn");
            logger.info(THIS_CLASS, "findcabinets(): climateSystem: " + string);
            String string3 = string2 + ";" + string;
            arrayList.add(string3);
        }
        logger.info(THIS_CLASS, "findCabinets(): cabinetArrayList.size: " + arrayList.size());
        logger.traceReturn(THIS_CLASS, "findCabinets()");
        return arrayList;
    }

    private void informStep2(List list) throws CrbsAueException {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringBuffer.append((stringBuffer.length() > 0 ? ":" : "") + string);
        }
        try {
            logger.info(THIS_CLASS, "informStep2, storeing in Auepersistency: " + stringBuffer.toString());
            this.tableHandler.storeInAuePersistency("", AUE_PERSISTENCY_KEY, stringBuffer.toString());
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException(tableDataException.getMessage(), (Throwable)tableDataException);
        }
    }

    private TableData getTableData(TableHandler tableHandler, String string) throws CrbsAueException {
        TableData tableData;
        try {
            tableData = tableHandler.getTableData(string);
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("It is not possible to get the table data: " + string, (Throwable)tableDataException);
        }
        return tableData;
    }
}

