/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.omf.aue.step1.actions;

import java.util.ArrayList;
import java.util.Map;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;
import se.ericsson.crbs.omf.aue.step1.actions.util.TableDataUtil;

public class HandleFroCtrlDomainRefForFuncMosAction
extends AbstractConversionAction {
    private static final Class THIS_CLASS = HandleFroCtrlDomainRefForFuncMosAction.class;
    private static TableHandler tableHandler;
    private static String cabinetLdn;
    private static final String CABINET_MO_TYPE = "Cabinet";
    private static final String POWERSUPPLY_MO_TYPE = "PowerSupply";
    private static final String POWERDISTRIBUTION_MO_TYPE = "PowerDistribution";
    private static final String BATTERYBACKUP_MO_TYPE = "BatteryBackup";
    private static final String LDN_ATTRIBUTE_NAME = "ldn";
    private static final int CABINET_FRO_TYPE = 0x7040000;
    private static final String CONTROL_DOMAIN_REF_ATTRIBUTE_NAME = "controlDomainRef";
    private static final String STEP2_FUNCMO_UPDATED = "funcMoUpdated";
    private static final String STEP2_FUNCMO_LIST = "funcMoList";
    private boolean funcMoUpdated = false;
    private final StringBuffer funcMoList = new StringBuffer();
    private TableData cabinetTableData = null;
    private static final AbstractLogger logger;

    public void convert(AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "createInstance()");
        logger.info(THIS_CLASS, "createInstance()");
        tableHandler = (TableHandler)aueContext.getAttribute("CURRENT_TABLE_HANDLER");
        if (this.cabinetExist(aueContext)) {
            for (int i = 0; i < 3; ++i) {
                TableData tableData = null;
                String string = POWERSUPPLY_MO_TYPE;
                switch (i) {
                    case 0: {
                        string = POWERSUPPLY_MO_TYPE;
                        break;
                    }
                    case 1: {
                        string = POWERDISTRIBUTION_MO_TYPE;
                        break;
                    }
                    case 2: {
                        string = BATTERYBACKUP_MO_TYPE;
                        break;
                    }
                    default: {
                        string = null;
                    }
                }
                try {
                    tableData = tableHandler.getTableData(string);
                    if (!this.funcMoExist(string, tableData, tableHandler)) continue;
                    this.checkAndUpdateControlDomainRef(string, tableData, this.cabinetTableData, tableHandler);
                    continue;
                }
                catch (TableDataException tableDataException) {
                    throw new CrbsAueException("tableData not Accessable", (Throwable)tableDataException);
                }
            }
            try {
                tableHandler.storeInAuePersistency("", STEP2_FUNCMO_UPDATED, Boolean.toString(this.funcMoUpdated));
                tableHandler.storeInAuePersistency("", STEP2_FUNCMO_LIST, this.funcMoList.toString());
            }
            catch (TableDataException tableDataException) {
                throw new CrbsAueException("Failed to write tableData: ", (Throwable)tableDataException);
            }
        }
        logger.traceReturn(THIS_CLASS, "createInstance()");
    }

    private void checkAndUpdateControlDomainRef(String string, TableData tableData, TableData tableData2, TableHandler tableHandler) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "checkAndUpdateControlDomainRef()");
        if (tableData != null && tableData.doesAttributeExist(CONTROL_DOMAIN_REF_ATTRIBUTE_NAME)) {
            try {
                Map map = tableData.getRecordMap(0);
                String string2 = (String)map.get(LDN_ATTRIBUTE_NAME);
                String string3 = (String)map.get(CONTROL_DOMAIN_REF_ATTRIBUTE_NAME);
                if (string3.equalsIgnoreCase("") || string3.length() - TableDataUtil.createEmptyArrayXmlString((String)CONTROL_DOMAIN_REF_ATTRIBUTE_NAME).length() < 3) {
                    String string4 = TableDataUtil.getFroid((String)cabinetLdn, (TableData)tableData2);
                    String string5 = TableDataUtil.createMoRefInArrayXmlString((String)cabinetLdn, (String)Integer.toString(0x7040000), (String)string4);
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(string5);
                    String string6 = TableDataUtil.createArrayXmlString((String)CONTROL_DOMAIN_REF_ATTRIBUTE_NAME, arrayList);
                    tableData.setAttributeValue(0, CONTROL_DOMAIN_REF_ATTRIBUTE_NAME, (Object)string6);
                    tableHandler.storeInAuePersistency(string2, CONTROL_DOMAIN_REF_ATTRIBUTE_NAME, cabinetLdn);
                    this.funcMoList.append((this.funcMoList.length() > 0 ? ":" : "") + string2);
                    this.funcMoUpdated = true;
                }
            }
            catch (TableDataException tableDataException) {
                throw new CrbsAueException("Failed to find read " + string + " tabledata.", (Throwable)tableDataException);
            }
        }
        logger.traceReturn(THIS_CLASS, "checkAndUpdateControlDomainRef()");
    }

    private boolean funcMoExist(String string, TableData tableData, TableHandler tableHandler) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "funcMoExist()");
        try {
            tableData = tableHandler.getTableData(string);
            if (tableData != null && tableData.isNotEmpty()) {
                return true;
            }
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Failed to find read tabledata for MO: " + string + ".", (Throwable)tableDataException);
        }
        logger.traceReturn(THIS_CLASS, "funcMoExist()");
        return false;
    }

    private boolean cabinetExist(AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "cabinetExist()");
        tableHandler = (TableHandler)aueContext.getAttribute("CURRENT_TABLE_HANDLER");
        try {
            this.cabinetTableData = tableHandler.getTableData(CABINET_MO_TYPE);
            if (this.cabinetTableData != null && this.cabinetTableData.isNotEmpty() && this.cabinetTableData.getNumberOfRecords() != 0) {
                Object[] objectArray = this.cabinetTableData.getAttributeValues(LDN_ATTRIBUTE_NAME);
                cabinetLdn = objectArray[0].toString();
                return true;
            }
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Failed to find read Cabinet tabledata.", (Throwable)tableDataException);
        }
        logger.traceReturn(THIS_CLASS, "cabinetExist()");
        return false;
    }

    static {
        logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    }
}

