/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.omf.aue.step1.actions;

import java.util.HashMap;
import java.util.Map;
import se.ericsson.cello.aueframework.collector.CollectorContext;
import se.ericsson.cello.aueframework.collector.MoAccessor;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.cello.managedelement.ManagedElementMo;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.actions.NoSuchTableException;
import se.ericsson.crbs.omf.aue.common.actions.TableAlreadyExistsException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.LdnUtil;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractCreateInstanceAction;
import se.ericsson.crbs.omf.aue.step1.actions.ChangeAttributeValueAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;
import se.ericsson.crbs.omf.aue.step1.actions.util.TableDataUtil;

public class HandleFroHwUnitPositionRefAction
extends AbstractCreateInstanceAction {
    private static final Class THIS_CLASS = HandleFroHwUnitPositionRefAction.class;
    private static TableHandler tableHandler;
    private static final String CABINET_MO_TYPE = "Cabinet";
    private static final String HWUNIT_MO_TYPE = "HwUnit";
    private static final String LDN_ATTRIBUTE_NAME = "ldn";
    private static final String MANAGED_ELEMENT_LDN = "ManagedElement=1";
    private static final int CABINET_FRO_TYPE = 0x7040000;
    private static final String POSITION_REF_ATTRIBUTE_NAME = "positionRef";
    private static final String UNIT_TYPE_ATTRIBUTE_NAME = "unitType";
    private static final String STEP2_HWUNITS_UPDATED_TAG = "hwUnitPositionRefsUpdated";
    private static final String STEP2_HWUNITS_LIST_TAG = "hwUnitsWithUpdatedPositionRef";
    private static final String RBS6601 = "RBS6601";
    private static final String RBS6301 = "RBS6301";
    private static final String RBS6501 = "RBS6501";
    private static final String SUP = "SUP";
    private static final String SCU = "SCU";
    private static final AbstractLogger logger;

    public void createInstance(AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "createInstance()");
        tableHandler = (TableHandler)aueContext.getAttribute("CURRENT_TABLE_HANDLER");
        try {
            TableData tableData = null;
            TableData tableData2 = null;
            try {
                tableData = tableHandler.getTableData(HWUNIT_MO_TYPE);
            }
            catch (TableDataException tableDataException) {
                tableData = null;
            }
            try {
                tableData2 = tableHandler.getTableData(CABINET_MO_TYPE);
            }
            catch (TableDataException tableDataException) {
                tableData2 = null;
            }
            if (tableData2 != null && tableData2.getNumberOfRecords() == 1 && tableData != null && tableData.getNumberOfRecords() != 0) {
                Map map = tableData2.getRecordMap(0);
                String string = (String)map.get(LDN_ATTRIBUTE_NAME);
                String string2 = TableDataUtil.getFroid((String)string, (TableData)tableData2);
                logger.traceDebug(THIS_CLASS, "CabinetLdn: " + string + " FroId: " + string2);
                this.updatePositionRefs(string, string2, tableData, aueContext);
            } else {
                logger.traceDebug(THIS_CLASS, "Only one Cabinet or no Hwunits. Nothing updated.");
                tableHandler.storeInAuePersistency("", STEP2_HWUNITS_UPDATED_TAG, Boolean.toString(false));
            }
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Failed to find read Cabinet or HwUnit tabledata.", (Throwable)tableDataException);
        }
        logger.traceReturn(THIS_CLASS, "createInstance()");
    }

    private boolean isOkToSetPositionRef(String string, String string2, String string3) {
        if (string.length() > 0) {
            return false;
        }
        if (string2.equals(SUP) || string2.equals(SCU)) {
            return true;
        }
        return !string3.startsWith(RBS6601) && !string3.startsWith(RBS6301) && !string3.startsWith(RBS6501);
    }

    private String getProductNameFromManagedElementMO(AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "getProductNameFromManagedElementMO");
        try {
            MoAccessor moAccessor = ((CollectorContext)aueContext).getMoAccessor();
            ManagedElementMo managedElementMo = (ManagedElementMo)moAccessor.lookup(MANAGED_ELEMENT_LDN);
            if (null == managedElementMo) {
                throw new CrbsAueException("Can't find ManagedElement=1");
            }
            String string = managedElementMo.getProductName(null);
            logger.traceReturn(THIS_CLASS, "getProductNameFromManagedElementMO - productName: " + string + ".");
            return string;
        }
        catch (MoAccessException moAccessException) {
            throw new CrbsAueException("Failed to find read productName from ManagedElement.", (Throwable)moAccessException);
        }
    }

    private void updatePositionRefs(String string, String string2, TableData tableData, AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "updatePositionRefs()");
        StringBuffer stringBuffer = new StringBuffer();
        try {
            Object[] objectArray = TableDataUtil.getLdns((TableData)tableData);
            Object[] objectArray2 = tableData.getAttributeValues(POSITION_REF_ATTRIBUTE_NAME);
            Object[] objectArray3 = tableData.getAttributeValues(UNIT_TYPE_ATTRIBUTE_NAME);
            String string3 = this.getProductNameFromManagedElementMO(aueContext);
            logger.traceDebug(THIS_CLASS, "productName: " + string3);
            String string4 = TableDataUtil.createMoRefXmlString((String)CABINET_MO_TYPE, (String)string, (String)Integer.toString(0x7040000), (String)string2);
            boolean bl = false;
            for (int i = 0; i < tableData.getNumberOfRecords(); ++i) {
                try {
                    String string5 = objectArray[i].toString();
                    String string6 = LdnUtil.getRdnValue((String)string5);
                    String string7 = objectArray2[i].toString();
                    String string8 = objectArray3[i].toString();
                    logger.traceDebug(THIS_CLASS, "hwUnitLdn: " + string5 + " positionRef: " + string7 + " unitType: " + string8);
                    logger.traceDebug(THIS_CLASS, "positionRefLdn: " + TableDataUtil.getLdnFromMoRef((String)string7));
                    if (this.isOkToSetPositionRef(TableDataUtil.getLdnFromMoRef((String)string7), string8, string3)) {
                        bl = true;
                        ChangeAttributeValueAction changeAttributeValueAction = new ChangeAttributeValueAction();
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        hashMap.put("Mo", HWUNIT_MO_TYPE);
                        hashMap.put("rdnValue", string6);
                        hashMap.put("attribute", POSITION_REF_ATTRIBUTE_NAME);
                        hashMap.put("newAttributeValue", string4);
                        changeAttributeValueAction.setMoActionArgs(hashMap);
                        changeAttributeValueAction.convert(aueContext);
                        stringBuffer.append((stringBuffer.length() > 0 ? ":" : "") + string5);
                    }
                }
                catch (NoSuchTableException noSuchTableException) {
                    throw new CrbsAueException(noSuchTableException.getMessage(), (Throwable)noSuchTableException);
                }
                catch (TableAlreadyExistsException tableAlreadyExistsException) {
                    throw new CrbsAueException(tableAlreadyExistsException.getMessage(), (Throwable)tableAlreadyExistsException);
                }
                tableHandler.storeInAuePersistency("", STEP2_HWUNITS_UPDATED_TAG, Boolean.toString(bl));
            }
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException(tableDataException.getMessage(), (Throwable)tableDataException);
        }
        if (stringBuffer.length() != 0) {
            try {
                tableHandler.storeInAuePersistency("", STEP2_HWUNITS_LIST_TAG, stringBuffer.toString());
            }
            catch (TableDataException tableDataException) {
                throw new CrbsAueException(tableDataException.getMessage(), (Throwable)tableDataException);
            }
        }
        logger.traceReturn(THIS_CLASS, "updatePositionRefs()");
    }

    static {
        logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    }
}

