/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;

public class Strings {
    public static final int MISSING = -1;
    public static final Class TYPE = String.class;
    public static final String NEWLINE = "\n";
    public static final String NULL = "null";
    public static final String PACKAGE_SEPARATOR = ".";
    public static final String CONSTANT_SEPARATOR = "_";
    public static final String EMPTY_STRING = "";
    public static final String ALARM_STATUS = "alarmStatus";
    public static final int UNPRINTABLE_CHAR_MIN_VALUE = 32;
    public static final int UNPRINTABLE_CHAR_MAX_VALUE = 126;

    public static boolean contains(String container, String contained) {
        return container != null && contained != null && container.indexOf(contained) >= 0;
    }

    public static boolean contains(String s, String[] ss) {
        for (int i = 0; i < ss.length; ++i) {
            if (!s.equals(ss[i])) continue;
            return true;
        }
        return false;
    }

    public static String replaceAll(String container, String str2replace, String replacementStr) {
        int start = 0;
        int end = 0;
        StringBuffer result2 = new StringBuffer();
        if (container != null && str2replace != null && replacementStr != null) {
            while ((end = container.indexOf(str2replace, start)) >= 0) {
                result2.append(container.substring(start, end));
                result2.append(replacementStr);
                start = end + str2replace.length();
            }
            result2.append(container.substring(start));
        }
        return result2.toString();
    }

    public static String toPascalCase(String uppercase) {
        StringBuffer lowerCase = new StringBuffer();
        if (uppercase != null) {
            StringTokenizer tok = new StringTokenizer(uppercase, CONSTANT_SEPARATOR);
            if (tok.countTokens() > 0) {
                while (tok.hasMoreTokens()) {
                    String elem = tok.nextToken();
                    if (elem.length() > 1) {
                        lowerCase.append(elem.substring(0, 1).toUpperCase(Locale.ENGLISH)).append(elem.substring(1, elem.length()).toLowerCase(Locale.ENGLISH));
                        continue;
                    }
                    lowerCase.append(elem.substring(0, 1).toUpperCase(Locale.ENGLISH));
                }
            } else {
                lowerCase.append(uppercase.substring(0, 1).toUpperCase(Locale.ENGLISH)).append(uppercase.substring(1, uppercase.length()).toLowerCase(Locale.ENGLISH));
            }
        }
        return lowerCase.toString();
    }

    public static String toConstantCase(String fieldName) {
        StringBuffer buf = new StringBuffer();
        int start = 0;
        for (int i = 0; i < fieldName.length(); ++i) {
            if (!Character.isUpperCase(fieldName.charAt(i)) || i == 0) continue;
            String str = fieldName.substring(start, i);
            buf.append(str.toUpperCase(Locale.ENGLISH)).append(CONSTANT_SEPARATOR);
            start = i;
        }
        buf.append(fieldName.substring(start, fieldName.length()).toUpperCase(Locale.ENGLISH));
        return buf.toString();
    }

    public static String removeAllSpaces(String str) {
        StringBuffer newStr = new StringBuffer();
        str = str.trim();
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            newStr.append(str.charAt(i));
        }
        return newStr.toString();
    }

    public static String getSimpleName(Class c) {
        String fullName = c.getName();
        int i = fullName.lastIndexOf(PACKAGE_SEPARATOR);
        if (i == -1) {
            return fullName;
        }
        return fullName.substring(i + 1);
    }

    public static String toString(byte[] value) {
        if (value == null) {
            return EMPTY_STRING;
        }
        StringBuffer stBuf = new StringBuffer();
        for (int i = 0; i < value.length; ++i) {
            if (value[i] == 0) {
                return stBuf.toString();
            }
            stBuf.append((char)value[i]);
        }
        return stBuf.toString();
    }

    public static byte[] getBytes(String str, int length, char padChar) {
        if (str.length() > length) {
            return str.substring(0, length).getBytes();
        }
        StringBuffer buf = new StringBuffer(str);
        while (buf.length() < length) {
            buf.append(padChar);
        }
        return buf.toString().getBytes();
    }

    public static byte[] getBytes(String str, int length, byte padByte) {
        return Strings.getBytes(str, length, (char)padByte);
    }

    public static byte[] getBytes(String str, int length) {
        return Strings.getBytes(str, length, '\u0000');
    }

    public static int countNrOfOccurrences(String txt, char c) {
        int count = 0;
        for (int i = 0; i < txt.length(); ++i) {
            if (txt.charAt(i) != c) continue;
            ++count;
        }
        return count;
    }

    public static String extractFirstToken(StringBuffer txt, char c) {
        String first;
        int delChar = txt.toString().indexOf(c);
        if (delChar != -1) {
            first = txt.substring(0, delChar);
            txt.delete(0, delChar + 1);
        } else {
            first = txt.toString();
            txt.delete(0, txt.length());
        }
        return first;
    }

    public static String trimAwayChars(String string, char delimChar) {
        byte[] stringAsBytes = string.getBytes();
        for (int i = 0; i < stringAsBytes.length; ++i) {
            if (stringAsBytes[i] != delimChar) continue;
            return string.substring(0, i);
        }
        return string;
    }

    public static String removeNonPrintableAscii(String input) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (!Strings.isPrintableAscii(c)) continue;
            buffer.append(c);
        }
        return buffer.toString();
    }

    private static boolean isPrintableAscii(char c) {
        char decValue = c;
        return decValue >= ' ' && decValue <= '~' && c != '&' && c != '<' && c != '>';
    }

    public static String toString(int[] ints) {
        StringBuffer result2 = new StringBuffer("[");
        for (int i = 0; i < ints.length; ++i) {
            if (i > 0) {
                result2.append(",");
            }
            result2.append(ints[i]);
        }
        result2.append("]");
        return result2.toString();
    }

    public static List splitString(String origString, int maxLength) {
        if (null == origString) {
            return null;
        }
        ArrayList<String> stringList = new ArrayList<String>();
        String str = origString.trim();
        while (str.length() > maxLength) {
            stringList.add(str.substring(0, maxLength));
            str = str.substring(maxLength);
        }
        if (str.length() > 0) {
            stringList.add(str);
        }
        return stringList;
    }

    public static String[] split(String str, String reg) {
        if (str == null || str.trim().equals(EMPTY_STRING)) {
            return new String[0];
        }
        if (reg == null || EMPTY_STRING.equals(reg)) {
            return new String[]{str};
        }
        ArrayList<String> tmpList = new ArrayList<String>();
        int from = 0;
        int to = -1;
        while ((to = str.indexOf(reg, from)) >= 0) {
            if (to > from) {
                tmpList.add(str.substring(from, to));
            }
            from = to + reg.length();
        }
        if (from < str.length()) {
            tmpList.add(str.substring(from));
        }
        return tmpList.toArray(new String[tmpList.size()]);
    }
}

