/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.common.generic;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.RbsLicenseFeatureT;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.NodeBFunctionMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RbsFeatureMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RbsLocalCellMo;
import se.ericsson.wcdma.rbs.boam.mao.rmo.cell.RbsLocalCellMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.rmo.node.NoCellRbsFeatureMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.rmo.node.RbsFeatureMoImpl;

public class RbsGenericLicenseManager {
    private static HashMap licenseFeatureMap = new HashMap();

    private RbsGenericLicenseManager() {
    }

    public static void generateFeatureMap(List featureList) {
        for (int i = 0; i < featureList.size(); ++i) {
            RbsLicenseFeatureT rbsLicenseFeature = (RbsLicenseFeatureT)featureList.get(i);
            String keyName = rbsLicenseFeature.licenseName;
            RbsGenericLicenseManager.addLicenseFeatureMap(keyName, rbsLicenseFeature);
        }
    }

    public static void addLicenseFeatureMap(String key, RbsLicenseFeatureT value) {
        licenseFeatureMap.put(key, value);
    }

    public static RbsLicenseFeatureT getRbsLicenseFeature(int internalId) {
        Iterator iter = licenseFeatureMap.keySet().iterator();
        while (iter.hasNext()) {
            RbsLicenseFeatureT rbsLicenseFeature = (RbsLicenseFeatureT)licenseFeatureMap.get(iter.next());
            if (rbsLicenseFeature.internalID != internalId) continue;
            return rbsLicenseFeature;
        }
        return null;
    }

    public static RbsLicenseFeatureT getRbsLicenseFeature(String licFeatureName) {
        return (RbsLicenseFeatureT)licenseFeatureMap.get(licFeatureName);
    }

    public static RbsFeatureMo findGenericRbsLicenseMo(Object target, String attrName, Coordinator context) {
        if (!(target instanceof NodeBFunctionMo) && !(target instanceof RbsLocalCellMo)) {
            return null;
        }
        String tempLicenseName = null;
        String ldn = null;
        RbsLicenseFeatureT tempRbsLicenseFeature = null;
        RbsFeatureMoImpl featureMo = null;
        if (attrName.startsWith("licenseState")) {
            tempLicenseName = attrName.substring("licenseState".length());
        } else if (attrName.startsWith("featureState")) {
            tempLicenseName = attrName.substring("featureState".length());
        } else {
            return null;
        }
        tempRbsLicenseFeature = RbsGenericLicenseManager.getRbsLicenseFeature(tempLicenseName);
        if (null == tempRbsLicenseFeature) {
            return null;
        }
        if (tempRbsLicenseFeature.featureType == 0) {
            ldn = "ManagedElement=1,SystemFunctions=1,Licensing=1,RbsFeature=" + tempLicenseName;
            featureMo = (RbsFeatureMoImpl)MoRepository.instance().lookup(ldn);
            if (featureMo != null) {
                MessageLog.trace((int)2, (Class)RbsGenericLicenseManager.class, (String)"find node level RbsFeatureMo for licenseState");
                return featureMo;
            }
        } else if (attrName.startsWith("licenseState") && target instanceof NodeBFunctionMo) {
            MoIterator iter = MoRepository.instance().lookupType("RbsLocalCell");
            if (null == iter) {
                MessageLog.trace((int)2, (Class)RbsGenericLicenseManager.class, (String)"do not find any RbsLocalCell for cell level licenseState, just send get license state with cellFroId=-1");
                return new NoCellRbsFeatureMoImpl(tempRbsLicenseFeature.internalID);
            }
            if (iter.hasMoreElements()) {
                RbsLocalCellMoImpl cellmo = (RbsLocalCellMoImpl)iter.nextElement();
                ldn = "ManagedElement=1,SystemFunctions=1,Licensing=1,RbsFeature=" + cellmo.getNamingAttributeValue() + "-" + tempLicenseName;
                featureMo = (RbsFeatureMoImpl)MoRepository.instance().lookup(ldn);
                if (featureMo != null) {
                    MessageLog.trace((int)2, (Class)RbsGenericLicenseManager.class, (String)"find cell level RbsFeatureMo for licenseState");
                    return featureMo;
                }
            }
        } else if (attrName.startsWith("featureState") && target instanceof RbsLocalCellMo) {
            ldn = "ManagedElement=1,SystemFunctions=1,Licensing=1,RbsFeature=" + ((RbsLocalCellMoImpl)target).getNamingAttributeValue() + "-" + tempLicenseName;
            featureMo = (RbsFeatureMoImpl)MoRepository.instance().lookup(ldn);
            if (featureMo != null) {
                MessageLog.trace((int)2, (Class)RbsGenericLicenseManager.class, (String)"find cell level RbsFeatureMo for featureState");
                return featureMo;
            }
        } else {
            MessageLog.traceError((Class)RbsGenericLicenseManager.class, (String)("can not find any RbsFeature. There must be something wrong: attrName is " + attrName + " target is " + target.getClass().getName()));
        }
        MessageLog.traceReturn((Class)RbsGenericLicenseManager.class, (String)("did not find any RbsFeature.attrName is " + attrName + " target is " + target.getClass().getName()));
        return null;
    }

    public static void setGenericRbsLicenseState(ManagedObject mo, String attrName, Object value, Coordinator context) throws MoAccessException {
        if (attrName.startsWith("featureState")) {
            ((RbsFeatureMoImpl)mo).setFeatureState(attrName, (Integer)value, context);
        }
    }
}

