/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.common.xmlutil;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Hashtable;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.common.xmlutil.NlhFileEncryptDecryption;
import se.ericsson.wcdma.rbs.boam.common.xmlutil.SimpleXMLParser;

public class NlhFileParser {
    public static final String FILES_DOWNLOADED_SUCCESSFULLY = "FilesDownloadedSuccessfully";
    private static final String NLH_STATUS_TAG = "NlhStatus";
    private static final String NLH_STATUS_ATTR = "status";
    private static final String NLH_REVISION_TAG = "Format";
    private static final String NLH_REVISION_ATTR = "revision";
    private static final String NLH_ROLLBACK_CV_NAME_TAG = "NlRollBackCv";
    private static final String NLH_ROLLBACK_CV_NAME_ATTR = "name";
    private static final String AI_SUMMARY_FILE_TAG = "AutoIntegrationRbsSummaryFile";
    private static final String WCDMA_CONFIGURATION_FILES_TAG = "WcdmaConfigurationFiles";
    private static final String CABINET_FILE_PATH_ATTR = "cabinetEquipmentFilePath";
    private static final String OAM_FILE_PATH_ATTR = "oamAccessFilePath";
    private static final String SITE_FILE_PATH_ATTR = "siteEquipmentFilePath";
    private static final String[] REQUIRED_ELEMENTS = new String[]{"NlhStatus", "Format", "NlRollBackCv", "AutoIntegrationRbsSummaryFile"};
    private static final String[] REQUIRED_NLH_STATUS_ATTRIBUTES = new String[]{"status"};
    private static final String[] VALID_NLH_STATUS_ATTRIBUTES_VALUES = new String[]{"FilesDownloadedSuccessfully"};
    private static final String[] REQUIRED_REVISION_ATTRIBUTES = new String[]{"revision"};
    private static final String[] VALID_REVISION_ATTRIBUTES_VALUES = new String[]{"A"};
    private static final String[] REQUIRED_ROLLBACK_CV_NAME_ATTRIBUTES = new String[]{"name"};
    private static final String[] REQUIRED_AI_SUMMARY_FILE_ELEMENTS = new String[]{"WcdmaConfigurationFiles"};
    private static final String[] REQUIRED_WCDMA_CONFIG_FILES_ATTRIBUTES = new String[]{"cabinetEquipmentFilePath", "oamAccessFilePath", "siteEquipmentFilePath"};
    private SimpleXMLParser parser;
    private Hashtable nlhElements;
    private File nlhFile;

    public NlhFileParser(File nlhFile) {
        this.nlhFile = nlhFile;
        this.nlhElements = new Hashtable(9);
    }

    public boolean decryptAndParseXML(String decryptPassword) {
        boolean decryptRet = NlhFileEncryptDecryption.decryptFile(this.nlhFile.getAbsolutePath(), this.nlhFile.getAbsolutePath(), decryptPassword);
        if (decryptRet) {
            this.parser = new SimpleXMLParser(this.nlhFile);
        }
        return this.parser != null;
    }

    public void encryptNlhFile(String decryptPassword) throws GeneralSecurityException, IOException {
        NlhFileEncryptDecryption.encryptFile(this.nlhFile.getAbsolutePath(), this.nlhFile.getAbsolutePath(), decryptPassword);
    }

    public void parseAndValidate() throws NlhParserException {
        if (this.parser == null || !this.parser.run()) {
            NlhParserException ex = new NlhParserException("Couldn't parse the NlhFile: " + this.nlhFile.toString());
            MessageLog.traceError(this.getClass(), "NlhFileParser()", ex);
            throw ex;
        }
        this.nlhElements = this.parser.getElements();
        if (this.nlhElements == null || this.nlhElements.size() < REQUIRED_ELEMENTS.length) {
            NlhParserException ex = new NlhParserException("The xml file is not an NLH-file");
            MessageLog.traceError(this.getClass(), "NlhFileParser()", ex);
            throw ex;
        }
        this.checkValidityOfNlhFile();
    }

    private void checkAttributeValue(String tag, String attributeName, String[] validValues) throws NlhParserException {
        SimpleXMLParser.Element element = (SimpleXMLParser.Element)this.nlhElements.get(tag);
        String attributeValue = (String)element.attributes.get(attributeName);
        if (!Arrays.asList(validValues).contains(attributeValue)) {
            String tmpAttrValues = "";
            int length = validValues.length;
            for (int i = 0; i < length; ++i) {
                tmpAttrValues = tmpAttrValues + (i == length - 1 ? validValues[i] : validValues[i] + " or ");
            }
            NlhParserWrongAttributeValueException ex = new NlhParserWrongAttributeValueException(attributeName, attributeName + " attribute value is wrong. Value expected: " + tmpAttrValues + " but is: " + attributeValue);
            MessageLog.traceError(this.getClass(), "containsValidAttributeValue(...)", ex);
            throw ex;
        }
    }

    private void checkRequiredAttributes(String tag, String[] requiredAttributes) throws NlhParserException {
        SimpleXMLParser.Element element = (SimpleXMLParser.Element)this.nlhElements.get(tag);
        this.checkRequiredAttributes(element, requiredAttributes);
    }

    private void checkRequiredAttributes(SimpleXMLParser.Element element, String[] requiredAttributes) throws NlhParserException {
        int length = requiredAttributes.length;
        for (int i = 0; i < length; ++i) {
            if (element.attributes.containsKey(requiredAttributes[i])) continue;
            String attrNames = "";
            for (int j = 0; j < length; ++j) {
                attrNames = attrNames + (j == length - 1 ? requiredAttributes[j] : requiredAttributes[j] + ", ");
            }
            NlhParserMissingRequiredAttributeException ex = new NlhParserMissingRequiredAttributeException(attrNames, element.name + " do not have the correct attribute specified. Should at least have: " + attrNames);
            MessageLog.traceError(this.getClass(), "containsRequiredAttributes(...)", ex);
            throw ex;
        }
    }

    private void checkValidityOfNlhStatus() throws NlhParserException {
        this.checkRequiredAttributes(NLH_STATUS_TAG, REQUIRED_NLH_STATUS_ATTRIBUTES);
        this.checkAttributeValue(NLH_STATUS_TAG, NLH_STATUS_ATTR, VALID_NLH_STATUS_ATTRIBUTES_VALUES);
    }

    private void checkValidityOfRevision() throws NlhParserException {
        this.checkRequiredAttributes(NLH_REVISION_TAG, REQUIRED_REVISION_ATTRIBUTES);
        this.checkAttributeValue(NLH_REVISION_TAG, NLH_REVISION_ATTR, VALID_REVISION_ATTRIBUTES_VALUES);
    }

    private void checkValidityOfRollbackCvName() throws NlhParserException {
        this.checkRequiredAttributes(NLH_ROLLBACK_CV_NAME_TAG, REQUIRED_ROLLBACK_CV_NAME_ATTRIBUTES);
    }

    private void checkValidityOfAiSummaryFile() throws NlhParserException {
        this.checkHasAllRequiredElements(AI_SUMMARY_FILE_TAG, REQUIRED_AI_SUMMARY_FILE_ELEMENTS);
        if (this.parser == null) {
            return;
        }
        SimpleXMLParser.Element element = (SimpleXMLParser.Element)this.parser.getChildElements(AI_SUMMARY_FILE_TAG).get(WCDMA_CONFIGURATION_FILES_TAG);
        this.checkRequiredAttributes(element, REQUIRED_WCDMA_CONFIG_FILES_ATTRIBUTES);
    }

    private void checkHasAllRequiredElements(String tag, String[] requiredElements) throws NlhParserElementMissingException {
        Hashtable elements = null;
        if (tag == null) {
            elements = this.nlhElements;
        } else if (this.parser != null) {
            elements = this.parser.getChildElements(tag);
        } else {
            return;
        }
        for (int i = 0; i < requiredElements.length; ++i) {
            SimpleXMLParser.Element element = (SimpleXMLParser.Element)elements.get(requiredElements[i]);
            if (element != null) continue;
            NlhParserElementMissingException ex = new NlhParserElementMissingException(requiredElements[i], "hasAllRequiredElements(): " + requiredElements[i] + " tag seems to be missing!?");
            MessageLog.traceError(this.getClass(), "hasAllRequiredElements()", ex);
            throw ex;
        }
    }

    private void checkValidityOfNlhFile() throws NlhParserException {
        this.checkHasAllRequiredElements(null, REQUIRED_ELEMENTS);
        this.checkValidityOfNlhStatus();
        this.checkValidityOfRevision();
        this.checkValidityOfRollbackCvName();
        this.checkValidityOfAiSummaryFile();
    }

    public String getNlhStatus() {
        MessageLog.traceEnter(this.getClass(), "getNlhStatus()");
        return this.getAttribute(NLH_STATUS_TAG, NLH_STATUS_ATTR);
    }

    public String getRevision() {
        MessageLog.traceEnter(this.getClass(), "getRevision()");
        return this.getAttribute(NLH_REVISION_TAG, NLH_REVISION_ATTR);
    }

    public String getNLRollbackCvName() {
        MessageLog.traceEnter(this.getClass(), "getRollbackCvName()");
        return this.getAttribute(NLH_ROLLBACK_CV_NAME_TAG, NLH_ROLLBACK_CV_NAME_ATTR);
    }

    public String getCabinetFilePath() {
        MessageLog.traceEnter(this.getClass(), "getCabinetFilePath()");
        if (this.parser == null) {
            return "";
        }
        SimpleXMLParser.Element element = this.parser.getElement(WCDMA_CONFIGURATION_FILES_TAG);
        return this.getAttribute(element, CABINET_FILE_PATH_ATTR);
    }

    public String getOamAccessFilePath() {
        MessageLog.traceEnter(this.getClass(), "getOamAccessFilePath()");
        if (this.parser == null) {
            return "";
        }
        SimpleXMLParser.Element element = this.parser.getElement(WCDMA_CONFIGURATION_FILES_TAG);
        return this.getAttribute(element, OAM_FILE_PATH_ATTR);
    }

    public String getSiteEquipmentFilePath() {
        MessageLog.traceEnter(this.getClass(), "getSiteEquipmentFilePath()");
        if (this.parser == null) {
            return "";
        }
        SimpleXMLParser.Element element = this.parser.getElement(WCDMA_CONFIGURATION_FILES_TAG);
        return this.getAttribute(element, SITE_FILE_PATH_ATTR);
    }

    private String getAttribute(SimpleXMLParser.Element element, String attrName) {
        return element != null ? (String)element.attributes.get(attrName) : null;
    }

    private String getAttribute(String tag, String attrName) {
        SimpleXMLParser.Element element = (SimpleXMLParser.Element)this.nlhElements.get(tag);
        return this.getAttribute(element, attrName);
    }

    public static class NlhParserMissingRequiredAttributeException
    extends NlhParserException {
        private static final long serialVersionUID = 843304382782551589L;

        public NlhParserMissingRequiredAttributeException(String attribute, String message) {
            super("Missing attribute: " + attribute + ", " + message);
        }
    }

    public static class NlhParserWrongAttributeValueException
    extends NlhParserException {
        private static final long serialVersionUID = 843304382782551589L;

        public NlhParserWrongAttributeValueException(String attribute, String message) {
            super("Wrong attribute: " + attribute + ", " + message);
        }
    }

    public static class NlhParserElementMissingException
    extends NlhParserException {
        private static final long serialVersionUID = 843304382782551589L;

        public NlhParserElementMissingException(String element, String message) {
            super("Element missing: " + element + ", " + message);
        }
    }

    public static class NlhParserException
    extends Exception {
        private static final long serialVersionUID = 843304382782551589L;

        public NlhParserException(String message) {
            super(message);
        }
    }
}

