/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.common.xmlutil;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.wcdma.rbs.boam.common.RbsErrorException;
import se.ericsson.wcdma.rbs.boam.common.Strings;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.common.xmlutil.SimpleXMLParser;

public class RbsSummaryFileParsHelper {
    public static final String FORMAT_REV = "A|B|C";
    public static final String FORMAT = "Format";
    public static final String REV = "revision";
    public static final String MY_XML_FILE_TYPE = "AutoIntegrationRbsSummaryFile";
    public static final String E_CONIF_FILE = "ConfigurationFiles";
    public static final String SERVER_ADDR = "serverAddress";
    public static final String CABINET_FILE_PATH = "cabinetFilePath";
    public static final String SITE_BASIC_FILE_PATH = "siteBasicFilePath";
    public static final String EXT_HW_FILE_PATH = "externalHwFilePath";
    public static final String ANTENNA_SYSTEM_CONFIGURATION_FILE = "antennaSystemFilePath";
    private final SimpleXMLParser parser;
    private final SimpleXMLParser.Element myElements;

    public RbsSummaryFileParsHelper(File anInputFile) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "RbsSummaryFileParsHelper()<--");
        this.parser = new SimpleXMLParser(anInputFile);
        if (!this.parser.run()) {
            throw new RbsErrorException("Couldn't parse the AutoIntegrationRbsSummaryFile!!");
        }
        this.myElements = (SimpleXMLParser.Element)this.parser.getElements().get(MY_XML_FILE_TYPE);
        if (this.myElements == null) {
            String message = "Couldn't find info for AutoIntegrationRbsSummaryFile in the xml file!!";
            MessageLog.traceError(this.getClass(), "Couldn't find info for AutoIntegrationRbsSummaryFile in the xml file!!");
            throw new RbsErrorException("Couldn't find info for AutoIntegrationRbsSummaryFile in the xml file!!");
        }
        this.validateXmlFileFormat();
    }

    public String getServerAddress() throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getServerAddress()<--");
        return this.getAttributeValue(SERVER_ADDR);
    }

    public String getCabinetFilePath() throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getCabinetFilePath()<--");
        return this.getAttributeValue(CABINET_FILE_PATH);
    }

    public String getSiteBasicFilePath() throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getSiteBasicFilePath()<--");
        return this.getAttributeValue(SITE_BASIC_FILE_PATH);
    }

    public String getExternalHwFilePath() throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getExternalHwFilePath()<--");
        return this.getAttributeValue(EXT_HW_FILE_PATH);
    }

    private List getAttribute(String attr) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getAttribute()<--");
        try {
            ArrayList attrList = new ArrayList();
            this.getAttributesIter(this.myElements, attr, attrList);
            return attrList;
        }
        catch (Exception e) {
            String message = attr + " not found in the xml file!! due to exception: " + e;
            MessageLog.traceError(this.getClass(), "getAttribute(), " + attr + message);
            throw new RbsErrorException(message);
        }
    }

    private void getAttributesIter(SimpleXMLParser.Element cur, String attr, List aList) {
        if (null == cur) {
            return;
        }
        Enumeration e = cur.attributes.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = (String)cur.attributes.get(key);
            if (!key.equals(attr)) continue;
            aList.add(value);
        }
        List contentList = cur.contents;
        for (int i = 0; i < contentList.size(); ++i) {
            this.getAttributesIter(((SimpleXMLParser.Content)cur.contents.get((int)i)).element, attr, aList);
        }
    }

    private void validateXmlFileFormat() throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "validateXmlFileFormat()");
        String revision = this.getXmlFileFormatRev();
        String[] revString = Strings.split(FORMAT_REV, "|");
        boolean match = false;
        for (int i = 0; i < revString.length; ++i) {
            if (!revString[i].equalsIgnoreCase(revision)) continue;
            match = true;
            break;
        }
        if (!match) {
            String message = "The Format revision of the xml file is not supported!! Expected Rev:A|B|C, AutoIntegrationRbsSummaryFile, received file revision: " + (revision == null ? "null" : revision);
            MessageLog.traceError(this.getClass(), "validateXmlFileFormat(), " + message);
            throw new RbsErrorException(message);
        }
    }

    private String getXmlFileFormatRev() throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "validateXmlFileFormat()");
        if (this.myElements == null) {
            String message = "No revision information is found in the Xml file!! Check the xml file for the given type: AutoIntegrationRbsSummaryFile";
            MessageLog.traceError(this.getClass(), "getXmlFileFormatRev(), No revision information is found in the Xml file!! Check the xml file for the given type: AutoIntegrationRbsSummaryFile");
            throw new RbsErrorException("No revision information is found in the Xml file!! Check the xml file for the given type: AutoIntegrationRbsSummaryFile");
        }
        return (String)this.getAttribute(REV).get(0);
    }

    public List getAntennaSystemConfigurationFileName() throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getAntennaSystemConfigurationFileName()<--");
        return this.getAttribute(ANTENNA_SYSTEM_CONFIGURATION_FILE);
    }

    private String getAttributeValue(String attributeName) throws MoAccessException {
        List list = this.getAttribute(attributeName);
        if (list.size() > 0) {
            return (String)list.get(0);
        }
        return "";
    }
}

