/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.fpx.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import se.ericsson.wcdma.rbs.boam.fpx.common.PmCounterItemS;
import se.ericsson.wcdma.rbs.boam.fpx.common.PmCounterTable;

public abstract class PmCounterTableManager {
    private static HashMap counterMap = PmCounterTable.counterMap;

    public static String getCounterNameFromCounterId(int counterId) {
        return ((PmCounterItemS)PmCounterTableManager.counterMap.get((Object)new Integer((int)counterId))).counterName;
    }

    public static int getCounterIdFromCounterName(String counterName) {
        Iterator iter = counterMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String tmpCounterName = ((PmCounterItemS)entry.getValue()).counterName;
            if (!tmpCounterName.equals(counterName)) continue;
            return (Integer)entry.getKey();
        }
        return -1;
    }

    public static int getCounterSizeFromCounterName(String counterName) {
        Iterator iter = counterMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!((PmCounterItemS)entry.getValue()).counterName.equals(counterName)) continue;
            return ((PmCounterItemS)entry.getValue()).counterSize;
        }
        return -1;
    }

    public static List getCountersInMeasurementGroup(int measType) {
        ArrayList<PmCounterItemS> result2 = new ArrayList<PmCounterItemS>();
        Iterator iter = counterMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            PmCounterItemS pmCntIterm = (PmCounterItemS)entry.getValue();
            if (pmCntIterm.measurementType != measType) continue;
            Iterator resIter = result2.iterator();
            boolean isNewItem = true;
            while (resIter.hasNext()) {
                PmCounterItemS existingItem = (PmCounterItemS)resIter.next();
                if (!pmCntIterm.counterName.equals(existingItem.counterName) || pmCntIterm.momTypeName.equals(existingItem.momTypeName)) continue;
                isNewItem = false;
                break;
            }
            if (!isNewItem) continue;
            result2.add(pmCntIterm);
        }
        return PmCounterTableManager.sortCounters(result2);
    }

    private static List sortCounters(List counters) {
        ArrayList<PmCounterItemS> result2 = new ArrayList<PmCounterItemS>();
        for (int i = 0; i < counters.size(); ++i) {
            for (int j = i + 1; j < counters.size(); ++j) {
                Object A = counters.get(i);
                Object B = counters.get(j);
                if (((PmCounterItemS)A).counterId <= ((PmCounterItemS)B).counterId) continue;
                Object C = B;
                counters.set(j, A);
                counters.set(i, C);
            }
            result2.add((PmCounterItemS)counters.get(i));
        }
        return result2;
    }

    public static int getCounterGroupSize(int measurementType) {
        int length = 0;
        List couterGroupList = PmCounterTableManager.getCountersInMeasurementGroup(measurementType);
        for (int i = 0; i < couterGroupList.size(); ++i) {
            length += ((PmCounterItemS)couterGroupList.get((int)i)).counterSize;
        }
        return length;
    }

    public static Map getAllCountersInMO(String typeName) {
        String tmpMomName = null;
        int tmpMeasType = -1;
        HashMap result2 = new HashMap();
        Iterator iter = counterMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            tmpMomName = ((PmCounterItemS)entry.getValue()).momTypeName;
            tmpMeasType = ((PmCounterItemS)entry.getValue()).measurementType;
            if (!tmpMomName.equals(typeName)) continue;
            if (result2.containsKey(new Integer(tmpMeasType))) {
                List tmp = (List)result2.get(new Integer(tmpMeasType));
                tmp.add((PmCounterItemS)entry.getValue());
                continue;
            }
            ArrayList<PmCounterItemS> tmpGroupCounterList = new ArrayList<PmCounterItemS>();
            tmpGroupCounterList.add((PmCounterItemS)entry.getValue());
            result2.put(new Integer(tmpMeasType), tmpGroupCounterList);
        }
        return result2;
    }

    public static boolean isInPmCounterTable(String groupName) {
        int tmpMeasType = -1;
        Iterator iter = counterMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            tmpMeasType = ((PmCounterItemS)entry.getValue()).measurementType;
            if (!groupName.equals(String.valueOf(tmpMeasType))) continue;
            return true;
        }
        return false;
    }
}

