/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies;

import se.ericsson.wcdma.rbs.boam.common.FroNotAccessibleException;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EcGenericProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EcSubscSyncResAvcReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EcSubscSyncResAvcRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EcSyncResAvcIndS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsCreateNodeSyncTpReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsCreateNodeSyncTpRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsCreateSyncResReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsCreateSyncResRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsDeleteNodeSyncTpReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsDeleteNodeSyncTpRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsDeleteSyncResReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsDeleteSyncResRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsGetNodeSyncTpParamReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsGetNodeSyncTpParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsGetSyncResParamReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsGetSyncResParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsSubscSyncResEventReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsSubscSyncResEventRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsSubscSyncResReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsSubscSyncResRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsSwitchSyncResReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsSwitchSyncResRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsSyncResEventIndS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsSyncResFaultIndS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsSyncResFaultceaseIndS;

public class EcTimingProxy
extends EcGenericProxy {
    public static final int SYNC_RES_REG_FOR_NOTIF_ID = -1;
    private static EcTimingProxy theOneAndOnly = null;
    private static final String SERVICE_NAME = "EqcBdhBoardDeviceHandler";

    private EcTimingProxy() {
        super(SERVICE_NAME);
        this.addSignalObservers();
        MessageLog.traceEnter(this.getClass(), "Constructor");
    }

    public static synchronized EcTimingProxy instance() {
        if (theOneAndOnly == null) {
            theOneAndOnly = new EcTimingProxy();
        }
        return theOneAndOnly;
    }

    public void addSignalObservers() {
        MessageLog.traceEnter(this.getClass(), "addSignalObservers()");
        this.boamSignalPort.addSignalObserver(this, LrsSyncResFaultIndS.class);
        this.boamSignalPort.addSignalObserver(this, LrsSyncResFaultceaseIndS.class);
        this.boamSignalPort.addSignalObserver(this, LrsSyncResEventIndS.class);
        this.boamSignalPort.addSignalObserver(this, EcSyncResAvcIndS.class);
        MessageLog.trace(7, this.getClass(), " addSignalObservers() executed ");
    }

    public LrsCreateSyncResRspS createSyncRes(int transactionId, int clientId, int timingId) throws FroRequestFailedException, FroNotAccessibleException {
        LrsCreateSyncResReqS reqSig = new LrsCreateSyncResReqS(transactionId, clientId, timingId);
        return (LrsCreateSyncResRspS)this.sendAndRec(reqSig);
    }

    public LrsDeleteSyncResRspS deleteSyncRes(int transactionId, int clientId, int syncResId) throws FroRequestFailedException, FroNotAccessibleException {
        LrsDeleteSyncResReqS reqSig = new LrsDeleteSyncResReqS(transactionId, clientId, syncResId);
        return (LrsDeleteSyncResRspS)this.sendAndRec(reqSig);
    }

    public LrsGetSyncResParamRspS getSyncResParam(int clientId, int transactionId, int syncResId) throws FroRequestFailedException, FroNotAccessibleException {
        LrsGetSyncResParamReqS reqSig = new LrsGetSyncResParamReqS(clientId, transactionId, syncResId);
        return (LrsGetSyncResParamRspS)this.sendAndRec(reqSig);
    }

    public LrsCreateNodeSyncTpRspS createNodeSyncTp(int transactionId, int clientId, int syncResId, long numOfValidAal0CepFroId, long aal0CepFroId1, long aal0CepFroId2, long aal0CepFroId3, long aal0CepFroId4) throws FroRequestFailedException, FroNotAccessibleException {
        LrsCreateNodeSyncTpReqS reqSig = new LrsCreateNodeSyncTpReqS(transactionId, clientId, syncResId, numOfValidAal0CepFroId, aal0CepFroId1, aal0CepFroId2, aal0CepFroId3, aal0CepFroId4);
        return (LrsCreateNodeSyncTpRspS)this.sendAndRec(reqSig);
    }

    public LrsDeleteNodeSyncTpRspS deleteNodeSyncTp(int transactionId, int clientId, int nodeSyncTpId) throws FroRequestFailedException, FroNotAccessibleException {
        LrsDeleteNodeSyncTpReqS reqSig = new LrsDeleteNodeSyncTpReqS(transactionId, clientId, nodeSyncTpId);
        return (LrsDeleteNodeSyncTpRspS)this.sendAndRec(reqSig);
    }

    public LrsGetNodeSyncTpParamRspS getNodeSyncTpParam(int clientId, int transactionId, int nodeSyncTpId) throws FroRequestFailedException, FroNotAccessibleException {
        LrsGetNodeSyncTpParamReqS reqSig = new LrsGetNodeSyncTpParamReqS(clientId, transactionId, nodeSyncTpId);
        return (LrsGetNodeSyncTpParamRspS)this.sendAndRec(reqSig);
    }

    private EcSubscSyncResAvcRspS subscSyncResAvcRspS(int clientId, int subscribeOperation) throws FroRequestFailedException, FroNotAccessibleException {
        EcSubscSyncResAvcReqS reqSig = new EcSubscSyncResAvcReqS(clientId, subscribeOperation, this.signalPort.getServiceName());
        return (EcSubscSyncResAvcRspS)this.sendAndRec(reqSig);
    }

    private LrsSubscSyncResRspS subscribeSyncRes(int clientId, int subscribeOperation) throws FroRequestFailedException, FroNotAccessibleException {
        LrsSubscSyncResReqS reqSig = new LrsSubscSyncResReqS(clientId, subscribeOperation, this.signalPort.getServiceName());
        return (LrsSubscSyncResRspS)this.sendAndRec(reqSig);
    }

    private LrsSubscSyncResEventRspS subscribeSyncResEvent(int clientId, int subscribeOperation) throws FroRequestFailedException, FroNotAccessibleException {
        LrsSubscSyncResEventReqS reqSig = new LrsSubscSyncResEventReqS(clientId, subscribeOperation, this.signalPort.getServiceName());
        return (LrsSubscSyncResEventRspS)this.sendAndRec(reqSig);
    }

    public LrsSwitchSyncResRspS switchSyncRes(int clientId) throws FroRequestFailedException, FroNotAccessibleException {
        LrsSwitchSyncResReqS reqSig = new LrsSwitchSyncResReqS(clientId);
        return (LrsSwitchSyncResRspS)this.sendAndRec(reqSig);
    }

    public void subscribeToFroNotification() {
        MessageLog.traceEnter(this.getClass(), "subscribeToFroNotification");
        try {
            this.subscribeSyncResEvent(1, 0);
            this.subscribeSyncRes(1, 0);
            this.subscSyncResAvcRspS(1, 0);
        }
        catch (FroRequestFailedException e) {
            MessageLog.traceError(this.getClass(), "Received result NOK from resource when subscribing to the notifications" + (Object)((Object)e));
        }
        catch (FroNotAccessibleException e) {
            MessageLog.traceError(this.getClass(), "Received result NOK from resource when subscribing to the notifications" + (Object)((Object)e));
        }
        MessageLog.trace(7, this.getClass(), "subscribeToFroService(), successfull subscribtion to service name = : EqcBdhBoardDeviceHandler");
    }

    public String getErrorCodeServiceName() {
        return "lrsTsTimingManager";
    }
}

