/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs;

import enea.ose.io.SignalInputStream;
import enea.ose.io.SignalOutputStream;
import enea.ose.system.UnlinkedSignal;
import java.io.IOException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.wcdma.rbs.boam.common.Strings;

public class EcAntennaDeviceScanReqS
extends UnlinkedSignal {
    public static final int SIG_NO = 16816504;
    public long clientId;
    public int dataRate;
    public String server;
    public String path;
    public String username;
    public String password;
    public String additionalInfo;

    public EcAntennaDeviceScanReqS() {
        super(16816504);
        this.server = "";
        this.path = "";
        this.username = "";
        this.password = "";
    }

    public EcAntennaDeviceScanReqS(long clientId, int dataRate, String server, String path, String username, String password, String additionalInfo) {
        super(16816504);
        this.clientId = clientId;
        this.dataRate = dataRate;
        this.server = server;
        this.path = path;
        this.username = username;
        this.password = password;
        this.additionalInfo = additionalInfo;
    }

    public void initReceive() {
        SignalInputStream in = this.getSignalInputStream();
        try {
            this.clientId = in.readU32();
            this.dataRate = in.readS32();
            this.server = Strings.toString(in.readS8Array(256));
            this.path = Strings.toString(in.readS8Array(256));
            this.username = Strings.toString(in.readS8Array(256));
            this.password = Strings.toString(in.readS8Array(256));
            this.additionalInfo = in.readString();
        }
        catch (IOException e) {
            MessageLog.traceError(((Object)((Object)this)).getClass(), (String)("initReceive failed in EcAntennaDeviceScanReqS: " + e));
        }
    }

    public void initSend() {
        SignalOutputStream out = this.getSignalOutputStream();
        try {
            out.writeU32(this.clientId);
            out.writeS32(this.dataRate);
            out.writeS8Array(Strings.getBytes(this.server, 256));
            out.writeS8Array(Strings.getBytes(this.path, 256));
            out.writeS8Array(Strings.getBytes(this.username, 256));
            out.writeS8Array(Strings.getBytes(this.password, 256));
            out.writeString(this.additionalInfo);
        }
        catch (IOException e) {
            MessageLog.traceError(((Object)((Object)this)).getClass(), (String)("initSend failed in EcAntennaDeviceScanReqS: " + e));
        }
    }
}

