/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.fpx.scmi.proxies;

import java.util.ArrayList;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.wcdma.rbs.boam.common.FroNotAccessibleException;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.RbsErrorException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcAntennaBranchProxy;
import se.ericsson.wcdma.rbs.boam.fpx.proxies.ScannedValue;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.proxies.ScGenericProxy;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsCreateRfapReqS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsCreateRfapRspS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsDeleteRfapReqS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsDeleteRfapRspS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsInitRfapReqS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsInitRfapRspS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsInitSectorGetParamReqS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsInitSectorGetParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsRetGetParamReqS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsRetGetParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsRfapCalibrateRetReqS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsRfapCalibrateRetRspS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsRfapCreateAbReqS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsRfapCreateAbRspS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsRfapCreateRetprofileReqS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsRfapCreateRetprofileRspS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsRfapDeleteAbReqS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsRfapDeleteAbRspS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsRfapDeleteRetprofileReqS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsRfapDeleteRetprofileRspS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsRfapGetParamAbReqS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsRfapGetParamAbRspS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsRfapGetPmSlotReqS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsRfapGetPmSlotRspS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsRfapGetRetprofileReqS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsRfapGetRetprofileRspS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsRfapRetFaultCeaseIndS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsRfapRetFaultIndS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsRfapSectorFaultIndS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsRfapSectorFaultceaseIndS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsRfapSetAntennaSupReqS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsRfapSetAntennaSupRspS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsRfapSetFqbandReqS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsRfapSetFqbandRspS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsRfapSetMaxUlGainReqS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsRfapSetMaxUlGainRspS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsRfapSetMmrReqS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsRfapSetMmrRspS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsRfapStartPmReqS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsRfapStartPmRspS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsRfapStopPmReqS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsRfapStopPmRspS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsSectorGetParamReqS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsSectorGetParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsSubscFmRfapRetReqS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsSubscFmRfapRetRspS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsSubscFmRfapSectorReqS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsSubscFmRfapSectorRspS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsUninitRfapReqS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsUninitRfapRspS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.SccFaultCeaseIndS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.SccFaultIndS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.SccRetAntennaConfigFileReqS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.SccRetAntennaConfigFileRspS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.SccSubscAvcRetReqS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.SccSubscAvcRetRspS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.SccWiltCellsReqS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.SccWiltCellsRspS;
import se.ericsson.wcdma.rbs.boam.pms.iface.ProxyScanner;

public class ScRfAccessProxy
extends ScGenericProxy
implements ProxyScanner {
    private static ScRfAccessProxy theOneAndOnly = null;
    public static final String SERVICE_NAME = "lrsRcRfAccessResMgr";
    private static int CLIENT_ID = 0;
    private int clientID = 0;

    private ScRfAccessProxy() {
        super(SERVICE_NAME);
        MessageLog.traceEnter(this.getClass(), "Constructor");
        this.boamSignalPort.addSignalObserver(this, LrsRfapSectorFaultIndS.class);
        this.boamSignalPort.addSignalObserver(this, LrsRfapSectorFaultceaseIndS.class);
        this.boamSignalPort.addSignalObserver(this, LrsRfapRetFaultIndS.class);
        this.boamSignalPort.addSignalObserver(this, LrsRfapRetFaultCeaseIndS.class);
        this.boamSignalPort.addSignalObserver(this, SccFaultIndS.class);
        this.boamSignalPort.addSignalObserver(this, SccFaultCeaseIndS.class);
    }

    public void pmsStart(String name, int granularityPeriod, int froId, int bbPoolId, int[] additionalInfo) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "pmsStart():" + name);
        int ab = (int)EqcAntennaBranchProxy.instance().getAbParam((int)0, (int)0, (int)additionalInfo[0]).branchName;
        this.rfapStartPm(this.clientID, this.getMeasType(name), froId, ab, granularityPeriod);
    }

    public void pmsStop(String name, int froId, int bbPoolId, int[] additionalInfo) throws MoAccessException {
        int antennaBranchId = (int)EqcAntennaBranchProxy.instance().getAbParam((int)0, (int)0, (int)additionalInfo[0]).branchName;
        this.rfapStopPm(this.clientID, this.getMeasType(name), froId, antennaBranchId);
    }

    public ScannedValue[] getPmsAttribute(String name, int froId, int bbPoolId, int[] additionalInfo) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getPmsAttribute():" + name);
        ArrayList<ScannedValue> result2 = new ArrayList<ScannedValue>();
        if (!name.equals("pmNoOfPowLimSlots")) {
            MessageLog.traceError(this.getClass(), "No such a PM counters " + name);
            throw new RbsErrorException("getPmsAttribute():No such a PM counter " + name);
        }
        int antennaBranchId = (int)EqcAntennaBranchProxy.instance().getAbParam((int)0, (int)0, (int)additionalInfo[0]).branchName;
        LrsRfapGetPmSlotRspS rspSig = this.rfapGetPmSlot(this.clientID, froId, antennaBranchId);
        ScannedValue aValue = new ScannedValue("pmNoOfPowLimSlots", new int[]{rspSig.noOfPowLimSlots});
        result2.add(aValue);
        return result2.toArray(new ScannedValue[result2.size()]);
    }

    public static synchronized ScRfAccessProxy instance() {
        if (theOneAndOnly == null) {
            theOneAndOnly = new ScRfAccessProxy();
        }
        return theOneAndOnly;
    }

    public LrsCreateRfapRspS createRfap(int transactionId, int clientId, int sectorFroId, int maxInternalUlGainOn, int mixedModeRadio, String sectorRdn) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "createRfap()");
        LrsCreateRfapReqS reqSig = new LrsCreateRfapReqS(transactionId, clientId, sectorFroId, maxInternalUlGainOn, mixedModeRadio, sectorRdn);
        return (LrsCreateRfapRspS)this.sendAndRec(reqSig);
    }

    public LrsInitRfapRspS initRfap(int transactionId, int clientId, int rfAccessPointFroId, int band, int tmaProperties, int mixedModeRadio) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "initRfap()");
        LrsInitRfapReqS reqSig = new LrsInitRfapReqS(transactionId, clientId, rfAccessPointFroId, band, tmaProperties, mixedModeRadio);
        return (LrsInitRfapRspS)this.sendAndRec(reqSig);
    }

    public SccWiltCellsRspS startWiltCells() throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "startWiltCells()");
        SccWiltCellsReqS reqSig = new SccWiltCellsReqS(CLIENT_ID, this.signalPort.getServiceName());
        return (SccWiltCellsRspS)this.sendAndRec(reqSig);
    }

    public LrsDeleteRfapRspS deleteRfap(int transactionId, int clientId, int rfAccessPointFroId) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "deleteRfap()");
        LrsDeleteRfapReqS reqSig = new LrsDeleteRfapReqS(transactionId, clientId, rfAccessPointFroId);
        return (LrsDeleteRfapRspS)this.sendAndRec(reqSig);
    }

    public LrsRfapSetAntennaSupRspS rfapSetAntennaSup(int transactionId, int clientId, int rfAccessPointFroId, int antennaBranch, int antennaSupervisionThreshold) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "rfapSetAntennaSup()");
        LrsRfapSetAntennaSupReqS reqSig = new LrsRfapSetAntennaSupReqS(transactionId, clientId, rfAccessPointFroId, antennaBranch, antennaSupervisionThreshold);
        return (LrsRfapSetAntennaSupRspS)this.sendAndRec(reqSig);
    }

    public LrsRfapSetMaxUlGainRspS rfapSetSetMaxUlGain(int transactionId, int clientId, int rfAccessPointFroId, int maxInternalUlGainOn) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "rfapSetSetMaxUlGain()");
        LrsRfapSetMaxUlGainReqS reqSig = new LrsRfapSetMaxUlGainReqS(transactionId, clientId, rfAccessPointFroId, maxInternalUlGainOn);
        return (LrsRfapSetMaxUlGainRspS)this.sendAndRec(reqSig);
    }

    public LrsRfapSetMmrRspS rfapSetMixedModeRadio(int transactionId, int clientId, int rfAccessPointFroId, int mixedModeRadio) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "rfapSetMixedModeRadio()");
        LrsRfapSetMmrReqS reqSig = new LrsRfapSetMmrReqS(transactionId, clientId, rfAccessPointFroId, mixedModeRadio);
        return (LrsRfapSetMmrRspS)this.sendAndRec(reqSig);
    }

    public LrsUninitRfapRspS uninitRfap(int transactionId, int clientId, int rfAccessPointFroId) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "uninitRfap()");
        LrsUninitRfapReqS reqSig = new LrsUninitRfapReqS(transactionId, clientId, rfAccessPointFroId);
        return (LrsUninitRfapRspS)this.sendAndRec(reqSig);
    }

    public LrsRfapStartPmRspS rfapStartPm(int clientId, int measType, int rfAccessPointFroId, int antennaBranchId, int granularityPeriod) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "rfapStartPm()");
        LrsRfapStartPmReqS reqSig = new LrsRfapStartPmReqS(clientId, measType, rfAccessPointFroId, antennaBranchId, granularityPeriod);
        return (LrsRfapStartPmRspS)this.sendAndRec(reqSig);
    }

    public LrsRfapStopPmRspS rfapStopPm(int clientId, int measType, int rfAccessPointFroId, int antennaBranchId) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "rfapStopPm()");
        LrsRfapStopPmReqS reqSig = new LrsRfapStopPmReqS(clientId, measType, rfAccessPointFroId, antennaBranchId);
        return (LrsRfapStopPmRspS)this.sendAndRec(reqSig);
    }

    public LrsRfapGetPmSlotRspS rfapGetPmSlot(int clientId, int rfAccessPointFroId, int antennaBranchId) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "rfapGetPmSlot()");
        LrsRfapGetPmSlotReqS reqSig = new LrsRfapGetPmSlotReqS(clientId, rfAccessPointFroId, antennaBranchId);
        return (LrsRfapGetPmSlotRspS)this.sendAndRec(reqSig);
    }

    public LrsInitSectorGetParamRspS initSectorGetParam(int transactionId, int clientId, int rfAccessPointFroId) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "initSectorGetParam()");
        LrsInitSectorGetParamReqS reqSig = new LrsInitSectorGetParamReqS(clientId, transactionId, rfAccessPointFroId);
        return (LrsInitSectorGetParamRspS)this.sendAndRec(reqSig);
    }

    public LrsSectorGetParamRspS sectorGetParam(int transactionId, int clientId, int rfAccessPointFroId) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "sectorGetParam()");
        LrsSectorGetParamReqS reqSig = new LrsSectorGetParamReqS(clientId, transactionId, rfAccessPointFroId);
        return (LrsSectorGetParamRspS)this.sendAndRec(reqSig);
    }

    public LrsRfapGetParamAbRspS rfapGetParamAb(int transactionId, int clientId, int rfAccessPointFroId) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "rfapGetParamAb()");
        LrsRfapGetParamAbReqS reqSig = new LrsRfapGetParamAbReqS(clientId, transactionId, rfAccessPointFroId);
        return (LrsRfapGetParamAbRspS)this.sendAndRec(reqSig);
    }

    public LrsRetGetParamRspS retGetParam(int clientId, int rfAccessPointFroId, int retDeviceFroId) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "retGetParam()");
        LrsRetGetParamReqS reqSig = new LrsRetGetParamReqS(clientId, rfAccessPointFroId, retDeviceFroId);
        return (LrsRetGetParamRspS)this.sendAndRec(reqSig);
    }

    public SccRetAntennaConfigFileRspS sendAretAntennaConfigFile(int client_id, int rfAccessPointFroId, int retDeviceFroId, String aretFilePath, String aretFileName) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "sendAretAntennaConfigFile().");
        SccRetAntennaConfigFileReqS reqSig = new SccRetAntennaConfigFileReqS(client_id, rfAccessPointFroId, retDeviceFroId, aretFilePath, aretFileName);
        return (SccRetAntennaConfigFileRspS)this.sendAndRec(reqSig);
    }

    private SccSubscAvcRetRspS subSccSubscAvcRet(int clientId, int subscribeOperation) throws FroRequestFailedException, FroNotAccessibleException {
        SccSubscAvcRetReqS reqSig = new SccSubscAvcRetReqS(clientId, subscribeOperation, this.signalPort.getServiceName());
        return (SccSubscAvcRetRspS)this.sendAndRec(reqSig);
    }

    private LrsSubscFmRfapSectorRspS subscFmRfapSector(int clientId, int subscribeOperation) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "subscFmRfapSector()");
        LrsSubscFmRfapSectorReqS reqSig = new LrsSubscFmRfapSectorReqS(clientId, subscribeOperation, this.signalPort.getServiceName());
        return (LrsSubscFmRfapSectorRspS)this.sendAndRec(reqSig);
    }

    private LrsSubscFmRfapRetRspS subscFmRfapRet(int clientId, int subscribeOperation) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "subscFmRfapRet()");
        LrsSubscFmRfapRetReqS reqSig = new LrsSubscFmRfapRetReqS(clientId, subscribeOperation, this.signalPort.getServiceName());
        return (LrsSubscFmRfapRetRspS)this.sendAndRec(reqSig);
    }

    public LrsRfapCalibrateRetRspS rfapCalibrateRet(int transactionId, int clientId, int rfAccessPointFroId, int retDeviceFroId) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "rfapCalibrateRet()");
        LrsRfapCalibrateRetReqS reqSig = new LrsRfapCalibrateRetReqS(transactionId, clientId, rfAccessPointFroId, retDeviceFroId);
        return (LrsRfapCalibrateRetRspS)this.sendAndRec(reqSig);
    }

    public LrsRfapCreateRetprofileRspS rfapCreateRetProfile(int transactionId, int clientId, int retType, int antennaType, int minTilt, int maxTilt, int retParam1, int retParam2, int retParam3, int retParam4, int retParam5, int retParam6, int retParam7, int retParam8, int checkSum) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "rfapCreateRetProfile()");
        LrsRfapCreateRetprofileReqS reqSig = new LrsRfapCreateRetprofileReqS(transactionId, clientId, retType, antennaType, minTilt, maxTilt, retParam1, retParam2, retParam3, retParam4, retParam5, retParam6, retParam7, retParam8, checkSum);
        return (LrsRfapCreateRetprofileRspS)this.sendAndRec(reqSig);
    }

    public LrsRfapDeleteRetprofileRspS rfapDeleteRetProfile(int transactionId, int clientId, int retType, int antennaType) throws MoAccessException {
        boolean shouldLoop = true;
        int noOfAttempts = 0;
        MessageLog.traceEnter(this.getClass(), "rfapDeleteRetProfile()");
        LrsRfapDeleteRetprofileRspS rspSig = null;
        LrsRfapDeleteRetprofileReqS reqSig = new LrsRfapDeleteRetprofileReqS(transactionId, clientId, retType, antennaType);
        while (shouldLoop) {
            try {
                rspSig = (LrsRfapDeleteRetprofileRspS)this.sendAndRec(reqSig);
                shouldLoop = false;
            }
            catch (FroRequestFailedException e) {
                if (e.getOrgErrorCode() == 8 && noOfAttempts < 2) {
                    MessageLog.info(this.getClass(), "Got \"Ret Profile is used\" from Scc, waiting 30 seconds for next attempt");
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException e2) {
                        MessageLog.info(this.getClass(), "Got interrupted exception while waiting to send LrsRfapDeleteRetProfile");
                        shouldLoop = false;
                    }
                }
                throw e;
            }
            ++noOfAttempts;
        }
        return rspSig;
    }

    public LrsRfapGetRetprofileRspS rfapGetRetProfile(int transactionId, int clientId, int retType, int antennaType) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "rfapGetretprofile()");
        LrsRfapGetRetprofileReqS reqSig = new LrsRfapGetRetprofileReqS(transactionId, clientId, retType, antennaType);
        return (LrsRfapGetRetprofileRspS)this.sendAndRec(reqSig);
    }

    public LrsRfapSetFqbandRspS rfapSetFqband(int transactionId, int clientId, int rfAccessPointFroId, int antennaBranch, int fqBandLowEdge, int fqBandHighEdge) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "rfapSetFqband()");
        LrsRfapSetFqbandReqS reqSig = new LrsRfapSetFqbandReqS(transactionId, clientId, rfAccessPointFroId, antennaBranch, fqBandLowEdge, fqBandHighEdge);
        return (LrsRfapSetFqbandRspS)this.sendAndRec(reqSig);
    }

    public LrsRfapCreateAbRspS rfapCreateAb(int transactionId, int clientId, int rfAccessPointFroId, int antennaBranch, int antennaSupervisionThreshold, int antennaType, int fqBandHighEdge, int fqBandLowEdge) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "rfapCreateAb()");
        LrsRfapCreateAbReqS reqSig = new LrsRfapCreateAbReqS(transactionId, clientId, rfAccessPointFroId, antennaBranch, antennaSupervisionThreshold, fqBandHighEdge, fqBandLowEdge);
        return (LrsRfapCreateAbRspS)this.sendAndRec(reqSig);
    }

    public LrsRfapDeleteAbRspS rfapDeleteAb(int transactionId, int clientId, int rfAccessPointFroId, int antennaBranch) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "rfapDeleteAb()");
        LrsRfapDeleteAbReqS reqSig = new LrsRfapDeleteAbReqS(transactionId, clientId, rfAccessPointFroId, antennaBranch);
        return (LrsRfapDeleteAbRspS)this.sendAndRec(reqSig);
    }

    private int getMeasType(String cntName) throws MoAccessException {
        int measType = 0;
        if (!cntName.equals("pmNoOfPowLimSlots")) {
            MessageLog.traceError(this.getClass(), "No such a PM counters " + cntName);
            throw new RbsErrorException("getMeasType():No such a PM counter " + cntName);
        }
        measType = 0;
        return measType;
    }

    public void subscribeToFroNotification() {
        try {
            this.subscFmRfapSector(CLIENT_ID, 0);
        }
        catch (FroRequestFailedException e) {
            MessageLog.traceError(this.getClass(), "Received result NOK from resource when subscribing to the notifications" + (Object)((Object)e));
        }
        catch (FroNotAccessibleException e) {
            MessageLog.traceError(this.getClass(), "Received result NOK from resource when subscribing to the notifications" + (Object)((Object)e));
        }
        try {
            this.subscFmRfapRet(CLIENT_ID, 0);
        }
        catch (FroRequestFailedException e) {
            MessageLog.traceParam(this.getClass(), "FroRequestFailedException caught. The error message is " + e.getMessage());
        }
        catch (FroNotAccessibleException e) {
            MessageLog.traceParam(this.getClass(), "FroNotAccessibleException caught. The error message is " + e.getMessage());
        }
        try {
            this.subSccSubscAvcRet(CLIENT_ID, 0);
        }
        catch (FroRequestFailedException e) {
            MessageLog.traceError(this.getClass(), "Received result NOK from resource when subscribing to the notifications" + (Object)((Object)e));
        }
        catch (FroNotAccessibleException e) {
            MessageLog.traceError(this.getClass(), "Received result NOK from resource when subscribing to the notifications" + (Object)((Object)e));
        }
    }
}

