/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.auxpiu;

import java.util.ArrayList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFilter;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.MoTypeFilter;
import se.ericsson.cello.moframework.SoftwareErrorException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.swmanagement.PiuTypeMo;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcAuxPiuProxy;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.auxpiu.AuxPlugInUnitUpgradeHelper;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AuxPlugInUnitMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.XpProgramMo;

public class AuxPiuSwUpgradeHandler {
    private static final EqcAuxPiuProxy eqcAuxPiuProxy = EqcAuxPiuProxy.instance();
    private AuxPlugInUnitMo auxPiu;

    public AuxPiuSwUpgradeHandler(AuxPlugInUnitMo mo) {
        this.auxPiu = mo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reconfigureProgramPrepare(Coordinator c) throws MoAccessException {
        ManagedObject newLoadModule;
        ManagedObject newpiu;
        String boardPRev;
        String boardPNum;
        ManagedObject curLoadModule;
        block18: {
            ManagedObject piu;
            block15: {
                block16: {
                    block17: {
                        MessageLog.traceEnter(this.getClass(), "reconfigureProgramPrepare()<---");
                        piu = this.auxPiu.getPiuType(c);
                        curLoadModule = AuxPlugInUnitUpgradeHelper.getCurrentLoadModule(this.auxPiu, c);
                        Struct curPidData = ((PiuTypeMo)piu).getProductData(c);
                        String curPiuPNum = (String)curPidData.getValue("productNumber");
                        String curPiuPRev = (String)curPidData.getValue("productRevision");
                        boardPNum = curPiuPNum;
                        boardPRev = curPiuPRev;
                        if (this.auxPiu.getOperationalState(c) != 1 || this.auxPiu.getAdministrativeState(c) != 1) break block15;
                        MessageLog.info(this.getClass(), "reconfigureProgramPrepare() : OperState = ENABLED and AdmState = UNLOCKED");
                        boardPNum = this.auxPiu.getProductNumber(c);
                        boardPRev = this.auxPiu.getProductRevision(c);
                        if (boardPNum.equals("") || boardPRev.equals("")) break block16;
                        if (curPiuPNum.equalsIgnoreCase(boardPNum) || curPiuPRev.equalsIgnoreCase(boardPRev)) break block17;
                        newpiu = AuxPlugInUnitUpgradeHelper.fetchNewPiuType(this.auxPiu, boardPNum, boardPRev, c);
                        if (newpiu != null) {
                            ManagedObject newRepertoire = AuxPlugInUnitUpgradeHelper.getNewRepertoire(this.auxPiu, newpiu, c);
                            if (newRepertoire == null) {
                                this.auxPiu.generateInternalAlarm(null);
                                try {
                                    c.rollbackOnly();
                                }
                                catch (InactiveTransactionException e) {
                                    // empty catch block
                                }
                                MessageLog.info(this.getClass(), "No repertoire is found for PiuType: " + newpiu.getLocalDistinguishedName() + ",  ReconfigureProgramPrepare closed without creating any new Xp Pgm!!");
                                return;
                            }
                            newLoadModule = AuxPlugInUnitUpgradeHelper.getNewLoadModule(newpiu, newRepertoire, c);
                            break block18;
                        } else {
                            if (AuxPlugInUnitUpgradeHelper.isGenericPiuType((PiuTypeMo)piu, c) && AuxPlugInUnitUpgradeHelper.isGenericPiuTypeInRepertoire((PiuTypeMo)piu, this.auxPiu, c)) {
                                MessageLog.info(this.getClass(), "New PiuType not found, existing PiuType is generic. No action needed.");
                                return;
                            }
                            this.auxPiu.generateInternalAlarm(null);
                            try {
                                c.rollbackOnly();
                                return;
                            }
                            catch (InactiveTransactionException e) {
                                // empty catch block
                            }
                            return;
                        }
                    }
                    newpiu = piu;
                    ManagedObject newRepertoire = AuxPlugInUnitUpgradeHelper.getNewRepertoire(this.auxPiu, newpiu, c);
                    newLoadModule = AuxPlugInUnitUpgradeHelper.getNewLoadModule(newpiu, newRepertoire, c);
                    break block18;
                }
                newpiu = piu;
                ManagedObject newRepertoire = AuxPlugInUnitUpgradeHelper.getNewRepertoire(this.auxPiu, newpiu, c);
                newLoadModule = AuxPlugInUnitUpgradeHelper.getNewLoadModule(newpiu, newRepertoire, c);
                break block18;
            }
            MessageLog.info(this.getClass(), "reconfigureProgramPrepare() : OpState != ENABLED or AdmState != UNLOCKED");
            newpiu = piu;
            if (AuxPlugInUnitUpgradeHelper.isGenericPiuType((PiuTypeMo)newpiu, c)) {
                if (!AuxPlugInUnitUpgradeHelper.isGenericPiuTypeInRepertoire((PiuTypeMo)newpiu, this.auxPiu, c)) {
                    this.auxPiu.generateInternalAlarm(null);
                }
                MessageLog.info(this.getClass(), "selected PiuType is generic, not possible to get new LM data");
                return;
            }
            ManagedObject newRepertoire = AuxPlugInUnitUpgradeHelper.getNewRepertoire(this.auxPiu, newpiu, c);
            newLoadModule = AuxPlugInUnitUpgradeHelper.getNewLoadModule(newpiu, newRepertoire, c);
        }
        if (newLoadModule == null) {
            MessageLog.info(this.getClass(), "reconfigureProgramPrepare() : couldn't find new load module. Set tx to rollback only, and generate internal alarm");
            this.auxPiu.generateInternalAlarm(null);
            try {
                c.rollbackOnly();
                return;
            }
            catch (InactiveTransactionException e) {
                // empty catch block
            }
            return;
        }
        if (curLoadModule == newLoadModule) {
            MessageLog.info(this.getClass(), "reconfigureProgramPrepare() : curLoadModule == newLoadModule, nothing to do return!");
            return;
        }
        ArrayList xpPgmList = AuxPlugInUnitUpgradeHelper.getAllXpProgram(this.auxPiu);
        if (xpPgmList.size() > 1) {
            MessageLog.info(this.getClass(), "reconfigureProgramPrepare() : xpPgmList.size() > 1 (size:" + xpPgmList.size() + ") ; return");
            return;
        }
        AuxPlugInUnitUpgradeHelper.disableOldPrograms(this.auxPiu, newpiu, c);
        this.auxPiu.setPiuTypeForSwUpgrade(newpiu, c);
        Struct newPidData = ((PiuTypeMo)newpiu).getProductData(c);
        String newPiuPNum = (String)newPidData.getValue("productNumber");
        String newPiuPRev = (String)newPidData.getValue("productRevision");
        MessageLog.info(this.getClass(), "Product data from PiuType used for XpProgram creation: " + newPiuPNum + " " + newPiuPRev + " instead of " + boardPNum + " " + boardPRev);
        AuxPlugInUnitUpgradeHelper.createNewXpProgram(this.auxPiu, newpiu, newLoadModule, newPiuPNum, newPiuPRev, c);
    }

    public void removeDisabledPrograms(Coordinator c) throws MoAccessException {
        Struct[] progConfigList;
        MessageLog.traceEnter(this.getClass(), "removeDisabledPrograms()<---");
        int j = 0;
        int nb = 40;
        while (j < nb) {
            try {
                eqcAuxPiuProxy.verifyProxyAvaliable();
                j = nb;
            }
            catch (Exception e2) {
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException e3) {
                    MessageLog.trace(4, this.getClass(), "Exception caught during sleep()");
                }
                ++j;
            }
        }
        ManagedObject piuType = this.auxPiu.getPiuType(c);
        if (piuType != null && (progConfigList = ((PiuTypeMo)piuType).getProgramConfiguration(c)) != null) {
            for (int pc = 0; pc < progConfigList.length; ++pc) {
                String moType = (String)progConfigList[pc].getValue("programMoTypeName");
                ManagedObject parent = AuxPlugInUnitUpgradeHelper.getPiuParent(progConfigList[pc], this.auxPiu, c);
                if (parent == null) continue;
                MoIterator moIter = MoRepository.instance().select(parent, 1, (MoFilter)new MoTypeFilter(moType));
                while (moIter.hasMoreElements()) {
                    ManagedObject mo = moIter.nextMo();
                    if (mo == null || !(mo instanceof XpProgramMo)) continue;
                    try {
                        if (((XpProgramMo)mo).getStartState(c) != 0) continue;
                        mo.delete(c);
                    }
                    catch (MoAccessException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new SoftwareErrorException((Throwable)e);
                    }
                }
            }
        }
    }
}

