/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.dmo.climate;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCreateGroupRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGetFanGroupParamRspS;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxDeviceGroupMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxDeviceGroupMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AuxPlugInUnitMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.FanDeviceGroupMo;

public class FanDeviceGroupMoImpl
extends AuxDeviceGroupMoImpl
implements FanDeviceGroupMo {
    public static final int MO_DATA_REVISION = 1020801;

    private FanDeviceGroupMoImpl(ManagedObject parent, String userLabel, int alarmStatus, String identity, Coordinator context) throws MoAccessException {
        super(parent, "FanDeviceGroup", identity, context);
        MessageLog.traceEnter(this.getClass(), "Normal constructor");
        EqcCreateGroupRspS rsp = this.createAuxDeviceGroupResource(parent, 49555, context);
        this.initMoData(userLabel, alarmStatus, (int)rsp.groupFroInfo.groupFroId, context);
        AuxDeviceGroupMoFactory.instance(49555).createDeviceGroupMoTree((ManagedObject)this, rsp.groupFroInfo, "", context);
        this.addObservers(49555, context);
    }

    public FanDeviceGroupMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        try {
            this.addObservers(49555, null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Couldn't init the Observers!!");
        }
        MessageLog.trace(1, this.getClass(), "Mo recovered");
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(FanDeviceGroupMoImpl.class, "create()");
        FanDeviceGroupMoImpl thisMo = null;
        FanDeviceGroupMoImpl.checkTransaction(context);
        ValidateAttributes.checkParent(parent, "AuxPlugInUnit");
        if (((AuxPlugInUnitMo)parent).getAuType(null) != 3) {
            throw new IllegalParentException("FanDeviceGroup");
        }
        String checkedUserLabel = ValidateAttributes.checkAndGetStringAttribute(attributes, "userLabel", "optional", "", 0, 128, "FanDeviceGroup");
        int checkedAlarmStatus = FanDeviceGroupMoImpl.checkAndGetAlarmStatus(attributes, 0, "FanDeviceGroup", context);
        ValidateAttributes.checkOtherAttributes(attributes, "FanDeviceGroup");
        thisMo = new FanDeviceGroupMoImpl(parent, checkedUserLabel, checkedAlarmStatus, identity, context);
        return thisMo;
    }

    public String getType() {
        return "FanDeviceGroup";
    }

    public String getFanDeviceGroupId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getFanDeviceGroupId()");
        return this.getIdentity(context);
    }

    public int getUsageState(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUsageState()");
        throw new NoSuchAttributeException("usageState", "FanDeviceGroup");
    }

    public int getFanUnitSpeedSetting(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getFanUnitSpeedSetting()");
        EqcGetFanGroupParamRspS rspSig = this.eqcDeviceGroupProxy.getFanParameters(this.getTxIdNonTransactional(context), 0L, this.getAuxGroupFroId(context));
        return rspSig.fanUnitSpeedSetting;
    }

    public int getSupplyAirTemperature(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getSupplyAirTemperature()");
        EqcGetFanGroupParamRspS rspSig = this.eqcDeviceGroupProxy.getFanParameters(this.getTxIdNonTransactional(context), 0L, this.getAuxGroupFroId(context));
        return rspSig.supplyAirTemperature;
    }

    private void initMoData(String userLabel, int alarmStatus, int auxGroupFroId, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "initMoData() ");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.bcmStoreAndRegisterIntAttribute("auxGroupFroId", auxGroupFroId);
        this.bcmStoreAndRegisterStringAttribute("userLabel", userLabel);
        this.initAlarmStatus(alarmStatus, context);
        this.myData.setRevision(1020801);
    }
}

