/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.dmo.timing;

import se.ericsson.cello.equipment.PlugInUnitMo;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EcTimingProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsGetSyncResParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.proxies.FroProxy;
import se.ericsson.wcdma.rbs.boam.mao.alarm.MoAlarms;
import se.ericsson.wcdma.rbs.boam.mao.dmo.device.DeviceMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.TimDeviceMo;
import se.ericsson.wcdma.rbs.boam.mao.rmo.node.RbsSynchronizationMoImpl;

public class TimDeviceMoImpl
extends DeviceMoImpl
implements TimDeviceMo {
    public static final int IS_SYNCHRONIZED_FALSE = 0;
    public static final int IS_STABLE_FALSE = 0;
    public static final int MO_DATA_REVISION = 1030301;
    private EcTimingProxy ecTimingProxy = EcTimingProxy.instance();

    public TimDeviceMoImpl(ManagedObject parent, String thisMoName, int deviceFroId, String identity, String userLabel, Coordinator context) throws MoAccessException {
        super(parent, thisMoName, deviceFroId, identity, context, userLabel);
        IntegerAttribute tmpAttr = new IntegerAttribute("SYNC_RES_ID", false);
        tmpAttr.setValue(-1);
        this.myData.registerPersistentAttr((Attribute)tmpAttr);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        MessageLog.traceEnter(this.getClass(), "Normal constructor");
        int checkedAlarmStatus = 0;
        this.initAlarmStatus(checkedAlarmStatus, context);
        this.notifyRbsSyncTimCreated(context);
        this.myData.setRevision(1030301);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.addObservers(1, context);
    }

    public TimDeviceMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        MessageLog.traceEnter(this.getClass(), "Recovery constructor");
        try {
            this.addObservers(1, null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Couldn't init the Observers!!");
        }
    }

    public void sysDelete(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "sysDelete()");
        this.notifyRbsSyncTimDeleted(context);
        super.superDelete(context);
    }

    public String getTimDeviceId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getTimDeviceId()");
        return this.getIdentity(context);
    }

    public int getIsStable(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getIsStable()");
        IntegerAttribute tmp = (IntegerAttribute)this.myData.getAttribute("SYNC_RES_ID");
        int syncResId = tmp.getValue(context);
        if (syncResId != -1) {
            LrsGetSyncResParamRspS rspSig = this.ecTimingProxy.getSyncResParam(0, this.getTxIdNonTransactional(context), syncResId);
            return rspSig.isStable;
        }
        return 0;
    }

    public int getIsSynchronized(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getIsSynchronized()");
        IntegerAttribute tmp = (IntegerAttribute)this.myData.getAttribute("SYNC_RES_ID");
        int syncResId = tmp.getValue(context);
        if (syncResId != -1) {
            LrsGetSyncResParamRspS rspSig = this.ecTimingProxy.getSyncResParam(0, this.getTxIdNonTransactional(context), syncResId);
            return rspSig.isSynchronized;
        }
        return 0;
    }

    public String getType() {
        return "TimDevice";
    }

    private void notifyRbsSyncTimCreated(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "notifyRbsSyncTimCreated()");
        PlugInUnitMo piuMoRef = (PlugInUnitMo)TimDeviceMoImpl.getAncestor(this, "PlugInUnit");
        RbsSynchronizationMoImpl.getInstance().bringTimIntoService(piuMoRef, this, context);
    }

    private void notifyRbsSyncTimDeleted(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "notifyRbsSyncTimDeleted()");
        PlugInUnitMo piuMoRef = (PlugInUnitMo)TimDeviceMoImpl.getAncestor(this, "PlugInUnit");
        RbsSynchronizationMoImpl.getInstance().bringTimOutOfService(piuMoRef, this, context);
    }

    public void setSyncResId(int aSyncResId, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setSyncResId()");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        IntegerAttribute tmp = (IntegerAttribute)this.myData.getAttribute("SYNC_RES_ID");
        tmp.setValue(aSyncResId);
    }

    public void clearSyncResId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "clearSyncResId()");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        IntegerAttribute tmp = (IntegerAttribute)this.myData.getAttribute("SYNC_RES_ID");
        tmp.setValue(-1);
    }

    protected void addObservers(int froType, Coordinator context) throws MoAccessException {
        this.myMoAlarms = new MoAlarms((ManagedObject)this, new FroProxy[]{this.ecTimingProxy, this.eqcBdhIndProxy}, froType, this.getFroId(context), context);
    }
}

