/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.emo.bb;

import java.util.ArrayList;
import java.util.List;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.mao.emo.bb.DownlinkBaseBandPoolMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.OperationNotAllowedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.BbifBoardMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.DeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.ObifDeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RuifDeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.StrxDeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.pms.iface.PmCapableMoFactory;
import se.ericsson.wcdma.rbs.boam.pms.impl.Counter;
import se.ericsson.wcdma.rbs.boam.pms.impl.CounterGroup;
import se.ericsson.wcdma.rbs.boam.pms.impl.MoScannerAgent;
import se.ericsson.wcdma.rbs.boam.pms.impl.PmsException;
import se.ericsson.wcdma.rbs.boam.pms.impl.PredefinedScannerMgr;

public class DownlinkBaseBandPoolMoFactory
implements MoFactory,
PmCapableMoFactory {
    private static DownlinkBaseBandPoolMoFactory instance = null;
    private List counterList = new ArrayList();

    private DownlinkBaseBandPoolMoFactory() {
        MessageLog.traceEnter(this.getClass(), "DownlinkBaseBandPoolMoFactory()");
        MoFactoryMgr.instance().register((MoFactory)this, this.getMoTypeName());
        this.setupCounter();
        this.setupRbsPredefScanner();
    }

    public static synchronized DownlinkBaseBandPoolMoFactory getInstance() {
        return instance;
    }

    public static synchronized DownlinkBaseBandPoolMoFactory instance() {
        if (instance == null) {
            instance = new DownlinkBaseBandPoolMoFactory();
        }
        return instance;
    }

    private void createGroupsCounters(String name, int noOfElements) throws PmsException {
        CounterGroup cntGrp = new CounterGroup(name);
        int nameIndex = 4;
        for (int i = 0; i < 7; ++i) {
            Counter cnt = new Counter(name + nameIndex, noOfElements, cntGrp);
            this.counterList.add(cnt);
            nameIndex *= 2;
        }
    }

    public ManagedObject createSystemMo(ManagedObject parent, AttrList attributes, int poolId, ManagedObject creator, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " createSystemMo() ");
        if (!(creator instanceof RuifDeviceGroupMo || creator instanceof StrxDeviceGroupMo || creator instanceof ObifDeviceGroupMo || creator instanceof BbifBoardMo || creator instanceof DeviceGroupMo)) {
            MessageLog.traceError(this.getClass(), "Invalid Create attempt by Mo : " + creator.getClass() + ", this is a System Created MO :");
            throw new OperationNotAllowedException();
        }
        MoIterator MoTypeExistsItr = MoRepository.instance().lookupType("DownlinkBaseBandPool");
        if (MoTypeExistsItr != null) {
            while (MoTypeExistsItr.hasMoreElements()) {
                ManagedObject existingMo = MoTypeExistsItr.nextMo();
                String fDn = existingMo.getFullDistinguishedName();
                if (!fDn.endsWith(String.valueOf(poolId))) continue;
                ((DownlinkBaseBandPoolMoImpl)existingMo).reservePool(creator, context);
                MessageLog.trace(1, this.getClass(), "DownlinkBaseBandPool with fDdn = " + fDn + " Already Exists, hence reservePool() invoked");
                return existingMo;
            }
        }
        ManagedObject createdMo = DownlinkBaseBandPoolMoImpl.createSystemMo(parent, attributes, String.valueOf(poolId), source, context);
        ((DownlinkBaseBandPoolMoImpl)createdMo).reservePool(creator, context);
        MessageLog.trace(1, this.getClass(), "DownlinkBaseBandPool MO Created");
        return createdMo;
    }

    public ManagedObject createMo(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.trace(1, this.getClass(), "Invalid Create attempt, this is a System Created MO");
        throw new OperationNotAllowedException();
    }

    public List getCounters() {
        return this.counterList;
    }

    public String getMoTypeName() {
        MessageLog.traceEnter(this.getClass(), "getMoTypeName()");
        return "DownlinkBaseBandPool";
    }

    public ManagedObject recoverMo(MoData recoveredData) throws MoNameAlreadyTakenException {
        MessageLog.traceEnter(this.getClass(), "recoverMo");
        return new DownlinkBaseBandPoolMoImpl(recoveredData);
    }

    private void setupCounter() {
        try {
            this.createGroupsCounters("pmNoOfRadioLinksSf", 15);
            this.createGroupsCounters("pmSetupAttemptsSf", 1);
            this.createGroupsCounters("pmSetupFailuresSf", 1);
            this.createGroupsCounters("pmNoOfRlAdditionFailuresSf", 1);
            Counter cnt = new Counter("pmCapacityDlCe", 11, null);
            this.counterList.add(cnt);
            cnt = new Counter("pmCapacityAllocAttDlCe", 1, null);
            this.counterList.add(cnt);
            cnt = new Counter("pmCapacityAllocRejDlCe", 1, null);
            this.counterList.add(cnt);
            CounterGroup cntGrp = new CounterGroup("capacityNumDlCe");
            cnt = new Counter("pmSumCapacityDlCe", 1, cntGrp);
            this.counterList.add(cnt);
            cnt = new Counter("pmSumSqrCapacityDlCe", 1, cntGrp);
            this.counterList.add(cnt);
            cnt = new Counter("pmSamplesCapacityDlCe", 1, cntGrp);
            this.counterList.add(cnt);
            cnt = new Counter("pmAllocRejADch", 1, null);
            this.counterList.add(cnt);
            cnt = new Counter("pmUsedADch", 11, null);
            this.counterList.add(cnt);
            new MoScannerAgent(this.getMoTypeName(), this.counterList);
        }
        catch (PmsException pmse) {
            MessageLog.traceError(this.getClass(), "setupCounter(): Setup counters failed!!", (Throwable)((Object)pmse));
        }
    }

    private void setupRbsPredefScanner() {
        MessageLog.traceEnter(this.getClass(), "setupRbsPredefScanner()");
        String[] classnames = new String[]{this.getMoTypeName()};
        String[][] counterArray = new String[][]{{"pmCapacityAllocAttDlCe", "pmCapacityAllocRejDlCe", "pmSumCapacityDlCe", "pmSamplesCapacityDlCe"}};
        PredefinedScannerMgr.instance().createPredefinedScanner("PREDEF.PRIMARY.STATS", classnames, counterArray, 5);
    }

    public static synchronized void _setupCounter_onlyForTest() {
        if (instance != null) {
            MoFactoryMgr.instance().deregister(instance.getMoTypeName());
            instance = null;
        }
    }
}

