/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.emo.bb;

import java.util.ArrayList;
import java.util.List;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.mao.common.PmCounterSetup;
import se.ericsson.wcdma.rbs.boam.mao.emo.bb.UplinkBaseBandPoolMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.OperationNotAllowedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.BbifBoardMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.DeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.ObifDeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RuifDeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.StrxDeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.pms.iface.PmCapableMoFactory;
import se.ericsson.wcdma.rbs.boam.pms.impl.Counter;
import se.ericsson.wcdma.rbs.boam.pms.impl.CounterGroup;
import se.ericsson.wcdma.rbs.boam.pms.impl.MoScannerAgent;
import se.ericsson.wcdma.rbs.boam.pms.impl.PmsException;
import se.ericsson.wcdma.rbs.boam.pms.impl.PredefinedScannerMgr;

public class UplinkBaseBandPoolMoFactory
implements MoFactory,
PmCapableMoFactory {
    private static UplinkBaseBandPoolMoFactory instance = null;
    private List counterList = new ArrayList();

    private UplinkBaseBandPoolMoFactory() {
        MessageLog.traceEnter(this.getClass(), "UplinkBaseBandPoolMoFactory()");
        MoFactoryMgr.instance().register((MoFactory)this, this.getMoTypeName());
        this.setupCounter();
        this.setupRbsPredefScanner();
    }

    public static synchronized UplinkBaseBandPoolMoFactory getInstance() {
        return instance;
    }

    public static synchronized UplinkBaseBandPoolMoFactory instance() {
        if (instance == null) {
            instance = new UplinkBaseBandPoolMoFactory();
        }
        return instance;
    }

    private void createGroupsCounters(String name, int noOfElements) throws PmsException {
        CounterGroup cntGrp = new CounterGroup(name);
        int nameIndex = 4;
        for (int i = 0; i < 7; ++i) {
            Counter cnt = new Counter(name + nameIndex, noOfElements, cntGrp);
            this.counterList.add(cnt);
            nameIndex *= 2;
        }
    }

    public ManagedObject createMo(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.trace(1, this.getClass(), "Invalid Create attempt, this is a System Created MO");
        throw new OperationNotAllowedException();
    }

    public List getCounters() {
        return this.counterList;
    }

    public ManagedObject createSystemMo(ManagedObject parent, AttrList attributes, int poolId, ManagedObject creator, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " createSystemMo() ");
        if (!(creator instanceof RuifDeviceGroupMo || creator instanceof StrxDeviceGroupMo || creator instanceof ObifDeviceGroupMo || creator instanceof BbifBoardMo || creator instanceof DeviceGroupMo)) {
            MessageLog.traceError(this.getClass(), "Invalid Create attempt by Mo : " + creator.getClass() + ", this is a System Created MO :");
            throw new OperationNotAllowedException();
        }
        MoIterator MoTypeExistsItr = MoRepository.instance().lookupType("UplinkBaseBandPool");
        if (MoTypeExistsItr != null) {
            while (MoTypeExistsItr.hasMoreElements()) {
                ManagedObject existingMo = MoTypeExistsItr.nextMo();
                String fDn = existingMo.getFullDistinguishedName();
                if (!fDn.endsWith(String.valueOf(poolId))) continue;
                ((UplinkBaseBandPoolMoImpl)existingMo).reservePool(creator, context);
                MessageLog.trace(1, this.getClass(), "UplinkBaseBandPool with fDdn = " + fDn + " Already Exists, hence reservePool() invoked");
                return existingMo;
            }
        }
        ManagedObject createdMo = UplinkBaseBandPoolMoImpl.createSystemMo(parent, attributes, String.valueOf(poolId), source, context);
        ((UplinkBaseBandPoolMoImpl)createdMo).reservePool(creator, context);
        MessageLog.trace(1, this.getClass(), "UplinkBaseBandPool MO Created");
        return createdMo;
    }

    public String getMoTypeName() {
        MessageLog.traceEnter(this.getClass(), "getMoTypeName()");
        return "UplinkBaseBandPool";
    }

    public ManagedObject recoverMo(MoData recoveredData) throws MoNameAlreadyTakenException {
        MessageLog.traceEnter(this.getClass(), "recoverMo");
        return new UplinkBaseBandPoolMoImpl(recoveredData);
    }

    private void setupCounter() {
        try {
            this.createGroupsCounters("pmNoOfRadioLinksSf", 15);
            this.createGroupsCounters("pmSetupAttemptsSf", 1);
            this.createGroupsCounters("pmSetupFailuresSf", 1);
            Counter cnt = new Counter("pmCpcUlActivityFactor", 20, null);
            this.counterList.add(cnt);
            cnt = new Counter("pmNoOfIbho", 1, null);
            this.counterList.add(cnt);
            cnt = new Counter("pmHwCePoolEul", 93, null);
            this.counterList.add(cnt);
            CounterGroup group = new CounterGroup("capacityUlCe");
            this.counterList.add(new Counter("pmCapacityUlCe", 11, group));
            this.counterList.add(new Counter("pmCapacityUlCeExt", 10, group));
            cnt = new Counter("pmCapacityAllocAttUlCe", 1, null);
            this.counterList.add(cnt);
            cnt = new Counter("pmCapacityAllocRejUlCe", 1, null);
            this.counterList.add(cnt);
            CounterGroup cntGrp = new CounterGroup("capacityNumUlCe");
            cnt = new Counter("pmSumCapacityUlCe", 1, cntGrp);
            this.counterList.add(cnt);
            cnt = new Counter("pmSumSqrCapacityUlCe", 1, cntGrp);
            this.counterList.add(cnt);
            cnt = new Counter("pmSamplesCapacityUlCe", 1, cntGrp);
            this.counterList.add(cnt);
            PmCounterSetup.setupCounters(this.getMoTypeName(), this.counterList);
            new MoScannerAgent(this.getMoTypeName(), this.counterList);
        }
        catch (PmsException pmse) {
            MessageLog.traceError(this.getClass(), "setupCounter(): Setup counters failed!!", (Throwable)((Object)pmse));
        }
    }

    private void setupRbsPredefScanner() {
        MessageLog.traceEnter(this.getClass(), "setupRbsPredefScanner()");
        String[] classnames = new String[]{this.getMoTypeName()};
        String[][] counterArray = new String[][]{{"pmCapacityAllocAttUlCe", "pmCapacityAllocRejUlCe", "pmSumCapacityUlCe", "pmSamplesCapacityUlCe"}};
        PredefinedScannerMgr.instance().createPredefinedScanner("PREDEF.PRIMARY.STATS", classnames, counterArray, 5);
    }

    public static synchronized void _setupCounter_onlyForTest() {
        if (instance != null) {
            MoFactoryMgr.instance().deregister(instance.getMoTypeName());
            instance = null;
        }
    }
}

