/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.emo.cable;

import se.ericsson.cello.equipment.EquipmentMo;
import se.ericsson.cello.equipment.PlugInUnitMaoi;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCreateCableRspS;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.emo.cable.RbsCableMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.BbifBoardMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.GammaCableMo;

public class GammaCableMoImpl
extends RbsCableMoImpl
implements GammaCableMo {
    private static final int GAMMA_PARAM_ELECTRICAL_DELAY = 1;
    private static final int NOT_APPLICABLE = 0;
    private static final int GAMMA_CABLE_MAX_NO_OF_CHILDREN = 4;
    public static final int MO_DATA_REVISION = 4010101;

    public GammaCableMoImpl(ManagedObject parent, String motypeName, AttrList attributes, String identity, Coordinator context, String checkedUserLabel, ManagedObject checkedBbifBoardRef, int checkedBbifConnector, ManagedObject checkedRfifPlugInUnitRef, int checkedRfifConnector, int checkedElectricalDelay, int checkedAlarmStatus) throws MoAccessException {
        super(parent, motypeName, identity, context, 4);
        MessageLog.traceEnter(this.getClass(), " GammaCableMoImpl Normal constructor");
        ManagedObject rfifDeviceGroupRef = null;
        rfifDeviceGroupRef = this.checkPreconditionsGetRfifDeviceGroupRef(checkedRfifPlugInUnitRef, context);
        this.setReservation("bbifBoardRef", checkedBbifBoardRef, context);
        this.setReservation("rfifPlugInUnitRef", checkedRfifPlugInUnitRef, context);
        int bbifFroId = ((BbifBoardMo)checkedBbifBoardRef).getBbifFroId(context);
        int rfifPlugInUnitFroId = ((PlugInUnitMaoi)checkedRfifPlugInUnitRef).getFroId(context);
        EqcCreateCableRspS rspSig = this.eqcCableProxy.createCable(this.getTxIdTransactional(context), 0L, 50160, 0L, bbifFroId, checkedBbifConnector, rfifPlugInUnitFroId, checkedRfifConnector);
        int cableFroId = (int)rspSig.cableFroId;
        this.eqcCableProxy.setGammaCableParameters(this.getTxIdTransactional(context), 0L, cableFroId, 1, checkedElectricalDelay);
        this.initMoData(checkedUserLabel, checkedBbifBoardRef, checkedRfifPlugInUnitRef, rfifDeviceGroupRef, cableFroId, checkedAlarmStatus, context);
        this.addObservers(50160, context);
    }

    public GammaCableMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        MessageLog.traceEnter(this.getClass(), " GammaCableMoImpl Recovery constructor");
        try {
            this.addObservers(50160, null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Couldn't init the Observers!!");
        }
        MessageLog.trace(1, this.getClass(), "Mo recovered");
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(GammaCableMoImpl.class, "create()");
        GammaCableMoImpl.checkTransaction(context);
        GammaCableMoImpl.checkParent(parent);
        String checkedUserLabel = ValidateAttributes.checkAndGetStringAttribute(attributes, "userLabel", "optional", "", 0, 128, "GammaCable");
        ManagedObject checkedBbifBoardRef = GammaCableMoImpl.checkAndGetBbifBoardRef(attributes, context);
        int checkedBbifConnector = ValidateAttributes.checkAndGetIntAttribute(attributes, "bbifConnector", "mandatory", 1, 1, 2, "GammaCable");
        if (checkedBbifConnector == 1) {
            checkedBbifConnector = 0;
        } else if (checkedBbifConnector == 2) {
            checkedBbifConnector = 1;
        } else {
            MessageLog.trace(1, GammaCableMoImpl.class, "incorrect input parameter");
        }
        ManagedObject checkedRfifPlugInUnitRef = GammaCableMoImpl.checkAndGetRfifPlugInUnitRef(attributes, context);
        int checkedRfifConnector = ValidateAttributes.checkAndGetIntAttribute(attributes, "rfifConnector", "mandatory", 1, 1, 2, "GammaCable");
        if (checkedRfifConnector == 1) {
            checkedRfifConnector = 0;
        } else if (checkedRfifConnector == 2) {
            checkedRfifConnector = 1;
        } else {
            MessageLog.trace(1, GammaCableMoImpl.class, "incorrect input parameter");
        }
        int checkedElectricalDelay = ValidateAttributes.checkAndGetIntAttribute(attributes, "electricalDelay", "mandatory", 0, ELECTRICAL_DELAY_MIN_VALUES, ELECTRICAL_DELAY_MAX_VALUES, "GammaCable");
        int checkedAlarmStatus = ValidateAttributes.checkAndGetIntAttribute(attributes, "alarmStatus", "optional", 0, ALARM_STATUS_MIN_VALUES, ALARM_STATUS_MAX_VALUES, "GammaCable");
        ValidateAttributes.checkOtherAttributes(attributes, "GammaCable");
        GammaCableMoImpl createdMo = new GammaCableMoImpl(parent, "GammaCable", attributes, identity, context, checkedUserLabel, checkedBbifBoardRef, checkedBbifConnector, checkedRfifPlugInUnitRef, checkedRfifConnector, checkedElectricalDelay, checkedAlarmStatus);
        return createdMo;
    }

    public String getType() {
        return "GammaCable";
    }

    public String getGammaCableId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getGammaCableId()");
        return super.bcmGetIdentity(this.getLocalDistinguishedName(), context);
    }

    public int getBbifConnector(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getBbifConnector()");
        return this.getRoValue(context, 50160, "bbifConnector", 1, 2);
    }

    public int getRfifConnector(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getRfifConnector()");
        return this.getRoValue(context, 50160, "rfifConnector", 1, 2);
    }

    public int getElectricalDelay(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getElectricalDelay()");
        return this.getRoValue(context, 50160, "electricalDelay", ELECTRICAL_DELAY_MIN_VALUES, ELECTRICAL_DELAY_MAX_VALUES);
    }

    public void setElectricalDelay(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setElectricalDelay()");
        this.setRoValue(context, 50160, 1, "electricalDelay", value, ELECTRICAL_DELAY_MIN_VALUES, ELECTRICAL_DELAY_MAX_VALUES);
        this.sendAVC("electricalDelay", value, context);
    }

    public int getCableType() {
        MessageLog.traceEnter(this.getClass(), "getCableType()");
        return 50160;
    }

    private static void checkParent(ManagedObject parent) throws IllegalParentException {
        MessageLog.traceEnter(GammaCableMoImpl.class, "checkParent");
        if (parent == null || !(parent instanceof EquipmentMo)) {
            String msg = " Illegal parent, Expecting EquipmentMo, received for : GammaCable";
            throw new IllegalParentException(msg);
        }
    }

    private void initMoData(String checkedUserLabel, ManagedObject checkedBbifBoardRef, ManagedObject checkedRfifPlugInUnitRef, ManagedObject rfifDeviceGroupRef, int cableFroId, int checkedAlarmStatus, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "initMoData() ");
        this.bcmStoreAndRegisterStringAttribute("userLabel", checkedUserLabel);
        this.bcmStoreAndRegisterReferenceAttribute("bbifBoardRef", checkedBbifBoardRef);
        this.bcmStoreAndRegisterReferenceAttribute("rfifPlugInUnitRef", checkedRfifPlugInUnitRef);
        this.bcmStoreAndRegisterReferenceAttribute("rfifDeviceGroupRef", rfifDeviceGroupRef);
        this.bcmStoreAndRegisterIntAttribute("cableFroId", cableFroId);
        this.initAlarmStatus(checkedAlarmStatus, context);
        this.myData.setRevision(4010101);
    }
}

