/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.emo.cable;

import se.ericsson.cello.equipment.EquipmentMo;
import se.ericsson.cello.equipment.PlugInUnitMaoi;
import se.ericsson.cello.equipment.PlugInUnitMo;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcCableProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcRrhIndProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCreateCableRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGetRfCableParamRspS;
import se.ericsson.wcdma.rbs.boam.mao.alarm.MoAlarms;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObjectWithAlarms;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AiuDeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AuxDeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AuxPlugInUnitMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.ConnectionFieldMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.DbDeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.DeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.FuDeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.PauDeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RfCableMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RruDeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RuDeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.SaiuDeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.StrxDeviceGroupMo;

public class RfCableMoImpl
extends BoamManagedObjectWithAlarms
implements RfCableMo {
    private static final int NOT_APPLICABLE = 0;
    public static final String RF_CABLE_FRO_ID = "rfCableFroId";
    public static final int MO_DATA_REVISION = 2031001;
    private int rfCableFroId;
    private final EqcCableProxy eqcCableProxy = EqcCableProxy.instance();
    private final EqcRrhIndProxy eqcRrhIndProxy = EqcRrhIndProxy.instance();
    private IntegerAttribute rfCableFroIdAttr;
    private ReferenceAttribute connectedToObjectARefAttr;
    private ReferenceAttribute connectedToObjectBRefAttr;

    public RfCableMoImpl(ManagedObject parent, String moTypeName, AttrList attributes, String identity, Coordinator context, String checkedUserLabel, int checkedObjectAConnector, int checkedObjectBConnector, ManagedObject checkedConnectedToObjectARef, ManagedObject checkedConnectedToObjectBRef, int checkedDlAttenuation, int checkedElectricalDlDelay, int checkedElectricalUlDelay, int checkedUlAttenuation, int checkedAlarmStatus) throws MoAccessException {
        super(parent, moTypeName, identity, context);
        MessageLog.traceEnter(this.getClass(), "RfCableMoImpl Normal constructor");
        int cableFroId = this.createRo(context, checkedObjectAConnector, checkedObjectBConnector, checkedConnectedToObjectARef, checkedConnectedToObjectBRef, checkedDlAttenuation, checkedElectricalDlDelay, checkedElectricalUlDelay, checkedUlAttenuation);
        this.initMoData(checkedUserLabel, cableFroId, checkedConnectedToObjectARef, checkedConnectedToObjectBRef, checkedAlarmStatus, context);
        this.addObservers(50163, context);
    }

    public RfCableMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        MessageLog.traceEnter(this.getClass(), "RfCableMoImpl Recovery constructor");
        this.myData = recoveredData;
        this.rfCableFroIdAttr = new IntegerAttribute(RF_CABLE_FRO_ID, false);
        this.rfCableFroIdAttr = (IntegerAttribute)recoveredData.getAttribute(RF_CABLE_FRO_ID);
        if (this.rfCableFroIdAttr == null) {
            MessageLog.traceError(this.getClass(), "Recovered attribute rfCableFroIdAttr is null");
        }
        this.connectedToObjectARefAttr = new ReferenceAttribute("connectedToObjectARef", false);
        this.connectedToObjectARefAttr = (ReferenceAttribute)recoveredData.getAttribute("connectedToObjectARef");
        if (this.connectedToObjectARefAttr == null) {
            MessageLog.traceError(this.getClass(), "Recovered attribute connectedToObjectARefAttr is null");
        }
        this.connectedToObjectBRefAttr = new ReferenceAttribute("connectedToObjectBRef", false);
        this.connectedToObjectBRefAttr = (ReferenceAttribute)recoveredData.getAttribute("connectedToObjectBRef");
        if (this.connectedToObjectBRefAttr == null) {
            MessageLog.traceError(this.getClass(), "Recovered attribute connectedToObjectBRefAttr is null");
        }
        try {
            this.addObservers(50163, null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Couldn't init the Observers!!");
        }
        MessageLog.trace(1, this.getClass(), "Mo recovered");
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(RfCableMoImpl.class, "create()");
        RfCableMoImpl.checkTransaction(context);
        RfCableMoImpl.checkParent(parent);
        String checkedUserLabel = ValidateAttributes.checkAndGetStringAttribute(attributes, "userLabel", "optional", "", 0, 128, "RfCable");
        int checkedObjectAConnector = RfCableMoImpl.objectAConnectorMomToEcMi(ValidateAttributes.checkAndGetIntAttribute(attributes, "objectAConnector", "mandatory", 0, 0, 14, "RfCable"));
        int checkedObjectBConnector = RfCableMoImpl.objectBConnectorMomToEcMi(ValidateAttributes.checkAndGetIntAttribute(attributes, "objectBConnector", "mandatory", 1, 1, 22, "RfCable"));
        String[] classNameCTOAR = new String[]{"AuxPlugInUnit", "ConnectionField", "PlugInUnit"};
        ManagedObject checkedConnectedToObjectARef = ValidateAttributes.checkAndGetReferenceAttribute("connectedToObjectARef", attributes, "mandatory", classNameCTOAR, "RfCable");
        ManagedObject checkedConnectedToObjectBRef = ValidateAttributes.checkAndGetReferenceAttribute("connectedToObjectBRef", attributes, "mandatory", classNameCTOAR, "RfCable");
        int checkedDlAttenuation = ValidateAttributes.checkAndGetIntAttribute(attributes, "dlAttenuation", "optional", -1, DL_ATTENUATION_MIN_VALUES, DL_ATTENUATION_MAX_VALUES, "RfCable");
        int checkedElectricalDlDelay = ValidateAttributes.checkAndGetIntAttribute(attributes, "electricalDlDelay", "optional", -1, ELECTRICAL_DL_DELAY_MIN_VALUES, ELECTRICAL_DL_DELAY_MAX_VALUES, "RfCable");
        int checkedElectricalUlDelay = ValidateAttributes.checkAndGetIntAttribute(attributes, "electricalUlDelay", "optional", -1, ELECTRICAL_UL_DELAY_MIN_VALUES, ELECTRICAL_UL_DELAY_MAX_VALUES, "RfCable");
        int checkedUlAttenuation = ValidateAttributes.checkAndGetIntAttribute(attributes, "ulAttenuation", "optional", -1, UL_ATTENUATION_MIN_VALUES, UL_ATTENUATION_MAX_VALUES, "RfCable");
        int checkedAlarmStatus = ValidateAttributes.checkAndGetIntAttribute(attributes, "alarmStatus", "optional", 0, ALARM_STATUS_MIN_VALUES, ALARM_STATUS_MAX_VALUES, "RfCable");
        ValidateAttributes.checkOtherAttributes(attributes, "RfCable");
        RfCableMoImpl createdMo = new RfCableMoImpl(parent, "RfCable", attributes, identity, context, checkedUserLabel, checkedObjectAConnector, checkedObjectBConnector, checkedConnectedToObjectARef, checkedConnectedToObjectBRef, checkedDlAttenuation, checkedElectricalDlDelay, checkedElectricalUlDelay, checkedUlAttenuation, checkedAlarmStatus);
        return createdMo;
    }

    public void delete(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "deleteRfCable() " + this.getFullDistinguishedName());
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        int rfCableFroId = this.getRfCableFroId(context);
        this.eqcCableProxy.deleteCable(this.getTxIdTransactional(context), 0, rfCableFroId, 50163);
        ManagedObject connectedToObjectARef = this.getConnectedToObjectARef(context);
        ManagedObject connectedToObjectBRef = this.getConnectedToObjectBRef(context);
        this.releaseReservation("connectedToObjectARef", connectedToObjectARef, context);
        this.releaseReservation("connectedToObjectBRef", connectedToObjectBRef, context);
        this.removeObservers(context);
        super.delete(context);
        MessageLog.trace(1, this.getClass(), this.getType() + " Mo is Deleted ");
    }

    public String getType() {
        return "RfCable";
    }

    public int getRfCableFroId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getRfCableFroId()");
        return this.bcmGetIntAttribute(RF_CABLE_FRO_ID, context);
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData()");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(this.getClass(), "isMyMoDataPersistent()");
        return true;
    }

    public String getUserLabel(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUserLabel()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        StringAttribute userLabelAttr = (StringAttribute)this.myData.getAttribute("userLabel");
        return userLabelAttr.getValue(context);
    }

    public void setUserLabel(String value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setUserLabel() ");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.bcmSetStringAttribute("userLabel", value, 0, 128, this.getType(), context);
        this.sendAVC("userLabel", value, context);
    }

    public int getObjectAConnector(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getObjectAConnector()");
        int objectAConnector = this.getAttribute(context, "objectAConnector");
        switch (objectAConnector) {
            case 18: {
                objectAConnector = 4;
                break;
            }
            case 19: {
                objectAConnector = 5;
                break;
            }
            case 41: {
                objectAConnector = 2;
                break;
            }
            case 68: {
                objectAConnector = 0;
                break;
            }
            case 39: {
                objectAConnector = 6;
                break;
            }
            case 52: {
                objectAConnector = 8;
                break;
            }
            case 38: {
                objectAConnector = 7;
                break;
            }
            case 53: {
                objectAConnector = 9;
                break;
            }
            case 54: {
                objectAConnector = 10;
                break;
            }
            case 50: {
                objectAConnector = 11;
                break;
            }
            case 36: {
                objectAConnector = 1;
                break;
            }
            case 32: {
                objectAConnector = 3;
                break;
            }
            case 90: {
                objectAConnector = 12;
                break;
            }
            case 92: {
                objectAConnector = 14;
                break;
            }
            case 91: {
                objectAConnector = 13;
                break;
            }
            default: {
                String msg = "The attribute objectAConnector is Out of range" + objectAConnector;
                MessageLog.traceError(this.getClass(), this.getType() + msg);
            }
        }
        return objectAConnector;
    }

    public void setObjectAConnector(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setObjectAConnector()");
        ValidateAttributes.checkTransaction(context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.rfCableFroId = this.getRfCableFroId(context);
        this.eqcCableProxy.setRfCableParameters(this.getTxIdTransactional(context), 0L, this.rfCableFroId, 2, 0L, RfCableMoImpl.objectAConnectorMomToEcMi(value), 0, 0, 0, 0);
        this.sendAVC("objectAConnector", value, context);
    }

    public int getObjectBConnector(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getObjectBConnector()");
        int objectBConnector = this.getAttribute(context, "objectBConnector");
        if (objectBConnector == 31) {
            objectBConnector = 1;
        } else if (objectBConnector == 40) {
            objectBConnector = 2;
        } else if (objectBConnector == 37) {
            objectBConnector = 3;
        } else if (objectBConnector == 38) {
            objectBConnector = 4;
        } else if (objectBConnector == 7) {
            objectBConnector = 5;
        } else if (objectBConnector == 4) {
            objectBConnector = 6;
        } else if (objectBConnector == 8) {
            objectBConnector = 7;
        } else if (objectBConnector == 5) {
            objectBConnector = 8;
        } else if (objectBConnector == 9) {
            objectBConnector = 9;
        } else if (objectBConnector == 6) {
            objectBConnector = 10;
        } else if (objectBConnector == 25) {
            objectBConnector = 11;
        } else if (objectBConnector == 26) {
            objectBConnector = 12;
        } else if (objectBConnector == 27) {
            objectBConnector = 13;
        } else if (objectBConnector == 28) {
            objectBConnector = 14;
        } else if (objectBConnector == 29) {
            objectBConnector = 15;
        } else if (objectBConnector == 30) {
            objectBConnector = 16;
        } else if (objectBConnector == 36) {
            objectBConnector = 17;
        } else if (objectBConnector == 39) {
            objectBConnector = 18;
        } else if (objectBConnector == 53) {
            objectBConnector = 19;
        } else if (objectBConnector == 90) {
            objectBConnector = 20;
        } else if (objectBConnector == 92) {
            objectBConnector = 22;
        } else {
            String msg = "The attribute objectBConnector is Out of range" + objectBConnector;
            MessageLog.traceError(this.getClass(), this.getType() + msg);
        }
        return objectBConnector;
    }

    public ManagedObject getConnectedToObjectARef(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getConnectedToObjectARef()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        this.connectedToObjectARefAttr = (ReferenceAttribute)this.myData.getAttribute("connectedToObjectARef");
        ManagedObject connectedToObjectARef = this.connectedToObjectARefAttr.getValue(context);
        return connectedToObjectARef;
    }

    public void setConnectedToObjectARef(ManagedObject value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setConnectedToObjectARef()" + this.getFullDistinguishedName());
        ValidateAttributes.checkTransaction(context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.rfCableFroId = this.getRfCableFroId(context);
        int objectARefFroId = this.getObjectARefFroId(value, context);
        this.eqcCableProxy.setRfCableParameters(this.getTxIdTransactional(context), 0L, this.rfCableFroId, 1, objectARefFroId, 0, 0, 0, 0, 0);
        this.connectedToObjectARefAttr = (ReferenceAttribute)this.myData.getAttribute("connectedToObjectARef");
        ManagedObject moOldRef = this.connectedToObjectARefAttr.getValue(context);
        if (moOldRef != null) {
            ((Reservable)moOldRef).release((ManagedObject)this, context);
        }
        this.connectedToObjectARefAttr.setValue(value);
        ((Reservable)value).reserve((ManagedObject)this, context);
        this.sendAVC("connectedToObjectARef", value, context);
    }

    public ManagedObject getConnectedToObjectBRef(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getConnectedToObjectBRef()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        this.connectedToObjectBRefAttr = (ReferenceAttribute)this.myData.getAttribute("connectedToObjectBRef");
        ManagedObject connectedToObjectBRef = this.connectedToObjectBRefAttr.getValue(context);
        return connectedToObjectBRef;
    }

    public int getDlAttenuation(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getDlAttenuation()");
        int dlAttenuation = this.getAttribute(context, "dlAttenuation");
        return dlAttenuation;
    }

    public void setDlAttenuation(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setDlAttenuation()");
        ValidateAttributes.checkTransaction(context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        ValidateAttributes.intValueRangeCheck("dlAttenuation", value, DL_ATTENUATION_MIN_VALUES, DL_ATTENUATION_MAX_VALUES, "RfCable");
        this.rfCableFroId = this.getRfCableFroId(context);
        this.eqcCableProxy.setRfCableParameters(this.getTxIdTransactional(context), 0L, this.rfCableFroId, 3, 0L, 0, value, 0, 0, 0);
        this.sendAVC("dlAttenuation", value, context);
    }

    public int getElectricalDlDelay(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getElectricalDlDelay()");
        int electricalDlDelay = this.getAttribute(context, "electricalDlDelay");
        return electricalDlDelay;
    }

    public void setElectricalDlDelay(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setElectricalDlDelay()");
        ValidateAttributes.checkTransaction(context);
        this.getMyMoData().handleTransaction(context, MoData.WRITE_ACCESS);
        ValidateAttributes.intValueRangeCheck("electricalDlDelay", value, ELECTRICAL_DL_DELAY_MIN_VALUES, ELECTRICAL_DL_DELAY_MAX_VALUES, "RfCable");
        this.rfCableFroId = this.getRfCableFroId(context);
        this.eqcCableProxy.setRfCableParameters(this.getTxIdTransactional(context), 0L, this.rfCableFroId, 4, 0L, 0, 0, value, 0, 0);
    }

    public int getElectricalUlDelay(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getElectricalUlDelay()");
        int electricalUlDelay = this.getAttribute(context, "electricalUlDelay");
        return electricalUlDelay;
    }

    public void setElectricalUlDelay(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setElectricalUlDelay()");
        ValidateAttributes.checkTransaction(context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        ValidateAttributes.intValueRangeCheck("electricalUlDelay", value, ELECTRICAL_UL_DELAY_MIN_VALUES, ELECTRICAL_UL_DELAY_MAX_VALUES, "RfCable");
        this.rfCableFroId = this.getRfCableFroId(context);
        this.eqcCableProxy.setRfCableParameters(this.getTxIdTransactional(context), 0L, this.rfCableFroId, 6, 0L, 0, 0, 0, 0, value);
    }

    public int getUlAttenuation(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUlAttenuation()");
        int ulAttenuation = this.getAttribute(context, "ulAttenuation");
        return ulAttenuation;
    }

    public void setUlAttenuation(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setUlAttenuation()");
        ValidateAttributes.checkTransaction(context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        ValidateAttributes.intValueRangeCheck("ulAttenuation", value, UL_ATTENUATION_MIN_VALUES, UL_ATTENUATION_MAX_VALUES, "RfCable");
        this.rfCableFroId = this.getRfCableFroId(context);
        this.eqcCableProxy.setRfCableParameters(this.getTxIdTransactional(context), 0L, this.rfCableFroId, 5, 0L, 0, 0, 0, value, 0);
        this.sendAVC("ulAttenuation", value, context);
    }

    private static void checkParent(ManagedObject parent) throws IllegalParentException {
        MessageLog.traceEnter(RfCableMoImpl.class, "checkParent");
        if (parent == null || !(parent instanceof EquipmentMo)) {
            String msg = parent != null ? " Illegal parent, Expecting EquipmentMo, received: " + parent.getClass().getName() : "parent is null";
            throw new IllegalParentException(msg);
        }
    }

    private void initMoData(String checkedUserLabel, int cableFroId, ManagedObject checkedConnectedToObjectARef, ManagedObject checkedConnectedToObjectBRef, int checkedAlarmStatus, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "initMoData() ");
        this.myData = new MoData(this.getLocalDistinguishedName(), this.getType(), true, context);
        this.bcmStoreAndRegisterStringAttribute("userLabel", checkedUserLabel);
        this.bcmStoreAndRegisterIntAttribute(RF_CABLE_FRO_ID, cableFroId);
        this.bcmStoreAndRegisterReferenceAttribute("connectedToObjectARef", checkedConnectedToObjectARef);
        this.bcmStoreAndRegisterReferenceAttribute("connectedToObjectBRef", checkedConnectedToObjectBRef);
        this.initAlarmStatus(checkedAlarmStatus, context);
        this.myData.setRevision(2031001);
    }

    private int createRo(Coordinator context, int checkedObjectAConnector, int checkedObjectBConnector, ManagedObject checkedConnectedToObjectARef, ManagedObject checkedConnectedToObjectBRef, int checkedDlAttenuation, int checkedElectricalDlDelay, int checkedElectricalUlDelay, int checkedUlAttenuation) throws MoAccessException {
        MessageLog.trace(1, this.getClass(), "createRo()");
        ManagedObject objectAChildRef = this.getChildRef(checkedConnectedToObjectARef, context);
        ManagedObject objectBChildRef = this.getChildRef(checkedConnectedToObjectBRef, context);
        if (objectAChildRef == null || objectBChildRef == null) {
            String msg = "One or both of the objects that RfCable was going to connect is/are not created";
            MessageLog.trace(1, this.getClass(), msg);
            if (objectAChildRef == null) {
                String msg2 = "objectAChildRef = null";
                MessageLog.trace(1, this.getClass(), msg2);
            }
            if (objectBChildRef == null) {
                String msg3 = "objectBChildRef = null";
                MessageLog.trace(1, this.getClass(), msg3);
            }
            throw new MoCanNotBeCreatedException(msg);
        }
        MessageLog.trace(1, this.getClass(), "objectAChildRef is of type:" + objectAChildRef.getType());
        MessageLog.trace(1, this.getClass(), "objectBChildRef is of type:" + objectBChildRef.getType());
        if (objectAChildRef.getType().equals(objectBChildRef.getType()) && objectBChildRef.getType() != "DeviceGroup" && objectBChildRef.getType() != "RruDeviceGroup") {
            String msg = "objectA and objectB are of the same type " + objectBChildRef.getClass();
            MessageLog.traceError(RfCableMoImpl.class, msg);
            throw new MoCanNotBeCreatedException(msg);
        }
        if (!(objectAChildRef instanceof PauDeviceGroupMo) && !(objectAChildRef instanceof StrxDeviceGroupMo) && !(objectAChildRef instanceof SaiuDeviceGroupMo) && !(objectAChildRef instanceof FuDeviceGroupMo) && !(objectAChildRef instanceof RuDeviceGroupMo) && !(objectAChildRef instanceof DeviceGroupMo) && !(objectAChildRef instanceof RruDeviceGroupMo) || !(objectBChildRef instanceof PauDeviceGroupMo) && !(objectBChildRef instanceof StrxDeviceGroupMo) && !(objectBChildRef instanceof SaiuDeviceGroupMo) && !(objectBChildRef instanceof FuDeviceGroupMo) && !(objectBChildRef instanceof RuDeviceGroupMo) && !(objectBChildRef instanceof AiuDeviceGroupMo) && !(objectBChildRef instanceof DeviceGroupMo) && !(objectBChildRef instanceof ConnectionFieldMo) && !(objectBChildRef instanceof RruDeviceGroupMo)) {
            String msg = "incorrect set of objectA and objectB";
            MessageLog.trace(1, RfCableMoImpl.class, msg);
            throw new MoCanNotBeCreatedException(msg);
        }
        int objectAFroId = 0;
        int objectBFroId = 0;
        if (checkedConnectedToObjectARef instanceof PlugInUnitMo) {
            ((PlugInUnitMo)checkedConnectedToObjectARef).reserve((ManagedObject)this, context);
            objectAFroId = ((PlugInUnitMaoi)checkedConnectedToObjectARef).getFroId(context);
        } else if (checkedConnectedToObjectARef instanceof AuxPlugInUnitMo) {
            ((AuxPlugInUnitMo)checkedConnectedToObjectARef).reserve(this, context);
            objectAFroId = ((AuxPlugInUnitMo)checkedConnectedToObjectARef).getAuxPlugInUnitFroId(context);
        } else {
            String msg = "objectA is not a valid type";
            MessageLog.trace(1, RfCableMoImpl.class, msg);
            throw new MoCanNotBeCreatedException(msg);
        }
        if (checkedConnectedToObjectBRef instanceof PlugInUnitMo) {
            ((Reservable)checkedConnectedToObjectBRef).reserve((ManagedObject)this, context);
            objectBFroId = ((PlugInUnitMaoi)checkedConnectedToObjectBRef).getFroId(context);
        } else if (checkedConnectedToObjectBRef instanceof AuxPlugInUnitMo) {
            ((AuxPlugInUnitMo)checkedConnectedToObjectBRef).reserve(this, context);
            objectBFroId = ((AuxPlugInUnitMo)checkedConnectedToObjectBRef).getAuxPlugInUnitFroId(context);
        } else if (checkedConnectedToObjectBRef instanceof ConnectionFieldMo) {
            ((ConnectionFieldMo)checkedConnectedToObjectBRef).reserve(this, context);
            objectBFroId = 0;
        }
        EqcCreateCableRspS rspSig = this.eqcCableProxy.createCable(this.getTxIdTransactional(context), 0L, 50163, 0L, objectAFroId, checkedObjectAConnector, objectBFroId, checkedObjectBConnector);
        int cableFroId = (int)rspSig.cableFroId;
        try {
            this.eqcCableProxy.setRfCableParameters(this.getTxIdTransactional(context), 0L, cableFroId, 0, objectAFroId, checkedObjectAConnector, checkedDlAttenuation, checkedElectricalDlDelay, checkedUlAttenuation, checkedElectricalUlDelay);
        }
        catch (MoAccessException e) {
            try {
                context.rollbackOnly();
            }
            catch (InactiveTransactionException e1) {
                // empty catch block
            }
            throw e;
        }
        return cableFroId;
    }

    private void releaseReservation(String refName, ManagedObject moRef, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "releaseReservation() ");
        if (moRef != null) {
            ((Reservable)moRef).release((ManagedObject)this, context);
        } else {
            String msg = refName + " MO to be released is missing ";
            MessageLog.trace(2, this.getClass(), msg);
        }
    }

    private ManagedObject getChildRef(ManagedObject checkedConnectedToObjectXRef, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getChildRef() ");
        MessageLog.trace(1, this.getClass(), "checkedConnectedToObjectXRef is of class " + checkedConnectedToObjectXRef.getClass());
        ManagedObject childRef = null;
        if (checkedConnectedToObjectXRef instanceof ConnectionFieldMo) {
            childRef = checkedConnectedToObjectXRef;
            MessageLog.trace(1, this.getClass(), "checkedConnectedToObjectXRef is instanceof ConnectionFieldMoImpl and return it back");
        } else {
            MessageLog.trace(1, this.getClass(), "checkedConnectedToObjectXRef is not ConnectionFieldMoImpl");
            MoIterator iter = checkedConnectedToObjectXRef.getChildren();
            MessageLog.trace(1, this.getClass(), "checkedConnectedToObjectXRef's children are:");
            while (iter.hasMoreElements()) {
                ManagedObject mo = iter.nextMo();
                if (!(mo instanceof AuxDeviceGroupMo) && !(mo instanceof DbDeviceGroupMo)) continue;
                MessageLog.trace(1, this.getClass(), "" + mo.getClass());
                childRef = mo;
                break;
            }
        }
        if (childRef != null) {
            MessageLog.traceReturn(this.getClass(), childRef.getClass() + " is returned finally");
        } else {
            MessageLog.traceReturn(this.getClass(), "childRef is null and returned");
        }
        return childRef;
    }

    private int getObjectARefFroId(ManagedObject connectedToObjectARef, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getObjectARefFroId()");
        if (connectedToObjectARef instanceof PlugInUnitMo) {
            return ((PlugInUnitMaoi)connectedToObjectARef).getFroId(context);
        }
        if (connectedToObjectARef instanceof AuxPlugInUnitMo) {
            return ((AuxPlugInUnitMo)connectedToObjectARef).getAuxPlugInUnitFroId(context);
        }
        String msg = "Wrong object reference";
        MessageLog.trace(2, this.getClass(), msg);
        throw new ValueOutOfRangeException(msg, "RfCable");
    }

    private int getAttribute(Coordinator context, String attributeName) throws MoAccessException, NoSuchAttributeException {
        MessageLog.traceEnter(this.getClass(), "getAttribute()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        this.rfCableFroId = this.getRfCableFroId(context);
        EqcGetRfCableParamRspS rspSig = this.eqcCableProxy.getRfCableParameters(this.getTxIdNonTransactional(context), 0, this.rfCableFroId);
        if (attributeName.equals("objectAConnector")) {
            return rspSig.objectAConnectorId;
        }
        if (attributeName.equals("objectBConnector")) {
            return rspSig.objectBConnectorId;
        }
        if (attributeName.equals("dlAttenuation")) {
            return rspSig.dlAttenuation;
        }
        if (attributeName.equals("ulAttenuation")) {
            return rspSig.ulAttenuation;
        }
        if (attributeName.equals("electricalDlDelay")) {
            return rspSig.electricalDlDelay;
        }
        if (attributeName.equals("electricalUlDelay")) {
            return rspSig.electricalUlDelay;
        }
        String msg = "Attribute EqcRfCableParametersRspS." + attributeName + " no such attribute";
        MessageLog.trace(2, this.getClass(), msg);
        throw new NoSuchAttributeException(msg, this.getType());
    }

    private void addObservers(int froType, Coordinator context) throws MoAccessException {
        this.myMoAlarms = new MoAlarms((ManagedObject)this, this.eqcRrhIndProxy, froType, this.getRfCableFroId(context), context);
    }

    private void removeObservers(Coordinator context) throws MoAccessException {
        this.myMoAlarms.delete(context);
    }

    public int getFroId(Coordinator c) {
        MessageLog.traceEnter(this.getClass(), "getFroId()");
        try {
            return this.getRfCableFroId(c);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Can't find froId", e);
            return -1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static int objectAConnectorMomToEcMi(int value) throws MoAccessException {
        void var1_1;
        switch (value) {
            case 4: {
                int objectAConnector = 18;
                break;
            }
            case 5: {
                int objectAConnector = 19;
                break;
            }
            case 2: {
                int objectAConnector = 41;
                break;
            }
            case 0: {
                int objectAConnector = 68;
                break;
            }
            case 6: {
                int objectAConnector = 39;
                break;
            }
            case 8: {
                int objectAConnector = 52;
                break;
            }
            case 7: {
                int objectAConnector = 38;
                break;
            }
            case 9: {
                int objectAConnector = 53;
                break;
            }
            case 10: {
                int objectAConnector = 54;
                break;
            }
            case 11: {
                int objectAConnector = 50;
                break;
            }
            case 1: {
                int objectAConnector = 36;
                break;
            }
            case 3: {
                int objectAConnector = 32;
                break;
            }
            case 12: {
                int objectAConnector = 90;
                break;
            }
            case 14: {
                int objectAConnector = 92;
                break;
            }
            case 13: {
                int objectAConnector = 91;
                break;
            }
            default: {
                MessageLog.trace(2, RfCableMoImpl.class, "Mub value out of range: objectAConnector = " + value);
                throw new ValueOutOfRangeException("objectAConnector", "RfCable");
            }
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static int objectBConnectorMomToEcMi(int value) throws MoAccessException {
        void var1_1;
        switch (value) {
            case 1: {
                int objectBConnector = 31;
                break;
            }
            case 2: {
                int objectBConnector = 40;
                break;
            }
            case 3: {
                int objectBConnector = 37;
                break;
            }
            case 4: {
                int objectBConnector = 38;
                break;
            }
            case 5: {
                int objectBConnector = 7;
                break;
            }
            case 6: {
                int objectBConnector = 4;
                break;
            }
            case 7: {
                int objectBConnector = 8;
                break;
            }
            case 8: {
                int objectBConnector = 5;
                break;
            }
            case 9: {
                int objectBConnector = 9;
                break;
            }
            case 10: {
                int objectBConnector = 6;
                break;
            }
            case 11: {
                int objectBConnector = 25;
                break;
            }
            case 12: {
                int objectBConnector = 26;
                break;
            }
            case 13: {
                int objectBConnector = 27;
                break;
            }
            case 14: {
                int objectBConnector = 28;
                break;
            }
            case 15: {
                int objectBConnector = 29;
                break;
            }
            case 16: {
                int objectBConnector = 30;
                break;
            }
            case 17: {
                int objectBConnector = 36;
                break;
            }
            case 18: {
                int objectBConnector = 39;
                break;
            }
            case 19: {
                int objectBConnector = 53;
                break;
            }
            case 20: {
                int objectBConnector = 90;
                break;
            }
            case 22: {
                int objectBConnector = 92;
                break;
            }
            default: {
                MessageLog.trace(2, RfCableMoImpl.class, "Mub value out of range: objectBConnector = " + value);
                throw new ValueOutOfRangeException("objectBConnector", "RfCable");
            }
        }
        return (int)var1_1;
    }
}

