/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.emo.power;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoHasChildrenException;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.common.FroAttribute;
import se.ericsson.wcdma.rbs.boam.fpx.common.FroProxyOperations;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.BatteryEqcProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EcPowerProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCreateBatteryRspS;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObject;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.BatteryMo;

public class BatteryMoImpl
extends BoamManagedObject
implements BatteryMo {
    public static final int MO_DATA_REVISION = 4030001;
    private static final String BATTERY_FRO_ID = "batteryFroId";
    private static final FroProxyOperations lrsPowerProxy = EcPowerProxy.instance();
    private static final FroProxyOperations batteryEqcProxy = BatteryEqcProxy.instance();
    private MoData myData;

    public BatteryMoImpl(ManagedObject parent, String motypeName, String identity, Coordinator context, String checkedUserLabel, String checkedFreeText1, String checkedFreeText2, String checkedFreeText3, String checkedFreeText4, String checkedFreeDate1, String checkedFreeDate2, String checkedFreeDate3, int checkedBatteryCapacityDefaultValue, int checkedBatteryVoltageDefaultValue, int checkedTempCharging, int checkedCompFactor, int checkedCyclicChargeInterval, int checkedBatteryTestEndLimit, int checkedRemainingBackupTime, int checkedDischargeLimit, int checkedChargeTimeLimit, int checkedChargeLimit, int checkedInitialBatteryTestStartTime, int checkedMinDaysBeforeCyclicCharge, int checkedChargeOffset, ManagedObject source) throws MoAccessException {
        super(parent, motypeName, identity, context);
        MessageLog.traceEnter(this.getClass(), " Battery Normal constructor");
        lrsPowerProxy.createRo(new FroAttribute[]{new FroAttribute("batteryCapacityDefaultValue", checkedBatteryCapacityDefaultValue), new FroAttribute("batteryVoltageDefaultValue", checkedBatteryVoltageDefaultValue), new FroAttribute("tempCharging", checkedTempCharging), new FroAttribute("compFactor", checkedCompFactor), new FroAttribute("cyclicChargeInterval", checkedCyclicChargeInterval), new FroAttribute("batteryTestEndLimit", checkedBatteryTestEndLimit), new FroAttribute("remainingBackupTime", checkedRemainingBackupTime), new FroAttribute("dischargeLimit", checkedDischargeLimit), new FroAttribute("chargeTimeLimit", checkedChargeTimeLimit), new FroAttribute("chargeLimit", checkedChargeLimit), new FroAttribute("initialBatteryTestStartTime", checkedInitialBatteryTestStartTime), new FroAttribute("minDaysBeforeCyclicCharge", checkedMinDaysBeforeCyclicCharge), new FroAttribute("chargeOffset", checkedChargeOffset)}, "Battery", context);
        int batteryFroId = (int)((EqcCreateBatteryRspS)BatteryMoImpl.batteryEqcProxy.createRo(null, (String)"Battery", (Coordinator)context)).batteryFroId;
        this.initMoData(batteryFroId, checkedUserLabel, checkedFreeText1, checkedFreeText2, checkedFreeText3, checkedFreeText4, checkedFreeDate1, checkedFreeDate2, checkedFreeDate3, context);
    }

    public BatteryMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData.getLocalDistinguishedName());
        MessageLog.traceEnter(this.getClass(), " Battery Recovery constructor");
        this.myData = recoveredData;
        MessageLog.trace(1, this.getClass(), "MO is Restored, version Attribute in MoData = " + this.myData.getRevision());
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(BatteryMoImpl.class, "create()");
        ValidateAttributes.checkTransaction(context);
        ValidateAttributes.checkParent(parent, "Equipment");
        String checkedUserLabel = ValidateAttributes.checkAndGetStringAttribute(attributes, "userLabel", "optional", "", 0, 128, "Battery");
        String checkedFreeText1 = ValidateAttributes.checkAndGetStringAttribute(attributes, "freeText1", "optional", "", 0, 20, "Battery");
        String checkedFreeText2 = ValidateAttributes.checkAndGetStringAttribute(attributes, "freeText2", "optional", "", 0, 20, "Battery");
        String checkedFreeText3 = ValidateAttributes.checkAndGetStringAttribute(attributes, "freeText3", "optional", "", 0, 20, "Battery");
        String checkedFreeText4 = ValidateAttributes.checkAndGetStringAttribute(attributes, "freeText4", "optional", "", 0, 20, "Battery");
        String checkedFreeDate1 = ValidateAttributes.checkAndGetStringAttribute(attributes, "freeDate1", "optional", "", 0, 20, "Battery");
        String checkedFreeDate2 = ValidateAttributes.checkAndGetStringAttribute(attributes, "freeDate2", "optional", "", 0, 20, "Battery");
        String checkedFreeDate3 = ValidateAttributes.checkAndGetStringAttribute(attributes, "freeDate3", "optional", "", 0, 20, "Battery");
        int checkedBatteryCapacityDefaultValue = ValidateAttributes.checkAndGetIntAttribute(attributes, "batteryCapacityDefaultValue", "optional", 60, BATTERY_CAPACITY_DEFAULT_VALUE_MIN_VALUES, BATTERY_CAPACITY_DEFAULT_VALUE_MAX_VALUES, "Battery");
        int checkedBatteryVoltageDefaultValue = ValidateAttributes.checkAndGetIntAttribute(attributes, "batteryVoltageDefaultValue", "optional", -545, BATTERY_VOLTAGE_DEFAULT_VALUE_MIN_VALUES, BATTERY_VOLTAGE_DEFAULT_VALUE_MAX_VALUES, "Battery");
        int checkedTempCharging = ValidateAttributes.checkAndGetIntAttribute(attributes, "tempCharging", "optional", 250, TEMP_CHARGING_MIN_VALUES, TEMP_CHARGING_MAX_VALUES, "Battery");
        int checkedCompFactor = ValidateAttributes.checkAndGetIntAttribute(attributes, "compFactor", "optional", -96, COMP_FACTOR_MIN_VALUES, COMP_FACTOR_MAX_VALUES, "Battery");
        int checkedCyclicChargeInterval = ValidateAttributes.checkAndGetIntAttribute(attributes, "cyclicChargeInterval", "optional", 30, CYCLIC_CHARGE_INTERVAL_MIN_VALUES, CYCLIC_CHARGE_INTERVAL_MAX_VALUES, "Battery");
        int checkedBatteryTestEndLimit = ValidateAttributes.checkAndGetIntAttribute(attributes, "batteryTestEndLimit", "optional", -456, BATTERY_TEST_END_LIMIT_MIN_VALUES, BATTERY_TEST_END_LIMIT_MAX_VALUES, "Battery");
        int checkedRemainingBackupTime = ValidateAttributes.checkAndGetIntAttribute(attributes, "remainingBackupTime", "optional", 30, REMAINING_BACKUP_TIME_MIN_VALUES, REMAINING_BACKUP_TIME_MAX_VALUES, "Battery");
        int checkedDischargeLimit = ValidateAttributes.checkAndGetIntAttribute(attributes, "dischargeLimit", "optional", 80, DISCHARGE_LIMIT_MIN_VALUES, DISCHARGE_LIMIT_MAX_VALUES, "Battery");
        int checkedChargeTimeLimit = ValidateAttributes.checkAndGetIntAttribute(attributes, "chargeTimeLimit", "optional", 20, CHARGE_TIME_LIMIT_MIN_VALUES, CHARGE_TIME_LIMIT_MAX_VALUES, "Battery");
        int checkedChargeLimit = ValidateAttributes.checkAndGetIntAttribute(attributes, "chargeLimit", "optional", 104, CHARGE_LIMIT_MIN_VALUES, CHARGE_LIMIT_MAX_VALUES, "Battery");
        int checkedInitialBatteryTestStartTime = ValidateAttributes.checkAndGetIntAttribute(attributes, "initialBatteryTestStartTime", "optional", 0, INITIAL_BATTERY_TEST_START_TIME_MIN_VALUES, INITIAL_BATTERY_TEST_START_TIME_MAX_VALUES, "Battery");
        int checkedMinDaysBeforeCyclicCharge = ValidateAttributes.checkAndGetIntAttribute(attributes, "minDaysBeforeCyclicCharge", "optional", 16, MIN_DAYS_BEFORE_CYCLIC_CHARGE_MIN_VALUES, MIN_DAYS_BEFORE_CYCLIC_CHARGE_MAX_VALUES, "Battery");
        int checkedChargeOffset = ValidateAttributes.checkAndGetIntAttribute(attributes, "chargeOffset", "optional", 15, CHARGE_OFFSET_MIN_VALUES, CHARGE_OFFSET_MAX_VALUES, "Battery");
        ValidateAttributes.checkOtherAttributes(attributes, "Battery");
        BatteryMoImpl createdMo = new BatteryMoImpl(parent, "Battery", identity, context, checkedUserLabel, checkedFreeText1, checkedFreeText2, checkedFreeText3, checkedFreeText4, checkedFreeDate1, checkedFreeDate2, checkedFreeDate3, checkedBatteryCapacityDefaultValue, checkedBatteryVoltageDefaultValue, checkedTempCharging, checkedCompFactor, checkedCyclicChargeInterval, checkedBatteryTestEndLimit, checkedRemainingBackupTime, checkedDischargeLimit, checkedChargeTimeLimit, checkedChargeLimit, checkedInitialBatteryTestStartTime, checkedMinDaysBeforeCyclicCharge, checkedChargeOffset, source);
        return createdMo;
    }

    public void delete(Coordinator c) throws MoAccessException, MoHasChildrenException {
        MessageLog.traceEnter(this.getClass(), "delete() ");
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        lrsPowerProxy.deleteRo(null, "Battery", c);
        batteryEqcProxy.deleteRo(new FroAttribute[]{new FroAttribute("froId", this.getFroId(c))}, "Battery", c);
        super.delete(c);
        MessageLog.trace(1, this.getClass(), "Battery Mo is Deleted ");
    }

    public String getType() {
        return "Battery";
    }

    public void proxiesUnavailable() {
        MessageLog.traceEnter(this.getClass(), "proxiesUnavailable()");
    }

    public void proxiesAvailable() throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "proxiesAvailable()");
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData()");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(this.getClass(), "isMyMoDataPersistent()");
        return true;
    }

    public String getBatteryId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getBatteryId()");
        return super.bcmGetIdentity(this.getLocalDistinguishedName(), context);
    }

    public String getUserLabel(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUserLabel() ");
        return this.bcmGetStringAttribute("userLabel", context);
    }

    public void setUserLabel(String value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setUserLabel() ");
        this.bcmSetStringAttribute("userLabel", value, 0, 128, "Battery", context);
        this.sendAVC("userLabel", value, context);
    }

    public String getFreeText1(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getFreeText1() ");
        return this.bcmGetStringAttribute("freeText1", context);
    }

    public void setFreeText1(String newText, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setFreeText1() ");
        this.bcmSetStringAttribute("freeText1", newText, 0, 20, "Battery", context);
        this.sendAVC("freeText1", newText, context);
    }

    public String getFreeText2(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getFreeText2() ");
        return this.bcmGetStringAttribute("freeText2", context);
    }

    public void setFreeText2(String newText, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setFreeText2() ");
        this.bcmSetStringAttribute("freeText2", newText, 0, 20, "Battery", context);
        this.sendAVC("freeText2", newText, context);
    }

    public String getFreeText3(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getFreeText3() ");
        return this.bcmGetStringAttribute("freeText3", context);
    }

    public void setFreeText3(String newText, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setFreeText3() ");
        this.bcmSetStringAttribute("freeText3", newText, 0, 20, "Battery", context);
        this.sendAVC("freeText3", newText, context);
    }

    public String getFreeText4(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getFreeText4() ");
        return this.bcmGetStringAttribute("freeText4", context);
    }

    public void setFreeText4(String newText, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setFreeText4() ");
        this.bcmSetStringAttribute("freeText4", newText, 0, 20, "Battery", context);
        this.sendAVC("freeText4", newText, context);
    }

    public String getFreeDate1(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getFreeDate1() ");
        return this.bcmGetStringAttribute("freeDate1", context);
    }

    public void setFreeDate1(String newDate, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setFreeDate1() ");
        this.bcmSetStringAttribute("freeDate1", newDate, 0, 20, "Battery", context);
        this.sendAVC("freeDate1", newDate, context);
    }

    public String getFreeDate2(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getFreeDate2() ");
        return this.bcmGetStringAttribute("freeDate2", context);
    }

    public void setFreeDate2(String newDate, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setFreeDate2() ");
        this.bcmSetStringAttribute("freeDate2", newDate, 0, 20, "Battery", context);
        this.sendAVC("freeDate2", newDate, context);
    }

    public String getFreeDate3(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getFreeDate3() ");
        return this.bcmGetStringAttribute("freeDate3", context);
    }

    public void setFreeDate3(String newDate, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setFreeDate3() ");
        this.bcmSetStringAttribute("freeDate3", newDate, 0, 20, "Battery", context);
        this.sendAVC("freeDate3", newDate, context);
    }

    public int getBatteryCapacityDefaultValue(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getBatteryCapacityDefaultValue() ");
        return (Integer)lrsPowerProxy.getRo(null, "batteryCapacityDefaultValue", "Battery", context);
    }

    public void setBatteryCapacityDefaultValue(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setBatteryCapacityDefaultValue() ");
        ValidateAttributes.intValueRangeCheck("batteryCapacityDefaultValue", value, BatteryMo.BATTERY_CAPACITY_DEFAULT_VALUE_MIN_VALUES, BatteryMo.BATTERY_CAPACITY_DEFAULT_VALUE_MAX_VALUES, "Battery");
        lrsPowerProxy.setRo(new FroAttribute[]{new FroAttribute("paramId", 0), new FroAttribute("value", value)}, "Battery", context);
        this.sendAVC("batteryCapacityDefaultValue", value, context);
    }

    public int getBatteryVoltageDefaultValue(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getBatteryVoltageDefaultValue() ");
        return (Integer)lrsPowerProxy.getRo(null, "batteryVoltageDefaultValue", "Battery", context);
    }

    public void setBatteryVoltageDefaultValue(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setBatteryVoltageDefaultValue() ");
        ValidateAttributes.intValueRangeCheck("batteryVoltageDefaultValue", value, BatteryMo.BATTERY_VOLTAGE_DEFAULT_VALUE_MIN_VALUES, BatteryMo.BATTERY_VOLTAGE_DEFAULT_VALUE_MAX_VALUES, "Battery");
        lrsPowerProxy.setRo(new FroAttribute[]{new FroAttribute("paramId", 1), new FroAttribute("value", value)}, "Battery", context);
        this.sendAVC("batteryVoltageDefaultValue", value, context);
    }

    public int getTempCharging(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getTempCharging() ");
        return (Integer)lrsPowerProxy.getRo(null, "tempCharging", "Battery", context);
    }

    public void setTempCharging(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setTempCharging() ");
        ValidateAttributes.intValueRangeCheck("tempCharging", value, BatteryMo.TEMP_CHARGING_MIN_VALUES, BatteryMo.TEMP_CHARGING_MAX_VALUES, "Battery");
        lrsPowerProxy.setRo(new FroAttribute[]{new FroAttribute("paramId", 2), new FroAttribute("value", value)}, "Battery", context);
        this.sendAVC("tempCharging", value, context);
    }

    public int getCompFactor(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getCompFactor() ");
        return (Integer)lrsPowerProxy.getRo(null, "compFactor", "Battery", context);
    }

    public void setCompFactor(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setCompFactor() ");
        ValidateAttributes.intValueRangeCheck("compFactor", value, BatteryMo.COMP_FACTOR_MIN_VALUES, BatteryMo.COMP_FACTOR_MAX_VALUES, "Battery");
        lrsPowerProxy.setRo(new FroAttribute[]{new FroAttribute("paramId", 3), new FroAttribute("value", value)}, "Battery", context);
        this.sendAVC("compFactor", value, context);
    }

    public int getCyclicChargeInterval(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getCyclicChargeInterval() ");
        return (Integer)lrsPowerProxy.getRo(null, "cyclicChargeInterval", "Battery", context);
    }

    public void setCyclicChargeInterval(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setCyclicChargeInterval() ");
        ValidateAttributes.intValueRangeCheck("cyclicChargeInterval", value, BatteryMo.CYCLIC_CHARGE_INTERVAL_MIN_VALUES, BatteryMo.CYCLIC_CHARGE_INTERVAL_MAX_VALUES, "Battery");
        lrsPowerProxy.setRo(new FroAttribute[]{new FroAttribute("paramId", 4), new FroAttribute("value", value)}, "Battery", context);
        this.sendAVC("cyclicChargeInterval", value, context);
    }

    public int getBatteryTestEndLimit(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getBatteryTestEndLimit() ");
        return (Integer)lrsPowerProxy.getRo(null, "batteryTestEndLimit", "Battery", context);
    }

    public void setBatteryTestEndLimit(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setBatteryTestEndLimit() ");
        ValidateAttributes.intValueRangeCheck("batteryTestEndLimit", value, BatteryMo.BATTERY_TEST_END_LIMIT_MIN_VALUES, BatteryMo.BATTERY_TEST_END_LIMIT_MAX_VALUES, "Battery");
        lrsPowerProxy.setRo(new FroAttribute[]{new FroAttribute("paramId", 5), new FroAttribute("value", value)}, "Battery", context);
        this.sendAVC("batteryTestEndLimit", value, context);
    }

    public int getRemainingBackupTime(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getRemainingBackupTime() ");
        return (Integer)lrsPowerProxy.getRo(null, "remainingBackupTime", "Battery", context);
    }

    public void setRemainingBackupTime(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setRemainingBackupTime() ");
        ValidateAttributes.intValueRangeCheck("remainingBackupTime", value, BatteryMo.REMAINING_BACKUP_TIME_MIN_VALUES, BatteryMo.REMAINING_BACKUP_TIME_MAX_VALUES, "Battery");
        lrsPowerProxy.setRo(new FroAttribute[]{new FroAttribute("paramId", 6), new FroAttribute("value", value)}, "Battery", context);
        this.sendAVC("remainingBackupTime", value, context);
    }

    public int getDischargeLimit(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getDischargeLimit() ");
        return (Integer)lrsPowerProxy.getRo(null, "dischargeLimit", "Battery", context);
    }

    public void setDischargeLimit(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setDischargeLimit() ");
        ValidateAttributes.intValueRangeCheck("dischargeLimit", value, BatteryMo.DISCHARGE_LIMIT_MIN_VALUES, BatteryMo.DISCHARGE_LIMIT_MAX_VALUES, "Battery");
        lrsPowerProxy.setRo(new FroAttribute[]{new FroAttribute("paramId", 7), new FroAttribute("value", value)}, "Battery", context);
        this.sendAVC("dischargeLimit", value, context);
    }

    public int getChargeTimeLimit(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getChargeTimeLimit() ");
        return (Integer)lrsPowerProxy.getRo(null, "chargeTimeLimit", "Battery", context);
    }

    public void setChargeTimeLimit(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setChargeTimeLimit() ");
        ValidateAttributes.intValueRangeCheck("chargeTimeLimit", value, BatteryMo.CHARGE_TIME_LIMIT_MIN_VALUES, BatteryMo.CHARGE_TIME_LIMIT_MAX_VALUES, "Battery");
        lrsPowerProxy.setRo(new FroAttribute[]{new FroAttribute("paramId", 8), new FroAttribute("value", value)}, "Battery", context);
        this.sendAVC("chargeTimeLimit", value, context);
    }

    public int getChargeLimit(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getChargeLimit() ");
        return (Integer)lrsPowerProxy.getRo(null, "chargeLimit", "Battery", context);
    }

    public void setChargeLimit(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setChargeLimit() ");
        ValidateAttributes.intValueRangeCheck("chargeLimit", value, BatteryMo.CHARGE_LIMIT_MIN_VALUES, BatteryMo.CHARGE_LIMIT_MAX_VALUES, "Battery");
        lrsPowerProxy.setRo(new FroAttribute[]{new FroAttribute("paramId", 9), new FroAttribute("value", value)}, "Battery", context);
        this.sendAVC("chargeLimit", value, context);
    }

    public int getInitialBatteryTestStartTime(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getInitialBatteryTestStartTime() ");
        return (Integer)lrsPowerProxy.getRo(null, "initialBatteryTestStartTime", "Battery", context);
    }

    public void setInitialBatteryTestStartTime(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setInitialBatteryTestStartTime() ");
        ValidateAttributes.intValueRangeCheck("initialBatteryTestStartTime", value, BatteryMo.INITIAL_BATTERY_TEST_START_TIME_MIN_VALUES, BatteryMo.INITIAL_BATTERY_TEST_START_TIME_MAX_VALUES, "Battery");
        lrsPowerProxy.setRo(new FroAttribute[]{new FroAttribute("paramId", 10), new FroAttribute("value", value)}, "Battery", context);
        this.sendAVC("initialBatteryTestStartTime", value, context);
    }

    public int getMinDaysBeforeCyclicCharge(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getMinDaysBeforeCyclicCharge() ");
        return (Integer)lrsPowerProxy.getRo(null, "minDaysBeforeCyclicCharge", "Battery", context);
    }

    public void setMinDaysBeforeCyclicCharge(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setMinDaysBeforeCyclicCharge() ");
        ValidateAttributes.intValueRangeCheck("minDaysBeforeCyclicCharge", value, BatteryMo.MIN_DAYS_BEFORE_CYCLIC_CHARGE_MIN_VALUES, BatteryMo.MIN_DAYS_BEFORE_CYCLIC_CHARGE_MAX_VALUES, "Battery");
        lrsPowerProxy.setRo(new FroAttribute[]{new FroAttribute("paramId", 11), new FroAttribute("value", value)}, "Battery", context);
        this.sendAVC("minDaysBeforeCyclicCharge", value, context);
    }

    public int getChargeOffset(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getChargeOffset() ");
        return (Integer)lrsPowerProxy.getRo(null, "chargeOffset", "Battery", context);
    }

    public void setChargeOffset(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setChargeOffset() ");
        ValidateAttributes.intValueRangeCheck("chargeOffset", value, BatteryMo.CHARGE_OFFSET_MIN_VALUES, BatteryMo.CHARGE_OFFSET_MAX_VALUES, "Battery");
        lrsPowerProxy.setRo(new FroAttribute[]{new FroAttribute("paramId", 12), new FroAttribute("value", value)}, "Battery", context);
        this.sendAVC("chargeOffset", value, context);
    }

    private void initMoData(int batteryFroId, String checkedUserLabel, String checkedFreeText1, String checkedFreeText2, String checkedFreeText3, String checkedFreeText4, String checkedFreeDate1, String checkedFreeDate2, String checkedFreeDate3, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " initMoData() ");
        this.myData = new MoData(this.getLocalDistinguishedName(), this.getType(), true, context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.bcmStoreAndRegisterIntAttribute(BATTERY_FRO_ID, batteryFroId);
        this.bcmStoreAndRegisterStringAttribute("userLabel", checkedUserLabel);
        this.bcmStoreAndRegisterStringAttribute("freeText1", checkedFreeText1);
        this.bcmStoreAndRegisterStringAttribute("freeText2", checkedFreeText2);
        this.bcmStoreAndRegisterStringAttribute("freeText3", checkedFreeText3);
        this.bcmStoreAndRegisterStringAttribute("freeText4", checkedFreeText4);
        this.bcmStoreAndRegisterStringAttribute("freeDate1", checkedFreeDate1);
        this.bcmStoreAndRegisterStringAttribute("freeDate2", checkedFreeDate2);
        this.bcmStoreAndRegisterStringAttribute("freeDate3", checkedFreeDate3);
        this.myData.setRevision(4030001);
    }

    public int getFroId(Coordinator c) {
        MessageLog.traceEnter(this.getClass(), "getFroId()");
        int froId = -1;
        try {
            froId = this.bcmGetIntAttribute(BATTERY_FRO_ID, c);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Could not retrieve batteryFroId");
        }
        return froId;
    }
}

