/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.rmo.cell;

import java.util.ArrayList;
import java.util.List;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.proxies.ScCellCarrierProxy;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.proxies.ScRfAccessProxy;
import se.ericsson.wcdma.rbs.boam.mao.rmo.cell.CarrierMoImpl;
import se.ericsson.wcdma.rbs.boam.pms.iface.PmCapableMoFactory;
import se.ericsson.wcdma.rbs.boam.pms.impl.Counter;
import se.ericsson.wcdma.rbs.boam.pms.impl.CounterGroup;
import se.ericsson.wcdma.rbs.boam.pms.impl.MoScannerAgent;
import se.ericsson.wcdma.rbs.boam.pms.impl.PredefinedScannerMgr;

public class CarrierMoFactory
implements PmCapableMoFactory {
    private static CarrierMoFactory instance = null;
    private List counterList = new ArrayList();
    private List sccCounterList = new ArrayList();
    private List chcCounterList = new ArrayList();

    private CarrierMoFactory() {
        MessageLog.traceEnter(this.getClass(), " constructor");
        MoFactoryMgr.instance().register((MoFactory)this, this.getMoTypeName());
        this.setupPmsCounters();
        this.setupRbsPredefScanner();
        ScCellCarrierProxy.instance();
        ScRfAccessProxy.instance();
    }

    public static synchronized CarrierMoFactory instance() {
        if (instance == null) {
            instance = new CarrierMoFactory();
        }
        return instance;
    }

    public ManagedObject createMo(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "createMo()");
        ManagedObject mo = CarrierMoImpl.create(parent, this.getMoTypeName(), identity, context, attributes, source);
        return mo;
    }

    public ManagedObject recoverMo(MoData recoveredData) throws MoNameAlreadyTakenException {
        MessageLog.traceEnter(this.getClass(), "recoverMo()");
        return new CarrierMoImpl(recoveredData);
    }

    public String getMoTypeName() {
        return "Carrier";
    }

    public List getCounters() {
        return this.counterList;
    }

    public List getSccCounters() {
        return this.sccCounterList;
    }

    public List getChcCounters() {
        return this.chcCounterList;
    }

    private void setupPmsCounters() {
        MessageLog.traceEnter(this.getClass(), "setupPmsCounters()");
        try {
            CounterGroup counterGroup = new CounterGroup("pmsAverageRssi");
            Counter cnt = new Counter("pmAverageRssi", 65, counterGroup);
            this.sccCounterList.add(cnt);
            cnt = new Counter("pmAverageRssi1", 65, counterGroup);
            this.sccCounterList.add(cnt);
            cnt = new Counter("pmAverageRssi2", 65, counterGroup);
            this.sccCounterList.add(cnt);
            cnt = new Counter("pmAverageRssi3", 65, counterGroup);
            this.sccCounterList.add(cnt);
            cnt = new Counter("pmAverageRssiHigh", 142, counterGroup);
            this.sccCounterList.add(cnt);
            counterGroup = new CounterGroup("pmsTransmittedCarrierPowerGrp2");
            cnt = new Counter("pmTransmittedCarrierPower", 54, counterGroup);
            this.sccCounterList.add(cnt);
            cnt = new Counter("pmTransmittedCarrierPowerW", 100, counterGroup);
            this.sccCounterList.add(cnt);
            cnt = new Counter("pmTransmittedCarrierPowerWLimit", 1, counterGroup);
            this.sccCounterList.add(cnt);
            CounterGroup counterGroup2 = new CounterGroup("pmsUsedDlCodesGrp");
            cnt = new Counter("pmSumUsedDlCodes", 1, counterGroup2);
            this.sccCounterList.add(cnt);
            cnt = new Counter("pmSampledUsedDlCodes", 1, counterGroup2);
            this.sccCounterList.add(cnt);
            cnt = new Counter("pmUsedDlCodesUtilisation", 20, counterGroup2);
            this.sccCounterList.add(cnt);
            counterGroup = new CounterGroup(String.valueOf(169));
            cnt = new Counter("pmRxPowerSpectrum", 42, counterGroup);
            this.chcCounterList.add(cnt);
            this.counterList.addAll(this.sccCounterList);
            this.counterList.addAll(this.chcCounterList);
            new MoScannerAgent("Carrier", this.counterList);
        }
        catch (RuntimeException pmse) {
            MessageLog.traceError(this.getClass(), " Could not setup boam.pms.MoScannerAgent." + pmse);
        }
        catch (Exception pmse) {
            MessageLog.traceError(this.getClass(), " Could not setup boam.pms.MoScannerAgent." + pmse);
        }
    }

    private void setupRbsPredefScanner() {
        MessageLog.traceEnter(this.getClass(), "setupRbsPredefScanner()");
        String[] classnames = new String[]{this.getMoTypeName()};
        String[][] counterArray = new String[][]{{"pmAverageRssi", "pmAverageRssiHigh", "pmTransmittedCarrierPower", "pmTransmittedCarrierPowerW", "pmTransmittedCarrierPowerWLimit"}};
        PredefinedScannerMgr.instance().createPredefinedScanner("PREDEF.PRIMARY.STATS", classnames, counterArray, 5);
    }

    public static synchronized void _reset_onlyForTest() {
        if (instance != null) {
            MoFactoryMgr.instance().deregister(instance.getMoTypeName());
            instance = null;
        }
    }
}

