/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.rmo.cell;

import se.ericsson.cello.equipment.EquipmentMo;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcSectorAntennaProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EcCreateSaRspS;
import se.ericsson.wcdma.rbs.boam.mao.alarm.MoAlarms;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObjectWithAlarms;
import se.ericsson.wcdma.rbs.boam.mao.common.ConfigNotSupportedException;
import se.ericsson.wcdma.rbs.boam.mao.common.ErrorMgr;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.SectorAntennaMo;

public class SectorAntennaMoImpl
extends BoamManagedObjectWithAlarms
implements SectorAntennaMo {
    public static final Class SELF = SectorAntennaMoImpl.class;
    public static final int MO_DATA_REVISION = 7060000;
    private static final int CREATE_DELETE = 1;
    private EqcSectorAntennaProxy eqcSectorAntennaProxy = EqcSectorAntennaProxy.instance();

    private SectorAntennaMoImpl(ManagedObject parent, String motypeName, String identity, Coordinator context, String userLabel, int alarmStatus, int antennaType, int sectorFroId, String beamDirection, String positionInformation, ManagedObject positionRef) throws MoAccessException {
        super(parent, motypeName, identity, context);
        MessageLog.traceEnter(SELF, "SectorAntennaMoImpl()");
        EcCreateSaRspS ecSig = this.eqcSectorAntennaProxy.createAntenna(this.getTxIdTransactional(context), 0, sectorFroId, false);
        int froId = (int)ecSig.saFroId;
        this.eqcSectorAntennaProxy.setAntennaType(this.getTxIdTransactional(context), 0, froId, antennaType);
        this.initMoData(identity, userLabel, alarmStatus, froId, beamDirection, positionInformation, positionRef, context);
        this.addObservers(128, context);
        MessageLog.trace(1, SELF, "SectorAntenna MO created.");
    }

    public SectorAntennaMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        MessageLog.traceEnter(SELF, " SectorAntennaMoImpl()");
        this.myData = recoveredData;
        ErrorMgr.shotDownIfNull(this.myData.getAttribute("userLabel"), "userLabel");
        ErrorMgr.shotDownIfNull(this.myData.getAttribute("antennaType"), "antennaType");
        ErrorMgr.shotDownIfNull(this.myData.getAttribute("froId"), "froId");
        ErrorMgr.shotDownIfNull(this.myData.getAttribute("alarmStatus"), "alarmStatus");
        ErrorMgr.shotDownIfNull(this.myData.getAttribute("beamDirection"), "beamDirection");
        try {
            this.addObservers(128, null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(SELF, "Couldn't init the Observers!!");
        }
        MessageLog.trace(1, SELF, "SectorAntenna MO restored.");
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SectorAntennaMoImpl.class, "create()");
        SectorAntennaMoImpl.checkTransaction(context);
        SectorAntennaMoImpl.checkParent(parent);
        String checkedUserLabel = ValidateAttributes.checkAndGetStringAttribute(attributes, "userLabel", "optional", "", 0, 128, "SectorAntenna");
        int checkedAlarmStatus = ValidateAttributes.checkAndGetIntAttribute(attributes, "alarmStatus", "optional", 0, ALARM_STATUS_MIN_VALUES, ALARM_STATUS_MAX_VALUES, "SectorAntenna");
        int checkedantennaType = ValidateAttributes.checkAndGetIntAttribute(attributes, "antennaType", "optional", 0, ANTENNA_TYPE_MIN_VALUES, ANTENNA_TYPE_MAX_VALUES, "SectorAntenna");
        String positionInformation = ValidateAttributes.checkAndGetStringAttribute(attributes, "positionInformation", "optional", "", 0, 255, "SectorAntenna");
        ManagedObject positionRef = ValidateAttributes.checkAndGetReferenceAttribute("positionRef", attributes, "optional", new String[]{"HwGroup"}, "SectorAntenna");
        int checkedSectorFroId = SectorAntennaMoImpl.checkAndGetSectorFroId(attributes);
        String checkedBeamDirection = ValidateAttributes.checkAndGetStringAttribute(attributes, "beamDirection", "optional", "N/A", 3, 3, "SectorAntenna");
        ValidateAttributes.checkOtherAttributes(attributes, "SectorAntenna");
        SectorAntennaMoImpl createdMo = new SectorAntennaMoImpl(parent, "SectorAntenna", identity, context, checkedUserLabel, checkedAlarmStatus, checkedantennaType, checkedSectorFroId, checkedBeamDirection, positionInformation, positionRef);
        return createdMo;
    }

    public void delete(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "delete() ");
        if (this.isReserved(context)) {
            MessageLog.trace(1, SELF, " Mo is reserved and can not be deleted.");
            throw new UndeletableMoException((ManagedObject)this);
        }
        int froId = this.getFroId(context);
        this.eqcSectorAntennaProxy.deleteSectorAntenna(this.getTxIdTransactional(context), 0, froId);
        this.getMyMoData().handleTransaction(context, MoData.WRITE_ACCESS);
        this.removeObservers(context);
        super.delete(context);
        MessageLog.trace(1, SELF, "MO is deleted");
    }

    private static int checkAndGetSectorFroId(AttrList attributes) throws AttrMissingAtCreateException, NotHandledAttributeTypeException, MoNotFoundException {
        int attrIndex = attributes.indexOf("sectorFroId");
        if (attrIndex == -1) {
            throw new AttrMissingAtCreateException("sectorFroId", "SectorAntenna");
        }
        Integer tmpInteger = (Integer)attributes.getValue(attrIndex);
        attributes.removeElementAt(attrIndex);
        return tmpInteger;
    }

    public String getUserLabel(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getUserLabel() ");
        return this.bcmGetStringAttribute("userLabel", context);
    }

    public void setUserLabel(String value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "setUserLabel() ");
        this.bcmSetStringAttribute("userLabel", value, 0, 128, "SectorAntenna", context);
        this.sendAVC("userLabel", value, context);
    }

    public int getAntennaType(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getAntennaType() ");
        return this.eqcSectorAntennaProxy.getSaParam((int)this.getTxIdNonTransactional((Coordinator)context), (int)0, (int)this.getFroId((Coordinator)context)).antennaType;
    }

    public void setAntennaType(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "setAntennaType() ");
        ValidateAttributes.checkTransaction(context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        ValidateAttributes.intValueRangeCheck("antennaType", value, ANTENNA_TYPE_MIN_VALUES, ANTENNA_TYPE_MAX_VALUES, "SectorAntenna");
        this.eqcSectorAntennaProxy.setAntennaType(this.getTxIdTransactional(context), 0, this.getFroId(context), value);
        this.bcmSetIntAttribute("antennaType", value, ANTENNA_TYPE_MIN_VALUES, ANTENNA_TYPE_MAX_VALUES, "SectorAntenna", context);
        this.sendAVC("antennaType", value, context);
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(SELF, "getMyMoData() ");
        return this.myData;
    }

    public String getType() {
        return "SectorAntenna";
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(SELF, "isMyMoDataPersistent() ");
        return true;
    }

    public void proxiesUnavailable() {
        MessageLog.traceEnter(SELF, "proxiesUnavailable");
    }

    public void proxiesAvailable() throws MoAccessException {
        MessageLog.traceEnter(SELF, "proxiesAvailable");
    }

    private static void checkParent(ManagedObject parent) throws IllegalParentException {
        String msg = " Illegal parent, Expecting EquipmentMo[Impl], received: ";
        if (parent == null) {
            MessageLog.trace(1, SectorAntennaMoImpl.class, msg + "null");
            throw new IllegalParentException(msg);
        }
        if (!(parent instanceof EquipmentMo)) {
            MessageLog.trace(1, SectorAntennaMoImpl.class, msg + parent.getClass().getName());
            throw new IllegalParentException(msg);
        }
    }

    private void initMoData(String identity, String userLabel, int alarmStatus, int froId, String beamDirection, String positionInformation, ManagedObject positionRef, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "initMoData() ");
        this.myData = new MoData(this.getLocalDistinguishedName(), this.getType(), true, context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.bcmStoreAndRegisterStringAttribute("userLabel", userLabel);
        this.bcmStoreAndRegisterIntAttribute("antennaType", 0);
        this.bcmStoreAndRegisterStringAttribute("positionInformation", positionInformation);
        this.bcmStoreAndRegisterReferenceAttribute("positionRef", positionRef);
        this.initAlarmStatus(alarmStatus, context);
        this.bcmStoreAndRegisterIntAttribute("froId", froId);
        this.bcmStoreAndRegisterStringAttribute("beamDirection", beamDirection);
    }

    public int getFroId(Coordinator context) {
        MessageLog.traceEnter(SELF, "getFroId()");
        IntegerAttribute intAttr = (IntegerAttribute)this.myData.getAttribute("froId");
        return intAttr.getValue(context);
    }

    private void addObservers(int froType, Coordinator context) throws MoAccessException {
        this.myMoAlarms = new MoAlarms((ManagedObject)this, this.eqcSectorAntennaProxy, froType, this.getFroId(context), context);
    }

    private void removeObservers(Coordinator context) throws MoAccessException {
        this.myMoAlarms.delete(context);
    }

    public boolean hasAtmauDevice() {
        return BoamHelper.getMatchingMo(this, "DeviceGroup", "ATMAU") != null;
    }

    public boolean hasTmfDevice() {
        return BoamHelper.getMatchingMo(this, "DeviceGroup", "TMF") != null;
    }

    public String getBeamDirection(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getBeamDirection() ");
        return this.bcmGetStringAttribute("beamDirection", c);
    }

    public void setBeamDirection(String value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(SELF, "setBeamDirection() ");
        if (value == null || value.length() != 3) {
            throw new ValueOutOfRangeException("beamDirection", "SectorAntenna");
        }
        this.bcmSetStringAttribute("beamDirection", value, 3, 3, "SectorAntenna", c);
        this.sendAVC("beamDirection", value, c);
    }

    public int getInternalSectorAntennaNo() throws ConfigNotSupportedException {
        String id = this.getNamingAttributeValue();
        int startIndex = id.lastIndexOf("-");
        if (startIndex == -1) {
            throw new ConfigNotSupportedException("Could not parse SectorAntennaId, invalid value: " + id);
        }
        String saNo = id.substring(startIndex + 1, id.length());
        return Integer.valueOf(saNo);
    }

    public String getPositionInformation(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getPositionInformation() ");
        return this.bcmGetStringAttribute("positionInformation", c);
    }

    public void setPositionInformation(String value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(SELF, "setPositionInformation() ");
        if (value == null || value.length() > 255 || value.length() < 0) {
            throw new ValueOutOfRangeException("positionInformation", "SectorAntenna");
        }
        this.bcmSetStringAttribute("positionInformation", value, 0, 255, "SectorAntenna", c);
        this.sendAVC("positionInformation", value, c);
    }

    public ManagedObject getPositionRef(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getPositionRef() ");
        return this.bcmGetReferenceAttribute("positionRef", c);
    }

    public void setPositionRef(ManagedObject value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(SELF, "setPositionRef() ");
        if (null != value && !value.getType().equals("HwGroup")) {
            throw new WrongAttributeTypeException("positionRef", "SectorAntenna");
        }
        ManagedObject oldRef = this.getPositionRef(c);
        if (value != null && oldRef != null && value.getLocalDistinguishedName().equals(oldRef.getLocalDistinguishedName())) {
            MessageLog.trace(2, this.getClass(), "setPositionRef : the old value  and the new vlaue is the same, nothing to change!! mo:" + this.getFullDistinguishedName());
            return;
        }
        if (oldRef != null) {
            ((Reservable)oldRef).release((ManagedObject)this, c);
        }
        if (value != null) {
            ((Reservable)value).reserve((ManagedObject)this, c);
        }
        this.bcmSetReferenceAttribute("positionRef", value, "SectorAntenna", c);
        this.sendAVC("positionRef", value, c);
    }
}

